/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar;

import com.blazeloader.jarjar.console.CommandReader;
import com.blazeloader.jarjar.console.Options;
import com.blazeloader.jarjar.convert.ClassRemapper;
import com.blazeloader.jarjar.tree.ClassTree;
import com.blazeloader.jarjar.tree.ClassTreeMatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import net.acomputerdog.OBFUtil.parse.types.SRGFileParser;
import net.acomputerdog.OBFUtil.table.DirectOBFTable;

public class RemapperConsole
extends CommandReader {
    private ClassTreeMatcher matcher;
    private final ClassRemapper remapper;
    private final File srg;

    public RemapperConsole(ClassRemapper remapper, File srg) {
        this(remapper, srg, null);
    }

    public RemapperConsole(ClassRemapper remapper, File srg, String json) {
        super(System.in, System.out);
        this.remapper = remapper;
        this.srg = srg;
        if (json != null) {
            this.matcher = remapper.loadMatcherFromJson(json);
            if (this.matcher == null) {
                System.out.println("Error: Could not load matcher.");
            }
        } else {
            this.matcher = remapper.loadMatcher();
        }
    }

    @Override
    public String handleCommand(String ... args) throws Throwable {
        block13 : switch (args[0].toLowerCase()) {
            case "lookup": {
                boolean full;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher found = this.matcher.lookup(args[1]);
                boolean bl = full = args.length > 2 && "full".equalsIgnoreCase(args[2]);
                if (found != null) {
                    if (full) {
                        return found.toString();
                    }
                    return String.valueOf(found.bitMask()) + " " + found.description();
                }
                ClassTree unmapped = this.matcher.before().lookup(args[1]);
                if (unmapped != null) {
                    this.out.print("{null} <- ");
                    if (full) {
                        return unmapped.toString();
                    }
                    return unmapped.description();
                }
                return "Entry not found";
            }
            case "lookup-reverse": {
                boolean full;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher found = this.matcher.reverseLookup(args[1]);
                boolean bl = full = args.length > 2 && "full".equalsIgnoreCase(args[2]);
                if (found != null) {
                    if (full) {
                        return found.toString();
                    }
                    return String.valueOf(found.bitMask()) + " " + found.description();
                }
                ClassTree unmapped = this.matcher.after().lookup(args[1]);
                if (unmapped != null) {
                    this.out.print("{null} -> ");
                    if (full) {
                        return unmapped.toString();
                    }
                    return unmapped.description();
                }
                return "Entry not found";
            }
            case "lookup-parent": {
                ClassTreeMatcher result;
                if (args.length < 2) {
                    return "Error: Too few arguments";
                }
                boolean reverse = args.length == 3 && "reverse".equalsIgnoreCase(args[2]);
                ClassTree tree = reverse ? this.matcher.after() : this.matcher.before();
                ClassTreeMatcher classTreeMatcher = result = reverse ? this.matcher.reverseLookup(args[1]) : this.matcher.lookup(args[1]);
                if (result != null) {
                    return result.parent().description();
                }
                if ((tree = tree.lookup(args[1])) != null) {
                    tree = tree.parent();
                    ClassTreeMatcher classTreeMatcher2 = result = reverse ? this.matcher.reverseLookup(tree.getName()) : this.matcher.lookup(tree.getName());
                    if (result != null) {
                        return result.description();
                    }
                    this.out.print(reverse ? "{null} <- " : "{null} -> ");
                    return tree.description();
                }
                return "Entry not found.";
            }
            case "define": {
                if (args.length < 3) {
                    return "Error: Too few arguments";
                }
                ClassTree from = this.matcher.before().lookup(args[1]);
                ClassTree to = this.matcher.after().lookup(args[2]);
                if (from == null) {
                    return "Error: From class not found.";
                }
                if (to == null) {
                    return "Error: To class not found.";
                }
                this.matcher.define(from, to);
                return this.handleCommand("get", args[2]);
            }
            case "swap": {
                if (args.length < 3) {
                    return "Error: Too few arguments";
                }
                ClassTreeMatcher old = this.matcher.lookup(args[1]);
                ClassTreeMatcher neu = this.matcher.lookup(args[2]);
                if (old == null) {
                    return "Error: class not found: " + args[1];
                }
                if (neu == null) {
                    return "Error: class not found: " + args[2];
                }
                old.swap(neu);
                this.out.println(this.handleCommand("get", args[1]));
                return this.handleCommand("get", args[2]);
            }
            case "save-mcp": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                File output = new File(args[1]);
                SRGFileParser parser = new SRGFileParser("", false);
                DirectOBFTable table = new DirectOBFTable();
                parser.loadEntries(this.srg, table, true);
                table = this.remapper.remapTree(table);
                parser.storeEntries(output, table);
                this.out.println("Conversion complete.");
                return "result saved to " + args[1];
            }
            case "save-tree": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                File output = new File(args[1]);
                BufferedWriter w = new BufferedWriter(new FileWriter(output));
                w.write(this.matcher.toString());
                ((Writer)w).close();
                return "Tree saved to " + args[1];
            }
            case "save-json": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                File output = new File(args[1]);
                BufferedWriter w = new BufferedWriter(new FileWriter(output));
                w.write(this.matcher.writeToJson());
                ((Writer)w).close();
                return "Tree saved to " + args[1];
            }
            case "load-json": {
                if (args.length < 3) {
                    return "Error: Too few arguments.";
                }
                this.matcher = this.remapper.loadMatcherFromJson(args[2]);
                if (this.matcher == null) {
                    return "Error: Could not load matcher.";
                }
            }
            case "list": {
                if (args.length < 2) {
                    return "Error: Too few arguments.";
                }
                int count = 0;
                switch (args[1].toLowerCase()) {
                    case "unmatched": {
                        this.out.println("Unmatched source classes:");
                        for (String i : this.matcher.getUnmatched()) {
                            ClassTree item = this.matcher.before().lookup(i);
                            this.out.println(String.valueOf(++count) + ". Parent: " + item.parent().description());
                            this.out.println(item.toString());
                        }
                        break block13;
                    }
                    case "unassigned": {
                        this.out.println("Unassigned destination classes:");
                        for (String i : this.matcher.getUnassigned()) {
                            ClassTree item = this.matcher.after().lookup(i);
                            this.out.println(String.valueOf(++count) + ". Parent: " + item.parent().description());
                            this.out.println(item.toString());
                        }
                    }
                }
                break;
            }
            case "grep": {
                String line;
                boolean reverse = args.length == 2 && "reverse".equalsIgnoreCase(args[1]);
                Options ops = new Options();
                while ((line = this.readLine()) != null && !"\\".equals(line)) {
                    ops.readOption(line);
                }
                if (ops.size() == 0) {
                    this.out.println("Error: No conditions given!");
                    this.out.println("Specify conditions one per line as: {property}={value}");
                    this.out.println("Terminate with \"\\\"");
                    return null;
                }
                ClassTree tree = reverse ? this.matcher.after() : this.matcher.before();
                int matches = 0;
                for (String i : tree.keySet()) {
                    ClassTreeMatcher looked;
                    ClassTree node = tree.lookup(i);
                    if (ops.containsKey("fields") && ops.getInt("fields") != node.fields() || ops.containsKey("methods") && ops.getInt("methods") != node.methods() || ops.containsKey("interfaces") && ops.getInt("interfaces") != node.interfaces() || ops.containsKey("isInner") && ops.getBool("IsInner") != node.isInner() || ops.containsKey("isInterface") && ops.getBool("IsInterface") != node.isInner() || ops.containsKey("parent") && !((String)ops.get("parent")).equals(node.parent().getName())) continue;
                    ClassTreeMatcher classTreeMatcher = looked = reverse ? this.matcher.reverseLookup(i) : this.matcher.lookup(i);
                    if (ops.containsKey("unmatched") && (!ops.getBool("unmatched") ? looked == null : looked != null) || ops.containsKey("namechange") && (!ops.getBool("namechange") ? looked == null || !looked.before().getName().equals(looked.after().getName()) : looked != null && looked.before().getName().equals(looked.after().getName()))) continue;
                    if (looked == null) {
                        this.out.print(reverse ? "{null} -> " : "{null} <- ");
                        this.out.println(node.description());
                    } else {
                        if (ops.containsKey("samefields") && ops.getBool("samefields") != (looked.before().fields() == looked.after().fields()) || ops.containsKey("samemethods") && ops.getBool("samemethods") != (looked.before().methods() == looked.after().methods()) || ops.containsKey("sameinterfaces") && ops.getBool("sameinterfaces") != (looked.before().interfaces() == looked.after().interfaces())) continue;
                        this.out.println(looked.description());
                    }
                    ++matches;
                }
                this.out.println(String.valueOf(matches) + " classes matched.");
            }
        }
        return null;
    }

    @Override
    public void printHelp() {
        this.out.println("lookup [classname] {full}\t-\tRetrieves a single class mapping from a loaded tree.");
        this.out.println("lookup-reverse [classname] {full}\t-\tRetrieves the class that is mapped into the given one.");
        this.out.println("lookup-parent [classname] {reverse}\t-\tRetrieves the parent of the given class.");
        this.out.println("define [from] [to]\t-\tDefines a new mapping between two classes. (parents/children/interfaces are implicitly defined)");
        this.out.println("swap [one] [two]\t-\tSwaps the destinations of two classes.");
        this.out.println("save-mcp [file]\t-\tRemap and output mcp mappings for the current class map tree.");
        this.out.println("save-tree [file]\t-\tOutput the entire class map tree to file.");
        this.out.println("save-json [file]\t-\tSaves the match tree to json. Useful if you want to edit it later.");
        this.out.println("load-json [file]\t-\tLoads a match tree from json.");
        this.out.println("list [unmatched|unassigned]\t-\tPrints a list of all classes not included in the matching tree.");
        this.out.println("grep {reverse}\t-\tFinds classes matching given conditions.");
        this.out.println("exit\t-\tExit");
    }
}

