/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.hash;

import java.lang.reflect.Array;

public abstract class Hash {
    private static final int PRIME = 37;
    public static final int SEED = 19;

    public static int hash(int seed, boolean val) {
        return Hash.firstTerm(seed) + (val ? 1 : 0);
    }

    public static int hash(int seed, char val) {
        return Hash.firstTerm(seed) + val;
    }

    public static int hash(int seed, long val) {
        return Hash.firstTerm(seed) + (int)(val ^ val >>> 32);
    }

    public static int hash(int seed, float val) {
        return Hash.hash(seed, Float.floatToIntBits(val));
    }

    public static int hash(int seed, double val) {
        return Hash.hash(seed, Double.doubleToLongBits(val));
    }

    public static int hash(int seed, int val) {
        return Hash.firstTerm(seed) + val;
    }

    public static int hash(int seed, Object obj) {
        int result = seed;
        if (obj == null) {
            result = Hash.hash(result, 0);
        } else if (!Hash.isArray(obj)) {
            result = Hash.hash(result, obj.hashCode());
        } else {
            int length = Array.getLength(obj);
            int index = 0;
            while (index < length) {
                Object item = Array.get(obj, index);
                if (item != obj) {
                    result = Hash.hash(result, item);
                }
                ++index;
            }
        }
        return result;
    }

    private static int firstTerm(int seed) {
        return 37 * seed;
    }

    private static boolean isArray(Object obj) {
        return obj.getClass().isArray();
    }
}

