/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.FileParser;
import net.acomputerdog.OBFUtil.parse.FormatException;
import net.acomputerdog.OBFUtil.parse.URLParser;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.OBFUtil.table.OBFTableSRG;
import net.acomputerdog.OBFUtil.util.Obfuscator;

public class ONFParser
extends FileParser
implements URLParser {
    private final Obfuscator obfuscator = new Obfuscator();
    private String activeDirectory = null;
    private final List<DetectedTransformation> transformations = Lists.newArrayList();
    private final List<String> seenFiles = Lists.newArrayList();

    public List<DetectedTransformation> getDetectedTransformations() {
        return this.transformations;
    }

    @Override
    public void loadEntries(File file, OBFTable table, boolean overwrite) throws IOException {
        this.activeDirectory = file.getParent();
        this.seenFiles.add(file.getName());
        this.loadEntries(new FileInputStream(file), table, overwrite);
        this.activeDirectory = null;
        this.seenFiles.clear();
    }

    @Override
    public void loadEntries(URL url, OBFTable table, boolean overwrite) throws IOException {
        String path = url.getPath().replace("\\", "/");
        this.activeDirectory = path.substring(0, path.lastIndexOf("/"));
        this.seenFiles.add(path.replace(this.activeDirectory, ""));
        this.loadEntries(url.openStream(), table, overwrite);
        this.activeDirectory = null;
        this.seenFiles.clear();
    }

    private void loadEntries(InputStream stream, OBFTable table, boolean overwrite) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        try (BufferedReader in = null;){
            try {
                in = new BufferedReader(new InputStreamReader(stream));
                this.parseFile(in, table, overwrite);
            }
            catch (IOException e) {
                throw new IOException("Exception whilst reading file", e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Exception whilst reading file", e);
            }
        }
    }

    private void handleImport(String fileName, OBFTable table, boolean overwrite) {
        if (this.seenFiles.contains(fileName)) {
            return;
        }
        InputStream input = null;
        try {
            if (this.activeDirectory.contains("!")) {
                input = ONFParser.class.getResourceAsStream(this.activeDirectory.split("!")[1].concat("/").concat(fileName));
            } else {
                File f = new File(this.activeDirectory, fileName);
                if (f.exists()) {
                    input = new FileInputStream(f);
                }
            }
            if (input == null) {
                throw new IllegalArgumentException("File \"" + this.activeDirectory.concat("/").concat(fileName) + "\" could not be opened.");
            }
            this.seenFiles.add(fileName);
            this.loadEntries(input, table, overwrite);
        }
        catch (IOException e) {
            new IllegalArgumentException("Exception whilst sideloading file: \"" + fileName + "\". Skipping.", e).printStackTrace();
        }
    }

    @Override
    public void storeEntries(File file, OBFTable table) throws IOException {
        this.storeEntries(new FileOutputStream(file), table);
    }

    public void storeEntries(OutputStream stream, OBFTable table) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("OutputStream must not be null!");
        }
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter(stream));
            if (table instanceof OBFTableSRG) {
                this.writeTableSRG(out, (OBFTableSRG)table);
            } else {
                this.writeTableNormal(out, table);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void parseFile(BufferedReader in, OBFTable table, boolean overwrite) throws IOException {
        String i;
        boolean takeSrg = table instanceof OBFTableSRG;
        String[] activePackage = null;
        String[] activeClass = null;
        ArrayList<Object[]> retroActive = Lists.newArrayList();
        block6: while ((i = in.readLine()) != null) {
            if (i.isEmpty() || i.startsWith("#")) continue;
            if ((i = i.split("#")[0]).startsWith(">>")) {
                this.handleImport(i.substring(2, i.length()), table, overwrite);
                continue;
            }
            TargetType type = this.typeof(i);
            i = i.trim();
            String[] parsed = null;
            switch (type) {
                case PACKAGE: {
                    activePackage = parsed = this.unambiguate(i, type);
                    break;
                }
                case CLASS: {
                    parsed = this.unambiguate(i, type);
                    activeClass = parsed;
                    if (activePackage == null) {
                        throw new FormatException("Class before package at \n" + i);
                    }
                    parsed = this.prependClassAndPackage(parsed, new String[][]{activePackage});
                    break;
                }
                case FIELD: {
                    if (activeClass == null) {
                        throw new FormatException("Field before class at \n" + i);
                    }
                    parsed = this.prependClassAndPackage(this.unambiguate(i, type), new String[][]{activeClass});
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    if (activeClass == null) {
                        throw new FormatException("Method/Constructor before class at \n" + i);
                    }
                    if (i.indexOf(" ") == -1) {
                        throw new FormatException("Missing Method/Constructor arguments at \n" + i);
                    }
                    parsed = this.prependClassAndPackage(this.unambiguate(i, type), new String[][]{activeClass});
                    retroActive.add(new Object[]{type, parsed, i.indexOf("\\!") != -1 ? null : i.split("\\!")[0]});
                    continue block6;
                }
            }
            if (i.indexOf("!") != -1 && type == TargetType.CLASS || type == TargetType.FIELD) {
                this.transformations.add(new DetectedTransformation(i.split("!")[0], parsed[2], type));
            }
            if (!(overwrite | !table.hasObf(parsed[0], type))) continue;
            if (takeSrg) {
                ((OBFTableSRG)table).addTypeSRG(parsed[0], parsed[1], parsed[2], type);
                continue;
            }
            table.addType(parsed[0], parsed[2], type);
        }
        for (Object[] j : retroActive) {
            String[] parsed = (String[])j[1];
            String deobfuscatedDecriptor = parsed[2].split(" ")[1];
            String obfuscatedDescriptor = this.obfuscator.obfuscateDescriptor(deobfuscatedDecriptor, table);
            TargetType type = (TargetType)((Object)j[0]);
            parsed[0] = String.valueOf(parsed[0].split(" ")[0]) + " " + obfuscatedDescriptor;
            parsed[1] = String.valueOf(parsed[1].split(" ")[0]) + " " + deobfuscatedDecriptor;
            if (overwrite | !table.hasObf(parsed[0], type)) {
                if (takeSrg) {
                    ((OBFTableSRG)table).addTypeSRG(parsed[0], parsed[1], parsed[2], type);
                } else {
                    table.addType(parsed[0], parsed[2], type);
                }
            }
            if (j[2] == null) continue;
            this.transformations.add(new DetectedTransformation((String)j[2], parsed[2], type));
        }
    }

    protected void writeTableNormal(Writer out, OBFTable table) throws IOException {
        String[] packages = table.getAllDeobf(TargetType.PACKAGE);
        String[] classes = table.getAllDeobf(TargetType.CLASS);
        String[] fields = table.getAllDeobf(TargetType.FIELD);
        String[] methods = table.getAllDeobf(TargetType.METHOD);
        String[] constructors = table.getAllDeobf(TargetType.CONSTRUCTOR);
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            String obf = table.obf(pack, TargetType.PACKAGE);
            out.write(String.valueOf(obf) + ":" + pack + "\n");
            String[] stringArray2 = classes;
            int n3 = classes.length;
            int n4 = 0;
            while (n4 < n3) {
                String clazz = stringArray2[n4];
                if (clazz.indexOf(pack) == 0) {
                    String clazzName = clazz.replace(String.valueOf(pack) + ".", "");
                    String clazzNameObf = table.obf(clazz, TargetType.CLASS).replace(obf, "");
                    out.write("\t" + clazzNameObf + ":" + clazzName);
                    String[] stringArray3 = fields;
                    int n5 = fields.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String field = stringArray3[n6];
                        if (field.indexOf(clazz) == 0) {
                            String fieldName = field.replace(String.valueOf(clazz) + ".", "");
                            String fieldNameObf = table.obf(field, TargetType.FIELD).replace(String.valueOf(clazz) + ".", "");
                            out.write("\t\t" + fieldNameObf + ":" + fieldName);
                        }
                        ++n6;
                    }
                    stringArray3 = constructors;
                    n5 = constructors.length;
                    n6 = 0;
                    while (n6 < n5) {
                        String constr = stringArray3[n6];
                        if (constr.indexOf(clazz) == 0) {
                            out.write("\t\t<init> " + constr.split(" ")[1] + "\n");
                        }
                        ++n6;
                    }
                    stringArray3 = methods;
                    n5 = methods.length;
                    n6 = 0;
                    while (n6 < n5) {
                        String method = stringArray3[n6];
                        if (method.indexOf(clazz) == 0) {
                            String desc = method.split(" ")[1];
                            String methodName = method.replace(String.valueOf(clazz) + ".", "").split(" ")[0];
                            String methodNameObf = table.obf(method, TargetType.METHOD).replace(String.valueOf(clazz) + ".", "").split(" ")[0];
                            out.write("\t\t" + methodNameObf + ":" + methodName + " " + desc);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void writeTableSRG(Writer out, OBFTableSRG table) throws IOException {
        String[] packages = table.getAllDeobf(TargetType.PACKAGE);
        String[] classes = table.getAllDeobf(TargetType.CLASS);
        String[] fields = table.getAllDeobf(TargetType.FIELD);
        String[] methods = table.getAllDeobf(TargetType.METHOD);
        String[] constructors = table.getAllDeobf(TargetType.CONSTRUCTOR);
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String pack = stringArray[n2];
            String obf = table.obf(pack, TargetType.PACKAGE);
            out.write(String.valueOf(obf) + ":" + pack + "\n");
            String[] stringArray2 = classes;
            int n3 = classes.length;
            int n4 = 0;
            while (n4 < n3) {
                String clazz = stringArray2[n4];
                if (clazz.indexOf(pack) == 0) {
                    String clazzName = clazz.replace(String.valueOf(pack) + ".", "");
                    String clazzNameObf = table.obf(clazz, TargetType.CLASS).replace(obf, "");
                    out.write("\t" + clazzNameObf + ":" + clazzName + "\n");
                    String[] stringArray3 = fields;
                    int n5 = fields.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String field = stringArray3[n6];
                        if (field.indexOf(clazz) == 0) {
                            String fieldName = field.replace(String.valueOf(clazz) + ".", "");
                            String fieldNameSrg = table.getSRGFromDeObf(field, TargetType.FIELD).replace(String.valueOf(clazz) + ".", "");
                            String fieldNameObf = table.obf(field, TargetType.FIELD).replace(String.valueOf(clazz) + ".", "");
                            out.write("\t\t" + fieldNameObf + ":" + fieldNameSrg + ":" + fieldName + "\n");
                        }
                        ++n6;
                    }
                    stringArray3 = constructors;
                    n5 = constructors.length;
                    n6 = 0;
                    while (n6 < n5) {
                        String constr = stringArray3[n6];
                        if (constr.indexOf(clazz) == 0) {
                            out.write("\t\t<init> " + constr.split(" ")[1] + "\n");
                        }
                        ++n6;
                    }
                    stringArray3 = methods;
                    n5 = methods.length;
                    n6 = 0;
                    while (n6 < n5) {
                        String method = stringArray3[n6];
                        if (method.indexOf(clazz) == 0) {
                            String desc = method.split(" ")[1];
                            String methodName = method.replace(String.valueOf(clazz) + ".", "").split(" ")[0];
                            String methodNameSrg = table.getSRGFromDeObf(method, TargetType.METHOD).replace(String.valueOf(clazz) + ".", "").split(" ")[0];
                            String methodNameObf = table.obf(method, TargetType.METHOD).replace(String.valueOf(clazz) + ".", "").split(" ")[0];
                            out.write("\t\t" + methodNameObf + ":" + methodNameSrg + ":" + methodName + " " + desc + "\n");
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private String[] prependClassAndPackage(String[] arr, String[] ... components) {
        int i = 0;
        while (i < arr.length) {
            int j = components.length - 1;
            while (j >= 0) {
                if (!components[j][i].isEmpty()) {
                    arr[i] = String.valueOf(components[j][i]) + "." + arr[i];
                }
                --j;
            }
            ++i;
        }
        return arr;
    }

    private String[] unambiguate(String line, TargetType type) {
        if (line.indexOf(33) != -1) {
            line = line.split("!")[1];
        }
        if (line.indexOf(58) != -1) {
            String[] split = line.split(":");
            if (split.length >= 3) {
                if (type == TargetType.METHOD) {
                    split[1] = "func_" + split[1];
                } else if (type == TargetType.FIELD) {
                    split[1] = "field_" + split[1];
                }
                return new String[]{split[0], split[1], split[2]};
            }
            return new String[]{split[0], split[1], split[1]};
        }
        return new String[]{line, line, line};
    }

    private TargetType typeof(String raw) {
        if (raw.startsWith("\t\t")) {
            if (raw.trim().indexOf(32) == -1) {
                return TargetType.FIELD;
            }
            if (raw.indexOf("<iinit>") == 0) {
                return TargetType.CONSTRUCTOR;
            }
            return TargetType.METHOD;
        }
        if (raw.startsWith("\t")) {
            return TargetType.CLASS;
        }
        return TargetType.PACKAGE;
    }

    public class DetectedTransformation {
        public final boolean isGlobal;
        public final String directives;
        public final String mcpTarget;
        public final TargetType targetType;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private DetectedTransformation(String transform, String target, TargetType type) throws FormatException {
            this.mcpTarget = target;
            boolean bl = this.isGlobal = type == TargetType.CLASS;
            if (this.isGlobal) {
                boolean hasF;
                boolean hasM = transform.lastIndexOf(109) >= transform.length() - 2;
                boolean bl2 = hasF = transform.lastIndexOf(102) >= transform.length() - 2;
                if (!hasM && !hasF) throw new FormatException("Global access transformations must have a target type flag (f|m) at \n" + transform + "!" + target);
                transform = transform.substring(0, transform.length() - 1);
                if (hasM) {
                    this.targetType = TargetType.METHOD;
                    if (hasF) {
                        transform = transform.substring(0, transform.length() - 1);
                        ONFParser.this.transformations.add(new DetectedTransformation(transform, target, TargetType.FIELD, true));
                    }
                } else {
                    this.targetType = TargetType.FIELD;
                }
            } else {
                this.targetType = type;
            }
            this.directives = transform;
        }

        private DetectedTransformation(String transform, String target, TargetType type, boolean global) {
            this.directives = transform;
            this.mcpTarget = target;
            this.targetType = type;
            this.isGlobal = global;
        }
    }
}

