/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.FileParser;
import net.acomputerdog.OBFUtil.parse.FormatException;
import net.acomputerdog.OBFUtil.parse.StreamParser;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.core.java.Patterns;

public class OBFParser
extends FileParser
implements StreamParser {
    @Override
    public void storeEntries(File file, OBFTable table) throws IOException {
        this.storeEntries(new FileOutputStream(file), table);
    }

    @Override
    public void loadEntries(InputStream stream, OBFTable table, boolean overwrite) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Stream cannot be null!");
        }
        try (BufferedReader in = null;){
            in = new BufferedReader(new InputStreamReader(stream));
            this.parseFile(in, table, overwrite);
        }
    }

    @Override
    public void storeEntries(OutputStream stream, OBFTable table) throws IOException {
        if (stream == null) {
            throw new NullPointerException("Stream cannot be null!");
        }
        try (BufferedWriter out = null;){
            out = new BufferedWriter(new OutputStreamWriter(stream));
            this.writeTable(out, table);
        }
    }

    @Override
    protected void parseFile(BufferedReader reader, OBFTable table, boolean overwrite) throws IOException {
        String str;
        int line = 0;
        while ((str = reader.readLine()) != null) {
            ++line;
            if (this.isCommentLine(str)) continue;
            String[] typeParts = str.split(Patterns.COLON);
            if (typeParts.length < 2) {
                throw new FormatException("Format error on line " + line + ": \"" + str + "\"");
            }
            TargetType type = TargetType.valueOf(typeParts[0]);
            if (type == null) {
                throw new FormatException("Illegal target type on line " + line + ": \"" + typeParts[0] + "\"");
            }
            String[] obfParts = typeParts[1].split(Patterns.EQUALS);
            if (obfParts.length < 2) {
                throw new FormatException("Format error on line " + line + ": \"" + str + "\"");
            }
            if (!overwrite && table.hasDeobf(obfParts[0], type)) continue;
            table.addType(obfParts[0], obfParts[1], type);
        }
    }

    protected void writeTable(Writer out, OBFTable table) throws IOException {
        TargetType[] targetTypeArray = TargetType.values();
        int n = targetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetType type = targetTypeArray[n2];
            if (table.supportsType(type)) {
                String[] stringArray = table.getAllObf(type);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String obf = stringArray[n4];
                    this.writeEntry(out, obf, type, table);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected void writeEntry(Writer out, String obf, TargetType type, OBFTable table) throws IOException {
        String deobf = table.deobf(obf, type);
        out.write(type.name());
        out.write(":");
        out.write(obf);
        out.write("=");
        out.write(deobf);
        out.write("\n");
    }

    protected boolean isCommentLine(String str) {
        String trimmed = str.trim();
        return trimmed.isEmpty() || trimmed.startsWith("#") || trimmed.startsWith("//");
    }
}

