/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.transformations;

import com.blazeloader.util.transformers.transformations.TargetSelector;
import com.blazeloader.util.transformers.transformations.Transformation;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodSelector
implements TargetSelector {
    private Transformation transformation;
    private final String methodDesc;
    private final String methodName;
    private final boolean global;

    public MethodSelector(String name) {
        this.global = "*".equals(name);
        this.methodDesc = name.split(" ")[1];
        this.methodName = name.split(" ")[0];
    }

    @Override
    public TargetSelector initWith(Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    @Override
    public boolean match(ClassNode cls) {
        boolean didApply = false;
        for (MethodNode method : cls.methods) {
            if (!this.global && (!method.name.equals(this.methodName) || !method.desc.equals(this.methodDesc))) continue;
            this.transformation.transformMethod(method);
            didApply = true;
        }
        return didApply;
    }
}

