/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.util.transformers.mapping;

import com.blazeloader.util.transformers.mapping.TransformationMap;
import com.blazeloader.util.transformers.transformations.Transformation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;

public class DefaultTransformationMap
extends HashMap<String, List<Transformation>>
implements TransformationMap {
    @Override
    public List<Transformation> getClassMap(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name must not be null!");
        }
        LinkedList trans = (LinkedList)this.get(className);
        if (trans == null) {
            trans = new LinkedList();
            this.put(className, trans);
        }
        return trans;
    }

    @Override
    public int getNumTransformations(String className) {
        return this.getClassMap(className).size();
    }

    @Override
    public void addTransformation(Transformation transformation) {
        if (transformation == null || transformation.targetClass == null) {
            throw new IllegalArgumentException("Class name and transformation must not be null!");
        }
        this.getClassMap(transformation.targetClass).add(transformation);
    }

    @Override
    public boolean applyAll(String className, ClassNode node) {
        boolean result = false;
        for (Transformation trans : this.getClassMap(className)) {
            result |= trans.apply(node);
        }
        return result;
    }
}

