/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.tree;

import com.blazeloader.jarjar.tree.ClassMap;
import com.blazeloader.jarjar.tree.Tree;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.acomputerdog.core.java.Patterns;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTree
implements Tree<ClassTree, String> {
    private ClassTree parent = null;
    private ClassTree root = null;
    private final List<ClassTree> interfaces = new ArrayList<ClassTree>();
    private final List<ClassTree> inners = new ArrayList<ClassTree>();
    private final List<ClassTree> children = new ArrayList<ClassTree>();
    private final String className;
    private final String outer;
    private final ClassNode element;
    private final boolean anon;
    private boolean isinterface = false;
    private boolean isabstract = false;
    private final int fields;
    private final int methods;
    private int abstractMethods = 0;

    public ClassTree(ClassMap classMap) {
        this.element = null;
        this.className = "java/lang/Object";
        this.root = this;
        this.anon = false;
        this.outer = null;
        this.methods = 0;
        this.fields = 0;
        ArrayList<Map.Entry<String, ClassNode>> classes = Lists.newArrayList();
        classes.addAll(classMap.entrySet());
        this.loadChildren(classes);
        this.loadinterfaces(classes, classMap);
        this.loadOrphans(classes, classMap);
        this.cleanupAnonymouseClasses();
        this.initialiseInnerClasses();
    }

    private ClassTree(String name) {
        this.className = name;
        this.anon = ClassTree.isAnon(name);
        this.outer = ClassTree.getOuter(name);
        this.element = null;
        this.methods = 0;
        this.fields = 0;
    }

    private ClassTree(String key, ClassNode element) {
        this.className = key;
        this.anon = ClassTree.isAnon(key);
        this.outer = ClassTree.getOuter(key);
        this.element = element;
        this.fields = element == null || element.fields == null ? 0 : element.fields.size();
        this.methods = element == null || element.methods == null ? 0 : element.methods.size();
        this.isabstract = (element.access & 0x400) != 0;
        for (MethodNode i : element.methods) {
            if (!Modifier.isAbstract(i.access)) continue;
            ++this.abstractMethods;
        }
    }

    public static boolean isAnon(String name) {
        int dollar = name.lastIndexOf(36);
        if (dollar == -1) {
            return false;
        }
        name = name.substring(dollar + 1, name.length());
        return Character.isDigit(name.charAt(0));
    }

    public static String getOuter(String name) {
        int dollar = name.lastIndexOf(36);
        if (dollar == -1) {
            return null;
        }
        name = name.substring(0, dollar);
        return name;
    }

    public static String getInner(String name) {
        int dollar = name.lastIndexOf(36);
        if (dollar == -1) {
            return null;
        }
        name = name.substring(dollar + 1, name.length());
        return name;
    }

    private ClassTree loadChildren(List<Map.Entry<String, ClassNode>> classes) {
        Iterator<Map.Entry<String, ClassNode>> iter = classes.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ClassNode> entry = iter.next();
            if (!this.classNameEquals(entry.getValue().superName)) continue;
            iter.remove();
            this.addChild(new ClassTree(entry.getKey(), entry.getValue()));
        }
        for (ClassTree i : this.children) {
            i.loadChildren(classes);
        }
        return this;
    }

    private void loadinterfaces(List<Map.Entry<String, ClassNode>> classes, ClassMap classMap) {
        if (this.element != null && this.element.interfaces != null) {
            for (String face : this.element.interfaces) {
                ClassNode node;
                ClassTree iface = this.root().lookup(face);
                if (iface == null && (node = (ClassNode)classMap.get(face)) != null) {
                    classes.remove(classMap.getEntry(face));
                    iface = this.root().addChild(new ClassTree(face, node));
                }
                if (iface == null) continue;
                this.interfaces.add(iface);
                iface.isinterface = true;
                iface.loadChildren(classes).loadinterfaces(classes, classMap);
            }
        }
    }

    private void loadOrphans(List<Map.Entry<String, ClassNode>> classes, ClassMap classMap) {
        System.out.println("Loading orphaned classes...");
        int count = 0;
        Iterator<Map.Entry<String, ClassNode>> iter = classes.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ClassNode> entry = iter.next();
            iter.remove();
            ClassTree orphan = new ClassTree(entry.getKey(), entry.getValue());
            orphan.loadChildren(classes);
            iter = classes.iterator();
            ClassTree parent = this.root().lookup(orphan.element.superName);
            if (parent == null) {
                ClassNode node = (ClassNode)classMap.get(orphan.element.superName);
                if (node != null) {
                    classes.remove(classMap.getEntry(orphan.element.superName));
                    iter = classes.iterator();
                    parent = new ClassTree(orphan.element.superName, node);
                } else {
                    parent = new ClassTree(orphan.element.superName);
                }
                this.root().addChild(parent);
            }
            parent.addChild(orphan);
            ++count;
        }
        if (count > 0) {
            System.out.println(String.valueOf(count) + " orphaned classes salvaged into {root}->{unknown/3rd party}->{orphan}");
        }
    }

    private void cleanupAnonymouseClasses() {
        ArrayList<ClassTree> anons = new ArrayList<ClassTree>();
        for (ClassTree i : this.children) {
            List ifaces;
            if (i.element == null || (ifaces = i.element.interfaces) == null || ifaces.size() != 1) continue;
            anons.add(i);
        }
        int added = 0;
        int created = 0;
        for (ClassTree i : anons) {
            List ifaces = i.element.interfaces;
            ClassTree face = this.root().lookup((String)ifaces.get(0));
            if (face == null) {
                ++created;
                face = this.root().addChild(new ClassTree((String)ifaces.get(0)));
            }
            ++added;
            face.addChild(i);
        }
        if (created > 0) {
            System.out.println(String.valueOf(created) + " interfaces classes created at {root}->{interface/3rd party}");
        }
        if (added > 0) {
            System.out.println(String.valueOf(added) + " inner classes moved to {root}->{interface/3rd party}->{inner}");
        }
    }

    private void initialiseInnerClasses() {
        for (ClassTree i : this.children) {
            if (i.isInner()) {
                i.outer().inners.add(i);
            }
            i.initialiseInnerClasses();
        }
    }

    @Override
    public ClassTree sort() {
        Collections.sort(this.children);
        Collections.sort(this.inners);
        for (ClassTree i : this.children) {
            i.sort();
        }
        return this;
    }

    @Override
    public ClassTree addChild(ClassTree child) {
        if (!child.isAnonymous()) {
            this.children.add(child);
            if (child.parent != null) {
                child.parent.children.remove(child);
            }
            child.parent = this;
            child.root = this.root();
        }
        return child;
    }

    @Override
    public List<ClassTree> children() {
        return this.children;
    }

    public int interfaces() {
        return this.interfaces.size();
    }

    public int fields() {
        return this.fields;
    }

    public int methods() {
        return this.methods;
    }

    public boolean isAnonymous() {
        return this.anon;
    }

    public boolean isInner() {
        return this.outer != null;
    }

    public boolean isInterface() {
        return this.isinterface;
    }

    public boolean isAbstract() {
        return this.isabstract || this.isInterface();
    }

    public ClassTree outer() {
        return this.isInner() ? this.root().lookup(this.outer) : null;
    }

    public List<ClassTree> inner() {
        return this.inners;
    }

    @Override
    public ClassTree parent() {
        return this.parent != null ? this.parent : this.root();
    }

    @Override
    public ClassTree root() {
        return this.root;
    }

    public String getName() {
        return this.className;
    }

    @Override
    public ClassTree lookup(String className) {
        if (this.className.equals(className)) {
            return this;
        }
        ClassTree result = null;
        for (ClassTree i : this.children) {
            result = i.lookup(className);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public double similarity(ClassTree other) {
        return 100.0 * (this.similarityInt(other) / (double)Math.max(this.size() + this.implSize(), other.size() + other.implSize()));
    }

    private boolean matchNesting(ClassTree other) {
        ClassTree one = this;
        while (one != null && other != null) {
            if (one.isInner() != other.isInner()) {
                return false;
            }
            one = one.outer();
            other = other.outer();
        }
        return true;
    }

    private double matchAttributes(ClassTree other) {
        double result = 0.0;
        result += (double)(this.similarity(this.fields(), other.fields()) / 6.0f);
        result += (double)(this.similarity(this.methods(), other.methods()) / 6.0f);
        result += (double)(this.similarity(this.abstractMethods, other.abstractMethods) / 6.0f);
        result += (double)(this.similarity(this.interfaces(), other.interfaces()) / 6.0f);
        if (this.isInner() && this.matchNesting(other)) {
            result += 0.0;
        }
        if (this.isAbstract() == other.isAbstract()) {
            result += 0.0;
        }
        return result;
    }

    private float similarity(int one, int two) {
        if (one == two) {
            return 1.0f;
        }
        one = Math.abs(one);
        two = Math.abs(two);
        return (float)Math.min(one, two) / (float)Math.max(one, two);
    }

    private double similarityInt(ClassTree other) {
        if (this.isInterface() != other.isInterface()) {
            return 0.0;
        }
        if (this.isInner() != other.isInner()) {
            return 0.0;
        }
        double result = this.matchAttributes(other) + this.reverseSimilarity(other);
        if (this.children.size() == 0 && other.children.size() == 0) {
            return result;
        }
        int i = 0;
        while (i < this.children.size() && i < other.children.size()) {
            result += this.children.get(i).similarityInt(other.children.get(i));
            ++i;
        }
        return result;
    }

    private double reverseSimilarity(ClassTree other) {
        double result = Math.min(this.interfaces(), other.interfaces());
        int i = 0;
        while (i < this.interfaces() && i < other.interfaces()) {
            result += this.interfaces.get(i).reverseSimilarity(other.interfaces.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public int size() {
        int size = 1;
        for (ClassTree i : this.children) {
            size += i.size();
        }
        return size;
    }

    public int implSize() {
        int size = this.interfaces.size();
        for (ClassTree i : this.interfaces) {
            size += i.implSize();
        }
        return size;
    }

    public boolean classNameEquals(String name) {
        if (name == null) {
            return this == this.root();
        }
        return name.equals(this.className);
    }

    @Override
    public String description() {
        return String.valueOf(this.className) + " { fields: " + this.fields() + "; methods: " + this.methods() + "; interfaces: " + this.interfaces() + " }";
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        String result = String.valueOf(indent) + this.description();
        result = String.valueOf(result) + Patterns.LINE_SEPARATOR;
        indent = String.valueOf(indent) + "\t";
        for (ClassTree i : this.children) {
            result = String.valueOf(result) + i.toString(indent);
        }
        return result;
    }

    @Override
    public int compareTo(ClassTree o) {
        int result = Integer.compare(this.size(), o.size());
        if (result == 0) {
            result = Integer.compare(this.methods(), o.methods());
        }
        if (result == 0) {
            result = Integer.compare(this.fields(), o.fields());
        }
        if (result == 0) {
            result = Integer.compare(this.interfaces(), o.interfaces());
        }
        return result;
    }

    @Override
    public List<String> keySet() {
        ArrayList<String> result = new ArrayList<String>();
        this.buildKeySet(result);
        return result;
    }

    private void buildKeySet(List<String> keyset) {
        keyset.add(this.className);
        for (ClassTree i : this.children) {
            i.buildKeySet(keyset);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ClassTree) {
            return this.getName().equals(((ClassTree)o).getName());
        }
        return false;
    }
}

