/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.bl.obf;

import com.blazeloader.bl.obf.BLOBFTable;
import com.blazeloader.bl.obf.OBFLevel;
import com.blazeloader.jarjar.Main;
import com.blazeloader.util.transformers.ONFTransformer;
import java.io.File;
import net.acomputerdog.OBFUtil.map.ObfMapSrg;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.types.ONFParser;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.core.java.Patterns;

public class BLOBF
implements ObfMapSrg.Entry {
    public final String obf;
    public final String srg;
    public final String name;
    public final String simpleMcp;
    public final String simpleObf;
    public final String simpleSrg;
    public static final BLOBFTable OBF = BLOBF.loadOBF();

    protected BLOBF(String obfName, String seargeName, String mcpName) {
        this.name = mcpName;
        this.srg = seargeName;
        this.obf = obfName;
        this.simpleMcp = this.splitPackageOff(mcpName);
        this.simpleObf = this.splitPackageOff(obfName);
        this.simpleSrg = this.splitPackageOff(seargeName);
    }

    private String splitPackageOff(String string) {
        String[] nameParts = string.split(Patterns.PERIOD);
        return nameParts.length > 0 ? nameParts[nameParts.length - 1] : string;
    }

    public String getValue() {
        if (OBFLevel.getCurrent() == OBFLevel.MCP) {
            return this.name;
        }
        if (OBFLevel.getCurrent() == OBFLevel.SRG) {
            return this.srg;
        }
        return this.obf;
    }

    public boolean matches(String name) {
        return this.name.equals(name) || this.obf.equals(name) || this.srg.equals(name) || this.simpleObf.equals(name) || this.simpleObf.split(" ")[0].equals(name) || this.simpleSrg.equals(name) || this.simpleSrg.split(" ")[0].equals(name) || this.simpleMcp.equals(name) || this.simpleMcp.split(" ")[0].equals(name);
    }

    private static BLOBFTable loadOBF() {
        BLOBFTable obf = new BLOBFTable();
        ONFParser parser = new ONFParser();
        BLOBF.loadEntries(parser, obf, true);
        ONFTransformer.setONFS(parser.getDetectedTransformations());
        return obf;
    }

    private static void loadEntries(ONFParser parser, BLOBFTable obf, boolean mustThrow) {
        try {
            parser.loadEntries(new File(Main.MAPPING_SOURCE), (OBFTable)obf, true);
        }
        catch (Exception e) {
            if (mustThrow) {
                throw new RuntimeException("Unable to load obfuscation table:", e);
            }
            e.printStackTrace();
        }
    }

    public static BLOBF getOBF(String obfName, TargetType type, OBFLevel level) {
        return OBF.getBLOBF(obfName, type, level);
    }

    @Override
    public String obf() {
        return this.obf;
    }

    @Override
    public String deObf() {
        return this.name;
    }

    @Override
    public String srg() {
        return this.srg;
    }
}

