# -*- coding: utf-8 -*-
"""TPDNE Editor v0.1 - TF Beta.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Ctw48hLWjqOMOM-ZptLqRmaom4OsBis2

# This Pony Does Not Exist - Pony Editor (Tensorflow Version Beta)


### To run:
**Click "Open in Playground" above (if you see that option) and then Runtime > Run All and wait a few minutes for everything to load. (Takes about 4 minutes)**

Feel free to watch the demo video or read the code (by clicking the triangle in the next section) while you wait.

---


### Credits

Customizable ponies using [my](https://twitter.com/arfafax) pony StyleGAN2 model from [TPDNE](https://thisponydoesnotexist.net/).

Latent directions were discovered using [@harskish](https://twitter.com/harskish)'s [Ganspace](https://github.com/harskish/ganspace) [notebook](https://colab.research.google.com/github/harskish/ganspace/blob/master/notebooks/Ganspace_colab.ipynb) put together by [@realmeatyhuman](https://twitter.com/realmeatyhuman).



---



### Shameless Plug
If you enjoyed This Pony Does Not Exist or This Fursona Does Not Exist and want to see more projects like it in the future, consider supporting me on Ko-fi or Patreon.

-[arfa](https://twitter.com/arfafax)


<div>
<a href="https://www.twitter.com/arfafax">
<img src="https://thisfursonadoesnotexist.com/arfa_sig.png" width="350"/>
</a>
</div>
<div>
<a href="https://ko-fi.com/arfafax">
<img src="https://cdn.ko-fi.com/cdn/kofi3.png?v=2" width="220"/>
</a>
<a href="https://www.patreon.com/arfafax">
<img src="https://c5.patreon.com/external/logo/become_a_patron_button.png" width="235"/>
</a>
</div>
"""

#@title Demo video
from IPython.display import YouTubeVideo
YouTubeVideo('wH_0vE3N2vc', width=1280, height=720)

"""## <- Click the triangle to view the code while you wait for it to load

"""

!git clone https://github.com/shawwn/stylegan2 -b estimator /content/stylegan2

import gdown
#!wget  -O /content/network-tpdne.pkl https://www.thisponydoesnotexist.net/model/network-ponies-1024-151552.pkl
!wget  -O /content/tpdne-directions.zip https://www.thisponydoesnotexist.net/tpdne-directions.zip

gdown.download('https://drive.google.com/uc?id=1jrciNNUmCaE0l7xSOc9SXTj4zqRp0KFn', '/content/network-tpdne.pkl', quiet=False)

# Commented out IPython magic to ensure Python compatibility.
# %tensorflow_version 1.x
# %cd /content/stylegan2

import os
import pickle
import numpy as np
import PIL.Image
import dnnlib
import dnnlib.tflib as tflib
import scipy
import tensorflow as tf
import tflex

if 'COLAB_TPU_ADDR' in os.environ:
    os.environ['TPU_NAME'] = 'grpc://' + os.environ['COLAB_TPU_ADDR']
    os.environ['NOISY'] = '1'

tflib.init_tf()
sess = tf.get_default_session()
sess.list_devices()
cores = tflex.get_cores()
tflex.set_override_cores(cores)
_G, _D, Gs = pickle.load(open("/content/network-tpdne.pkl", "rb"))
# _G = Instantaneous snapshot of the generator. Mainly useful for resuming a previous training run.
# _D = Instantaneous snapshot of the discriminator. Mainly useful for resuming a previous training run.
# Gs = Long-term average of the generator. Yields higher-quality results than the instantaneous snapshot.

def generate_image_from_w(w, truncation_psi):
    with tflex.device('/gpu:0'):
        noise_vars = [var for name, var in Gs.components.synthesis.vars.items() if name.startswith('noise')]
        Gs_kwargs = dnnlib.EasyDict()
        Gs_kwargs.output_transform = dict(func=tflib.convert_images_to_uint8, nchw_to_nhwc=True)
        Gs_kwargs.randomize_noise = False
        if truncation_psi is not None:
            Gs_kwargs.truncation_psi = truncation_psi
        synthesis_kwargs = dict(output_transform=Gs_kwargs.output_transform, truncation_psi=truncation_psi, minibatch_size=1)
        images = Gs.components.synthesis.run(w, randomize_noise=False, **synthesis_kwargs)
        display(PIL.Image.fromarray(images[0], 'RGB').resize((500,500),Image.LANCZOS))

# Commented out IPython magic to ensure Python compatibility.
# %cd "/content"

# Commented out IPython magic to ensure Python compatibility.
# %mkdir directions
# %cd directions
!unzip /content/tpdne-directions.zip

!rm /content/directions/StyleGAN2-Light_direction-ffhq-ipca-w-style-comp15-range8-9.pkl
!rm -r /content/directions/.ipynb_checkpoints
#!mv /content/directions/directions/* /content/ganspace/directions
#!rm -r /content/directions/directions

import os
named_directions = {}
latent_dirs = []
starts = []
ends = []
# 
path_to_directions = "/content/directions"

# This loads the directions in a dictionary in this format:
# {'name' : [direction_num, start, end]}
# and you load the direction by:
# directions[direction_num]

for i,file in enumerate(sorted(os.listdir(path_to_directions))):
    np_file = np.load(f'{path_to_directions}/{file}', allow_pickle=True)
    name = file.split("_layers_")[0].split("/")[-1]
    file = file.split('_')
    comp = int(name.split(".")[0][1:])
    
    named_directions[f'{name}'] = [comp, int(file[-2]), int(file[-1].split('.')[0]), f'{name}']
    if int(file[-2]) == 0:
        latent_dirs.append(np_file)

named_directions

# Commented out IPython magic to ensure Python compatibility.
import yaml
# %mkdir /content/animations
# %cd /content/animations

"""# UI

Paste a slider config below and run this cell to load that config:
"""

load_directions = """
a00.2: [0, 6, 8, Eye direction]
a00.4: [0, 10, 16, Body hue]
a01.0: [1, 2, 5, Zoom]
a02.0: [2, 0, 3, Head tilt]
a03.0: [3, 1, 4, Head angle]
a07.0: [7, 12, 14, Hair/Eye color]
a08.0: [8, 12, 14, Hair/Eye color]
a08.1: [8, 4, 5, Horn length]
a09.0: [9, 4, 9, Alicorn]
a09.1: [9, 0, 2, Head turn]
a10.0: [10, 9, 13, Hair streak]
a10.1: [10, 6, 9, Disgust to happy]
a11.0: [11, 7, 10, Mouth open]
a11.1: [11, 6, 9, Eye shape]
a12.0: [12, 9, 13, Shading]
a13.0: [13, 2, 4, Hair Floof]
a14.0: [14, 7, 8, Eye Dir]
a15.2: [15, 8, 9, Eyes C2O]
c00.0: [0, 0, 3, ':I - :o - :D']
c00.1: [0, 3, 6, ':D - :o - :I']
c00.2: [0, 6, 9, 'Eye direction']
c00.3: [0, 9, 12, c00.3]
c00.4: [0, 12, 15, 'palette']
c00.5: [0, 15, 18, 'almost no effect']
c01.0: [1, 0, 3, 'pov distance'] # 0-20 makes pony happier?
c01.1: [1, 3, 6, 'D: - o: - d:']
c01.2: [1, 6, 9, c01.2]
c01.3: [1, 9, 12, c01.3]
c01.4: [1, 12, 15, c01.4]
c01.5: [1, 15, 18, 'background lighting']
c02.0: [2, 0, 3, 'head left/right tilt']
c02.1: [2, 3, 6, 'head left/right tilt']
c02.2: [2, 6, 9, c02.2]
c02.3: [2, 9, 12, c02.3]
c02.4: [2, 12, 15, 'palette (slightly)']
c02.5: [2, 15, 18, 'almost no effect']
c03.0: [3, 0, 3, 'head left/right rotation']
c03.1: [3, 3, 6, 'head left/right rotation']
c03.2: [3, 6, 9, c03.2]
c03.3: [3, 9, 12, c03.3]
c03.4: [3, 12, 15, c03.4]
c03.5: [3, 15, 18, 'color temperature (almost invisible)']
c04.0: [4, 0, 3, 'mouth openess']
c04.1: [4, 3, 6, 'eyesight direction']
c04.2: [4, 6, 9, c04.2]
c04.3: [4, 9, 12, c04.3]
c04.4: [4, 12, 15, 'blue - pink colors']
c04.5: [4, 15, 18, 'color temperature (reversal, almost invisible)']
c05.0: [5, 0, 3, 'head size + mane style']
c05.1: [5, 3, 6, 'emotions']
c05.2: [5, 6, 9, c05.2]
c05.3: [5, 9, 12, c05.3]
c05.4: [5, 12, 15, 'palette']
c05.5: [5, 15, 18, 'color temperature (reversal, almost invisible)']
c06.0: [6, 0, 3, 'emotions']
c06.1: [6, 3, 6, 'mane style, no horn at +20']
c06.2: [6, 6, 9, c06.2]
c06.3: [6, 9, 12, c06.3]
c06.4: [6, 12, 15, 'palette'] # -20's colors just like oc:Bubble Lee colors
c06.5: [6, 15, 18, 'mane brightness/saturation']
c07.0: [7, 0, 3, 'head size + mane style']
c07.1: [7, 3, 6, 'head size + mane style']
c07.2: [7, 6, 9, c07.2]
c07.3: [7, 9, 12, c07.3]
c07.4: [7, 12, 15, 'palette'] # -20 was Pinkie
c07.5: [7, 15, 18, 'color temperature (almost invisible)']
c08.0: [8, 0, 3, 'eyesight direction']
c08.1: [8, 3, 6, 'mane style, horn size, emotions']
c08.2: [8, 6, 9, c08.2]
c08.3: [8, 9, 12, c08.3]
c08.4: [8, 12, 15, 'palette'] # -20 turned everything violet, +20 oversaturated
c08.5: [8, 15, 18, 'slight color temperature (reversal)']
c09.0: [9, 0, 3, 'head rotation + mane style']
c09.1: [9, 3, 6, 'eyesight direction + emotions']
c09.2: [9, 6, 9, c09.2]
c09.3: [9, 9, 12, c09.3]
c09.4: [9, 12, 15, 'palette'] # -20 turned everything violet
c09.5: [9, 15, 18, 'nothing']
c10.0: [10, 0, 3, '+20 makes pony drunk, -20 — right after she saw herself on +20']
c10.1: [10, 3, 6, 'mane style, horn size, emotions']
c10.2: [10, 6, 9, c10.2]
c10.3: [10, 9, 12, c10.3]
c10.4: [10, 12, 15, 'rarity-like - fluttershy-like colors']
c10.5: [10, 15, 18, 'slight color temperature']
c11.0: [11, 0, 3, 'cuteness (always use +20)']
c11.1: [11, 3, 6, 'emotions']
c11.2: [11, 6, 9, c11.2]
c11.3: [11, 9, 12, c11.3]
c11.4: [11, 12, 15, 'rarity-like (blue mane) - fluttershy-like colors']
c11.5: [11, 15, 18, 'slight color temperature']
c12.0: [12, 0, 3, 'emotions']
c12.1: [12, 3, 6, 'emotions (extreme disgust at +20)']
c12.2: [12, 6, 9, c12.2]
c12.3: [12, 9, 12, c12.3]
c12.4: [12, 12, 15, 'palette'] # -20 was Fluttershy colors 
c12.5: [12, 15, 18, 'color temperature (almost invisible)']
c13.0: [13, 0, 3, 'emotions']
c13.1: [13, 3, 6, 'eyesight direction']
c13.2: [13, 6, 9, c13.2]
c13.3: [13, 9, 12, c13.3]
c13.4: [13, 12, 15, 'palette'] # -20 was Pinkie colors
c13.5: [13, 15, 18, 'shadows intensivity (almost invisible)']
c14.0: [14, 0, 3, 'emotions']
c14.1: [14, 3, 6, 'emotions']
c14.2: [14, 6, 9, c14.2]
c14.3: [14, 9, 12, c14.3]
c14.4: [14, 12, 15, 'yellow - cyan colors'] # -20 was Fluttershy colors
c14.5: [14, 15, 18, 'slight color temperature']
c15.0: [15, 0, 3, 'emotions']
c15.1: [15, 3, 6, 'emotions']
c15.2: [15, 6, 9, 'Eyes C2O']
c15.3: [15, 9, 12, c15.3]
c15.4: [15, 12, 15, 'palette']
c15.5: [15, 15, 18, 'brightness (almost invisible)']
"""
named_directions = yaml.load(load_directions)

#@title Run UI (make sure you've done Runtime > Run All first or it won't work)
from ipywidgets import fixed
import PIL
import numpy as np
import ipywidgets as widgets
from PIL import Image
from IPython.display import clear_output
from ipywidgets import Layout, Button, Box, VBox, Label

box_layout = Layout(overflow='scroll hidden',
                    border='3px solid black',
                    width='',
                    height="500px")

loaded_w = None
def display_sample(seed, truncation, direction, distance, scale, start, end, update, disp=True, save=None, noise_spec=None, **args):
    global loaded_w
    if update == False:
        print("False")
    # blockPrint()
    rng = np.random.RandomState(seed)
    z = rng.standard_normal(*Gs.input_shape[1:]).reshape(1, *Gs.input_shape[1:])
    #z = np.load("/content/drive/My Drive/latents/1006-0-0-9.npy")
    noise_vars = [var for name, var in Gs.components.synthesis.vars.items() if name.startswith('noise')]
    Gs_kwargs = dnnlib.EasyDict()
    Gs_kwargs.randomize_noise = False

    all_w = Gs.components.mapping.run(z, None, **Gs_kwargs) # [minibatch, layer, component]
    if loaded_w is not None:
      all_w = loaded_w.copy()
    
    for i, item in enumerate(args):
        value = args[item]
        start_l = named_directions[item][1]
        end_l = named_directions[item][2]
        direction_l = latent_dirs[named_directions[item][0]]
        for l in range(start_l, end_l):
            all_w[0][l] = all_w[0][l] + direction_l * value * scale

    if truncation != 1:
        w_avg = Gs.get_var('dlatent_avg')
        all_w = w_avg + (all_w - w_avg) * truncation # [minibatch, layer, component]

    generate_image_from_w(all_w, truncation)

seed = np.random.randint(0,100000)
style = {'description_width': 'initial', 'width': '150px'}
row_length = 6

seed = widgets.IntSlider(min=0, max=100000, step=1, value=seed, description='Seed: ', continuous_update=False)
truncation = widgets.FloatSlider(min=0, max=2, step=0.1, value=0.4, description='Truncation: ', continuous_update=False)
distance = widgets.FloatSlider(min=-10, max=10, step=0.1, value=0, description='Distance: ', continuous_update=False, style=style)
scale = widgets.FloatSlider(min=0, max=10, step=0.05, value=1, description='Scale: ', continuous_update=False)
start_layer = widgets.IntSlider(min=0, max=18, step=1, value=18, description='start layer: ', continuous_update=False)
end_layer = widgets.IntSlider(min=0, max=18, step=1, value=18, description='end layer: ', continuous_update=False)


update = widgets.Checkbox(value=True, description="update")

directions_list = []
params = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}

for i, item in enumerate(named_directions):
    name = named_directions[item][3]
    widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=0, description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
    directions_list.append(widget)
    params[item] = widget

top_box = widgets.HBox([seed, truncation])
rename_dropdown = widgets.Dropdown(options=named_directions.keys())
rename_box = widgets.Text()
rename = widgets.Button(description="Rename")
bot_box = widgets.HBox([rename_dropdown, rename_box, rename])

ui = widgets.VBox([top_box, bot_box])

grid = widgets.GridspecLayout(len(directions_list)//6, 6, width='90%', height="300px")
for i in range(len(directions_list)//6):
    for j in range(6):
        grid[i, j] = directions_list[6*i+j]
    
ui2 = grid


random = widgets.Button(description="Randomize Sliders")
reset = widgets.Button(description="Reset Sliders")
mobile = widgets.Button(description="Mobile Mode")
desktop = widgets.Button(description="Desktop Mode")
def reset_sliders(b):
    directions_list = []
    params_new = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}
    for i, item in enumerate(named_directions):
        name = named_directions[item][3]
        widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=0, description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
        directions_list.append(widget)
        params_new[item] = widget
    params = params_new
    grid = widgets.GridspecLayout(len(directions_list)//6, 6, width='90%', height="300px")
    for i in range(len(directions_list)//6):
        for j in range(6):
            grid[i, j] = directions_list[6*i+j]
        
    ui2 = grid
    clear_output()
    out = widgets.interactive_output(display_sample, params)
    last_button = mobile
    if row_length == 1:
        last_button = desktop
    display(ui, out, ui2, reset, random, last_button, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))

def random_sliders(b):
    directions_list = []
    params_new = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}
    for i, item in enumerate(named_directions):
        name = named_directions[item][3]
        widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=np.random.normal(scale=2.5), description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
        directions_list.append(widget)
        params_new[item] = widget
    params = params_new
    grid = widgets.GridspecLayout(len(directions_list)//6, 6, width='90%', height="300px")
    for i in range(len(directions_list)//6):
        for j in range(6):
            grid[i, j] = directions_list[6*i+j]
        
    ui2 = grid
    clear_output()
    out = widgets.interactive_output(display_sample, params)
    last_button = mobile
    if row_length == 1:
        last_button = desktop
    display(ui, out, ui2, reset, random, last_button, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))

def mobile_mode(b):
    global row_length
    global params
    row_length = 1
    directions_list = []
    params_new = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}
    for i, item in enumerate(named_directions):
        name = named_directions[item][3]
        widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=params[item].value, description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
        directions_list.append(widget)
        params_new[item] = widget
    params = params_new
    row_list = []
    foo = []
    for i, item in enumerate(directions_list):
        row_list.append(item)
        if len(row_list) == row_length:
            bar = widgets.HBox(row_list)
            foo.append(bar)
            row_list = []
    bar = widgets.HBox(row_list)
    foo.append(bar)

    ui2 = widgets.VBox(foo)
    clear_output()
    out = widgets.interactive_output(display_sample, params)
    display(ui, out, ui2, reset, random, desktop, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))

def desktop_mode(b):
    global row_length
    global params
    row_length = 6
    directions_list = []
    params_new = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}
    for i, item in enumerate(named_directions):
        name = named_directions[item][3]
        widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=params[item].value, description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
        directions_list.append(widget)
        params_new[item] = widget
    params = params_new
    grid = widgets.GridspecLayout(len(directions_list)//6, 6, width='90%', height="300px")
    for i in range(len(directions_list)//6):
        for j in range(6):
            grid[i, j] = directions_list[6*i+j]
        
    ui2 = grid
    clear_output()
    out = widgets.interactive_output(display_sample, params)
    display(ui, out, ui2, reset, random, mobile, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))

def rename_slider(b):
    global row_length
    global params
    print(rename_dropdown.value, rename_box.value)
    named_directions[rename_dropdown.value][3] = rename_box.value
    #del named_directions[rename_dropdown.value]
    directions_list = []
    params_new = {'seed': seed, 'truncation': truncation, 'direction': fixed(0), 'distance': distance, 'scale': scale, 'start': start_layer, 'end': end_layer, 'update' : update}
    for i, item in enumerate(named_directions):
        name = named_directions[item][3]
        value_new = 0
        if item in params:
            value_new = params[item].value
        widget = widgets.FloatSlider(min=-20, max=20, step=0.1, value=value_new, description=name + ': ', continuous_update=False, style=style, layout={'width' : 'auto'})
        directions_list.append(widget)
        params_new[item] = widget
    params = params_new
    grid = widgets.GridspecLayout(len(directions_list)//6, 6, width='90%', height="300px")
    for i in range(len(directions_list)//6):
        for j in range(6):
            grid[i, j] = directions_list[6*i+j]
        
    ui2 = grid
    clear_output()
    out = widgets.interactive_output(display_sample, params)
    display(ui, out, ui2, reset, random, mobile, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))
  
save_name = widgets.Text()
load_name = widgets.Text()
save_btn = widgets.Button(description="Save")
load_btn = widgets.Button(description="Load")

def load_w(b):
    global loaded_w
    print("Loading ", load_name.value + ".npy")
    loaded_w = np.load(load_name.value + ".npy")

def save_w(b):
    global loaded_w
    rng = np.random.RandomState(params['seed'].value)
    z = rng.standard_normal(*Gs.input_shape[1:]).reshape(1, *Gs.input_shape[1:])

    noise_vars = [var for name, var in Gs.components.synthesis.vars.items() if name.startswith('noise')]
    Gs_kwargs = dnnlib.EasyDict()
    Gs_kwargs.randomize_noise = False

    all_w = Gs.components.mapping.run(z, None, **Gs_kwargs) # [minibatch, layer, component]
    if loaded_w is not None:
        all_w = loaded_w.copy()

    for i, item in enumerate(params):
        if item not in ['seed', 'truncation', 'direction', 'distance', 'scale', 'start', 'end', 'update']:
            value = params[item].value
            start_l = named_directions[item][1]
            end_l = named_directions[item][2]
            direction_l = latent_dirs[named_directions[item][0]]
            for l in range(start_l, end_l):
                all_w[0][l] = all_w[0][l] + direction_l * value * params['scale'].value

    if truncation != 1:
        w_avg = Gs.get_var('dlatent_avg')
        all_w = w_avg + (all_w - w_avg) * params['truncation'].value # [minibatch, layer, component]

    from datetime import datetime
    now = datetime.now()

    out_name = now.isoformat()
    
    if save_name.value:
        out_name = save_name.value
    np.save(out_name + ".npy", all_w)
    print("saved ", out_name + ".npy")

random.on_click(random_sliders)
reset.on_click(reset_sliders)
mobile.on_click(mobile_mode)
desktop.on_click(desktop_mode)
rename.on_click(rename_slider)
save_btn.on_click(save_w)
load_btn.on_click(load_w)
out = widgets.interactive_output(display_sample, params)
display(ui, out, ui2, reset, random, mobile, widgets.HBox([save_name, save_btn]), widgets.HBox([load_name, load_btn]))

"""Run this cell to get your slider config after you've made changes.
Be sure to share it on the [Derpibooru thread](https://derpibooru.org/forums/art/topics/this-pony-does-not-exist-editor-help-wanted) if you've figured out good sliders!
"""

import yaml
print(yaml.dump(named_directions))

"""# Animation stuff"""

import math
from PIL import ImageFont
from PIL import ImageDraw
def interpolate_between_ws(seed_array, truncation=0.5, duration_sec = 12.0, smoothing_sec = 1.0, mp4_fps = 20, filename=None, text=False):
    #_G, _D, Gs = pickle.load(open("/content/network-e621.pkl", "rb"))
    Gs_kwargs = dnnlib.EasyDict()
    Gs_kwargs.output_transform = dict(func=tflib.convert_images_to_uint8, nchw_to_nhwc=True)
    Gs_kwargs.randomize_noise = False
    synthesis_kwargs = dict(output_transform=Gs_kwargs.output_transform, truncation_psi=truncation, minibatch_size=8)
    noise_vars = [var for name, var in Gs.components.synthesis.vars.items() if name.startswith('noise')]
    #if seed_array[0] != seed_array[-1]:
    #    seed_array.append(seed_array[0])
    

    all_w = seed_array
        
    num_frames = int(np.rint(duration_sec * mp4_fps))
        
    def make_frame(t):
        blend = ((len(seed_array)-1)*t/duration_sec)%1.0
        src_i = math.floor((t/duration_sec)*(len(seed_array)-1))
        dst_i = src_i + 1
        #print(t, blend, src_i, dst_i)
        all_w_new = (blend * all_w[dst_i]) + (1 - blend) * all_w[src_i]
        all_images_src = Gs.components.synthesis.run(all_w_new, randomize_noise=False, **synthesis_kwargs)
        #all_images_dst = Gs.components.synthesis.run(all_w_dst, randomize_noise=False, **synthesis_kwargs)
        if text:
            new_im = PIL.Image.new('RGB', (512, 600))
            new_im.paste(PIL.Image.fromarray(np.median(all_images_src, axis=0).astype(np.uint8)), (0, 0))
            draw = ImageDraw.Draw(new_im)
            font = ImageFont.truetype("/usr/share/fonts/truetype/liberation/LiberationSans-Regular.ttf", size=16)
            draw.text((10, 512), "{:0.2f}".format((1-blend)), (255, 0, 0), font=font)
            draw.text((50, 512), str(seed_array[src_i]), (255, 255, 255), font=font)
            draw.text((10, 550), "{:0.2f}".format((blend)), (0, 255, 0), font=font)
            draw.text((50, 550), str(seed_array[dst_i]), (255, 255, 255), font=font)
            return np.array(new_im)
        else:
            return all_images_src[0]

    
    import moviepy.editor
    from datetime import datetime
    now = datetime.now()

    np.save(now.isoformat() + ".npy", all_w)
    mp4_file = '%s.mp4' % (now)
    if filename:
        mp4_file = filename
    mp4_codec = 'libx264'
    mp4_bitrate = '5M'

    video_clip = moviepy.editor.VideoClip(make_frame, duration=duration_sec)
    video_clip.write_videofile(mp4_file, fps=mp4_fps, codec=mp4_codec, bitrate=mp4_bitrate)
    
    return mp4_file

import glob
def preview_files():
    for file in sorted(glob.glob("*.npy")):
      try:
        truncation = 1
        print(file)
        w = np.load(file)
        noise_vars = [var for name, var in Gs.components.synthesis.vars.items() if name.startswith('noise')]
        Gs_kwargs = dnnlib.EasyDict()
        Gs_kwargs.randomize_noise = False


        if truncation != 1:
            w_avg = Gs.get_var('dlatent_avg')
            all_w = w_avg + (all_w - w_avg) * truncation # [minibatch, layer, component]

        generate_image_from_w(w, truncation)
      except:
        print("Error")

"""# Generate animation"""

!error Causing an error so the following cells are not run automatically....

"""Run this cell to preview all of the snapshots you've saved:"""

preview_files()

"""List all of the files you want to animate between:"""

ws = '''
pose1.npy
pose2.npy
pose3.npy
'''.split()
ws

"""Run this to generate the animation:"""

w_arr = []
for w in ws:
    w_val = np.load(w)
    w_arr.append(w_val)

output_file = interpolate_between_ws(w_arr, duration_sec = 2.0, smoothing_sec = 1.0, mp4_fps = 30)

"""Run this to download the animation:"""

from google.colab import files
files.download(output_file)