/* eslint-disable react/no-unescaped-entities */

import styled from 'styled-components'
import Link from 'next/link'
import Head from 'next/head'
import { Fragment, ReactElement, useRef } from 'react'
import Particles from 'react-tsparticles'
import type { Container, Engine, IImageShape, IOptions, RecursivePartial } from 'tsparticles-engine'
import { loadFull } from 'tsparticles'

import 'react-toastify/dist/ReactToastify.css'

import { cssTransition, ToastContainer } from 'react-toastify'
import { useRouter } from 'next/router'
import Confetti1 from '../assets/images/contest/confetti1.svg'
import Confetti2 from '../assets/images/contest/confetti2.svg'
import Confetti3 from '../assets/images/contest/confetti3.svg'
import Confetti4 from '../assets/images/contest/confetti4.svg'
import Confetti5 from '../assets/images/contest/confetti5.svg'
import Confetti6 from '../assets/images/contest/confetti6.svg'
import Confetti7 from '../assets/images/contest/confetti7.svg'
import Crown from '../assets/images/contest/lilcrown.svg'
import Goose from '../assets/images/contest/gussie.svg'

import { FlexColSpacer, FlexRow } from '../styles/ui/layout'
import { ArrowLeftIcon, Icon } from '../styles/ui/icons'
import { isFirefox, isMobileDevice } from '../util/compat'
import { InvertedButton } from '../styles/ui/button'
import { useAutoLogin } from '../hooks/useAutoLogin'
import { Dark } from '../styles/themes/dark'
import { VoteContainer } from './contest/vote/art'
import { LoginLink } from '.'

const particlesInit = async (main: Engine) => {
    await loadFull(main)
}
const particlesLoaded = async (container?: Container) => {
    container?.play()
}

export function ContestsLayout(page: ReactElement): JSX.Element {
    return (
        <OuterOuterContainer>
            <OuterContainer>
                <Particles
                    id="tsparticles"
                    init={particlesInit}
                    loaded={particlesLoaded}
                    options={backgroundParticlesConfig}
                />
                <ToastArea>
                    <ToastContainer transition={fade} />
                </ToastArea>
                {page}
            </OuterContainer>
        </OuterOuterContainer>
    )
}

export function StandbyCard(): JSX.Element {
    return (
        <ContestCard style={{ width: '100%' }}>
            <ContestCardHeader>Currently preparing for the votes.</ContestCardHeader>
            <ContestCardSection>
                Thank you for your submission! The voting period will begin soon. Stay tuned!
            </ContestCardSection>
        </ContestCard>
    )
}

export default function ContestContent(): JSX.Element {
    useAutoLogin()
    const router = useRouter()

    const artRef = useRef(null)
    const scenarioRef = useRef(null)
    const theme = Dark
    return (
        <Fragment>
            <Head>
                <title>A Call For Celebration Contest - NovelAI</title>
            </Head>
            <InnerContainer>
                <FlexColSpacer min={23} max={23} />
                <FlexRow>
                    <Link href="/stories" passHref>
                        <a>
                            <FlexRow grow={false}>
                                <ArrowLeftIcon theme={theme} />
                                <ToLanding>Back to Stories</ToLanding>
                            </FlexRow>
                        </a>
                    </Link>
                    <FlexRow grow={false}>
                        <LoginLink target="_blank" href="https://discord.com/invite/novelai">
                            Discord
                        </LoginLink>
                    </FlexRow>
                </FlexRow>
                <FlexColSpacer min={30} max={30} />
            </InnerContainer>
            <InnerContainer>
                <Banner>
                    <BannerGoose />
                    <BannerTop>
                        <CrownIcon />
                        <BannerTopContainer>
                            <BannerMiniText>2022 NovelAI Anniversary Contest</BannerMiniText>
                            <BannerTopText>A Call for Celebration</BannerTopText>
                        </BannerTopContainer>
                    </BannerTop>
                    <div>
                        Can’t believe it’s already nearly been a year since NovelAI was first publicly
                        released on June 16th, 2021.
                    </div>
                    <FlexColSpacer min={20} max={20} />
                    <div>
                        To start off the celebrations of this momentous occasion, we’ll be hosting contests
                        under two categories: <strong>Art & Writing</strong>.
                    </div>
                </Banner>
                <ContenstContainer style={{ width: '100%' }}>
                    <ContestCard ref={artRef}>
                        <ContestCardHeader>Art Contest!</ContestCardHeader>
                        <ContestCardSection>
                            <div>Theme</div>
                            <HF style={{ fontSize: 18 }}>NovelAI Celebrates!</HF>
                        </ContestCardSection>
                        <ContestCardSection>
                            <div>Details</div>
                            <div>
                                Create a piece of art in celebration of NovelAI's first birthday! <br />
                                May it be the cute goose mascot, the pen nib, the{' '}
                                <Link href="/assets" passHref>
                                    <a>NovelAI AI Models</a>
                                </Link>{' '}
                                or even the dev team - as long as it's related to NovelAI you are good to go!{' '}
                                <br />
                                <strong>
                                    So grab your medium of choice and create your next masterpiece!
                                </strong>
                                <br />
                                <br />
                                <strong>Art must be:</strong>
                                <br />
                                🞄 Created by the submitter
                                <br />
                                🞄 Related to the Theme
                                <br />
                                🞄 A visual media at a reasonable size (max file size 50MB) - .png .jpg .gif or
                                video .mp4.
                                <br />
                                <br />
                                <strong>Art may not include:</strong>
                                <br />
                                🞄 Pre-existing IPs of any kind
                                <br />
                                🞄 Overtly sexually explicit content.
                            </div>
                        </ContestCardSection>
                        <ContestCardSection>
                            <div>Rewards</div>
                            <div>
                                <Reward>
                                    <div>First Place</div>
                                    <div>1 Year Opus Subscription (delivered in 3-month keys)</div>
                                </Reward>
                                <Reward>
                                    <div>Second Place</div>
                                    <div>6 Month Opus Subscription (delivered in 3-month keys)</div>
                                </Reward>
                                <Reward>
                                    <div>Third Place</div>
                                    <div>3 Month Opus Subscription (delivered as one key)</div>
                                </Reward>
                                <Reward>
                                    <div>
                                        Each winner will receive an exclusive badge for NovelAI's upcoming
                                        content sharing platform.
                                    </div>
                                </Reward>
                            </div>
                        </ContestCardSection>
                    </ContestCard>
                    <ContestCard ref={scenarioRef}>
                        <ContestCardHeader>Writing Contest!</ContestCardHeader>
                        <ContestCardSection>
                            <div>Theme</div>
                            <HF style={{ fontSize: 18 }}>Celebrations and New Beginnings</HF>
                        </ContestCardSection>
                        <ContestCardSection>
                            <div>Details</div>
                            <div>
                                Create a prompt involving 'celebrations' of some sort! Feel free to let your
                                creativity soar, and write about a birthday (maybe NovelAIs?), a couple's
                                heartwarming wedding anniversary, a fancy party, the successful conquest of an
                                enemy kingdom or a festival that quickly turns sour... <br />
                                Let's see how you apply the topic to your favorite genre!
                                <br />
                                <br />
                                <strong>Stories must be:</strong>
                                <br />
                                🞄 SFW
                                <br />
                                🞄 Written by the submitter
                                <br />
                                🞄 Related to the Theme
                                <br />
                                <br />
                                <strong>Stories may not include:</strong>
                                <br />
                                🞄 Pre-existing IPs of any kind
                                <br />
                                🞄 Overtly sexually explicit content.
                            </div>
                        </ContestCardSection>
                        <ContestCardSection>
                            <div>Rewards</div>
                            <div>
                                <Reward>
                                    <div>First Place</div>
                                    <div>1 Year Opus Subscription (delivered in 3-month keys)</div>
                                </Reward>
                                <Reward>
                                    <div>Second Place</div>
                                    <div>6 Month Opus Subscription (delivered in 3-month keys)</div>
                                </Reward>
                                <Reward>
                                    <div>Third Place</div>
                                    <div>3 Month Opus Subscription (delivered as one key)</div>
                                </Reward>
                                <Reward>
                                    <div>
                                        Each winner will receive an exclusive badge for NovelAI's upcoming
                                        content sharing platform.
                                    </div>
                                </Reward>
                            </div>
                        </ContestCardSection>
                    </ContestCard>
                </ContenstContainer>
                <Banner>
                    <BannerTop>
                        <BannerTopContainer>
                            <BannerTopText>A Call for Celebration Details</BannerTopText>
                            <BannerMiniText>Art & Writing Contest Submission Guidelines:</BannerMiniText>
                        </BannerTopContainer>
                    </BannerTop>
                    <div>
                        <strong>Winner Selection:</strong>
                    </div>
                    <div>
                        Top three winners of both contests (Art & Writing) will be chosen by popular vote.
                        <br />
                        Additional winners may be selected by the NovelAI team.
                    </div>

                    <div>
                        <br />
                        <strong>
                            One contest entry of each contest type (art & writing) per contestant is allowed.
                        </strong>
                        <br /> <br />
                    </div>
                    <div>
                        <strong>Contest Submission period begins:</strong> May 25th 2022. <br />
                        <strong>Contest Submission period deadline:</strong> June 9th, 2022 at 10:00 AM PT.{' '}
                        <br />
                        <br />
                        <strong>Contest Voting begins:</strong> June 9th, 2022 through June 15th, 2022. <br />
                        <strong>Contest Voting deadline:</strong> June 15th, 2022 at 12:00 PM PT.
                        <br />
                        <br /> Once the entry period has concluded (June 9th, 2022 at 10:00 AM PT.) we will be
                        sharing a poll for the community to cast their votes from June 9th, 2022 through June
                        15th, 2022. Winners will be announced and their scenarios will be released in
                        NovelAI's Default Scenario Browser on June 16th, 2022.
                        <br /> Subscription Key Prizes will be delivered to the email provided during entry
                        submission on June 17th, 2022. <br />
                        All contest winners will receive an exclusive badge for NovelAI's upcoming content
                        sharing platform scheduled to release in 2022.
                    </div>
                    <div>
                        <br />
                        <strong>Submission Copyright Disclaimer:</strong>
                    </div>
                    <div>
                        The copyright in any Submission shall remain the property of the entrant, but entry
                        into the NovelAI Art & Writing Contests constitutes entrant’s irrevocable and
                        perpetual permission and consent, without further compensation or attribution, to use,
                        reproduce, print, publish, transmit, distribute, sell, perform, adapt, enhance, or
                        display such Submission for any purpose, including but not limited to editorial,
                        advertising, trade, commercial, and publicity purposes by Anlatan and/or others
                        authorized by Anlatan, in any and all media now in existence or hereinafter created,
                        throughout the world, for the duration or the copyright in the Submission. Anlatan
                        and/or others authorized by Anlatan shall have the right to edit, adapt, and modify
                        the Submission.
                    </div>
                    <FlexColSpacer min={20} max={20} />
                    <div></div>
                </Banner>
            </InnerContainer>
        </Fragment>
    )
}
ContestContent.Layout = ContestsLayout

const backgroundParticlesConfig: RecursivePartial<IOptions> = {
    backgroundMode: {
        enable: true,
        zIndex: 10,
    },
    detectRetina: true,
    duration: 0,
    fpsLimit: 120,
    motion: {
        disable: false,
    },
    background: {
        color: {
            value: 'transparent',
        },
    },
    particles: {
        shape: {
            type: 'image',
            image: [
                {
                    src: Confetti1.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti2.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti3.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti4.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti5.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti6.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
                {
                    src: Confetti7.src,
                    width: 16,
                    height: 16,
                } as IImageShape,
            ],
        },
        size: {
            random: false,
            value: {
                min: 6,
                max: 12,
            },
        },
        rotate: {
            direction: 'random',
            value: {
                min: 0,
                max: 360,
            },
            random: {
                enable: true,
                minimumValue: 5,
            },
            animation: {
                enable: true,
                speed: 10,
                sync: false,
            },
        },
        opacity: {
            random: true,
            value: {
                min: 0.1,
                max: 0.5,
            },
        },
        number: {
            density: {
                enable: true,
                area: 300,
                factor: 6000,
            },
            // reduce limit in firefox because of performance issues
            // see https://bugzilla.mozilla.org/show_bug.cgi?id=1602299
            limit: isFirefox ? (isMobileDevice ? 10 : 50) : 250,
            value: 100,
        },
        move: {
            enable: true,
            random: false,
            gravity: {
                enable: true,
                acceleration: 9.81,
                maxSpeed: 0.6,
            },
            drift: {
                min: -1,
                max: 1,
            },
            angle: {
                offset: 0,
                value: 0,
            },
            decay: 0.1,
            direction: 'bottom',
            outMode: 'out',
            warp: false,
            collisions: false,
            straight: true,
        },
    },
}

export const ToastArea = styled.div`
    position: fixed;
    right: 0;
    top: 0;
    width: 100%;
    z-index: 1000;

    .Toastify__toast-container {
        position: absolute;
    }

    .Toastify__toast {
        border-radius: 2px;
    }
    .Toastify__close-button {
        color: ${(props) => props.theme.colors.textMain};
    }

    .Toastify__progress-bar {
        height: 2px;
    }

    --toastify-color-light: ${(props) => props.theme.colors.bg3};
    --toastify-color-progress-light: ${(props) => props.theme.colors.textHeadings};
    --toastify-text-color-light: ${(props) => props.theme.colors.textMain};
    --toastify-font-family: ${(props) => props.theme.fonts.default};
`
const fade = cssTransition({
    enter: 'fade-in-right',
    exit: 'fade-out-right',
})

const CrownIcon = styled(Icon)`
    mask-image: url(${Crown.src});
    background-color: #ec55a7;
    height: 80px;
    width: 80px;
    position: relative;
    margin-bottom: 8px;
    flex: 0 0 80px;
    pointer-events: none;
`

const VerticalBox = styled.div`
    display: flex;
    flex-direction: column;
    width: 100%;
    justify-content: center;
`

export const OuterOuterContainer = styled.div`
    background-size: 1600px auto;
    background-repeat: no-repeat;
    background-position: center top;
    display: flex;
`
export const OuterContainer = styled(VerticalBox)`
    position: relative;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    color: white;
    font-size: 16px;
    padding-bottom: 100px;
    h1,
    h2,
    h3,
    h4,
    a {
        color: ${() => Dark.colors.textHeadings};
    }
`

export const InnerContainer = styled.div`
    position: relative;
    z-index: 10;
    display: flex;
    flex-direction: column;
    align-items: center;
    max-width: 1162px;
    width: 100%;
    flex: 0 0 auto;
    @media (max-width: 1300px) {
        padding: 0 30px;
    }
`

export const ToLanding = styled.div`
    font-size: 1rem;
    font-weight: 700;
    padding-left: 10px;
`

const Banner = styled.div`
    background-color: ${() => Dark.colors.bg2};
    border: 1px solid ${() => Dark.colors.bg3};
    flex: 0 0 auto;
    width: 100%;
    display: flex;
    flex-direction: column;
    align-items: left;
    padding: 30px;
    justify-content: space-around;
    background: #13152c;
    z-index: 100;
    position: relative;
    padding-top: 100px;
    position: relative;
    overflow: hidden;
    padding-right: 100px;
    @media screen and (max-width: 700px) {
        padding: 20px;
    }
    margin-bottom: 50px;
`
export const BannerTop = styled.div`
    text-align: left;
    display: flex;
    gap: 12px;
    align-items: flex-end;
    padding-bottom: 20px;
    max-width: 80%;
    position: relative;
    @media screen and (max-width: 700px) {
        flex-direction: column;
        align-items: flex-start;
    }
`
export const BannerTopContainer = styled.div``
export const BannerTopText = styled.h2`
    color: #ec55a7 !important;
    font-size: 3.2rem;
    line-height: 3.2rem;
    font-weight: bold;
    font-family: ${() => Dark.fonts.headings};
    margin: 0;
    word-break: keep-all;
    @media screen and (max-width: 700px) {
        font-size: 2.6rem;
    }
`
export const BannerMiniText = styled.h1`
    font-size: 18px;
    font-family: ${() => Dark.fonts.headings};
    color: ${() => Dark.colors.textHeadings} !important;
    padding-left: 6px;
    padding-bottom: 10px;
`

const BannerGoose = styled.div`
    position: absolute;
    top: 0;
    bottom: 0;
    right: 0;
    height: 100%;
    width: 36%;
    background-image: url(${Goose.src});
    background-size: cover;
    background-position: center left;
    pointer-events: none;
`

const ContenstContainer = styled.div`
    display: flex;
    flex-wrap: wrap;
    flex-direction: row;
    gap: 20px;
    margin-bottom: 50px;
    position: relative;
`
const ContestCard = styled.div`
    flex: 1 0 calc(50% - 20px);
    z-index: 100;
    min-width: 320px;
    background: #191b31;
    &:hover,
    &:focus {
        background: #13152c;
    }
    border: 1px solid #22253f;
    display: flex;
    flex-direction: column;
    padding: 30px;
    @media screen and (max-width: 700px) {
        padding: 20px;
    }
    position: relative;
`
const ContestCardHeader = styled.h2`
    margin-bottom: 1.5rem;
`
const ContestCardSection = styled.div`
    margin-bottom: 2rem;
    > div:nth-child(1) {
        font-size: 14px;
        color: #f7f7f7;
        opacity: 0.7;
        font-weight: 600;
        margin-bottom: 8px;
    }
    > div:nth-child(2) {
        color: #f7f7f7;
        line-height: 1.8rem;
    }
`
const HF = styled.div`
    font-family: ${() => Dark.fonts.headings};
    font-weight: bold;
`
const Reward = styled.div`
    > div:nth-child(1) {
        font-size: 18px;
        color: ${() => Dark.colors.textHeadings};
        font-weight: 600;
    }
    > div:nth-child(2) {
    }
    margin-bottom: 1rem;
`
