import Link from 'next/link'
import Head from 'next/head'
import styled from 'styled-components'
import { LoginBackground, LoginContainer } from '../styles/components/login'
import { FlexCol, FlexRow } from '../styles/ui/layout'
import { ArrowLeftIcon } from '../styles/ui/icons'
import { Header, Logo, Title, Container, LoginLink, Placeholder, LandingTop } from './index'

const Content = styled.div`
    display: flex;
    justify-content: center;
    width: 100%;
    align-items: center;
    flex-direction: column;
    flex: 1;
`
const Message = styled.h2`
    font-size: 3rem;
    color: ${(props) => props.theme.colors.textMain};
`
const SubMessage = styled.a`
    font-size: 1.1rem;
    padding: 1rem;
    &:hover {
        div {
            background-color: ${(props) => props.theme.colors.textHeadings};
        }
    }
`
const Arrow = styled(ArrowLeftIcon)`
    margin-right: 8px;
    position: relative;
    top: 2px;
    display: inline-block;
`

export default function ErrorPage(): JSX.Element {
    return (
        <LoginContainer>
            <Head>
                <title>Page not found - NovelAI</title>
            </Head>
            <LoginBackground style={{ flexDirection: 'column' }}>
                <LandingTop style={{ flex: 0 }}>
                    <Container>
                        <Header>
                            <Logo />
                            <Title>NovelAI</Title>
                            <Placeholder />
                            <div>
                                <Link href="/login" passHref>
                                    <LoginLink>Login</LoginLink>
                                </Link>
                            </div>
                        </Header>
                    </Container>
                </LandingTop>
                <Content>
                    <Container>
                        <FlexCol>
                            <FlexRow style={{ justifyContent: 'center' }}>
                                <Message>Page not found</Message>
                            </FlexRow>
                            <FlexRow style={{ justifyContent: 'center' }}>
                                <Link href="/" passHref>
                                    <SubMessage>
                                        <Arrow />
                                        Back to the landing page
                                    </SubMessage>
                                </Link>
                            </FlexRow>
                        </FlexCol>
                    </Container>
                </Content>
            </LoginBackground>
        </LoginContainer>
    )
}
