from novelutils.novelfra import *
from pyfra import *

config_obj = KubeConfig()
config_obj.set_name("pyfra-tts")
config_obj.set_image("novelai/kube-ssh:57")
config_obj.set_gpu(gpu_name=GPU.Quadro_RTX_4000, amount=1)
config_obj.set_ram(8)
config_obj.set_cpu(6)

config_obj.print_information()
config_obj.create_deployment()
config_obj.create_service()
remote = config_obj.get_pyfra_remote()

init_setup = True

env1 = remote.env('noname', python_version=None)
path = env1.path('/home/xuser/diffusionstorage/workspace/kuru/novelai-tts')

if init_setup:
    path.sh("pip3 uninstall -y torch")
    path.sh("pip3 install /home/xuser/hugessd/pytorch/torch-1.10.1+cu113-cp38-cp38-linux_x86_64.whl")
    path.sh("pip3 install -r vits/requirements.txt")
    path.sh("apt-get update")
    path.sh("apt-get install -y espeak lame opus-tools ffmpeg")
    path.sh("cd vits/monotonic_align ; python setup.py build_ext --inplace")
    path.sh("pip3 install nltk")

try:
    with always_rerun():
        #path.sh("bash")
        #path.sh("screen python server_test.py")
        path.sh("echo run: 'bash run_server.sh ;screen -r vits'")
        path.sh("bash")
except:
    pass

#config_obj.kill_deployment()
#config_obj.kill_service()
