#ifndef PACKAGE_H
#define PACKAGE_H

#include <string>
#include <vector>
#include <stdint.h>
#include <boost/shared_ptr.hpp>
#include "module.h"
#include "ast.h"

class Package
{
public:
   typedef boost::shared_ptr<Package> Ptr;
   typedef std::vector<Ptr> Vector;

protected:
   Package& _root;
   std::string _name;

   Module::Vector _modules;
   Package::Vector _packages;

public:
   Package();
	Package( Package& root, const std::string& name );
	virtual ~Package();

   const std::string& name() { return _name; }
   Package& root();

   bool parse( const std::string& directory );
   bool type_check();
   void print( uint32_t level );

   void resolve_type( const ASTBaseType& name, ASTTypeDefinition::Vector& list );
   void resolve_local_type( const std::string& name, ASTTypeDefinition::Vector& list );

protected:
   bool add_package( const std::string& path, const std::string& name );
   bool add_module( const std::string& path, const std::string& name );
   bool has_modules();
};

#endif // PACKAGE_H
