#include "package.h"

static void usage()
{
   printf(
      "Usage:\n"
      "\n"
      "no parameters: compile in the current directory.\n"
      "one parameter: compile in the specified directory.\n"
      "\n"
      );
}

int main( int argc, char **argv )
{
   const char* dir;

   switch( argc )
   {
   case 1:
      dir = ".";
      break;

   case 2:
      dir = argv[1];
      break;

   default:
      usage();
      return -1;
   }

   bool success = true;

   Package package;
   success &= package.parse( dir );
   success &= package.type_check();

   package.print( 0 );

   if( success )
   {
      printf( "Success.\n" );
   } else {
      printf( "Failure.\n" );
   }

   getchar();

   return success ? 0 : -1;
}
