#ifndef LOCATION_H
#define LOCATION_H

#include <cstddef>

class Location
{
private:
   size_t _line;
   size_t _pos;

public:
   Location( const Location& loc ) : _line( loc.line() ), _pos( loc.pos() ) {}
   Location( size_t line, size_t pos ) : _line( line ), _pos( pos ) {}

   inline size_t line() const { return _line; }
   inline size_t pos() const { return _pos; }

   inline void set_line( size_t line ) { _line = line; }
   inline void set_pos( size_t pos ) { _pos = pos; }
};

#endif
