#ifndef LEXER_H
#define LEXER_H

#include <string>
#include <fstream>
#include "errors.h"
#include "token.h"

class Lexer : public Location
{
protected:
   Errors& _errors;

   std::ifstream _file;
   size_t _unget_pos;
   size_t _comment_depth;

   std::string _data;

public:
	Lexer( Errors& errors );
	virtual ~Lexer();

   bool open( const std::string& filename );
   void close();
   Token::Ptr next();

protected:
   int get();
   void unget();

   Token::Ptr had_slash();
   Token::Ptr nested_comment();
   Token::Ptr line_comment();

   Token::Ptr had_string();
   Token::Ptr had_zero();
   Token::Ptr had_binary();
   Token::Ptr had_hexadecimal();
   Token::Ptr had_number();
   Token::Ptr had_real( Token::Ptr token );
   Token::Ptr had_identifier();
   Token::Ptr had_symbol();

   bool is_symbol( int c );
   int hex( int x );
};

#endif // LEXER_H
