#ifndef ERRORS_H
#define ERRORS_H

#include "location.h"
#include "error.h"

class Errors
{
protected:
   Error::List _list;

public:
	Errors() {}

   inline bool success() const { return !_list.empty(); }
   bool print( const std::string& filename ) const;

   std::ostringstream& report();
   std::ostringstream& report( const Location& loc );
   void clear();
};

#endif // ERRORS_H
