#include "errors.h"

bool Errors::print( const std::string& filename ) const
{
   Error::List::const_iterator i = _list.begin();
   Error::List::const_iterator end = _list.end();

   if( i == end )
   {
      return false;
   }

   for( ; i != end; i++ )
   {
      (*i)->print( filename );
   }

   return true;
}

std::ostringstream& Errors::report()
{
   Error::Ptr error = Error::Ptr( new Error( Location( 0, 0 ) ) );
   _list.push_back( error );

   return error->message();
}

std::ostringstream& Errors::report( const Location& loc )
{
   Error::Ptr error = Error::Ptr( new Error( loc ) );
   _list.push_back( error );

   return error->message();
}

void Errors::clear()
{
   _list.clear();
}
