#ifndef ERROR_H
#define ERROR_H

#include <sstream>
#include <list>
#include <boost/shared_ptr.hpp>
#include "location.h"

class Error : public Location
{
public:
   typedef boost::shared_ptr<Error> Ptr;
   typedef std::list<Ptr> List;

protected:
   std::ostringstream _message;

public:
   Error( const Location& loc ) : Location( loc ) {}

   std::ostringstream& message() { return _message; }

   void print( const std::string& filename ) const
   {
      std::cerr << "Error [" << filename << ":" << line() << ":" << pos() << "] " << _message.str() << std::endl;
   }
};

#endif // ERROR_H
