#ifndef ASTLIST_H
#define ASTLIST_H

#include "print.h"
#include "list.h"

template<class T> class ASTList : public List<T>
{
public:
   ASTList() : List<T>() {}
   ASTList( bool weak ) : List<T>( weak ) {}

   void print( uint32_t level )
   {
      indent( level );

      if( this->_count == 0 )
      {
         printf( "()\n" );
      } else {
         printf( "(\n" );

         for( uint32_t i = 0; i < this->_count; i++ )
         {
            this->_list[i]->print( level + 1 );
         }

         indent( level );
         printf( ")\n" );
      }
   }
};

#endif // ASTLIST_H
