let rec main_loop stream =
   match Stream.peek stream with
      | None -> ()
      | Some token ->
         begin
            try match token with
               | Token.Import ->
                  ignore (Parser.parse_import stream);
                  (*
                  let e = Parser.parse_import stream in
                     match e with
                     | Ast.Import s ->
                        let rs = List.rev s in
                           print_string "parsed import ";
                           List.iter print_string rs;
                           print_newline;
                           *)
               | _ ->
                  Stream.junk stream;
                  print_endline "unimplemented";
            with Stream.Error s ->
               Stream.junk stream;
               print_endline s;
         end;
         main_loop stream

let main () =
   Token.init;
   
   let stream = Lexer.lex (Stream.of_channel stdin) in
      main_loop stream;
   ;;

main ()
