let rec parse_base_type acc = parser
   | [< 'Token.Type s; e = parse_base_type_sep (s::acc) >] -> e
   | [< >] -> raise (Stream.Error "expected base type")

and parse_base_type_sep acc = parser
   | [< 'Token.Colon; e = parse_base_type acc >] -> e
   | [< 'Token.Terminator >] -> acc
   | [< >] -> raise (Stream.Error "expected : or ; in base type")

let parse_import stream = parser
   | [< 'Token.Import; e = parse_base_type [] >] ->
      let rs = List.rev e in
         print_string "parsed import ";
         List.iter print_string rs;
         print_newline ();
         Ast.Import e
