type reference =
   | Strong
   | Nil
   | Weak

type base = Type of string list * base list * reference

type unary_op =
   | Uminus
   | Not

type binary_op =
   | Eq
   | Ne
   | Lt
   | Gt
   | Le
   | Ge
   | And
   | Or
   | Xor
   | Lsh
   | Rsh
   | Plus
   | Minus
   | Multiply
   | Divide
   | Mod
   | Power

type expr =
   | Boolean of bool
   | Integer of int
   | Real of float
   | Imaginary of float
   | String of string
   | Array of expr list
   | This
   | Identifier of string
   | Unary of unary_op * expr
   | Binary of binary_op * expr * expr
   | ArrayIndex of expr * expr list
   | Call of expr * expr list
   | SuperCall of expr * expr list
   | ObjectCall of expr * expr * expr list
   | TypedIdentifier of base * string
   | VariableDecl of base * string list

type command =
   | Assign of expr list * expr list
   | Block of command list
   | If of expr * command list * command list
   | Return
   | Literal of string * expr
   | Member of base * string

type ast =
   | Import of string list
   | Expr of expr
   | Command of command
