/*
 * Decompiled with CFR 0.152.
 */
package package1;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;

public class FimfictionStory {
    public String title = "unknown title";
    public String author = "unknown author";
    public String description = "unknown description";
    public String datePublishedString = "unknown date";
    public Date datePublishedObject;
    public String contentRating = "unknown content rating";
    ArrayList<String> tags = new ArrayList();
    public int likes = -1;
    public int dislikes = -1;
    public int views = -1;
    public float percentRating;
    public int words = -1;
    public int ID = -1;
    public int prequelID = -1;
    public String completionStatus = "default completion status";
    public static Comparator<FimfictionStory> TitleComparator = new Comparator<FimfictionStory>(){

        @Override
        public int compare(FimfictionStory s1, FimfictionStory s2) {
            return s1.title.toUpperCase().compareTo(s2.title.toUpperCase());
        }
    };
    public static Comparator<FimfictionStory> LikesComparator = new Comparator<FimfictionStory>(){

        @Override
        public int compare(FimfictionStory s1, FimfictionStory s2) {
            return s2.likes - s1.likes;
        }
    };
    public static Comparator<FimfictionStory> WordsComparator = new Comparator<FimfictionStory>(){

        @Override
        public int compare(FimfictionStory s1, FimfictionStory s2) {
            return s2.words - s1.words;
        }
    };
    public static Comparator<FimfictionStory> ViewsComparator = new Comparator<FimfictionStory>(){

        @Override
        public int compare(FimfictionStory s1, FimfictionStory s2) {
            return s2.views - s1.views;
        }
    };
    public static Comparator<FimfictionStory> PercentRatingComparator = new Comparator<FimfictionStory>(){

        @Override
        public int compare(FimfictionStory s1, FimfictionStory s2) {
            if (s2.percentRating > s1.percentRating) {
                return 1;
            }
            return -1;
        }
    };

    public FimfictionStory() {
    }

    public FimfictionStory(int newID) {
        this.ID = newID;
    }

    public FimfictionStory(FimfictionStory original) {
        this.title = original.title;
        this.author = original.author;
        this.description = original.description;
        this.datePublishedString = original.datePublishedString;
        this.datePublishedObject = original.datePublishedObject;
        this.tags = new ArrayList<String>(original.tags);
        this.likes = original.likes;
        this.dislikes = original.dislikes;
        this.words = original.words;
        this.prequelID = original.prequelID;
    }

    public static void main(String[] args) throws ParseException, IOException {
        int d = 0;
        int i = 1;
        while (i <= 20) {
            System.out.println(i);
            System.out.println(d += i);
            ++i;
        }
    }

    public static void indent(int ind) {
        int i = 0;
        while (i < ind) {
            System.out.print("    ");
            ++i;
        }
    }

    public void removeHtmlFormattingFromDescription() {
        String html = this.description;
        HTMLEditorKit kit = new HTMLEditorKit();
        Document doc = ((EditorKit)kit).createDefaultDocument();
        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            StringReader reader = new StringReader(html);
            ((EditorKit)kit).read(reader, doc, 0);
            this.description = doc.getText(0, doc.getLength());
            this.description = this.description.replace("\u00e2\u20ac\u2122", "'");
        }
        catch (Exception e) {
            return;
        }
    }

    public float getRating() {
        if (this.likes == -1 || this.dislikes == -1) {
            return -1.0f;
        }
        return 100.0f * (float)(this.likes + 1) / (float)(this.likes + this.dislikes + 2);
    }

    public void calculateRating() {
        this.percentRating = this.likes == -1 || this.dislikes == -1 ? -1.0f : 100.0f * (float)(this.likes + 1) / (float)(this.likes + this.dislikes + 2);
    }

    public void calculateDatePublishedObject() {
    }

    public String toString() {
        return "Author: " + this.author + ", Title: " + this.title + ", ID: " + this.ID;
    }
}

