/*
 * Decompiled with CFR 0.152.
 */
package package1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import package1.FimfictionStory;

public class FimArchiveSearchGUI {
    static boolean useSampleIndex = false;
    static ArrayList<FimfictionStory> inputStoriesFromSerializableArray = new ArrayList();
    static ArrayList<FimfictionStory> resultsArray = new ArrayList();
    static ArrayList<String> arrayOfUselessProperties = new ArrayList();
    static ArrayList<String> goodTags = new ArrayList();
    static ArrayList<String> badTags = new ArrayList();
    static String titleContainsString = "";
    static String descriptionContainsString = "";
    static int indents = 0;
    static int numberOfStoriesScanned = 0;
    static boolean stillGood = true;
    static boolean tooManyResults = false;
    static FimfictionStory temp = new FimfictionStory();
    static int minLikesInt = -1;
    static int minWordsInt = -1;
    static int maxWordsInt = -1;
    static float minPercentageRatingFloat = -1.0f;
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
    static final int maxNumberOfResultsShown = 500;
    static final int updateInterval = 10000;
    static final int resultBufferPrintInterval = 10;
    static final int descriptionMaxLineLength = 120;
    static String sortByString = "default";
    static Date latestAllowedPublishDateObject;
    static Date earliestAllowedPublishDateObject;
    static boolean checkEarliestAllowedPublishDate;
    static boolean checkLatestAllowedPublishDate;
    static boolean hideStoriesWithUnkownPublishDate;
    static boolean completedStoriesOnly;
    static long startTimeMilliseconds;
    static DecimalFormat df;
    private JFrame frmTest;
    static TextField goodTag1;
    static TextField goodTag2;
    static TextField goodTag3;
    static TextField goodTag4;
    static TextField goodTag5;
    static TextField badTag1;
    static TextField badTag2;
    static TextField badTag3;
    static TextField badTag4;
    static TextField badTag5;
    static TextField titleContainsTextBox;
    static TextField descriptionContainsTextBox;
    static ArrayList<TextField> textAreasArrayList;
    static TextArea textArea;
    static JRadioButton viewsRadioButton;
    static JRadioButton likesRadioButton;
    static JRadioButton percentRatingRadioButton;
    static JRadioButton wordsRadioButton;
    static JRadioButton newestFirstRadioButton;
    static JRadioButton oldestFirstRadioButton;
    static Checkbox completedOnlyCheckbox;
    static Checkbox writeResultsCheckbox;
    static Checkbox useSubsetCheckbox;
    private ButtonGroup searchByRadioButtons = new ButtonGroup();
    static TextField minLikesText;
    static TextField minWordsText;
    static TextField maxWordsText;
    static TextField minPercentRatingTextBox;
    static TextField latestAllowedPublishDate;
    static TextField earliestAllowedPublishDate;
    static Checkbox hideUnknownPublishDateCheckbox;
    private final Label label_3 = new Label("Minimum Likes");
    private final Label label_4 = new Label("Minimum Words");
    private final Label label_5 = new Label("Maximum Words");
    private final Label label_6 = new Label("YYYY/MM/DD");
    private final Label label_8 = new Label("Published after");
    private final Label label_9 = new Label("Published before");
    private final JPanel panel = new JPanel();
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private final JPanel panel_1 = new JPanel();
    private final JTextArea txtrMadeByuitchylol = new JTextArea();
    private final Label label_12 = new Label("Description Contains");

    static {
        checkEarliestAllowedPublishDate = false;
        checkLatestAllowedPublishDate = false;
        hideStoriesWithUnkownPublishDate = false;
        completedStoriesOnly = false;
        startTimeMilliseconds = 0L;
        df = new DecimalFormat();
        goodTag1 = new TextField();
        goodTag2 = new TextField();
        goodTag3 = new TextField();
        goodTag4 = new TextField();
        goodTag5 = new TextField();
        badTag1 = new TextField();
        badTag2 = new TextField();
        badTag3 = new TextField();
        badTag4 = new TextField();
        badTag5 = new TextField();
        titleContainsTextBox = new TextField();
        descriptionContainsTextBox = new TextField();
        textAreasArrayList = new ArrayList();
        textArea = new TextArea();
        viewsRadioButton = new JRadioButton("Views");
        likesRadioButton = new JRadioButton("Likes");
        percentRatingRadioButton = new JRadioButton("Percent Rating");
        wordsRadioButton = new JRadioButton("Words");
        newestFirstRadioButton = new JRadioButton("Newest First");
        oldestFirstRadioButton = new JRadioButton("Oldest First");
        completedOnlyCheckbox = new Checkbox("Completed stories only");
        writeResultsCheckbox = new Checkbox();
        useSubsetCheckbox = new Checkbox();
        minLikesText = new TextField();
        minWordsText = new TextField();
        maxWordsText = new TextField();
        minPercentRatingTextBox = new TextField();
        latestAllowedPublishDate = new TextField();
        earliestAllowedPublishDate = new TextField();
        hideUnknownPublishDateCheckbox = new Checkbox();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FimArchiveSearchGUI window = new FimArchiveSearchGUI();
                    window.frmTest.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public FimArchiveSearchGUI() {
        this.initialize();
    }

    private void initialize() {
        arrayOfUselessProperties.clear();
        arrayOfUselessProperties.add("archive");
        arrayOfUselessProperties.add("avatar");
        arrayOfUselessProperties.add("color");
        arrayOfUselessProperties.add("cover_image");
        arrayOfUselessProperties.add("chapters");
        this.frmTest = new JFrame();
        this.frmTest.setTitle("Fimarchive Searcher by itchylol742");
        this.frmTest.setBounds(150, 25, 1394, 953);
        this.frmTest.setDefaultCloseOperation(3);
        this.frmTest.getContentPane().setLayout(new BorderLayout(0, 0));
        this.tabbedPane.setToolTipText("");
        this.tabbedPane.setForeground(Color.BLACK);
        this.tabbedPane.setFont(new Font("Arial", 0, 18));
        this.frmTest.getContentPane().add(this.tabbedPane);
        this.tabbedPane.addTab("Search", null, this.panel, null);
        this.tabbedPane.setEnabledAt(0, true);
        this.panel.setBackground(SystemColor.menu);
        this.panel.setLayout(null);
        JTextArea txtrLeave = new JTextArea();
        txtrLeave.setBounds(1182, 780, 164, 45);
        this.panel.add(txtrLeave);
        txtrLeave.setForeground(Color.GRAY);
        txtrLeave.setFont(new Font("Arial", 0, 15));
        txtrLeave.setBackground(SystemColor.menu);
        txtrLeave.setEditable(false);
        txtrLeave.setText("Leave fields empty for \r\nno limit/filter");
        textArea = new TextArea();
        textArea.setBounds(27, 282, 1133, 599);
        this.panel.add(textArea);
        textArea.setFont(new Font("Arial", 0, 20));
        latestAllowedPublishDate.setBounds(1182, 560, 164, 34);
        this.panel.add(latestAllowedPublishDate);
        latestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        this.label_9.setBounds(1182, 520, 158, 34);
        this.panel.add(this.label_9);
        this.label_9.setFont(new Font("Arial", 0, 20));
        this.label_6.setBounds(1182, 489, 158, 23);
        this.panel.add(this.label_6);
        this.label_6.setForeground(Color.GRAY);
        this.label_6.setFont(new Font("Arial", 0, 15));
        earliestAllowedPublishDate.setBounds(1182, 440, 164, 34);
        this.panel.add(earliestAllowedPublishDate);
        earliestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        this.label_8.setBounds(1182, 400, 158, 34);
        this.panel.add(this.label_8);
        this.label_8.setFont(new Font("Arial", 0, 20));
        maxWordsText.setBounds(1182, 320, 164, 34);
        this.panel.add(maxWordsText);
        maxWordsText.setText("10");
        maxWordsText.setFont(new Font("Arial", 0, 20));
        this.label_5.setBounds(1182, 280, 158, 34);
        this.panel.add(this.label_5);
        this.label_5.setFont(new Font("Arial", 0, 20));
        minWordsText.setBounds(1182, 240, 164, 34);
        this.panel.add(minWordsText);
        minWordsText.setText("10");
        minWordsText.setFont(new Font("Arial", 0, 20));
        this.label_4.setBounds(1182, 200, 158, 34);
        this.panel.add(this.label_4);
        this.label_4.setFont(new Font("Arial", 0, 20));
        minLikesText.setBounds(1182, 40, 164, 34);
        this.panel.add(minLikesText);
        minLikesText.setFont(new Font("Arial", 0, 20));
        minLikesText.setText("10");
        this.label_3.setBounds(1182, 0, 158, 34);
        this.panel.add(this.label_3);
        this.label_3.setFont(new Font("Arial", 0, 20));
        completedOnlyCheckbox.setBounds(913, 222, 225, 23);
        this.panel.add(completedOnlyCheckbox);
        completedOnlyCheckbox.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(oldestFirstRadioButton);
        oldestFirstRadioButton.setBounds(909, 170, 158, 23);
        this.panel.add(oldestFirstRadioButton);
        oldestFirstRadioButton.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(newestFirstRadioButton);
        newestFirstRadioButton.setBounds(909, 144, 158, 23);
        this.panel.add(newestFirstRadioButton);
        newestFirstRadioButton.setFont(new Font("Arial", 0, 18));
        wordsRadioButton.setBounds(909, 118, 109, 23);
        this.panel.add(wordsRadioButton);
        wordsRadioButton.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(wordsRadioButton);
        likesRadioButton.setBounds(909, 66, 109, 23);
        this.panel.add(likesRadioButton);
        likesRadioButton.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(likesRadioButton);
        viewsRadioButton.setBounds(909, 40, 109, 23);
        this.panel.add(viewsRadioButton);
        viewsRadioButton.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(viewsRadioButton);
        Label label = new Label("Sort By");
        label.setBounds(909, 0, 126, 34);
        this.panel.add(label);
        label.setFont(new Font("Arial", 0, 25));
        Label label_2 = new Label("Bad Tags");
        label_2.setBounds(723, 0, 126, 34);
        this.panel.add(label_2);
        label_2.setFont(new Font("Arial", 0, 25));
        badTag1.setBounds(718, 48, 164, 34);
        this.panel.add(badTag1);
        badTag1.setFont(new Font("Arial", 0, 21));
        badTag2.setBounds(718, 96, 164, 34);
        this.panel.add(badTag2);
        badTag2.setFont(new Font("Arial", 0, 21));
        badTag3.setBounds(718, 146, 164, 34);
        this.panel.add(badTag3);
        badTag3.setFont(new Font("Arial", 0, 21));
        badTag4.setBounds(718, 194, 164, 34);
        this.panel.add(badTag4);
        badTag4.setFont(new Font("Arial", 0, 21));
        badTag5.setBounds(718, 240, 164, 34);
        this.panel.add(badTag5);
        badTag5.setFont(new Font("Arial", 0, 21));
        Button button = new Button("Search");
        button.setBounds(299, 194, 355, 81);
        this.panel.add(button);
        button.setFont(new Font("Arial", 0, 46));
        goodTag5.setBounds(80, 240, 164, 34);
        this.panel.add(goodTag5);
        goodTag5.setFont(new Font("Arial", 0, 21));
        goodTag4.setBounds(80, 194, 164, 34);
        this.panel.add(goodTag4);
        goodTag4.setFont(new Font("Arial", 0, 21));
        goodTag3.setBounds(80, 146, 164, 34);
        this.panel.add(goodTag3);
        goodTag3.setFont(new Font("Arial", 0, 21));
        goodTag2.setBounds(80, 96, 164, 34);
        this.panel.add(goodTag2);
        goodTag2.setFont(new Font("Arial", 0, 21));
        goodTag1.setBounds(80, 48, 164, 34);
        this.panel.add(goodTag1);
        goodTag1.setFont(new Font("Arial", 0, 21));
        Label label_1 = new Label("Good Tags");
        label_1.setBounds(80, 0, 126, 34);
        this.panel.add(label_1);
        label_1.setFont(new Font("Arial", 0, 25));
        hideUnknownPublishDateCheckbox.setFont(new Font("Arial", 0, 18));
        hideUnknownPublishDateCheckbox.setBounds(1166, 634, 14, 23);
        this.panel.add(hideUnknownPublishDateCheckbox);
        JTextArea txtrHideStoriesWith = new JTextArea();
        txtrHideStoriesWith.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                hideUnknownPublishDateCheckbox.setState(!hideUnknownPublishDateCheckbox.getState());
            }
        });
        txtrHideStoriesWith.setText("Hide stories with \r\nunknown publish dates");
        txtrHideStoriesWith.setForeground(Color.BLACK);
        txtrHideStoriesWith.setFont(new Font("Arial", 0, 18));
        txtrHideStoriesWith.setEditable(false);
        txtrHideStoriesWith.setBackground(SystemColor.menu);
        txtrHideStoriesWith.setBounds(1182, 634, 187, 60);
        this.panel.add(txtrHideStoriesWith);
        this.txtrMadeByuitchylol.setText("Made by itchylol742");
        this.txtrMadeByuitchylol.setForeground(Color.GRAY);
        this.txtrMadeByuitchylol.setFont(new Font("Arial", 0, 15));
        this.txtrMadeByuitchylol.setEditable(false);
        this.txtrMadeByuitchylol.setBackground(SystemColor.menu);
        this.txtrMadeByuitchylol.setBounds(1182, 836, 164, 34);
        this.panel.add(this.txtrMadeByuitchylol);
        Label label_7 = new Label("Minimum % Rating");
        label_7.setFont(new Font("Arial", 0, 20));
        label_7.setBounds(1182, 80, 181, 34);
        this.panel.add(label_7);
        minPercentRatingTextBox.setText("60");
        minPercentRatingTextBox.setFont(new Font("Arial", 0, 20));
        minPercentRatingTextBox.setBounds(1182, 120, 164, 34);
        this.panel.add(minPercentRatingTextBox);
        this.searchByRadioButtons.add(percentRatingRadioButton);
        percentRatingRadioButton.setFont(new Font("Arial", 0, 18));
        percentRatingRadioButton.setBounds(909, 92, 181, 23);
        this.panel.add(percentRatingRadioButton);
        writeResultsCheckbox.setLabel("Write results to file");
        writeResultsCheckbox.setFont(new Font("Arial", 0, 18));
        writeResultsCheckbox.setBounds(1166, 700, 180, 23);
        this.panel.add(writeResultsCheckbox);
        useSubsetCheckbox.setLabel("optimizedIndex.json");
        useSubsetCheckbox.setFont(new Font("Arial", 0, 18));
        useSubsetCheckbox.setBounds(1166, 729, 203, 23);
        this.panel.add(useSubsetCheckbox);
        Label label_11 = new Label("Title Contains");
        label_11.setFont(new Font("Arial", 0, 25));
        label_11.setBounds(299, 0, 168, 34);
        this.panel.add(label_11);
        titleContainsTextBox.setFont(new Font("Arial", 0, 21));
        titleContainsTextBox.setBounds(299, 48, 355, 34);
        this.panel.add(titleContainsTextBox);
        descriptionContainsTextBox.setText("<dynamic");
        descriptionContainsTextBox.setFont(new Font("Arial", 0, 21));
        descriptionContainsTextBox.setBounds(299, 146, 355, 34);
        this.panel.add(descriptionContainsTextBox);
        this.label_12.setFont(new Font("Arial", 0, 25));
        this.label_12.setBounds(299, 96, 257, 34);
        this.panel.add(this.label_12);
        this.tabbedPane.addTab("Sequel/Prequel finder (unfinished)", null, this.panel_1, null);
        this.tabbedPane.setEnabledAt(1, true);
        this.panel_1.setLayout(null);
        TextField storyIDField = new TextField();
        storyIDField.setFont(new Font("Arial", 0, 21));
        storyIDField.setBounds(62, 140, 217, 34);
        this.panel_1.add(storyIDField);
        JTextArea txtrEnterTheStory = new JTextArea();
        txtrEnterTheStory.setText("Enter the story ID of a story, and it will find any sequels and prequels the story has.\r\nA story can only have maximum 1 prequel, but it can have any number of sequels. ");
        txtrEnterTheStory.setForeground(Color.GRAY);
        txtrEnterTheStory.setFont(new Font("Arial", 0, 15));
        txtrEnterTheStory.setEditable(false);
        txtrEnterTheStory.setBackground(SystemColor.menu);
        txtrEnterTheStory.setBounds(62, 36, 553, 45);
        this.panel_1.add(txtrEnterTheStory);
        Label label_10 = new Label("Story ID");
        label_10.setFont(new Font("Arial", 0, 20));
        label_10.setBounds(62, 87, 158, 34);
        this.panel_1.add(label_10);
        Button button_1 = new Button("Find sequels/prequels");
        button_1.setFont(new Font("Arial", 0, 20));
        button_1.setBounds(301, 140, 217, 34);
        this.panel_1.add(button_1);
        JComboBox comboBox = new JComboBox();
        comboBox.setEditable(true);
        comboBox.setBounds(161, 265, 421, 54);
        this.panel_1.add(comboBox);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (useSubsetCheckbox.getState()) {
                        FimArchiveSearchGUI.updateTextAreaFromOptimizedIndex();
                    } else {
                        FimArchiveSearchGUI.createOptimizedIndex();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        FimArchiveSearchGUI.loadTagTextAreasIntoTagTestAreasArrayList();
        FimArchiveSearchGUI.loadSettings();
        FimArchiveSearchGUI.goodPrint("IMPORTANT! If this is your first time running the program, have optimizedIndex.json UNCHECKED\n");
        FimArchiveSearchGUI.goodPrint("This will created optimizedIndex.json from information found in index.json\n");
        FimArchiveSearchGUI.goodPrint("After that, run the program with optimizedIndex.json checked\n");
        FimArchiveSearchGUI.goodPrint("optimizedIndex.json is 1/5th the size of index.json. This makes the program 5 times faster!\n");
        FimArchiveSearchGUI.goodPrint("\n");
        FimArchiveSearchGUI.goodPrint("- Tags are not case sensitive. Type in proper caps, no caps, or all caps if you want\n");
        FimArchiveSearchGUI.goodPrint("- Some stories have -1 likes due to metadata error, so even setting min likes to 0 will filter them out\n");
        FimArchiveSearchGUI.goodPrint("- Some stories have 0 (or very low number) words due to metadata error...?,\n");
        FimArchiveSearchGUI.goodPrint("    - Or maybe somehow those short stories got on the site\n");
        FimArchiveSearchGUI.goodPrint("- Percentage rating assumes there's 1 more like and 1 more dislike than there actually is\n");
        FimArchiveSearchGUI.goodPrint("    - The +1 makes sure stories with few ratings don't get perfect score\n");
        FimArchiveSearchGUI.goodPrint("- Dates are in the format YYYY/MM/DD\n");
        FimArchiveSearchGUI.goodPrint("    - but you don't need 0's before the month and day if it's less than 10\n");
        FimArchiveSearchGUI.goodPrint("    - For exmaple, 2015/02/03 is valid and 2015/2/3 is also valid\n");
    }

    public static void goodPrint(String theString) {
        textArea.append(theString);
    }

    public static void loadTagTextAreasIntoTagTestAreasArrayList() {
        textAreasArrayList.clear();
        textAreasArrayList.add(goodTag1);
        textAreasArrayList.add(goodTag2);
        textAreasArrayList.add(goodTag3);
        textAreasArrayList.add(goodTag4);
        textAreasArrayList.add(goodTag5);
        textAreasArrayList.add(badTag1);
        textAreasArrayList.add(badTag2);
        textAreasArrayList.add(badTag3);
        textAreasArrayList.add(badTag4);
        textAreasArrayList.add(badTag5);
    }

    public static void saveSettings() throws ParseException {
        String filename = "settings.txt";
        goodTags.clear();
        badTags.clear();
        FimArchiveSearchGUI.readTextBoxesIntoMemory();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("5 good tags then 5 bad tags. Hardcoded");
            out.newLine();
            int i = 0;
            while (i < 5) {
                out.write("GOOD");
                if (i < goodTags.size()) {
                    out.write(goodTags.get(i));
                }
                out.newLine();
                ++i;
            }
            i = 5;
            while (i < 10) {
                out.write("BAD ");
                if (i - 5 < badTags.size()) {
                    out.write(badTags.get(i - 5));
                }
                out.newLine();
                ++i;
            }
            out.write("Sort by:");
            out.newLine();
            if (viewsRadioButton.isSelected()) {
                out.write("views");
                out.newLine();
            } else if (likesRadioButton.isSelected()) {
                out.write("likes");
                out.newLine();
            } else if (percentRatingRadioButton.isSelected()) {
                out.write("percent");
                out.newLine();
            } else if (wordsRadioButton.isSelected()) {
                out.write("words");
                out.newLine();
            } else if (newestFirstRadioButton.isSelected()) {
                out.write("newest");
                out.newLine();
            } else if (oldestFirstRadioButton.isSelected()) {
                out.write("oldest");
                out.newLine();
            } else {
                out.write("default");
                out.newLine();
            }
            out.write("Min likes, min words, max words, min % rating - blank for no filter");
            out.newLine();
            out.write(minLikesText.getText());
            out.newLine();
            out.write(minWordsText.getText());
            out.newLine();
            out.write(maxWordsText.getText());
            out.newLine();
            out.write(minPercentRatingTextBox.getText());
            out.newLine();
            out.write("Completed stories only? y/n");
            out.newLine();
            if (completedOnlyCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("earliest allowed publish date in the format YYYY/MM/DD - blank for no filter");
            out.newLine();
            out.write(earliestAllowedPublishDate.getText());
            out.newLine();
            out.write("latest allowed publish date in the format YYYY/MM/DD - blank for no filter");
            out.newLine();
            out.write(latestAllowedPublishDate.getText());
            out.newLine();
            out.write("Hide stories with unknown publish dates? y/n");
            out.newLine();
            if (hideUnknownPublishDateCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Save results to results.txt? y/n");
            out.newLine();
            if (writeResultsCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Use subset? y/n");
            out.newLine();
            if (useSubsetCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Title contains:");
            out.newLine();
            out.write(titleContainsTextBox.getText());
            out.newLine();
            out.write("Description contains:");
            out.newLine();
            out.write(descriptionContainsTextBox.getText());
            out.newLine();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadSettings() {
        String filename = "settings.txt";
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(filename));
            line = br.readLine();
            System.out.println(line);
            int i = 0;
            while (i < 10) {
                line = br.readLine();
                System.out.println(String.valueOf(line) + " assign to textAreasArrayList index " + i);
                if (line.length() > 3) {
                    textAreasArrayList.get(i).setText(line.substring(4));
                }
                ++i;
            }
            line = br.readLine();
            System.out.println(line);
            line = br.readLine();
            System.out.println(line);
            if (line.equals("likes")) {
                likesRadioButton.setSelected(true);
            } else if (line.equals("views")) {
                viewsRadioButton.setSelected(true);
            } else if (line.equals("words")) {
                wordsRadioButton.setSelected(true);
            } else if (line.equals("newest")) {
                newestFirstRadioButton.setSelected(true);
            } else if (line.equals("oldest")) {
                oldestFirstRadioButton.setSelected(true);
            } else if (line.equals("percent")) {
                percentRatingRadioButton.setSelected(true);
            }
            line = br.readLine();
            line = br.readLine();
            minLikesText.setText(line);
            line = br.readLine();
            minWordsText.setText(line);
            line = br.readLine();
            maxWordsText.setText(line);
            line = br.readLine();
            minPercentRatingTextBox.setText(line);
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                completedOnlyCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            earliestAllowedPublishDate.setText(line);
            line = br.readLine();
            line = br.readLine();
            latestAllowedPublishDate.setText(line);
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                hideUnknownPublishDateCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                writeResultsCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                useSubsetCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            titleContainsTextBox.setText(line);
            line = br.readLine();
            line = br.readLine();
            descriptionContainsTextBox.setText(line);
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readTextBoxesIntoMemory() throws ParseException {
        goodTags.clear();
        badTags.clear();
        minLikesInt = -1;
        minWordsInt = -1;
        maxWordsInt = -1;
        minPercentageRatingFloat = -1.0f;
        resultsArray.clear();
        descriptionContainsString = "";
        titleContainsString = "";
        if (goodTag1.getText().length() > 1) {
            goodTags.add(goodTag1.getText().trim());
        }
        if (goodTag2.getText().length() > 1) {
            goodTags.add(goodTag2.getText().trim());
        }
        if (goodTag3.getText().length() > 1) {
            goodTags.add(goodTag3.getText().trim());
        }
        if (goodTag4.getText().length() > 1) {
            goodTags.add(goodTag4.getText().trim());
        }
        if (goodTag5.getText().length() > 1) {
            goodTags.add(goodTag5.getText().trim());
        }
        if (badTag1.getText().length() > 1) {
            badTags.add(badTag1.getText().trim());
        }
        if (badTag2.getText().length() > 1) {
            badTags.add(badTag2.getText().trim());
        }
        if (badTag3.getText().length() > 1) {
            badTags.add(badTag3.getText().trim());
        }
        if (badTag4.getText().length() > 1) {
            badTags.add(badTag4.getText().trim());
        }
        if (badTag5.getText().length() > 1) {
            badTags.add(badTag5.getText().trim());
        }
        if (minLikesText.getText().length() > 0) {
            minLikesInt = Integer.parseInt(minLikesText.getText());
        }
        if (minWordsText.getText().length() > 0) {
            minWordsInt = Integer.parseInt(minWordsText.getText());
        }
        if (maxWordsText.getText().length() > 0) {
            maxWordsInt = Integer.parseInt(maxWordsText.getText());
        }
        if (minPercentRatingTextBox.getText().length() > 0) {
            minPercentageRatingFloat = Float.parseFloat(minPercentRatingTextBox.getText());
        }
        checkEarliestAllowedPublishDate = false;
        checkLatestAllowedPublishDate = false;
        if (earliestAllowedPublishDate.getText().length() > 0) {
            earliestAllowedPublishDateObject = formatter.parse(earliestAllowedPublishDate.getText());
            checkEarliestAllowedPublishDate = true;
        }
        if (latestAllowedPublishDate.getText().length() > 0) {
            latestAllowedPublishDateObject = formatter.parse(latestAllowedPublishDate.getText());
            checkLatestAllowedPublishDate = true;
        }
        hideStoriesWithUnkownPublishDate = hideUnknownPublishDateCheckbox.getState();
        completedStoriesOnly = completedOnlyCheckbox.getState();
        if (viewsRadioButton.isSelected()) {
            sortByString = "views";
        } else if (likesRadioButton.isSelected()) {
            sortByString = "likes";
        } else if (percentRatingRadioButton.isSelected()) {
            sortByString = "percent";
        } else if (wordsRadioButton.isSelected()) {
            sortByString = "words";
        } else if (oldestFirstRadioButton.isSelected()) {
            sortByString = "oldest";
        } else if (newestFirstRadioButton.isSelected()) {
            sortByString = "newest";
        }
        if (titleContainsTextBox.getText().length() > 0) {
            titleContainsString = titleContainsTextBox.getText();
        }
        if (descriptionContainsTextBox.getText().length() > 0) {
            descriptionContainsString = descriptionContainsTextBox.getText();
        }
    }

    public static void createOptimizedIndex() throws ParseException {
        df.setMaximumFractionDigits(2);
        startTimeMilliseconds = System.currentTimeMillis();
        FimArchiveSearchGUI.saveSettings();
        numberOfStoriesScanned = 0;
        textArea.setText("");
        goodTags.clear();
        badTags.clear();
        tooManyResults = false;
        try {
            String name = "default";
            FimArchiveSearchGUI.readTextBoxesIntoMemory();
            FimArchiveSearchGUI.goodPrint(" --- Creating optimized index --- \n");
            FimArchiveSearchGUI.goodPrint("\n");
            JsonReader reader = new JsonReader(new FileReader("index.json"));
            if (useSampleIndex) {
                reader = new JsonReader(new FileReader("sampleIndex.json"));
            }
            block20: while (true) {
                JsonToken token = reader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        reader.beginArray();
                        ++indents;
                        continue block20;
                    }
                    case END_ARRAY: {
                        --indents;
                        reader.endArray();
                        continue block20;
                    }
                    case BEGIN_OBJECT: {
                        ++indents;
                        reader.beginObject();
                        continue block20;
                    }
                    case END_OBJECT: {
                        if (--indents == 1) {
                            resultsArray.add(temp);
                            if (numberOfStoriesScanned % 10000 == 0) {
                                FimArchiveSearchGUI.goodPrint("Scanned " + numberOfStoriesScanned + " stories\n");
                            }
                            temp = new FimfictionStory();
                            stillGood = true;
                        }
                        reader.endObject();
                        continue block20;
                    }
                    case NAME: {
                        name = reader.nextName();
                        if (indents == 1) {
                            ++numberOfStoriesScanned;
                        }
                        if (!arrayOfUselessProperties.contains(name)) continue block20;
                        reader.skipValue();
                        continue block20;
                    }
                    case STRING: {
                        String s = reader.nextString();
                        if (indents == 4 && name.equals("name")) {
                            FimArchiveSearchGUI.temp.tags.add(s);
                            continue block20;
                        }
                        if (indents == 2 && name.equals("title")) {
                            FimArchiveSearchGUI.temp.title = s;
                            continue block20;
                        }
                        if (indents == 2 && name.equals("date_published")) {
                            FimArchiveSearchGUI.temp.datePublishedString = s.substring(0, 10).replace('-', '/');
                            FimArchiveSearchGUI.temp.datePublishedObject = formatter.parse(FimArchiveSearchGUI.temp.datePublishedString);
                            continue block20;
                        }
                        if (indents == 3 && name.equals("name")) {
                            FimArchiveSearchGUI.temp.author = s;
                            continue block20;
                        }
                        if (name.equals("completion_status")) {
                            FimArchiveSearchGUI.temp.completionStatus = s;
                            continue block20;
                        }
                        if (name.equals("description_html")) {
                            FimArchiveSearchGUI.temp.description = s;
                            continue block20;
                        }
                        if (!name.equals("content_rating")) continue block20;
                        FimArchiveSearchGUI.temp.contentRating = s;
                        continue block20;
                    }
                    case NUMBER: {
                        int n = reader.nextInt();
                        if (name.equals("num_likes")) {
                            FimArchiveSearchGUI.temp.likes = n;
                            continue block20;
                        }
                        if (name.equals("num_dislikes")) {
                            FimArchiveSearchGUI.temp.dislikes = n;
                            continue block20;
                        }
                        if (name.equals("num_views")) {
                            FimArchiveSearchGUI.temp.views = n;
                            continue block20;
                        }
                        if (name.equals("num_words") && indents == 2) {
                            FimArchiveSearchGUI.temp.words = n;
                            continue block20;
                        }
                        if (indents == 2 && name.equals("id")) {
                            FimArchiveSearchGUI.temp.ID = n;
                            continue block20;
                        }
                        if (!name.equals("prequel")) continue block20;
                        FimArchiveSearchGUI.temp.prequelID = n;
                        continue block20;
                    }
                    case BOOLEAN: {
                        reader.nextBoolean();
                        continue block20;
                    }
                    case NULL: {
                        reader.nextNull();
                        continue block20;
                    }
                    case END_DOCUMENT: {
                        FimArchiveSearchGUI.goodPrint("--End of scanning--\n");
                        FimArchiveSearchGUI.goodPrint("--Total stories scanned: " + numberOfStoriesScanned + "--\n");
                        if (viewsRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by views--\n");
                        } else if (likesRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by likes--\n");
                        } else if (wordsRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by words--\n");
                        }
                        FimArchiveSearchGUI.goodPrint("Creating optimizedIndex.json (takes about 6 seconds). The program will appear to freeze\n");
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (FileWriter writer = new FileWriter("optimizedIndex.json");){
                            Gson gson = new GsonBuilder().create();
                            gson.toJson(resultsArray, (Appendable)writer);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        FimArchiveSearchGUI.goodPrint("Done creating optimizedIndex.json\n");
                        FimArchiveSearchGUI.goodPrint("Now run the program with \"optimizedIndex.json\" selected");
                        resultsArray.clear();
                        numberOfStoriesScanned = 0;
                        reader.close();
                        return;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateTextAreaFromOptimizedIndex() throws IOException, ParseException {
        FimArchiveSearchGUI.saveSettings();
        tooManyResults = false;
        String storyInfo = "";
        numberOfStoriesScanned = 0;
        textArea.setText("");
        startTimeMilliseconds = System.currentTimeMillis();
        ArrayList originalTags = new ArrayList();
        int indents = 0;
        String name = "filler";
        FimArchiveSearchGUI.readTextBoxesIntoMemory();
        FimArchiveSearchGUI.goodPrint(" --- Search Options --- \n");
        FimArchiveSearchGUI.goodPrint(" --- Searching from subset of all stories --- \n");
        FimArchiveSearchGUI.goodPrint("--Searching for stories with tags: " + goodTags + "\n");
        FimArchiveSearchGUI.goodPrint("--and without tags: " + badTags + "\n");
        FimArchiveSearchGUI.goodPrint("--Sorted by " + sortByString + "\n");
        if (minLikesInt != -1) {
            FimArchiveSearchGUI.goodPrint("--Min likes " + minLikesInt + "\n");
        }
        if (minWordsInt != -1) {
            FimArchiveSearchGUI.goodPrint("--Min words " + minWordsInt + "\n");
        }
        if (maxWordsInt != -1) {
            FimArchiveSearchGUI.goodPrint("--Max words " + maxWordsInt + "\n");
        }
        if (checkEarliestAllowedPublishDate) {
            FimArchiveSearchGUI.goodPrint("--Only stories published after " + earliestAllowedPublishDate.getText() + "\n");
        }
        if (checkLatestAllowedPublishDate) {
            FimArchiveSearchGUI.goodPrint("--Only stories published before " + latestAllowedPublishDate.getText() + "\n");
        }
        if (completedStoriesOnly) {
            FimArchiveSearchGUI.goodPrint("--Only completed stories\n");
        }
        if (hideStoriesWithUnkownPublishDate) {
            FimArchiveSearchGUI.goodPrint("--Hide stories with unknown publish date\n");
        }
        FimArchiveSearchGUI.goodPrint("\n");
        JsonReader reader = new JsonReader(new FileReader("optimizedIndex.json"));
        block14: while (true) {
            JsonToken token = reader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    ++indents;
                    continue block14;
                }
                case END_ARRAY: {
                    --indents;
                    reader.endArray();
                    continue block14;
                }
                case BEGIN_OBJECT: {
                    ++indents;
                    reader.beginObject();
                    continue block14;
                }
                case END_OBJECT: {
                    --indents;
                    if (name.equals("completionStatus")) {
                        FimArchiveSearchGUI.checkIfStoryMeetsRequirements();
                        if (stillGood) {
                            resultsArray.add(temp);
                        }
                        temp = new FimfictionStory();
                        if (++numberOfStoriesScanned % 10000 == 0) {
                            FimArchiveSearchGUI.goodPrint("Scanned " + numberOfStoriesScanned + ", found " + resultsArray.size() + " results so far\n");
                        }
                    }
                    reader.endObject();
                    continue block14;
                }
                case NAME: {
                    name = reader.nextName();
                    continue block14;
                }
                case STRING: {
                    String s = reader.nextString();
                    if (name.equals("tags")) {
                        FimArchiveSearchGUI.temp.tags.add(s);
                        continue block14;
                    }
                    if (name.equals("title")) {
                        FimArchiveSearchGUI.temp.title = s;
                        continue block14;
                    }
                    if (name.equals("author")) {
                        FimArchiveSearchGUI.temp.author = s;
                        continue block14;
                    }
                    if (name.equals("contentRating")) {
                        FimArchiveSearchGUI.temp.contentRating = s;
                        continue block14;
                    }
                    if (name.equals("datePublishedString")) {
                        FimArchiveSearchGUI.temp.datePublishedString = s;
                        if (s.equals("unknown date")) continue block14;
                        FimArchiveSearchGUI.temp.datePublishedString = s.substring(0, 10).replace('-', '/');
                        FimArchiveSearchGUI.temp.datePublishedObject = formatter.parse(FimArchiveSearchGUI.temp.datePublishedString);
                        continue block14;
                    }
                    if (name.equals("description")) {
                        FimArchiveSearchGUI.temp.description = s;
                        continue block14;
                    }
                    if (!name.equals("completionStatus")) continue block14;
                    FimArchiveSearchGUI.temp.completionStatus = s;
                    continue block14;
                }
                case NUMBER: {
                    double n = reader.nextDouble();
                    if (name.equals("words")) {
                        FimArchiveSearchGUI.temp.words = (int)n;
                        continue block14;
                    }
                    if (name.equals("likes")) {
                        FimArchiveSearchGUI.temp.likes = (int)n;
                        continue block14;
                    }
                    if (name.equals("dislikes")) {
                        FimArchiveSearchGUI.temp.dislikes = (int)n;
                        continue block14;
                    }
                    if (name.equals("ID")) {
                        FimArchiveSearchGUI.temp.ID = (int)n;
                        continue block14;
                    }
                    if (name.equals("prequelID")) {
                        FimArchiveSearchGUI.temp.prequelID = (int)n;
                        continue block14;
                    }
                    if (!name.equals("views")) continue block14;
                    FimArchiveSearchGUI.temp.views = (int)n;
                    continue block14;
                }
                case BOOLEAN: {
                    boolean b = reader.nextBoolean();
                    continue block14;
                }
                case NULL: {
                    reader.nextNull();
                    continue block14;
                }
                case END_DOCUMENT: {
                    FimArchiveSearchGUI.printResultsToTextArea();
                    FimArchiveSearchGUI.goodPrint("--End of scanning--\n");
                    FimArchiveSearchGUI.goodPrint("--Search completed in " + (float)(System.currentTimeMillis() - startTimeMilliseconds) / 1000.0f + " seconds--\n");
                    if (tooManyResults) {
                        FimArchiveSearchGUI.goodPrint("--Too many results, only showing 500 to avoid lag\n");
                    }
                    FimArchiveSearchGUI.goodPrint("--Total stories scanned: " + numberOfStoriesScanned + "--\n");
                    FimArchiveSearchGUI.goodPrint("--Results: " + resultsArray.size() + "--\n");
                    if (viewsRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by views--\n");
                    } else if (likesRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by likes--\n");
                    } else if (percentRatingRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by percent rating--\n");
                    } else if (wordsRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by words--\n");
                    } else if (newestFirstRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by newest first--\n");
                    } else if (oldestFirstRadioButton.isSelected()) {
                        FimArchiveSearchGUI.goodPrint("--Sorting by oldest first--\n");
                    }
                    if (writeResultsCheckbox.getState()) {
                        try {
                            String filename = "results.txt";
                            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
                            out.write(" ");
                            out.close();
                            PrintWriter out1 = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
                            String[] stringArray = textArea.getText().split("\\n");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String line = stringArray[n2];
                                out1.println(line);
                                ++n2;
                            }
                            out1.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    resultsArray.clear();
                    numberOfStoriesScanned = 0;
                    reader.close();
                    return;
                }
            }
        }
    }

    public static boolean checkIfStoryMeetsRequirements() {
        int i;
        stillGood = true;
        temp.calculateRating();
        if (completedStoriesOnly && !FimArchiveSearchGUI.temp.completionStatus.equals("complete")) {
            stillGood = false;
        }
        if (minLikesInt != -1 && stillGood && FimArchiveSearchGUI.temp.likes < minLikesInt) {
            stillGood = false;
        }
        if (minWordsInt != -1 && stillGood && FimArchiveSearchGUI.temp.words < minWordsInt) {
            stillGood = false;
        }
        if (maxWordsInt != -1 && stillGood && FimArchiveSearchGUI.temp.words > maxWordsInt) {
            stillGood = false;
        }
        if (minPercentageRatingFloat != -1.0f && stillGood && FimArchiveSearchGUI.temp.percentRating < minPercentageRatingFloat) {
            stillGood = false;
        }
        if (checkLatestAllowedPublishDate && stillGood && FimArchiveSearchGUI.temp.datePublishedObject != null && FimArchiveSearchGUI.temp.datePublishedObject.after(latestAllowedPublishDateObject)) {
            stillGood = false;
        }
        if (checkEarliestAllowedPublishDate && stillGood && FimArchiveSearchGUI.temp.datePublishedObject != null && FimArchiveSearchGUI.temp.datePublishedObject.before(earliestAllowedPublishDateObject)) {
            stillGood = false;
        }
        if (stillGood && hideStoriesWithUnkownPublishDate && FimArchiveSearchGUI.temp.datePublishedString.equals("unknown date")) {
            stillGood = false;
        }
        if (stillGood && titleContainsString.length() > 0 && !FimArchiveSearchGUI.temp.title.toLowerCase().contains(titleContainsString.toLowerCase())) {
            stillGood = false;
        }
        if (stillGood && descriptionContainsString.length() > 0 && !FimArchiveSearchGUI.temp.description.toLowerCase().contains(descriptionContainsString.toLowerCase())) {
            stillGood = false;
        }
        ArrayList<String> lowerCaseTags = new ArrayList<String>(FimArchiveSearchGUI.temp.tags);
        if (stillGood) {
            i = 0;
            while (i < lowerCaseTags.size()) {
                lowerCaseTags.set(i, FimArchiveSearchGUI.temp.tags.get(i).toLowerCase());
                ++i;
            }
            i = 0;
            while (i < goodTags.size()) {
                if (!lowerCaseTags.contains(goodTags.get(i).toLowerCase())) {
                    stillGood = false;
                    break;
                }
                ++i;
            }
        }
        if (stillGood) {
            i = 0;
            while (i < badTags.size()) {
                if (lowerCaseTags.contains(badTags.get(i).toLowerCase())) {
                    stillGood = false;
                    break;
                }
                ++i;
            }
        }
        return true;
    }

    public static void printResultsToTextArea() {
        String storyInfo = "";
        if (viewsRadioButton.isSelected()) {
            Collections.sort(resultsArray, FimfictionStory.ViewsComparator);
        } else if (likesRadioButton.isSelected()) {
            Collections.sort(resultsArray, FimfictionStory.LikesComparator);
        } else if (percentRatingRadioButton.isSelected()) {
            Collections.sort(resultsArray, FimfictionStory.PercentRatingComparator);
        } else if (wordsRadioButton.isSelected()) {
            Collections.sort(resultsArray, FimfictionStory.WordsComparator);
        } else if (!oldestFirstRadioButton.isSelected() && newestFirstRadioButton.isSelected()) {
            Collections.reverse(resultsArray);
        }
        storyInfo = "";
        int i = 0;
        while (i < resultsArray.size()) {
            temp.calculateRating();
            temp = resultsArray.get(i);
            storyInfo = String.valueOf(storyInfo) + "--Story Title: " + FimArchiveSearchGUI.temp.title + ", ";
            storyInfo = String.valueOf(storyInfo) + "Author: " + FimArchiveSearchGUI.temp.author + ", ";
            storyInfo = String.valueOf(storyInfo) + "ID: " + FimArchiveSearchGUI.temp.ID + "\n";
            temp.removeHtmlFormattingFromDescription();
            if (FimArchiveSearchGUI.temp.prequelID != -1) {
                storyInfo = String.valueOf(storyInfo) + "--Prequel ID: " + FimArchiveSearchGUI.temp.prequelID + "\n";
            }
            storyInfo = String.valueOf(storyInfo) + "--Description: ";
            storyInfo = String.valueOf(storyInfo) + FimArchiveSearchGUI.temp.description + "\n";
            storyInfo = String.valueOf(storyInfo) + "--Date Published: " + FimArchiveSearchGUI.temp.datePublishedString + ", Completion: " + FimArchiveSearchGUI.temp.completionStatus.substring(0, 1).toUpperCase() + FimArchiveSearchGUI.temp.completionStatus.substring(1) + "\n";
            storyInfo = String.valueOf(storyInfo) + "--Likes: " + FimArchiveSearchGUI.temp.likes + ", Dislikes: " + FimArchiveSearchGUI.temp.dislikes + ", ";
            storyInfo = String.valueOf(storyInfo) + "Percentage Rating: " + df.format(FimArchiveSearchGUI.temp.percentRating) + "%, ";
            storyInfo = String.valueOf(storyInfo) + "Views: " + FimArchiveSearchGUI.temp.views + ", Word Count: " + FimArchiveSearchGUI.temp.words + "\n";
            storyInfo = String.valueOf(storyInfo) + "--Tags: " + FimArchiveSearchGUI.temp.tags + "\n";
            storyInfo = String.valueOf(storyInfo) + "--Content rating: " + FimArchiveSearchGUI.temp.contentRating.substring(0, 1).toUpperCase() + FimArchiveSearchGUI.temp.contentRating.substring(1) + "\n";
            storyInfo = String.valueOf(storyInfo) + "\n";
            if (i % 10 == 0) {
                FimArchiveSearchGUI.goodPrint(storyInfo);
                storyInfo = "";
            }
            if (i > 500) {
                tooManyResults = true;
                break;
            }
            ++i;
        }
        FimArchiveSearchGUI.goodPrint(storyInfo);
        storyInfo = "";
    }

    public static void indent(int ind) {
        int i = 0;
        while (i < ind) {
            System.out.print("    ");
            ++i;
        }
    }
}

