/*
 * Decompiled with CFR 0.152.
 */
package package1;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;

public class HelloLucene {
    public static void main(String[] args) throws IOException, ParseException {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        boolean createNew = true;
        String SRC_FOLDER = "theLuceneIAAndex";
        if (createNew) {
            File directory = new File(SRC_FOLDER);
            if (!directory.exists()) {
                System.out.println("Directory does not exist.");
            } else {
                try {
                    HelloLucene.delete(directory);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
            System.out.println("delete Done");
        }
        FSDirectory index = FSDirectory.open(Paths.get(SRC_FOLDER, new String[0]));
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        if (createNew) {
            IndexWriter w = new IndexWriter(index, config);
            HelloLucene.addDoc(w, "Lucene in Action", "193398817");
            HelloLucene.addDoc(w, "Lucene for Dummies", "55320055Z");
            HelloLucene.addDoc(w, "Managing Gigabytes", "55063554A");
            HelloLucene.addDoc(w, "The Art of Computer Science", "9900333X");
            w.close();
        }
        QueryParser qp = new QueryParser("title", analyzer);
        Query q = qp.parse("title:lucene managing");
        int hitsPerPage = 10;
        DirectoryReader reader = DirectoryReader.open(index);
        IndexSearcher searcher = new IndexSearcher(reader);
        TopDocs docs = searcher.search(q, hitsPerPage);
        ScoreDoc[] hits = docs.scoreDocs;
        System.out.println("Found " + hits.length + " hits.");
        int i = 0;
        while (i < hits.length) {
            int docId = hits[i].doc;
            Document d = searcher.doc(docId);
            System.out.println(String.valueOf(i + 1) + ". " + d.get("isbn") + "\t" + d.get("title") + " " + d.get("za"));
            ++i;
        }
        reader.close();
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    HelloLucene.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public static void addDoc(IndexWriter w, String title, String isbn) throws IOException {
        Document doc = new Document();
        doc.add(new TextField("title", title, Field.Store.YES));
        doc.add(new StringField("isbn", isbn, Field.Store.YES));
        doc.add(new StringField("za", "thisisZA", Field.Store.YES));
        w.addDocument(doc);
    }
}

