/*
 * Decompiled with CFR 0.152.
 */
package package1;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;

public class TempStuff {
    public static Analyzer analyzer = new StandardAnalyzer();
    public static IndexWriterConfig config = new IndexWriterConfig(analyzer);
    public static RAMDirectory ramDirectory = new RAMDirectory();
    public static IndexWriter indexWriter;

    public static void main(String[] args) throws ParseException {
        TempStuff.createIndex();
        TempStuff.searchSingleTerm("title", "lucene");
        ramDirectory.close();
    }

    public static void createDoc(String author, String title, String date) throws IOException {
        Document doc = new Document();
        doc.add(new TextField("author", author, Field.Store.YES));
        doc.add(new TextField("title", title, Field.Store.YES));
        doc.add(new SortedDocValuesField("date", new BytesRef(date)));
        doc.add(new StoredField("date", date));
        indexWriter.addDocument(doc);
    }

    public static void createIndex() {
        try {
            indexWriter = new IndexWriter(ramDirectory, config);
            TempStuff.createDoc("Sam", "Lucece index option analyzed vs not analyzed", "2016-12-12 20:19:57");
            TempStuff.createDoc("Sam", "Lucene field boost and query time boost example", "2016-03-16 16:57:44");
            TempStuff.createDoc("Jack", "How to do Lucene search highlight example", "2016-03-16 17:47:38");
            TempStuff.createDoc("Smith", "Lucene BooleanQuery is depreacted as of 5.3.0", "2015-04-30 11:44:25");
            TempStuff.createDoc("Smith", "What is term vector in Lucene", "2015-04-10 20:33:53");
            TempStuff.createDoc("Smith2", "2What is term vector in Lucene", "2015-05-10 20:33:53");
            TempStuff.createDoc("Smith3", "3What is term vector in Lucene", "2015-06-10 20:33:53");
            indexWriter.close();
        }
        catch (IOException | NullPointerException ex) {
            System.out.println("Exception : " + ex.getLocalizedMessage());
        }
    }

    public static void searchIndexNoSortAndDisplayResults(Query query) {
        try {
            DirectoryReader idxReader = DirectoryReader.open(ramDirectory);
            IndexSearcher idxSearcher = new IndexSearcher(idxReader);
            TopDocs docs = idxSearcher.search(query, 100);
            System.out.println("length of top docs: " + docs.scoreDocs.length);
            ScoreDoc[] scoreDocArray = docs.scoreDocs;
            int n = docs.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                Document thisDoc = idxSearcher.doc(doc.doc);
                System.out.println(String.valueOf(doc.doc) + "\t" + thisDoc.get("author") + "\t" + thisDoc.get("title"));
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void searchIndexAndDisplayResults(Query query) {
        try {
            DirectoryReader idxReader = DirectoryReader.open(ramDirectory);
            IndexSearcher idxSearcher = new IndexSearcher(idxReader);
            Sort sort = new Sort(SortField.FIELD_SCORE, new SortField("date", SortField.Type.STRING));
            TopFieldDocs docs = idxSearcher.search(query, 10, sort, true, true);
            System.out.println("length of top docs: " + docs.scoreDocs.length + " sort by: " + sort);
            ScoreDoc[] scoreDocArray = docs.scoreDocs;
            int n = docs.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc doc = scoreDocArray[n2];
                Document thisDoc = idxSearcher.doc(doc.doc);
                System.out.println(String.valueOf(doc.doc) + "\t" + thisDoc.get("author") + "\t" + thisDoc.get("title") + "\t" + thisDoc.get("date"));
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void searchSingleTerm(String field, String termText) {
        Term term = new Term(field, termText);
        TermQuery termQuery = new TermQuery(term);
        TempStuff.searchIndexAndDisplayResults(termQuery);
        TempStuff.searchIndexNoSortAndDisplayResults(termQuery);
    }
}

