/*
 * Decompiled with CFR 0.152.
 */
package package1;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import package1.FimfictionStory;

public class FimArchiveSearchGUIBackup {
    static ArrayList<FimfictionStory> resultsArray = new ArrayList();
    static ArrayList<String> arrayOfUselessProperties = new ArrayList();
    static ArrayList<String> goodTags = new ArrayList();
    static ArrayList<String> badTags = new ArrayList();
    static int indents = 0;
    static int updateInterval = 5000;
    static int numberOfStoriesScanned = 0;
    static boolean stillGood = true;
    static FimfictionStory temp = new FimfictionStory();
    static int maxNumberOfResultsShown = 1000;
    static int minLikesInt = -1;
    static int minWordsInt = -1;
    static int maxWordsInt = -1;
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
    private JFrame frmTest;
    static TextField goodTag1 = new TextField();
    static TextField goodTag2 = new TextField();
    static TextField goodTag3 = new TextField();
    static TextField goodTag4 = new TextField();
    static TextField goodTag5 = new TextField();
    static TextField badTag1 = new TextField();
    static TextField badTag2 = new TextField();
    static TextField badTag3 = new TextField();
    static TextField badTag4 = new TextField();
    static TextField badTag5 = new TextField();
    static ArrayList<TextField> textAreasArrayList = new ArrayList();
    static TextArea textArea = new TextArea();
    static JRadioButton views = new JRadioButton("Views");
    static JRadioButton likes = new JRadioButton("Likes");
    static JRadioButton words = new JRadioButton("Words");
    static Checkbox completedOnlyCheckbox = new Checkbox("Completed stories only");
    private ButtonGroup searchByRadioButtons = new ButtonGroup();
    static TextField minLikesText = new TextField();
    static TextField minWordsText = new TextField();
    static TextField maxWordsText = new TextField();
    static TextField latestAllowedPublishDate = new TextField();
    static TextField earliestAllowedPublishDate = new TextField();
    private final Label label_3 = new Label("Minimum Likes");
    private final Label label_4 = new Label("Minimum Words");
    private final Label label_5 = new Label("Maximum Words");
    private final Label label_6 = new Label("YYYY/MM/DD");
    private final Label label_8 = new Label("Published after");
    private final Label label_9 = new Label("Published before");
    private final JRadioButton rdbtnNewestFirst = new JRadioButton("Newest First");
    private final JRadioButton rdbtnOldestFirst = new JRadioButton("Oldest First");

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FimArchiveSearchGUIBackup window = new FimArchiveSearchGUIBackup();
                    window.frmTest.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public FimArchiveSearchGUIBackup() {
        this.initialize();
    }

    private void initialize() {
        arrayOfUselessProperties.clear();
        arrayOfUselessProperties.add("archive");
        arrayOfUselessProperties.add("avatar");
        arrayOfUselessProperties.add("color");
        arrayOfUselessProperties.add("cover_image");
        arrayOfUselessProperties.add("chapters");
        this.frmTest = new JFrame();
        this.frmTest.setTitle("Fimfiction Archive Searcher");
        this.frmTest.setBounds(150, 25, 1394, 953);
        this.frmTest.setDefaultCloseOperation(3);
        this.frmTest.getContentPane().setLayout(null);
        textArea = new TextArea();
        textArea.setFont(new Font("Arial", 0, 20));
        textArea.setBounds(78, 305, 1105, 599);
        this.frmTest.getContentPane().add(textArea);
        views.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(views);
        views.setBounds(935, 50, 109, 23);
        this.frmTest.getContentPane().add(views);
        likes.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(likes);
        likes.setBounds(935, 76, 109, 23);
        this.frmTest.getContentPane().add(likes);
        words.setFont(new Font("Arial", 0, 18));
        this.searchByRadioButtons.add(words);
        words.setBounds(935, 102, 109, 23);
        this.frmTest.getContentPane().add(words);
        Button button = new Button("Search");
        button.setFont(new Font("Arial", 0, 99));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    FimArchiveSearchGUIBackup.updateTextArea();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        button.setBounds(339, 71, 355, 213);
        this.frmTest.getContentPane().add(button);
        goodTag1.setFont(new Font("Arial", 0, 21));
        goodTag1.setBounds(108, 58, 164, 34);
        this.frmTest.getContentPane().add(goodTag1);
        goodTag2.setFont(new Font("Arial", 0, 21));
        goodTag2.setBounds(108, 106, 164, 34);
        this.frmTest.getContentPane().add(goodTag2);
        goodTag3.setFont(new Font("Arial", 0, 21));
        goodTag3.setBounds(108, 156, 164, 34);
        this.frmTest.getContentPane().add(goodTag3);
        Label label = new Label("Sort By");
        label.setFont(new Font("Arial", 0, 25));
        label.setBounds(935, 10, 126, 34);
        this.frmTest.getContentPane().add(label);
        Label label_1 = new Label("Good Tags");
        label_1.setFont(new Font("Arial", 0, 25));
        label_1.setBounds(108, 10, 126, 34);
        this.frmTest.getContentPane().add(label_1);
        Label label_2 = new Label("Bad Tags");
        label_2.setFont(new Font("Arial", 0, 25));
        label_2.setBounds(748, 10, 126, 34);
        this.frmTest.getContentPane().add(label_2);
        badTag1.setFont(new Font("Arial", 0, 21));
        badTag1.setBounds(743, 61, 164, 34);
        this.frmTest.getContentPane().add(badTag1);
        badTag2.setFont(new Font("Arial", 0, 21));
        badTag2.setBounds(743, 106, 164, 34);
        this.frmTest.getContentPane().add(badTag2);
        badTag3.setFont(new Font("Arial", 0, 21));
        badTag3.setBounds(743, 156, 164, 34);
        this.frmTest.getContentPane().add(badTag3);
        goodTag4.setFont(new Font("Arial", 0, 21));
        goodTag4.setBounds(108, 204, 164, 34);
        this.frmTest.getContentPane().add(goodTag4);
        goodTag5.setFont(new Font("Arial", 0, 21));
        goodTag5.setBounds(108, 250, 164, 34);
        this.frmTest.getContentPane().add(goodTag5);
        badTag4.setFont(new Font("Arial", 0, 21));
        badTag4.setBounds(743, 204, 164, 34);
        this.frmTest.getContentPane().add(badTag4);
        badTag5.setFont(new Font("Arial", 0, 21));
        badTag5.setBounds(743, 250, 164, 34);
        textAreasArrayList.add(goodTag1);
        textAreasArrayList.add(goodTag2);
        textAreasArrayList.add(goodTag3);
        textAreasArrayList.add(goodTag4);
        textAreasArrayList.add(goodTag5);
        textAreasArrayList.add(badTag1);
        textAreasArrayList.add(badTag2);
        textAreasArrayList.add(badTag3);
        textAreasArrayList.add(badTag4);
        textAreasArrayList.add(badTag5);
        this.frmTest.getContentPane().add(badTag5);
        completedOnlyCheckbox.setFont(new Font("Arial", 0, 18));
        completedOnlyCheckbox.setBounds(935, 215, 225, 23);
        this.frmTest.getContentPane().add(completedOnlyCheckbox);
        minLikesText.setFont(new Font("Arial", 0, 20));
        minLikesText.setText("10");
        minLikesText.setBounds(1197, 58, 164, 34);
        this.frmTest.getContentPane().add(minLikesText);
        minWordsText.setText("10");
        minWordsText.setFont(new Font("Arial", 0, 20));
        minWordsText.setBounds(1197, 138, 164, 34);
        this.frmTest.getContentPane().add(minWordsText);
        maxWordsText.setText("10");
        maxWordsText.setFont(new Font("Arial", 0, 20));
        maxWordsText.setBounds(1197, 219, 164, 34);
        this.frmTest.getContentPane().add(maxWordsText);
        this.label_3.setFont(new Font("Arial", 0, 20));
        this.label_3.setBounds(1197, 10, 158, 34);
        this.frmTest.getContentPane().add(this.label_3);
        this.label_4.setFont(new Font("Arial", 0, 20));
        this.label_4.setBounds(1197, 102, 158, 34);
        this.frmTest.getContentPane().add(this.label_4);
        this.label_5.setFont(new Font("Arial", 0, 20));
        this.label_5.setBounds(1197, 179, 158, 34);
        this.frmTest.getContentPane().add(this.label_5);
        latestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        latestAllowedPublishDate.setBounds(1197, 529, 164, 34);
        this.frmTest.getContentPane().add(latestAllowedPublishDate);
        this.label_6.setForeground(Color.GRAY);
        this.label_6.setFont(new Font("Arial", 0, 15));
        this.label_6.setBounds(1197, 386, 158, 23);
        this.frmTest.getContentPane().add(this.label_6);
        earliestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        earliestAllowedPublishDate.setBounds(1197, 334, 164, 34);
        this.frmTest.getContentPane().add(earliestAllowedPublishDate);
        this.label_8.setFont(new Font("Arial", 0, 20));
        this.label_8.setBounds(1197, 294, 158, 34);
        this.frmTest.getContentPane().add(this.label_8);
        this.label_9.setFont(new Font("Arial", 0, 20));
        this.label_9.setBounds(1197, 489, 158, 34);
        this.frmTest.getContentPane().add(this.label_9);
        this.rdbtnNewestFirst.setFont(new Font("Arial", 0, 18));
        this.rdbtnNewestFirst.setBounds(935, 128, 158, 23);
        this.frmTest.getContentPane().add(this.rdbtnNewestFirst);
        this.rdbtnOldestFirst.setFont(new Font("Arial", 0, 18));
        this.rdbtnOldestFirst.setBounds(935, 156, 158, 23);
        this.frmTest.getContentPane().add(this.rdbtnOldestFirst);
        Label label_7 = new Label("Made\r\n by /u/itchylol742");
        label_7.setForeground(Color.GRAY);
        label_7.setFont(new Font("Arial", 0, 15));
        label_7.setBounds(1197, 855, 158, 23);
        this.frmTest.getContentPane().add(label_7);
        JTextArea txtrLeave = new JTextArea();
        txtrLeave.setForeground(Color.GRAY);
        txtrLeave.setFont(new Font("Arial", 0, 15));
        txtrLeave.setBackground(SystemColor.menu);
        txtrLeave.setEditable(false);
        txtrLeave.setText("Leave fields empty for \r\nno limit/filter");
        txtrLeave.setBounds(1197, 654, 164, 54);
        this.frmTest.getContentPane().add(txtrLeave);
        FimArchiveSearchGUIBackup.loadSettings();
        FimArchiveSearchGUIBackup.goodPrint("- Instructions:\n");
        FimArchiveSearchGUIBackup.goodPrint("- Tags are not case sensitive. Type in proper caps, no caps, or all caps if you want\n");
        FimArchiveSearchGUIBackup.goodPrint("\n");
        FimArchiveSearchGUIBackup.goodPrint("- Notes:\n");
        FimArchiveSearchGUIBackup.goodPrint("- Some stories have -1 likes due to metadata error, so even setting min likes to 0 will filter them out\n");
        FimArchiveSearchGUIBackup.goodPrint("- Some stories have 0 (or very low number) words due to metadata error...?,\n");
        FimArchiveSearchGUIBackup.goodPrint("    - Or maybe somehow those short stories got on the site\n");
        FimArchiveSearchGUIBackup.goodPrint("- Dates are in format YYYY/MM/DD\n");
        FimArchiveSearchGUIBackup.goodPrint("- Limited to 5 good tags and 5 bad tags. Hardcoded\n");
    }

    public static void goodPrint(String theString) {
        textArea.append(theString);
    }

    public static void saveSettings() {
        String filename = "settings.txt";
        goodTags.clear();
        badTags.clear();
        FimArchiveSearchGUIBackup.readTextBoxesIntoMemory();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("5 good tags then 5 bad tags. Hardcoded");
            out.newLine();
            int i = 0;
            while (i < 5) {
                out.write("GOOD");
                if (i < goodTags.size()) {
                    out.write(goodTags.get(i));
                }
                out.newLine();
                ++i;
            }
            i = 5;
            while (i < 10) {
                out.write("BAD ");
                if (i - 5 < badTags.size()) {
                    out.write(badTags.get(i - 5));
                }
                out.newLine();
                ++i;
            }
            out.write("Sort by:");
            out.newLine();
            if (views.isSelected()) {
                out.write("views");
                out.newLine();
            } else if (likes.isSelected()) {
                out.write("likes");
                out.newLine();
            } else if (words.isSelected()) {
                out.write("words");
                out.newLine();
            } else {
                out.write("default");
                out.newLine();
            }
            out.write("Min likes, min words, and max words");
            out.newLine();
            out.write(minLikesText.getText());
            out.newLine();
            out.write(minWordsText.getText());
            out.newLine();
            out.write(maxWordsText.getText());
            out.newLine();
            out.write("Completed stories only? y/n");
            out.newLine();
            if (completedOnlyCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadSettings() {
        String filename = "settings.txt";
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(filename));
            line = br.readLine();
            int i = 0;
            while (i < 10) {
                line = br.readLine();
                if (line.length() > 3) {
                    textAreasArrayList.get(i).setText(line.substring(4));
                }
                ++i;
            }
            line = br.readLine();
            line = br.readLine();
            if (line.equals("likes")) {
                likes.setSelected(true);
            } else if (line.equals("views")) {
                views.setSelected(true);
            } else if (line.equals("words")) {
                words.setSelected(true);
            }
            line = br.readLine();
            line = br.readLine();
            minLikesText.setText(line);
            line = br.readLine();
            minWordsText.setText(line);
            line = br.readLine();
            maxWordsText.setText(line);
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                completedOnlyCheckbox.setState(true);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readTextBoxesIntoMemory() {
        if (goodTag1.getText().length() > 1) {
            goodTags.add(goodTag1.getText().trim());
        }
        if (goodTag2.getText().length() > 1) {
            goodTags.add(goodTag2.getText().trim());
        }
        if (goodTag3.getText().length() > 1) {
            goodTags.add(goodTag3.getText().trim());
        }
        if (goodTag4.getText().length() > 1) {
            goodTags.add(goodTag4.getText().trim());
        }
        if (goodTag5.getText().length() > 1) {
            goodTags.add(goodTag5.getText().trim());
        }
        if (badTag1.getText().length() > 1) {
            badTags.add(badTag1.getText().trim());
        }
        if (badTag2.getText().length() > 1) {
            badTags.add(badTag2.getText().trim());
        }
        if (badTag3.getText().length() > 1) {
            badTags.add(badTag3.getText().trim());
        }
        if (badTag4.getText().length() > 1) {
            badTags.add(badTag4.getText().trim());
        }
        if (badTag5.getText().length() > 1) {
            badTags.add(badTag5.getText().trim());
        }
        if (minLikesText.getText().length() > 0) {
            minLikesInt = Integer.parseInt(minLikesText.getText());
        }
        if (minWordsText.getText().length() > 0) {
            minWordsInt = Integer.parseInt(minWordsText.getText());
        }
        if (maxWordsText.getText().length() > 0) {
            maxWordsInt = Integer.parseInt(maxWordsText.getText());
        }
    }

    public static void updateTextArea() throws ParseException {
        FimArchiveSearchGUIBackup.saveSettings();
        minLikesInt = -1;
        minWordsInt = -1;
        maxWordsInt = -1;
        textArea.setText("");
        goodTags.clear();
        badTags.clear();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        arrayOfUselessProperties.clear();
        arrayOfUselessProperties.add("archive");
        arrayOfUselessProperties.add("avatar");
        arrayOfUselessProperties.add("color");
        arrayOfUselessProperties.add("cover_image");
        arrayOfUselessProperties.add("chapters");
        try {
            String name = "default";
            FimArchiveSearchGUIBackup.readTextBoxesIntoMemory();
            JsonReader reader = new JsonReader(new FileReader("index.json"));
            block15: while (true) {
                JsonToken token = reader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        reader.beginArray();
                        ++indents;
                        continue block15;
                    }
                    case END_ARRAY: {
                        --indents;
                        reader.endArray();
                        continue block15;
                    }
                    case BEGIN_OBJECT: {
                        ++indents;
                        reader.beginObject();
                        continue block15;
                    }
                    case END_OBJECT: {
                        if (--indents == 1) {
                            int i;
                            if (completedOnlyCheckbox.getState() && !FimArchiveSearchGUIBackup.temp.completionStatus.equals("complete")) {
                                stillGood = false;
                            }
                            if (minLikesInt != -1 && stillGood && FimArchiveSearchGUIBackup.temp.likes < minLikesInt) {
                                stillGood = false;
                            }
                            if (minWordsInt != -1 && stillGood && FimArchiveSearchGUIBackup.temp.words < minWordsInt) {
                                stillGood = false;
                            }
                            if (maxWordsInt != -1 && stillGood && FimArchiveSearchGUIBackup.temp.words > maxWordsInt) {
                                stillGood = false;
                            }
                            if (stillGood) {
                                i = 0;
                                while (i < FimArchiveSearchGUIBackup.temp.tags.size()) {
                                    FimArchiveSearchGUIBackup.temp.tags.set(i, FimArchiveSearchGUIBackup.temp.tags.get(i).toLowerCase());
                                    ++i;
                                }
                                i = 0;
                                while (i < goodTags.size()) {
                                    if (!FimArchiveSearchGUIBackup.temp.tags.contains(goodTags.get(i).toLowerCase())) {
                                        stillGood = false;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (stillGood) {
                                i = 0;
                                while (i < badTags.size()) {
                                    if (FimArchiveSearchGUIBackup.temp.tags.contains(badTags.get(i).toLowerCase())) {
                                        stillGood = false;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (stillGood) {
                                resultsArray.add(temp);
                            }
                            if (numberOfStoriesScanned % updateInterval == 0) {
                                FimArchiveSearchGUIBackup.goodPrint("searching " + numberOfStoriesScanned + ", " + resultsArray.size() + " good stories\n");
                            }
                            temp = new FimfictionStory();
                            stillGood = true;
                        }
                        reader.endObject();
                        continue block15;
                    }
                    case NAME: {
                        if (indents == 1) {
                            ++numberOfStoriesScanned;
                        }
                        if (!arrayOfUselessProperties.contains(name = reader.nextName())) continue block15;
                        reader.skipValue();
                        continue block15;
                    }
                    case STRING: {
                        String s = reader.nextString();
                        if (indents == 4 && name.equals("name")) {
                            FimArchiveSearchGUIBackup.temp.tags.add(s);
                            continue block15;
                        }
                        if (indents == 2 && name.equals("title")) {
                            FimArchiveSearchGUIBackup.temp.title = s;
                            continue block15;
                        }
                        if (indents == 2 && name.equals("date_published")) {
                            FimArchiveSearchGUIBackup.temp.datePublishedString = s.substring(0, 10).replace('-', '/');
                            FimArchiveSearchGUIBackup.temp.datePublishedObject = formatter.parse(s.substring(0, 10).replace('-', '/'));
                            continue block15;
                        }
                        if (indents == 3 && name.equals("name")) {
                            FimArchiveSearchGUIBackup.temp.author = s;
                            continue block15;
                        }
                        if (name.equals("completion_status")) {
                            FimArchiveSearchGUIBackup.temp.completionStatus = s;
                            continue block15;
                        }
                        if (!name.equals("description_html")) continue block15;
                        FimArchiveSearchGUIBackup.temp.description = s;
                        continue block15;
                    }
                    case NUMBER: {
                        int n = reader.nextInt();
                        if (name.equals("num_likes")) {
                            FimArchiveSearchGUIBackup.temp.likes = n;
                            continue block15;
                        }
                        if (name.equals("num_dislikes")) {
                            FimArchiveSearchGUIBackup.temp.dislikes = n;
                            continue block15;
                        }
                        if (name.equals("num_views")) {
                            FimArchiveSearchGUIBackup.temp.views = n;
                            continue block15;
                        }
                        if (indents == 2 && name.equals("num_words")) {
                            FimArchiveSearchGUIBackup.temp.words = n;
                            continue block15;
                        }
                        if (!name.equals("prequel")) continue block15;
                        FimArchiveSearchGUIBackup.temp.prequelID = n;
                        continue block15;
                    }
                    case BOOLEAN: {
                        reader.nextBoolean();
                        continue block15;
                    }
                    case NULL: {
                        reader.nextNull();
                        continue block15;
                    }
                    case END_DOCUMENT: {
                        if (views.isSelected()) {
                            Collections.sort(resultsArray, FimfictionStory.ViewsComparator);
                        } else if (likes.isSelected()) {
                            Collections.sort(resultsArray, FimfictionStory.LikesComparator);
                        } else if (words.isSelected()) {
                            Collections.sort(resultsArray, FimfictionStory.WordsComparator);
                        }
                        boolean tooManyResults = false;
                        String storyInfo = "";
                        int i = 0;
                        while (i < resultsArray.size()) {
                            storyInfo = String.valueOf(storyInfo) + "Title: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).title + "\n";
                            storyInfo = String.valueOf(storyInfo) + "Author: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).author + "\n";
                            resultsArray.get(i).removeHtmlFormattingFromDescription();
                            storyInfo = String.valueOf(storyInfo) + "Description: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).description + "\n";
                            if (FimArchiveSearchGUIBackup.resultsArray.get((int)i).prequelID != -1) {
                                storyInfo = String.valueOf(storyInfo) + "Prequel ID: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).prequelID + "\n";
                            }
                            storyInfo = String.valueOf(storyInfo) + "Date Published: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).datePublishedString + "\n";
                            storyInfo = String.valueOf(storyInfo) + "Likes: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).likes;
                            storyInfo = String.valueOf(storyInfo) + ", Dislikes: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).dislikes + "\n";
                            storyInfo = String.valueOf(storyInfo) + "Views: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).views + "\n";
                            storyInfo = String.valueOf(storyInfo) + "Tags: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).tags + "\n";
                            storyInfo = String.valueOf(storyInfo) + "Word Count: " + FimArchiveSearchGUIBackup.resultsArray.get((int)i).words + "\n";
                            storyInfo = String.valueOf(storyInfo) + "\n";
                            if (i % 10 == 0) {
                                FimArchiveSearchGUIBackup.goodPrint(storyInfo);
                                storyInfo = "";
                            }
                            if (i > maxNumberOfResultsShown) {
                                tooManyResults = true;
                                FimArchiveSearchGUIBackup.goodPrint(storyInfo);
                                storyInfo = "";
                                break;
                            }
                            ++i;
                        }
                        FimArchiveSearchGUIBackup.goodPrint(storyInfo);
                        storyInfo = "";
                        if (tooManyResults) {
                            FimArchiveSearchGUIBackup.goodPrint("--Too many results, only showing " + maxNumberOfResultsShown + " to avoid lag\n");
                        }
                        FimArchiveSearchGUIBackup.goodPrint("--End of scanning--\n");
                        FimArchiveSearchGUIBackup.goodPrint("--Total stories scanned: " + numberOfStoriesScanned + "--\n");
                        FimArchiveSearchGUIBackup.goodPrint("--Results: " + resultsArray.size() + "--\n");
                        if (views.isSelected()) {
                            FimArchiveSearchGUIBackup.goodPrint("--Sorting by views--\n");
                        } else if (likes.isSelected()) {
                            FimArchiveSearchGUIBackup.goodPrint("--Sorting by likes--\n");
                        } else if (words.isSelected()) {
                            FimArchiveSearchGUIBackup.goodPrint("--Sorting by words--\n");
                        }
                        resultsArray.clear();
                        numberOfStoriesScanned = 0;
                        reader.close();
                        return;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

