/*
 * Decompiled with CFR 0.152.
 */
package package1;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.NumericUtils;
import package1.FimfictionStory;

public class FimArchiveSearchGUI {
    static boolean useSampleIndex = false;
    static String endOfLine = System.lineSeparator();
    static String endOfField = ", ";
    static ArrayList<FimfictionStory> inputStoriesFromSerializableArray = new ArrayList();
    static ArrayList<FimfictionStory> resultsArray = new ArrayList();
    static ArrayList<String> arrayOfUselessProperties = new ArrayList();
    static ArrayList<String> goodTags = new ArrayList();
    static ArrayList<String> badTags = new ArrayList();
    static String titleContainsString = "";
    static String descriptionContainsString = "";
    static int indents = 0;
    static int numberOfStoriesScanned = 0;
    static boolean tooManyResults = false;
    static FimfictionStory temp = new FimfictionStory();
    static int minLikesInt = -1;
    static int minWordsInt = -1;
    static int maxWordsInt = -1;
    static float minPercentageRatingFloat = -1.0f;
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
    static final int maxNumberOfResultsShown = 5000;
    static final int updateInterval = 2500;
    static final int descriptionMaxLineLength = 120;
    static long startTimeMilliseconds = 0L;
    static DecimalFormat df = new DecimalFormat();
    private JFrame frmTest;
    static TextField goodTag1 = new TextField();
    static TextField goodTag2 = new TextField();
    static TextField goodTag3 = new TextField();
    static TextField goodTag4 = new TextField();
    static TextField goodTag5 = new TextField();
    static TextField badTag1 = new TextField();
    static TextField badTag2 = new TextField();
    static TextField badTag3 = new TextField();
    static TextField badTag4 = new TextField();
    static TextField badTag5 = new TextField();
    static TextField titleContainsTextBox = new TextField();
    static TextField descriptionContainsTextBox = new TextField();
    static TextField authorTextField = new TextField();
    static ArrayList<TextField> textAreasArrayList = new ArrayList();
    static TextArea textArea = new TextArea();
    static JRadioButton viewsRadioButton = new JRadioButton("Views");
    static JRadioButton likesRadioButton = new JRadioButton("Likes");
    static JRadioButton percentRatingRadioButton = new JRadioButton("Percent Rating");
    static JRadioButton wordsRadioButton = new JRadioButton("Words");
    static JRadioButton newestFirstRadioButton = new JRadioButton("Newest First");
    static JRadioButton oldestFirstRadioButton = new JRadioButton("Oldest First");
    static Checkbox completedOnlyCheckbox = new Checkbox("Completed stories only");
    static Checkbox writeResultsCheckbox = new Checkbox();
    static Checkbox useSubsetCheckbox = new Checkbox();
    static Checkbox LimitResultsCheckbox = new Checkbox();
    private ButtonGroup searchByRadioButtons = new ButtonGroup();
    static TextField minLikesText = new TextField();
    static TextField minWordsText = new TextField();
    static TextField maxWordsText = new TextField();
    static TextField minPercentRatingTextBox = new TextField();
    static TextField latestAllowedPublishDate = new TextField();
    static TextField earliestAllowedPublishDate = new TextField();
    private final Label label_3 = new Label("Minimum Likes");
    private final Label label_4 = new Label("Minimum Words");
    private final Label label_5 = new Label("Maximum Words");
    private final Label label_6 = new Label("YYYY/MM/DD");
    private final Label label_8 = new Label("Published after/on");
    private final Label label_9 = new Label("Published before/on");
    private final JPanel panel = new JPanel();
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private final JPanel panel_1 = new JPanel();
    private final JTextArea txtrMadeByuitchylol = new JTextArea();
    private final Label label_12 = new Label("Description Contains");
    private final JPanel panel_3 = new JPanel();
    private final JPanel panel_4 = new JPanel();
    private final JPanel panel_5 = new JPanel();
    private final JPanel numberFilters = new JPanel();
    private final JPanel wordFilters = new JPanel();
    private final JLabel lblPrequelifThere = new JLabel("Prequel (if there is one)");
    private final JLabel lblTheStoryLooking = new JLabel("The story in question");
    private final JLabel lblSequelsIfThere = new JLabel("Sequel(s) if there is/are any");
    private static final TextField IDfield = new TextField();
    private static final TextArea sequels = new TextArea();
    private static final TextArea prequel = new TextArea();
    private static final JTextField siq = new JTextField();
    private static final Label label_14 = new Label("Author Name");

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FimArchiveSearchGUI window = new FimArchiveSearchGUI();
                    window.frmTest.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public FimArchiveSearchGUI() {
        this.initialize();
    }

    private void initialize() {
        siq.setFont(new Font("Arial", 0, 20));
        siq.setColumns(10);
        arrayOfUselessProperties.clear();
        arrayOfUselessProperties.add("archive");
        arrayOfUselessProperties.add("avatar");
        arrayOfUselessProperties.add("color");
        arrayOfUselessProperties.add("cover_image");
        arrayOfUselessProperties.add("chapters");
        this.frmTest = new JFrame();
        this.frmTest.setTitle("Fimarchive Searcher 1.01 by itchylol742");
        this.frmTest.setBounds(150, 25, 1394, 953);
        this.frmTest.setDefaultCloseOperation(3);
        this.frmTest.getContentPane().setLayout(new BorderLayout(0, 0));
        this.tabbedPane.setToolTipText("");
        this.tabbedPane.setForeground(Color.BLACK);
        this.tabbedPane.setFont(new Font("Arial", 0, 18));
        this.frmTest.getContentPane().add(this.tabbedPane);
        this.tabbedPane.addTab("Search", null, this.panel, null);
        this.tabbedPane.setEnabledAt(0, true);
        this.panel.setBackground(SystemColor.menu);
        this.panel.setLayout(new MigLayout("", "[80%,fill][20%,fill]", "[34%,fill][1%,fill][65%,fill]"));
        textArea = new TextArea();
        textArea.setFont(new Font("Arial", 0, 20));
        this.panel.add((Component)textArea, "cell 0 2,grow");
        this.panel.add((Component)this.numberFilters, "cell 1 0 1 3,grow");
        this.numberFilters.setLayout(new BoxLayout(this.numberFilters, 1));
        this.numberFilters.add(this.label_3);
        this.label_3.setFont(new Font("Arial", 0, 30));
        this.numberFilters.add(minLikesText);
        minLikesText.setFont(new Font("Arial", 0, 20));
        minLikesText.setText("10");
        Label label_7 = new Label("Minimum % Rating");
        this.numberFilters.add(label_7);
        label_7.setFont(new Font("Arial", 0, 30));
        Label label_13 = new Label("Decimals allowed for % rating");
        this.numberFilters.add(label_13);
        label_13.setForeground(Color.GRAY);
        label_13.setFont(new Font("Arial", 0, 20));
        this.numberFilters.add(minPercentRatingTextBox);
        minPercentRatingTextBox.setText("60");
        minPercentRatingTextBox.setFont(new Font("Arial", 0, 20));
        this.numberFilters.add(this.label_4);
        this.label_4.setFont(new Font("Arial", 0, 30));
        this.numberFilters.add(minWordsText);
        minWordsText.setText("10");
        minWordsText.setFont(new Font("Arial", 0, 20));
        this.numberFilters.add(this.label_5);
        this.label_5.setFont(new Font("Arial", 0, 30));
        this.numberFilters.add(maxWordsText);
        maxWordsText.setText("10");
        maxWordsText.setFont(new Font("Arial", 0, 20));
        this.numberFilters.add(this.label_8);
        this.label_8.setFont(new Font("Arial", 0, 30));
        this.numberFilters.add(earliestAllowedPublishDate);
        earliestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        this.numberFilters.add(this.label_6);
        this.label_6.setForeground(Color.GRAY);
        this.label_6.setFont(new Font("Arial", 0, 20));
        this.numberFilters.add(this.label_9);
        this.label_9.setFont(new Font("Arial", 0, 30));
        this.numberFilters.add(latestAllowedPublishDate);
        latestAllowedPublishDate.setFont(new Font("Arial", 0, 21));
        this.numberFilters.add(completedOnlyCheckbox);
        completedOnlyCheckbox.setFont(new Font("Arial", 0, 23));
        this.numberFilters.add(LimitResultsCheckbox);
        LimitResultsCheckbox.setLabel("Limit 5000 results (avoid lag)");
        LimitResultsCheckbox.setFont(new Font("Arial", 0, 23));
        this.numberFilters.add(writeResultsCheckbox);
        writeResultsCheckbox.setLabel("Write results to file");
        writeResultsCheckbox.setFont(new Font("Arial", 0, 23));
        this.numberFilters.add(useSubsetCheckbox);
        useSubsetCheckbox.setLabel("Done Lucene setup");
        useSubsetCheckbox.setFont(new Font("Arial", 0, 23));
        JTextArea txtrLeave = new JTextArea();
        this.numberFilters.add(txtrLeave);
        txtrLeave.setForeground(Color.GRAY);
        txtrLeave.setFont(new Font("Arial", 0, 20));
        txtrLeave.setBackground(SystemColor.menu);
        txtrLeave.setEditable(false);
        txtrLeave.setText("Leave fields empty for \r\nno limit/filter");
        this.numberFilters.add(this.txtrMadeByuitchylol);
        this.txtrMadeByuitchylol.setText("Made by itchylol742");
        this.txtrMadeByuitchylol.setForeground(Color.GRAY);
        this.txtrMadeByuitchylol.setFont(new Font("Arial", 0, 20));
        this.txtrMadeByuitchylol.setEditable(false);
        this.txtrMadeByuitchylol.setBackground(SystemColor.menu);
        this.panel.add((Component)this.wordFilters, "cell 0 0");
        this.wordFilters.setLayout(new BoxLayout(this.wordFilters, 0));
        JPanel panel_2 = new JPanel();
        this.wordFilters.add(panel_2);
        panel_2.setLayout(new BoxLayout(panel_2, 1));
        Label label_1 = new Label("Good Tags");
        panel_2.add(label_1);
        label_1.setFont(new Font("Arial", 0, 30));
        panel_2.add(goodTag1);
        goodTag1.setFont(new Font("Arial", 0, 21));
        panel_2.add(goodTag2);
        goodTag2.setFont(new Font("Arial", 0, 21));
        panel_2.add(goodTag3);
        goodTag3.setFont(new Font("Arial", 0, 21));
        panel_2.add(goodTag4);
        goodTag4.setFont(new Font("Arial", 0, 21));
        panel_2.add(goodTag5);
        goodTag5.setFont(new Font("Arial", 0, 21));
        this.wordFilters.add(this.panel_3);
        this.panel_3.setLayout(new BoxLayout(this.panel_3, 1));
        Label label_2 = new Label("Bad Tags ");
        this.panel_3.add(label_2);
        label_2.setFont(new Font("Arial", 0, 30));
        this.panel_3.add(badTag1);
        badTag1.setFont(new Font("Arial", 0, 21));
        this.panel_3.add(badTag2);
        badTag2.setFont(new Font("Arial", 0, 21));
        this.panel_3.add(badTag3);
        badTag3.setFont(new Font("Arial", 0, 21));
        this.panel_3.add(badTag4);
        badTag4.setFont(new Font("Arial", 0, 21));
        this.panel_3.add(badTag5);
        badTag5.setFont(new Font("Arial", 0, 21));
        this.wordFilters.add(this.panel_4);
        this.panel_4.setLayout(new BoxLayout(this.panel_4, 1));
        Label label_11 = new Label("Title Contains");
        this.panel_4.add(label_11);
        label_11.setFont(new Font("Arial", 0, 30));
        this.panel_4.add(titleContainsTextBox);
        titleContainsTextBox.setFont(new Font("Arial", 0, 21));
        this.panel_4.add(this.label_12);
        this.label_12.setFont(new Font("Arial", 0, 30));
        this.panel_4.add(descriptionContainsTextBox);
        descriptionContainsTextBox.setText("<dynamic");
        descriptionContainsTextBox.setFont(new Font("Arial", 0, 21));
        label_14.setFont(new Font("Arial", 0, 30));
        this.panel_4.add(label_14);
        authorTextField.setFont(new Font("Arial", 0, 21));
        this.panel_4.add(authorTextField);
        Button button = new Button("Search");
        this.panel_4.add(button);
        button.setFont(new Font("Arial", 0, 46));
        this.wordFilters.add(this.panel_5);
        this.panel_5.setLayout(new BoxLayout(this.panel_5, 1));
        Label label = new Label("Sort By");
        label.setAlignment(1);
        this.panel_5.add(label);
        label.setFont(new Font("Arial", 0, 30));
        this.panel_5.add(viewsRadioButton);
        viewsRadioButton.setFont(new Font("Arial", 0, 24));
        this.searchByRadioButtons.add(viewsRadioButton);
        this.panel_5.add(likesRadioButton);
        likesRadioButton.setFont(new Font("Arial", 0, 24));
        this.searchByRadioButtons.add(likesRadioButton);
        this.searchByRadioButtons.add(percentRatingRadioButton);
        this.panel_5.add(percentRatingRadioButton);
        percentRatingRadioButton.setFont(new Font("Arial", 0, 24));
        this.panel_5.add(wordsRadioButton);
        wordsRadioButton.setFont(new Font("Arial", 0, 24));
        this.searchByRadioButtons.add(wordsRadioButton);
        this.searchByRadioButtons.add(newestFirstRadioButton);
        this.panel_5.add(newestFirstRadioButton);
        newestFirstRadioButton.setFont(new Font("Arial", 0, 24));
        this.searchByRadioButtons.add(oldestFirstRadioButton);
        this.panel_5.add(oldestFirstRadioButton);
        oldestFirstRadioButton.setFont(new Font("Arial", 0, 24));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (useSubsetCheckbox.getState()) {
                        FimArchiveSearchGUI.updateTextAreaFromLuceneIndex();
                    } else {
                        FimArchiveSearchGUI.createOptimizedIndex();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.tabbedPane.addTab("Sequel/Prequel finder", null, this.panel_1, null);
        this.tabbedPane.setEnabledAt(1, true);
        this.panel_1.setLayout(new MigLayout("", "[40%,grow,fill][40%,fill][20%,grow,fill]", "[7%,fill][4.71%,fill][2%,fill][25%,grow,fill][10%,fill][25%,fill]"));
        Label label_10 = new Label("Story ID");
        label_10.setAlignment(1);
        label_10.setFont(new Font("Arial", 0, 20));
        this.panel_1.add((Component)label_10, "cell 0 0,grow");
        JTextArea txtrEnterTheStory = new JTextArea();
        txtrEnterTheStory.setText("Enter the story ID of a story, and it will find any sequels and prequels the story has.\r\nA story can only have maximum 1 prequel, but it can have any number of sequels. ");
        txtrEnterTheStory.setForeground(Color.GRAY);
        txtrEnterTheStory.setFont(new Font("Arial", 0, 20));
        txtrEnterTheStory.setEditable(false);
        txtrEnterTheStory.setBackground(SystemColor.menu);
        this.panel_1.add((Component)txtrEnterTheStory, "cell 1 0 2 1");
        IDfield.setFont(new Font("Arial", 0, 20));
        this.panel_1.add((Component)IDfield, "cell 0 1");
        Button button_1 = new Button("Find sequels/prequels");
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    FimArchiveSearchGUI.updatePrequelAndSequels();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        button_1.setFont(new Font("Arial", 0, 20));
        this.panel_1.add((Component)button_1, "cell 1 1,alignx left,growy");
        prequel.setRows(5);
        prequel.setFont(new Font("Arial", 0, 20));
        this.panel_1.add((Component)prequel, "cell 0 3 2 1");
        this.lblPrequelifThere.setFont(new Font("Tahoma", 0, 24));
        this.lblPrequelifThere.setHorizontalAlignment(0);
        this.panel_1.add((Component)this.lblPrequelifThere, "cell 2 3");
        this.panel_1.add((Component)siq, "cell 0 4 2 1,growx");
        this.lblTheStoryLooking.setHorizontalAlignment(0);
        this.lblTheStoryLooking.setFont(new Font("Tahoma", 0, 24));
        this.panel_1.add((Component)this.lblTheStoryLooking, "cell 2 4");
        sequels.setFont(new Font("Arial", 0, 20));
        this.panel_1.add((Component)sequels, "cell 0 5 2 1");
        this.lblSequelsIfThere.setHorizontalAlignment(0);
        this.lblSequelsIfThere.setFont(new Font("Tahoma", 0, 24));
        this.panel_1.add((Component)this.lblSequelsIfThere, "cell 2 5");
        FimArchiveSearchGUI.loadTagTextAreasIntoTagTestAreasArrayList();
        FimArchiveSearchGUI.loadSettings();
        FimArchiveSearchGUI.goodPrint("IMPORTANT! If this is your first time running the program, have Done Lucene setup UNCHECKED" + endOfLine);
        FimArchiveSearchGUI.goodPrint("This will created the Lucene index from information found in index.json" + endOfLine);
        FimArchiveSearchGUI.goodPrint("After that, run the program with Done Lucene setup checked" + endOfLine);
        FimArchiveSearchGUI.goodPrint(endOfLine);
        FimArchiveSearchGUI.goodPrint("- Nothing is case sensitive. Type in proper caps, no caps, or all caps if you want" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Some stories have -1 likes due to metadata error, so even setting min likes to 0 will filter them out" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Some stories have 0 (or very low number) words due to metadata error...?," + endOfLine);
        FimArchiveSearchGUI.goodPrint("    - Or maybe somehow those short stories got on the site" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Percentage rating assumes there's 1 more like and 1 more dislike than there actually is" + endOfLine);
        FimArchiveSearchGUI.goodPrint("    - So stories with few ratings don't get perfect score" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Dates are in the format YYYY/MM/DD" + endOfLine);
        FimArchiveSearchGUI.goodPrint("    - 0's before the month and day are REQUIRED if it's less than 10" + endOfLine);
        FimArchiveSearchGUI.goodPrint("    - For exmaple, 2015/02/03 is valid, but 2015/2/3 is invalid" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Some stories have unknown publish dates. They are classified" + endOfLine);
        FimArchiveSearchGUI.goodPrint("  as published in the year 1900" + endOfLine);
        FimArchiveSearchGUI.goodPrint("- Content ratings are classified as tags, and are filtered in the same way" + endOfLine);
    }

    public static void updatePrequelAndSequels() throws IOException, ParseException, java.text.ParseException {
        Document d;
        int i;
        FimArchiveSearchGUI.readTextBoxesIntoMemory();
        FimArchiveSearchGUI.saveSettings();
        prequel.setText("");
        siq.setText("");
        sequels.setText("");
        if (IDfield.getText().length() == 0) {
            FimArchiveSearchGUI.goodPrint("ID is required", 1);
            return;
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        String SRC_FOLDER = "theLuceneIAAndex";
        FSDirectory index = FSDirectory.open(Paths.get(SRC_FOLDER, new String[0]));
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        IndexWriter w = new IndexWriter(index, config);
        if (!FimArchiveSearchGUI.isThisStringAnInteger(IDfield.getText())) {
            FimArchiveSearchGUI.goodPrint("ID must be a number", 1);
            w.close();
            return;
        }
        int theIDToLookFor = Integer.parseInt(IDfield.getText());
        Query idQuery = IntPoint.newExactQuery("ID", theIDToLookFor);
        w.close();
        int hitsPerPage = 999999;
        DirectoryReader reader1 = DirectoryReader.open(index);
        IndexSearcher searcher = new IndexSearcher(reader1);
        Sort sort = new Sort((SortField)new SortedNumericSortField("datePublishedInt", SortField.Type.LONG, false));
        TopFieldDocs docs = searcher.search(idQuery, hitsPerPage, sort, true, true);
        ScoreDoc[] hits = docs.scoreDocs;
        if (hits.length == 0) {
            FimArchiveSearchGUI.goodPrint("There is no story with ID " + theIDToLookFor, 2);
            return;
        }
        int prequelId = -1;
        StringBuilder stringBuilder = new StringBuilder("");
        int i2 = 0;
        while (i2 < hits.length) {
            int docId = hits[i2].doc;
            Document d2 = searcher.doc(docId);
            stringBuilder.append(String.valueOf(d2.get("title")) + endOfField);
            stringBuilder.append(" by " + d2.get("author"));
            if (Integer.parseInt(d2.get("prequelID")) != -1) {
                prequelId = Integer.parseInt(d2.get("prequelID"));
            } else {
                FimArchiveSearchGUI.goodPrint("The story in question has no prequel", 1);
            }
            ++i2;
        }
        FimArchiveSearchGUI.goodPrint(stringBuilder.toString(), 2);
        if (prequelId > 0) {
            Query prequelQuery = IntPoint.newExactQuery("ID", prequelId);
            docs = searcher.search(prequelQuery, hitsPerPage, sort, true, true);
            hits = docs.scoreDocs;
            stringBuilder = new StringBuilder("");
            i = 0;
            while (i < hits.length) {
                int docId = hits[i].doc;
                d = searcher.doc(docId);
                stringBuilder.append("--Story Title: " + d.get("title") + endOfField);
                stringBuilder.append("Author: " + d.get("author") + endOfField);
                stringBuilder.append("ID: " + d.get("ID") + endOfLine);
                if (Integer.parseInt(d.get("prequelID")) != -1) {
                    stringBuilder.append("-This story has a prequel. ID of prequel: " + d.get("prequelID") + endOfLine);
                    prequelId = Integer.parseInt(d.get("prequelID"));
                }
                stringBuilder.append("Description: " + d.get("description") + endOfLine);
                stringBuilder.append("Date Published: " + d.get("datePublishedString") + endOfField);
                stringBuilder.append("Completion Status: " + d.get("completionStatus") + endOfLine);
                stringBuilder.append("Likes: " + d.get("likes") + endOfField);
                stringBuilder.append("Dislikes: " + d.get("dislikes") + endOfField);
                stringBuilder.append("Percent Rating: " + d.get("percentRating") + endOfField);
                stringBuilder.append("Views: " + d.get("views") + endOfField);
                stringBuilder.append("Word Count: " + d.get("words") + endOfLine);
                stringBuilder.append("Content Rating: " + d.get("contentRating") + endOfLine);
                stringBuilder.append("Tags: " + Arrays.asList(d.get("tagsString").split(",")) + endOfLine);
                stringBuilder.append(endOfLine);
                ++i;
            }
            FimArchiveSearchGUI.goodPrint(stringBuilder.toString(), 1);
        }
        Query sequelQuery = IntPoint.newExactQuery("prequelID", theIDToLookFor);
        docs = searcher.search(sequelQuery, hitsPerPage, sort, true, true);
        hits = docs.scoreDocs;
        stringBuilder = new StringBuilder("");
        i = 0;
        while (i < hits.length) {
            int docId = hits[i].doc;
            d = searcher.doc(docId);
            stringBuilder.append("--Story Title: " + d.get("title") + endOfField);
            stringBuilder.append("Author: " + d.get("author") + endOfField);
            stringBuilder.append("ID: " + d.get("ID") + endOfLine);
            if (Integer.parseInt(d.get("prequelID")) != -1) {
                stringBuilder.append("This story has a prequel (obviously). ID of prequel: " + d.get("prequelID") + endOfLine);
                prequelId = Integer.parseInt(d.get("prequelID"));
            }
            stringBuilder.append("Description: " + d.get("description") + endOfLine);
            stringBuilder.append("Date Published: " + d.get("datePublishedString") + endOfField);
            stringBuilder.append("Completion Status: " + d.get("completionStatus") + endOfLine);
            stringBuilder.append("Likes: " + d.get("likes") + endOfField);
            stringBuilder.append("Dislikes: " + d.get("dislikes") + endOfField);
            stringBuilder.append("Percent Rating: " + d.get("percentRating") + endOfField);
            stringBuilder.append("Views: " + d.get("views") + endOfField);
            stringBuilder.append("Word Count: " + d.get("words") + endOfLine);
            stringBuilder.append("Content Rating: " + d.get("contentRating") + endOfLine);
            stringBuilder.append("Tags: " + Arrays.asList(d.get("tagsString").split(",")) + endOfLine);
            stringBuilder.append(endOfLine);
            ++i;
        }
        stringBuilder.append("Total " + hits.length + " results. ");
        FimArchiveSearchGUI.goodPrint(stringBuilder.toString(), 3);
        if (hits.length == 0) {
            FimArchiveSearchGUI.goodPrint("The story in question has no sequel(s)", 3);
        }
        reader1.close();
    }

    public static void goodPrint(String theString) {
        textArea.append(theString);
    }

    public static void goodPrint(String theString, int whereToPrint) {
        switch (whereToPrint) {
            case 1: {
                prequel.append(theString);
                break;
            }
            case 2: {
                siq.setText(String.valueOf(siq.getText()) + theString);
                break;
            }
            case 3: {
                sequels.append(theString);
            }
        }
    }

    public static void loadTagTextAreasIntoTagTestAreasArrayList() {
        textAreasArrayList.clear();
        textAreasArrayList.add(goodTag1);
        textAreasArrayList.add(goodTag2);
        textAreasArrayList.add(goodTag3);
        textAreasArrayList.add(goodTag4);
        textAreasArrayList.add(goodTag5);
        textAreasArrayList.add(badTag1);
        textAreasArrayList.add(badTag2);
        textAreasArrayList.add(badTag3);
        textAreasArrayList.add(badTag4);
        textAreasArrayList.add(badTag5);
    }

    public static void saveSettings() throws java.text.ParseException {
        String filename = "settings.txt";
        goodTags.clear();
        badTags.clear();
        FimArchiveSearchGUI.readTextBoxesIntoMemory();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("5 good tags then 5 bad tags. Hardcoded");
            out.newLine();
            int i = 0;
            while (i < 5) {
                out.write("GOOD");
                if (i < goodTags.size()) {
                    out.write(goodTags.get(i));
                }
                out.newLine();
                ++i;
            }
            i = 5;
            while (i < 10) {
                out.write("BAD ");
                if (i - 5 < badTags.size()) {
                    out.write(badTags.get(i - 5));
                }
                out.newLine();
                ++i;
            }
            out.write("Sort by:");
            out.newLine();
            if (viewsRadioButton.isSelected()) {
                out.write("views");
                out.newLine();
            } else if (likesRadioButton.isSelected()) {
                out.write("likes");
                out.newLine();
            } else if (percentRatingRadioButton.isSelected()) {
                out.write("percent");
                out.newLine();
            } else if (wordsRadioButton.isSelected()) {
                out.write("words");
                out.newLine();
            } else if (newestFirstRadioButton.isSelected()) {
                out.write("newest");
                out.newLine();
            } else if (oldestFirstRadioButton.isSelected()) {
                out.write("oldest");
                out.newLine();
            } else {
                out.write("default");
                out.newLine();
            }
            out.write("Min likes, min words, max words, min % rating - blank for no filter");
            out.newLine();
            out.write(minLikesText.getText());
            out.newLine();
            out.write(minWordsText.getText());
            out.newLine();
            out.write(maxWordsText.getText());
            out.newLine();
            out.write(minPercentRatingTextBox.getText());
            out.newLine();
            out.write("Completed stories only? y/n");
            out.newLine();
            if (completedOnlyCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("earliest allowed publish date in the format YYYY/MM/DD - blank for no filter");
            out.newLine();
            out.write(earliestAllowedPublishDate.getText());
            out.newLine();
            out.write("latest allowed publish date in the format YYYY/MM/DD - blank for no filter");
            out.newLine();
            out.write(latestAllowedPublishDate.getText());
            out.newLine();
            out.write("Limit to 5000 results? y/n");
            out.newLine();
            if (LimitResultsCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Save results to results.txt? y/n");
            out.newLine();
            if (writeResultsCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Use subset? y/n");
            out.newLine();
            if (useSubsetCheckbox.getState()) {
                out.write("y");
                out.newLine();
            } else {
                out.write("n");
                out.newLine();
            }
            out.write("Title contains:");
            out.newLine();
            out.write(titleContainsTextBox.getText());
            out.newLine();
            out.write("Description contains:");
            out.newLine();
            out.write(descriptionContainsTextBox.getText());
            out.newLine();
            out.write("Author name:");
            out.newLine();
            out.write(authorTextField.getText());
            out.newLine();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadSettings() {
        String filename = "settings.txt";
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(filename));
            line = br.readLine();
            System.out.println(line);
            int i = 0;
            while (i < 10) {
                line = br.readLine();
                System.out.println(String.valueOf(line) + " assign to textAreasArrayList index " + i);
                if (line.length() > 3) {
                    textAreasArrayList.get(i).setText(line.substring(4));
                }
                ++i;
            }
            line = br.readLine();
            System.out.println(line);
            line = br.readLine();
            System.out.println(line);
            if (line.equals("likes")) {
                likesRadioButton.setSelected(true);
            } else if (line.equals("views")) {
                viewsRadioButton.setSelected(true);
            } else if (line.equals("words")) {
                wordsRadioButton.setSelected(true);
            } else if (line.equals("newest")) {
                newestFirstRadioButton.setSelected(true);
            } else if (line.equals("oldest")) {
                oldestFirstRadioButton.setSelected(true);
            } else if (line.equals("percent")) {
                percentRatingRadioButton.setSelected(true);
            }
            line = br.readLine();
            line = br.readLine();
            minLikesText.setText(line);
            line = br.readLine();
            minWordsText.setText(line);
            line = br.readLine();
            maxWordsText.setText(line);
            line = br.readLine();
            minPercentRatingTextBox.setText(line);
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                completedOnlyCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            earliestAllowedPublishDate.setText(line);
            line = br.readLine();
            line = br.readLine();
            latestAllowedPublishDate.setText(line);
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                LimitResultsCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                writeResultsCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            if (line.equals("y")) {
                useSubsetCheckbox.setState(true);
            }
            line = br.readLine();
            line = br.readLine();
            titleContainsTextBox.setText(line);
            line = br.readLine();
            line = br.readLine();
            descriptionContainsTextBox.setText(line);
            line = br.readLine();
            line = br.readLine();
            authorTextField.setText(line);
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readTextBoxesIntoMemory() throws java.text.ParseException {
        goodTags.clear();
        badTags.clear();
        minLikesInt = -1;
        minWordsInt = -1;
        maxWordsInt = -1;
        minPercentageRatingFloat = -1.0f;
        resultsArray.clear();
        descriptionContainsString = "";
        titleContainsString = "";
        if (goodTag1.getText().length() > 1) {
            goodTags.add(goodTag1.getText().trim());
        }
        if (goodTag2.getText().length() > 1) {
            goodTags.add(goodTag2.getText().trim());
        }
        if (goodTag3.getText().length() > 1) {
            goodTags.add(goodTag3.getText().trim());
        }
        if (goodTag4.getText().length() > 1) {
            goodTags.add(goodTag4.getText().trim());
        }
        if (goodTag5.getText().length() > 1) {
            goodTags.add(goodTag5.getText().trim());
        }
        if (badTag1.getText().length() > 1) {
            badTags.add(badTag1.getText().trim());
        }
        if (badTag2.getText().length() > 1) {
            badTags.add(badTag2.getText().trim());
        }
        if (badTag3.getText().length() > 1) {
            badTags.add(badTag3.getText().trim());
        }
        if (badTag4.getText().length() > 1) {
            badTags.add(badTag4.getText().trim());
        }
        if (badTag5.getText().length() > 1) {
            badTags.add(badTag5.getText().trim());
        }
        if (minLikesText.getText().length() > 0) {
            minLikesInt = Integer.parseInt(minLikesText.getText());
        }
        if (minWordsText.getText().length() > 0) {
            minWordsInt = Integer.parseInt(minWordsText.getText());
        }
        if (maxWordsText.getText().length() > 0) {
            maxWordsInt = Integer.parseInt(maxWordsText.getText());
        }
        if (minPercentRatingTextBox.getText().length() > 0) {
            minPercentageRatingFloat = Float.parseFloat(minPercentRatingTextBox.getText());
        }
        if (titleContainsTextBox.getText().length() > 0) {
            titleContainsString = titleContainsTextBox.getText();
        }
        if (descriptionContainsTextBox.getText().length() > 0) {
            descriptionContainsString = descriptionContainsTextBox.getText();
        }
    }

    public static void createOptimizedIndex() throws java.text.ParseException, ParseException {
        df.setMaximumFractionDigits(2);
        startTimeMilliseconds = System.currentTimeMillis();
        FimArchiveSearchGUI.saveSettings();
        numberOfStoriesScanned = 0;
        textArea.setText("");
        goodTags.clear();
        badTags.clear();
        tooManyResults = false;
        try {
            String name = "default";
            FimArchiveSearchGUI.readTextBoxesIntoMemory();
            FimArchiveSearchGUI.goodPrint(" --- Creating Lucene index --- " + endOfLine);
            FimArchiveSearchGUI.goodPrint(" It should take about 45 seconds" + endOfLine);
            FimArchiveSearchGUI.goodPrint(endOfLine);
            JsonReader reader = new JsonReader(new FileReader("index.json"));
            if (useSampleIndex) {
                reader = new JsonReader(new FileReader("sampleIndex.json"));
            }
            StandardAnalyzer analyzer = new StandardAnalyzer();
            boolean createNew = true;
            String SRC_FOLDER = "theLuceneIAAndex";
            if (createNew) {
                File directory = new File(SRC_FOLDER);
                if (!directory.exists()) {
                    System.out.println("Directory does not exist.");
                } else {
                    try {
                        FimArchiveSearchGUI.delete(directory);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
                System.out.println("delete Done");
            }
            FSDirectory index = FSDirectory.open(Paths.get(SRC_FOLDER, new String[0]));
            IndexWriterConfig config = new IndexWriterConfig(analyzer);
            IndexWriter w = new IndexWriter(index, config);
            block17: while (true) {
                JsonToken token = reader.peek();
                switch (token) {
                    case BEGIN_ARRAY: {
                        reader.beginArray();
                        ++indents;
                        continue block17;
                    }
                    case END_ARRAY: {
                        --indents;
                        reader.endArray();
                        continue block17;
                    }
                    case BEGIN_OBJECT: {
                        ++indents;
                        reader.beginObject();
                        continue block17;
                    }
                    case END_OBJECT: {
                        if (--indents == 1) {
                            temp.removeHtmlFormattingFromDescription();
                            FimArchiveSearchGUI.temp.description = FimArchiveSearchGUI.temp.description.substring(0, Math.min(FimArchiveSearchGUI.temp.description.length(), 10000));
                            FimArchiveSearchGUI.addDoc(w, temp);
                            if (numberOfStoriesScanned % 2500 == 0) {
                                FimArchiveSearchGUI.goodPrint("Scanned " + numberOfStoriesScanned + " stories\n");
                            }
                            temp = new FimfictionStory();
                        }
                        reader.endObject();
                        continue block17;
                    }
                    case NAME: {
                        name = reader.nextName();
                        if (indents == 1) {
                            ++numberOfStoriesScanned;
                        }
                        if (!arrayOfUselessProperties.contains(name)) continue block17;
                        reader.skipValue();
                        continue block17;
                    }
                    case STRING: {
                        String s = reader.nextString();
                        if (indents == 4 && name.equals("name")) {
                            FimArchiveSearchGUI.temp.tags.add(s);
                            continue block17;
                        }
                        if (indents == 2 && name.equals("title")) {
                            FimArchiveSearchGUI.temp.title = s;
                            continue block17;
                        }
                        if (indents == 2 && name.equals("date_published")) {
                            FimArchiveSearchGUI.temp.datePublishedString = s.substring(0, 10).replace('-', '/');
                            FimArchiveSearchGUI.temp.datePublishedObject = formatter.parse(FimArchiveSearchGUI.temp.datePublishedString);
                            continue block17;
                        }
                        if (indents == 3 && name.equals("name")) {
                            FimArchiveSearchGUI.temp.author = s;
                            continue block17;
                        }
                        if (name.equals("completion_status")) {
                            FimArchiveSearchGUI.temp.completionStatus = s;
                            continue block17;
                        }
                        if (name.equals("description_html")) {
                            FimArchiveSearchGUI.temp.description = s;
                            continue block17;
                        }
                        if (!name.equals("content_rating")) continue block17;
                        FimArchiveSearchGUI.temp.contentRating = s;
                        FimArchiveSearchGUI.temp.tags.add(s);
                        continue block17;
                    }
                    case NUMBER: {
                        int n = reader.nextInt();
                        if (name.equals("num_likes")) {
                            FimArchiveSearchGUI.temp.likes = n;
                            continue block17;
                        }
                        if (name.equals("num_dislikes")) {
                            FimArchiveSearchGUI.temp.dislikes = n;
                            continue block17;
                        }
                        if (name.equals("num_views")) {
                            FimArchiveSearchGUI.temp.views = n;
                            continue block17;
                        }
                        if (name.equals("num_words") && indents == 2) {
                            FimArchiveSearchGUI.temp.words = n;
                            continue block17;
                        }
                        if (indents == 2 && name.equals("id")) {
                            FimArchiveSearchGUI.temp.ID = n;
                            continue block17;
                        }
                        if (!name.equals("prequel")) continue block17;
                        FimArchiveSearchGUI.temp.prequelID = n;
                        continue block17;
                    }
                    case BOOLEAN: {
                        reader.nextBoolean();
                        continue block17;
                    }
                    case NULL: {
                        reader.nextNull();
                        continue block17;
                    }
                    case END_DOCUMENT: {
                        w.close();
                        FimArchiveSearchGUI.goodPrint("--End of scanning--\n");
                        FimArchiveSearchGUI.goodPrint("--Total stories scanned: " + numberOfStoriesScanned + "--" + endOfLine);
                        if (viewsRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by views--" + endOfLine);
                        } else if (likesRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by likes--" + endOfLine);
                        } else if (wordsRadioButton.isSelected()) {
                            FimArchiveSearchGUI.goodPrint("--Sorting by words--" + endOfLine);
                        }
                        FimArchiveSearchGUI.goodPrint("Creating Lucene Index (takes about 6 seconds). The program will appear to freeze" + endOfLine);
                        FimArchiveSearchGUI.goodPrint("Done creating Lucene Index" + endOfLine);
                        FimArchiveSearchGUI.goodPrint("Now run the program with Done Lucene setup selected");
                        resultsArray.clear();
                        numberOfStoriesScanned = 0;
                        reader.close();
                        return;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateTextAreaFromLuceneIndex() throws IOException, ParseException, java.text.ParseException {
        int latestAllowedPublishDateInt;
        int earliestAllowedPublishDateInt;
        FimArchiveSearchGUI.readTextBoxesIntoMemory();
        FimArchiveSearchGUI.saveSettings();
        textArea.setText("");
        StandardAnalyzer analyzer = new StandardAnalyzer();
        String SRC_FOLDER = "theLuceneIAAndex";
        FSDirectory index = FSDirectory.open(Paths.get(SRC_FOLDER, new String[0]));
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        IndexWriter indexWriter = new IndexWriter(index, config);
        QueryParser qp = new QueryParser("title", analyzer);
        String theString = "";
        theString = String.valueOf(theString) + "filler:abcde";
        if (titleContainsString.length() > 0) {
            titleContainsString = "\"" + titleContainsString + "\"";
            theString = String.valueOf(theString) + " AND title:" + titleContainsString;
        }
        if (descriptionContainsString.length() > 0) {
            descriptionContainsString = "\"" + descriptionContainsString + "\"";
            theString = String.valueOf(theString) + " AND description:" + descriptionContainsString;
        }
        String authorString = authorTextField.getText();
        if (authorTextField.getText().length() > 0) {
            authorString = "\"" + authorString + "\"";
            theString = String.valueOf(theString) + " AND author:" + authorString;
            System.out.println(authorTextField.getText());
            System.out.println(theString);
        }
        int i = 0;
        while (i < goodTags.size()) {
            goodTags.set(i, "\"" + goodTags.get(i) + "\"");
            theString = String.valueOf(theString) + " AND tagsString:" + goodTags.get(i);
            ++i;
        }
        i = 0;
        while (i < badTags.size()) {
            badTags.set(i, "\"" + badTags.get(i) + "\"");
            theString = String.valueOf(theString) + " AND !tagsString:" + badTags.get(i);
            ++i;
        }
        Query minLikesQuery = minLikesInt > -1 ? IntPoint.newRangeQuery("likes", minLikesInt, Integer.MAX_VALUE) : IntPoint.newRangeQuery("likes", Integer.MIN_VALUE, Integer.MAX_VALUE);
        Query minAndMaxWordsQuery = minWordsInt > -1 && maxWordsInt > -1 ? IntPoint.newRangeQuery("words", minWordsInt, maxWordsInt) : (minWordsInt > -1 ? IntPoint.newRangeQuery("words", minWordsInt, Integer.MAX_VALUE) : (maxWordsInt > -1 ? IntPoint.newRangeQuery("words", Integer.MIN_VALUE, maxWordsInt) : IntPoint.newRangeQuery("words", Integer.MIN_VALUE, Integer.MAX_VALUE)));
        if (earliestAllowedPublishDate.getText().length() > 0) {
            String earliestAllowedPublishDateStringWithoutSlashes = earliestAllowedPublishDate.getText().replace("/", "");
            earliestAllowedPublishDateInt = Integer.parseInt(earliestAllowedPublishDateStringWithoutSlashes);
        } else {
            earliestAllowedPublishDateInt = 0;
        }
        if (latestAllowedPublishDate.getText().length() > 0) {
            String latestAllowedPublishDateStringWithoutSlashes = latestAllowedPublishDate.getText().replace("/", "");
            latestAllowedPublishDateInt = Integer.parseInt(latestAllowedPublishDateStringWithoutSlashes);
        } else {
            latestAllowedPublishDateInt = Integer.MAX_VALUE;
        }
        Query datePublishedQuery = IntPoint.newRangeQuery("datePublishedInt", earliestAllowedPublishDateInt, latestAllowedPublishDateInt);
        Query percentRatingQuery = minPercentageRatingFloat > 0.0f ? FloatPoint.newRangeQuery("percentRating", minPercentageRatingFloat, 2.1474836E9f) : FloatPoint.newRangeQuery("percentRating", -10.0f, 200.0f);
        if (completedOnlyCheckbox.getState()) {
            theString = String.valueOf(theString) + " AND completionStatus:complete";
        }
        Query q = qp.parse(theString);
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).add(minLikesQuery, BooleanClause.Occur.MUST).add(minAndMaxWordsQuery, BooleanClause.Occur.MUST).add(datePublishedQuery, BooleanClause.Occur.MUST).add(percentRatingQuery, BooleanClause.Occur.MUST).build();
        indexWriter.close();
        int hitsPerPage = 999999;
        final DirectoryReader reader1 = DirectoryReader.open(index);
        final IndexSearcher searcher = new IndexSearcher(reader1);
        Sort sort = new Sort((SortField)new SortedNumericSortField("views", SortField.Type.LONG, true));
        if (!viewsRadioButton.isSelected()) {
            if (likesRadioButton.isSelected()) {
                sort = new Sort((SortField)new SortedNumericSortField("likes", SortField.Type.LONG, true));
            } else if (wordsRadioButton.isSelected()) {
                sort = new Sort((SortField)new SortedNumericSortField("words", SortField.Type.LONG, true));
            } else if (percentRatingRadioButton.isSelected()) {
                sort = new Sort((SortField)new SortedNumericSortField("percentRating", SortField.Type.LONG, true));
            } else if (oldestFirstRadioButton.isSelected()) {
                sort = new Sort((SortField)new SortedNumericSortField("datePublishedInt", SortField.Type.LONG, true));
            } else if (newestFirstRadioButton.isSelected()) {
                sort = new Sort((SortField)new SortedNumericSortField("datePublishedInt", SortField.Type.LONG, false));
            }
        }
        TopFieldDocs docs = searcher.search(booleanQuery, hitsPerPage, sort, true, true);
        final ScoreDoc[] hits = docs.scoreDocs;
        final DecimalFormat df2 = new DecimalFormat("#.##");
        final float estimatedSecondsTheProgramWillFreezeFor = (float)hits.length / 20000.0f;
        final String endOfLine = System.lineSeparator();
        final String endOfField = ", ";
        FimArchiveSearchGUI.goodPrint("Found " + hits.length + " results" + endOfLine);
        FimArchiveSearchGUI.goodPrint("Loading results into memory" + endOfLine);
        FimArchiveSearchGUI.goodPrint("The program will appear to freeze for about " + df2.format(estimatedSecondsTheProgramWillFreezeFor) + " seconds" + endOfLine);
        FimArchiveSearchGUI.goodPrint(endOfLine);
        FimArchiveSearchGUI.goodPrint("Search parameters:" + endOfLine);
        FimArchiveSearchGUI.goodPrint("Good tags entered: " + goodTags.toString() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Bad tags entered: " + badTags.toString() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Min words (-1 means no limit): " + minWordsInt + endOfLine);
        FimArchiveSearchGUI.goodPrint("Max words (-1 means no limit): " + maxWordsInt + endOfLine);
        FimArchiveSearchGUI.goodPrint("Published before/on: " + latestAllowedPublishDate.getText() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Published after/on: " + earliestAllowedPublishDate.getText() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Minimum likes (-1 means no limit): " + minLikesInt + endOfLine);
        FimArchiveSearchGUI.goodPrint("Minimum percentage rating (-1 means no limit): " + minPercentageRatingFloat + "%" + endOfLine);
        FimArchiveSearchGUI.goodPrint("Title contains: " + titleContainsTextBox.getText() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Description contains: " + descriptionContainsTextBox.getText() + endOfLine);
        FimArchiveSearchGUI.goodPrint("Author name: " + authorTextField.getText() + endOfLine);
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            StringBuilder stringBuilder = new StringBuilder("");

            @Override
            protected Void doInBackground() throws Exception {
                int i = 0;
                while (i < hits.length) {
                    int docId = hits[i].doc;
                    Document d = searcher.doc(docId);
                    this.stringBuilder.append("--Story Title: " + d.get("title") + endOfField);
                    this.stringBuilder.append("Author: " + d.get("author") + endOfField);
                    this.stringBuilder.append("ID: " + d.get("ID") + endOfLine);
                    if (Integer.parseInt(d.get("prequelID")) != -1) {
                        this.stringBuilder.append("!! this story has a prequel. ID of prequel: " + d.get("prequelID") + endOfLine);
                    }
                    this.stringBuilder.append("Description: " + d.get("description") + endOfLine);
                    this.stringBuilder.append("Date Published: " + d.get("datePublishedString") + endOfField);
                    this.stringBuilder.append("Completion Status: " + d.get("completionStatus") + endOfLine);
                    this.stringBuilder.append("Likes: " + d.get("likes") + endOfField);
                    this.stringBuilder.append("Dislikes: " + d.get("dislikes") + endOfField);
                    this.stringBuilder.append("Percent Rating: " + d.get("percentRating") + endOfField);
                    this.stringBuilder.append("Views: " + d.get("views") + endOfField);
                    this.stringBuilder.append("Word Count: " + d.get("words") + endOfLine);
                    this.stringBuilder.append("Content Rating: " + d.get("contentRating") + endOfLine);
                    this.stringBuilder.append("Tags: " + Arrays.asList(d.get("tagsString").split(",")) + endOfLine);
                    this.stringBuilder.append(endOfLine);
                    if (i == 5000 && LimitResultsCheckbox.getState()) break;
                    ++i;
                }
                if (hits.length > 5000) {
                    LimitResultsCheckbox.getState();
                }
                FimArchiveSearchGUI.goodPrint(String.valueOf(endOfLine) + "Done finding results. Now printing. " + "The program will appear to freeze for another " + df2.format((double)estimatedSecondsTheProgramWillFreezeFor * 0.8) + " seconds" + endOfLine + endOfLine);
                this.stringBuilder.append("Total " + hits.length + " results. ");
                if (hits.length > 5000 && LimitResultsCheckbox.getState()) {
                    this.stringBuilder.append("However, only showing 5000 results to avoid lag.");
                }
                FimArchiveSearchGUI.goodPrint(this.stringBuilder.toString());
                reader1.close();
                if (writeResultsCheckbox.getState()) {
                    BufferedWriter out = new BufferedWriter(new FileWriter("results.txt"));
                    out.write(textArea.getText());
                    out.close();
                }
                return null;
            }
        };
        worker.execute();
    }

    public static void addStoryToBufferString(StringBuilder stringBuilder, Document d) {
        stringBuilder.append("--Story Title: " + d.get("title") + endOfField);
        stringBuilder.append("Author: " + d.get("author") + endOfField);
        stringBuilder.append("ID: " + d.get("ID") + endOfLine);
        if (Integer.parseInt(d.get("prequelID")) != -1) {
            stringBuilder.append("!! this story has a prequel. ID of prequel: " + d.get("prequelID") + endOfLine);
        }
        stringBuilder.append("Description: " + d.get("description") + endOfLine);
        stringBuilder.append("Date Published: " + d.get("datePublishedString") + endOfField);
        stringBuilder.append("Completion Status: " + d.get("completionStatus") + endOfLine);
        stringBuilder.append("Likes: " + d.get("likes") + endOfField);
        stringBuilder.append("Dislikes: " + d.get("dislikes") + endOfField);
        stringBuilder.append("Percent Rating: " + d.get("percentRating") + endOfField);
        stringBuilder.append("Views: " + d.get("views") + endOfField);
        stringBuilder.append("Word Count: " + d.get("words") + endOfLine);
        stringBuilder.append("Content Rating: " + d.get("contentRating") + endOfLine);
        stringBuilder.append("Tags: " + Arrays.asList(d.get("tagsString").split(",")) + endOfLine);
        stringBuilder.append(endOfLine);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    FimArchiveSearchGUI.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public static void addDoc(IndexWriter w, FimfictionStory theStoryToBeAddedToIndex) throws IOException {
        Document doc = new Document();
        doc.add(new org.apache.lucene.document.TextField("filler", "abcde", Field.Store.YES));
        doc.add(new org.apache.lucene.document.TextField("title", theStoryToBeAddedToIndex.title, Field.Store.YES));
        doc.add(new org.apache.lucene.document.TextField("description", theStoryToBeAddedToIndex.description, Field.Store.YES));
        String tagsString = theStoryToBeAddedToIndex.tags.toString();
        tagsString = tagsString.replace("[", "");
        tagsString = tagsString.replace("]", "");
        tagsString = tagsString.replace(", ", ",");
        doc.add(new org.apache.lucene.document.TextField("tagsString", tagsString, Field.Store.YES));
        doc.add(new IntPoint("likes", theStoryToBeAddedToIndex.likes));
        doc.add(new StoredField("likes", theStoryToBeAddedToIndex.likes));
        doc.add(new SortedNumericDocValuesField("likes", theStoryToBeAddedToIndex.likes));
        doc.add(new IntPoint("dislikes", theStoryToBeAddedToIndex.dislikes));
        doc.add(new StoredField("dislikes", theStoryToBeAddedToIndex.dislikes));
        theStoryToBeAddedToIndex.calculateRating();
        doc.add(new FloatPoint("percentRating", theStoryToBeAddedToIndex.percentRating));
        doc.add(new StoredField("percentRating", theStoryToBeAddedToIndex.percentRating));
        doc.add(new SortedNumericDocValuesField("percentRating", NumericUtils.floatToSortableInt(theStoryToBeAddedToIndex.percentRating)));
        doc.add(new IntPoint("views", theStoryToBeAddedToIndex.views));
        doc.add(new StoredField("views", theStoryToBeAddedToIndex.views));
        doc.add(new SortedNumericDocValuesField("views", theStoryToBeAddedToIndex.views));
        doc.add(new org.apache.lucene.document.TextField("author", theStoryToBeAddedToIndex.author, Field.Store.YES));
        doc.add(new org.apache.lucene.document.TextField("datePublishedString", theStoryToBeAddedToIndex.datePublishedString, Field.Store.YES));
        int datePublishedInt = 19000101;
        if (theStoryToBeAddedToIndex.datePublishedString != "unknown date") {
            String datePublishedStringWithoutSlashes = theStoryToBeAddedToIndex.datePublishedString.replace("/", "");
            datePublishedInt = Integer.parseInt(datePublishedStringWithoutSlashes);
        }
        doc.add(new IntPoint("datePublishedInt", datePublishedInt));
        doc.add(new StoredField("datePublishedInt", datePublishedInt));
        doc.add(new SortedNumericDocValuesField("datePublishedInt", theStoryToBeAddedToIndex.datePublishedInt));
        doc.add(new org.apache.lucene.document.TextField("completionStatus", theStoryToBeAddedToIndex.completionStatus, Field.Store.YES));
        doc.add(new org.apache.lucene.document.TextField("contentRating", theStoryToBeAddedToIndex.contentRating, Field.Store.YES));
        doc.add(new IntPoint("words", theStoryToBeAddedToIndex.words));
        doc.add(new StoredField("words", theStoryToBeAddedToIndex.words));
        doc.add(new SortedNumericDocValuesField("words", theStoryToBeAddedToIndex.words));
        doc.add(new IntPoint("ID", theStoryToBeAddedToIndex.ID));
        doc.add(new StoredField("ID", theStoryToBeAddedToIndex.ID));
        doc.add(new IntPoint("prequelID", theStoryToBeAddedToIndex.prequelID));
        doc.add(new StoredField("prequelID", theStoryToBeAddedToIndex.prequelID));
        w.addDocument(doc);
    }

    public static boolean isThisStringAnInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

