/*
 * Decompiled with CFR 0.152.
 */
package JavaPonies;

import JavaPonies.Behavior;
import JavaPonies.Effect_Form;
import JavaPonies.JNumField;
import JavaPonies.ModifiedFlowLayout;
import JavaPonies.Options;
import JavaPonies.Pony;
import JavaPonies.Pony_Form;
import JavaPonies.Speaking_Line;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

public class WinMain
extends JFrame
implements ActionListener {
    private static String version = "v1.25.0";
    public static GraphicsEnvironment ge;
    public static GraphicsDevice[] screens_to_use;
    public static Timer MoveTimer;
    public static WinMain currentInstance;
    public static Random rand;
    public JPanel poniesPanel = new JPanel();
    private JButton btnStart = null;
    public List<Pony> Active_Ponies = new LinkedList<Pony>();
    public List<Pony> Selectable_Ponies = new LinkedList<Pony>();
    public List<Effect_Form> Active_Effects = new LinkedList<Effect_Form>();
    public static boolean Ponies_Have_Launched;
    public Date Audio_Last_Played = new Date();
    public static final int BO_name = 1;
    public static final int BO_probability = 2;
    public static final int BO_max_duration = 3;
    public static final int BO_min_duration = 4;
    public static final int BO_speed = 5;
    public static final int BO_right_image_path = 6;
    public static final int BO_left_image_path = 7;
    public static final int BO_movement_type = 8;
    public static final int BO_linked_behavior = 9;
    public static final int BO_speaking_start = 10;
    public static final int BO_speaking_end = 11;
    public static final int BO_skip = 12;
    public static final int BO_xcoord = 13;
    public static final int BO_ycoord = 14;
    public static final int BO_object_to_follow = 15;
    public static int IP_Name;
    public static int IP_Initiator;
    public static int IP_Probability;
    public static int IP_Proximity;
    public static int IP_Target_List;
    public static int IP_Target_Selection_Option;
    public static int IP_Behavior_List;
    public static int IP_Repeat_Delay;

    static {
        MoveTimer = null;
        currentInstance = null;
        rand = new Random();
        Ponies_Have_Launched = false;
        IP_Name = 0;
        IP_Initiator = 1;
        IP_Probability = 2;
        IP_Proximity = 3;
        IP_Target_List = 4;
        IP_Target_Selection_Option = 5;
        IP_Behavior_List = 6;
        IP_Repeat_Delay = 7;
    }

    public static void main(String[] args) {
        currentInstance = new WinMain();
        Options.loadOptions();
    }

    WinMain() {
        super("Desktop Ponies for Java " + version);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("Gilgapony.gif"));
        this.initializeWinMain();
        this.initializePonies();
    }

    private void Add_to_Menu(Pony pony) {
        JPanel ponyselect = new JPanel();
        JPanel ponylabels = new JPanel();
        JLabel ponypic = new JLabel();
        ponypic.setIcon(pony.picture);
        JLabel ponyname = new JLabel(pony.Name);
        JLabel howmany = new JLabel("How many?");
        JNumField ponycount = new JNumField("1");
        ponylabels.setLayout(new GridLayout(4, 1));
        ponylabels.add(ponyname);
        ponylabels.add(new JLabel());
        ponylabels.add(howmany);
        ponylabels.add(ponycount);
        ponyselect.setLayout(new GridLayout(1, 2));
        ponyselect.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        ponyselect.add(ponypic);
        ponyselect.add(ponylabels);
        this.poniesPanel.add(ponyselect);
        this.poniesPanel.getParent().validate();
        this.Selectable_Ponies.add(pony);
    }

    private Directions GetDirection(String setting) throws Exception {
        if (setting.trim().equalsIgnoreCase("top")) {
            return Directions.top;
        }
        if (setting.trim().equalsIgnoreCase("bottom")) {
            return Directions.bottom;
        }
        if (setting.trim().equalsIgnoreCase("left")) {
            return Directions.left;
        }
        if (setting.trim().equalsIgnoreCase("right")) {
            return Directions.right;
        }
        if (setting.trim().equalsIgnoreCase("bottom_right")) {
            return Directions.bottom_right;
        }
        if (setting.trim().equalsIgnoreCase("bottom_left")) {
            return Directions.bottom_left;
        }
        if (setting.trim().equalsIgnoreCase("top_right")) {
            return Directions.top_right;
        }
        if (setting.trim().equalsIgnoreCase("top_left")) {
            return Directions.top_left;
        }
        if (setting.trim().equalsIgnoreCase("center")) {
            return Directions.center;
        }
        if (setting.trim().equalsIgnoreCase("any")) {
            return Directions.random;
        }
        if (setting.trim().equalsIgnoreCase("any_notcenter")) {
            return Directions.random_not_center;
        }
        throw new Exception("Invalid placement direction or centering for effect.");
    }

    private void go_Click() {
        try {
            if (Options.Interactions_Enabled) {
                this.Load_Interactions();
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to load interactions.  Details: " + ex.getMessage());
        }
        if (screens_to_use.length == 0) {
            screens_to_use = ge.getScreenDevices();
        }
        LinkedList<Integer> number_of_ponies = new LinkedList<Integer>();
        int Total_Ponies = 0;
        Component[] componentArray = this.poniesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component ponypanel = componentArray[n2];
            Component controls = ((JPanel)ponypanel).getComponent(1);
            Component ponycount = ((JPanel)controls).getComponent(3);
            JTextField textbox = (JTextField)ponycount;
            try {
                int numbertoadd = Integer.parseInt(textbox.getText());
                number_of_ponies.add(numbertoadd);
                Total_Ponies += numbertoadd;
            }
            catch (NumberFormatException ex) {
                number_of_ponies.add(0);
            }
            ++n2;
        }
        if (Total_Ponies == 0) {
            JOptionPane.showMessageDialog(this, "The total is... no ponies...  That's TOO FEW PONY.");
            return;
        }
        if (Total_Ponies > Options.Max_Pony_Counter) {
            JOptionPane.showMessageDialog(this, "Sorry, I don't care who you are! " + Total_Ponies + " ponies is too much pony!  You'd only hurt yourself.\nNo, seriously your computer would crash.  Try less than " + Options.Max_Pony_Counter + " total.\n(Or override this limit in the options window)");
            return;
        }
        if (Total_Ponies > 50) {
            JOptionPane.showMessageDialog(this, String.valueOf(Total_Ponies) + " ponies!?!  I hope you can handle that much pony!  Here we go...");
        }
        LinkedList<Pony> ponies_to_remove = new LinkedList<Pony>();
        int i = 0;
        while (i < number_of_ponies.size()) {
            if ((Integer)number_of_ponies.get(i) == 0) {
                ponies_to_remove.add(this.Active_Ponies.get(i));
            } else if ((Integer)number_of_ponies.get(i) > 1) {
                try {
                    int z = 1;
                    while (z < (Integer)number_of_ponies.get(i)) {
                        Pony new_pony = this.Active_Ponies.get(i).Duplicate();
                        this.Active_Ponies.add(new_pony);
                        ++z;
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error duplicating pony: " + this.Active_Ponies.get((int)i).Name + "\n" + ex.getMessage());
                }
            }
            ++i;
        }
        for (Pony pony : ponies_to_remove) {
            this.Active_Ponies.remove(pony);
        }
        try {
            if (Options.Interactions_Enabled) {
                this.Initialize_Interactions();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Unable to initialize interactions.  Details: " + ex.getMessage());
        }
        this.Pony_Startup();
    }

    private void Pony_Startup() {
        MoveTimer.start();
        this.setVisible(false);
        Ponies_Have_Launched = true;
    }

    private void initializeWinMain() {
        ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        screens_to_use = ge.getScreenDevices();
        MoveTimer = new Timer(30, this);
        MoveTimer.stop();
        this.setDefaultCloseOperation(3);
        JPanel buttonPanel = new JPanel();
        this.btnStart = new JButton("GIVE ME PONIES!");
        JButton btnZeroAll = new JButton("0 all ponies");
        JButton btnOptions = new JButton("OPTIONS");
        this.btnStart.setActionCommand("Start");
        this.btnStart.addActionListener(this);
        btnZeroAll.setActionCommand("ZeroAll");
        btnZeroAll.addActionListener(this);
        btnOptions.setActionCommand("Options");
        btnOptions.addActionListener(this);
        buttonPanel.add(btnZeroAll);
        buttonPanel.add(btnOptions);
        buttonPanel.add(this.btnStart);
        this.setLayout(new BorderLayout());
        this.poniesPanel.setLayout(new ModifiedFlowLayout());
        JScrollPane js = new JScrollPane(this.poniesPanel);
        js.setHorizontalScrollBarPolicy(31);
        this.add((Component)js, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(708, 537);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initializePonies() {
        File dir = new File("./");
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] files = dir.listFiles(fileFilter);
        if (files.length == 0) {
            JOptionPane.showMessageDialog(this, "Error: Couldn't find any subfolders! Are you running from the right folder?\n" + dir.getAbsolutePath());
        }
        String smissingponies = "Error: No pony.ini configuration file found for these folders: ";
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File ponydir = fileArray[n2];
            FilenameFilter configfilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("pony.ini");
                }
            };
            File[] configfile = ponydir.listFiles(configfilter);
            if (configfile.length > 0) {
                Scanner fi = null;
                try {
                    fi = this.IsUTFFile(configfile[0].getPath()) ? new Scanner(new InputStreamReader((InputStream)new FileInputStream(configfile[0].getPath()), "UTF-16")) : new Scanner(new FileInputStream(configfile[0].getPath()));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Unable to open config file: " + configfile[0].getPath() + "\n" + e.toString());
                    System.out.println("Unable to open config file: " + configfile[0].getPath());
                    System.out.println(e.toString());
                }
                String PonyName = "";
                LinkedList<Speaking_Line> PonyLines = new LinkedList<Speaking_Line>();
                LinkedList<String> Behaviors = new LinkedList<String>();
                LinkedList<String> Effects = new LinkedList<String>();
                while (fi.hasNextLine()) {
                    String[] columns;
                    String line = fi.nextLine();
                    if (line.length() == 0 || line.startsWith("'") || (columns = this.SplitWithQualifiers(line, ",", "\"")).length <= 0) continue;
                    if (columns[0].equalsIgnoreCase("name")) {
                        PonyName = columns[1].trim();
                        continue;
                    }
                    if (columns[0].equalsIgnoreCase("behavior")) {
                        Behaviors.add(line);
                        continue;
                    }
                    if (columns[0].equalsIgnoreCase("speak")) {
                        switch (columns.length) {
                            case 2: {
                                PonyLines.add(new Speaking_Line("Unnamed", columns[1].replace("\"", ""), "", "", false));
                                break;
                            }
                            case 5: {
                                PonyLines.add(new Speaking_Line(columns[1].trim(), columns[2].replace("\"", ""), String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1), columns[3].replace("\"", "").trim(), Boolean.parseBoolean(columns[4].trim())));
                                break;
                            }
                        }
                        continue;
                    }
                    if (!columns[0].equalsIgnoreCase("effect")) continue;
                    Effects.add(line);
                }
                fi.close();
                if (PonyName.length() > 0) {
                    String[] columns;
                    Pony newPony = new Pony(PonyName, String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1), new Pony_Form(), PonyLines);
                    for (String behavior : Behaviors) {
                        File[] imgfiles;
                        columns = this.SplitWithQualifiers(behavior, ",", "\"");
                        if (columns.length <= 8) {
                            JOptionPane.showMessageDialog(this, "Warning:  You are missing a required parameter for pony " + PonyName + " in behvaior:\n" + behavior);
                            continue;
                        }
                        AllowedMoves movement = AllowedMoves.None;
                        String linked_behavior = "";
                        String speak_start = "";
                        String speak_end = "";
                        int xcoord = 0;
                        int ycoord = 0;
                        String follow = "";
                        boolean skip = false;
                        if (columns.length > 0) {
                            if (columns[8].trim().equalsIgnoreCase("none")) {
                                movement = AllowedMoves.None;
                            } else if (columns[8].trim().equalsIgnoreCase("horizontal_only")) {
                                movement = AllowedMoves.Horizontal_Only;
                            } else if (columns[8].trim().equalsIgnoreCase("vertical_only")) {
                                movement = AllowedMoves.Vertical_Only;
                            } else if (columns[8].trim().equalsIgnoreCase("horizontal_vertical")) {
                                movement = AllowedMoves.Horizontal_Vertical;
                            } else if (columns[8].trim().equalsIgnoreCase("diagonal_only")) {
                                movement = AllowedMoves.Diagonal_Only;
                            } else if (columns[8].trim().equalsIgnoreCase("diagonal_horizontal")) {
                                movement = AllowedMoves.Diagonal_Horizontal;
                            } else if (columns[8].trim().equalsIgnoreCase("diagonal_vertical")) {
                                movement = AllowedMoves.Diagonal_Vertical;
                            } else if (columns[8].trim().equalsIgnoreCase("all")) {
                                movement = AllowedMoves.All;
                            } else if (columns[8].trim().equalsIgnoreCase("mouseover")) {
                                movement = AllowedMoves.MouseOver;
                            } else if (columns[8].trim().equalsIgnoreCase("sleep")) {
                                movement = AllowedMoves.Sleep;
                            }
                        }
                        File[] fileArray2 = imgfiles = ponydir.listFiles();
                        int n3 = imgfiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File imgcase = fileArray2[n4];
                            if (imgcase.getName().equalsIgnoreCase(columns[7].trim())) {
                                columns[7] = imgcase.getName();
                            } else if (imgcase.getName().equalsIgnoreCase(columns[6].trim())) {
                                columns[6] = imgcase.getName();
                            }
                            ++n4;
                        }
                        if (columns.length > 9) {
                            linked_behavior = columns[9].trim();
                            speak_start = columns[10].trim();
                            speak_end = columns[11].trim();
                            skip = Boolean.parseBoolean(columns[12].trim());
                            xcoord = Integer.parseInt(columns[13].trim());
                            ycoord = Integer.parseInt(columns[14].trim());
                            if (columns.length > 15) {
                                follow = columns[15].trim();
                            }
                        }
                        newPony.Add_Behavior(columns[1].trim(), Double.parseDouble(columns[2].trim()), Double.parseDouble(columns[3].trim()), Double.parseDouble(columns[4].trim()), Double.parseDouble(columns[5].trim()), String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1) + columns[6].trim(), String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1) + columns[7].trim(), movement, linked_behavior, speak_start, speak_end, skip, xcoord, ycoord, follow);
                        if (newPony.picture != null) continue;
                        BufferedImage image = null;
                        try {
                            image = ImageIO.read(new File(String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1) + columns[6].trim()));
                        }
                        catch (Exception e) {
                            System.out.println("Could not load image: " + ponydir.getPath() + ponydir.getPath().charAt(1) + columns[6].trim());
                        }
                        if (image == null) continue;
                        newPony.picture = new ImageIcon(image);
                    }
                    for (String effect2 : Effects) {
                        columns = this.SplitWithQualifiers(effect2, ",", "\"");
                        boolean found_behavior = false;
                        for (Behavior behavior : newPony.Behaviors) {
                            File[] imgfiles;
                            if (!behavior.Name.equalsIgnoreCase(columns[2].replace('\"', ' ').trim())) continue;
                            Directions direction_right = Directions.center;
                            Directions centering_right = Directions.center;
                            Directions direction_left = Directions.center;
                            Directions centering_left = Directions.center;
                            try {
                                direction_right = this.GetDirection(columns[7]);
                                centering_right = this.GetDirection(columns[8]);
                                direction_left = this.GetDirection(columns[9]);
                                centering_left = this.GetDirection(columns[10]);
                            }
                            catch (Exception ex) {
                                System.out.println("Invalid placement direction or centering for effect " + columns[1] + " for pony " + PonyName + ":\n" + effect2);
                            }
                            File[] fileArray3 = imgfiles = ponydir.listFiles();
                            int e = imgfiles.length;
                            int image = 0;
                            while (image < e) {
                                File imgcase = fileArray3[image];
                                if (imgcase.getName().equalsIgnoreCase(columns[3].trim())) {
                                    columns[3] = imgcase.getName();
                                }
                                if (imgcase.getName().equalsIgnoreCase(columns[4].trim())) {
                                    columns[4] = imgcase.getName();
                                }
                                ++image;
                            }
                            Image rightimage = null;
                            Image leftimage = null;
                            try {
                                rightimage = Toolkit.getDefaultToolkit().createImage(String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1) + columns[3].trim());
                                leftimage = Toolkit.getDefaultToolkit().createImage(String.valueOf(ponydir.getPath()) + ponydir.getPath().charAt(1) + columns[4].trim());
                            }
                            catch (Exception e2) {
                                System.out.println("Could not load image: " + ponydir.getPath() + ponydir.getPath().charAt(1) + columns[3].trim());
                                System.out.println(e2.getMessage());
                            }
                            if (rightimage == null || leftimage == null) break;
                            behavior.AddEffect(columns[1].replace('\"', ' ').trim(), new ImageIcon(rightimage), new ImageIcon(leftimage), Double.parseDouble(columns[5].trim()), Double.parseDouble(columns[6].trim()), direction_right, centering_right, direction_left, centering_left, Boolean.parseBoolean(columns[11].trim()));
                            found_behavior = true;
                            break;
                        }
                        if (found_behavior) continue;
                        System.out.println("Could not find behavior for effect " + columns[1] + " for pony " + PonyName + ":\n" + effect2);
                    }
                    newPony.Link_Behaviors();
                    if (newPony.picture != null) {
                        this.Active_Ponies.add(newPony);
                        this.Add_to_Menu(newPony);
                        System.out.println(String.valueOf(PonyName) + " successfully loaded.");
                    } else {
                        JOptionPane.showMessageDialog(this, "The pony " + PonyName + " could not be loaded. Make sure the Pony.ini file has all the required information.");
                    }
                }
            } else {
                smissingponies = String.valueOf(smissingponies) + "\n" + ponydir.getPath();
            }
            ++n2;
        }
        if (smissingponies.length() > 64) {
            JOptionPane.showMessageDialog(this, String.valueOf(smissingponies) + "\nThese ponies were not loaded.");
        }
        if (this.Active_Ponies.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Sorry, but you don't seem to have any ponies installed.  There should have at least been a 'Derpy' folder in the same spot as this program.");
            this.btnStart.setEnabled(false);
        }
    }

    private boolean IsUTFFile(String filepath) throws Exception {
        Scanner fi = new Scanner(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-16"));
        while (fi.hasNextLine()) {
            String line = fi.nextLine();
            if (!line.trim().toLowerCase().startsWith("name") && !line.trim().toLowerCase().startsWith("'interactionname")) continue;
            fi.close();
            return true;
        }
        fi.close();
        return false;
    }

    private void Initialize_Interactions() {
        for (Pony pony : this.Active_Ponies) {
            pony.Initialize_Interactions();
        }
    }

    private void Load_Interactions() {
        File dir = new File("./");
        FilenameFilter configfilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("interactions.ini");
            }
        };
        File[] configfile = dir.listFiles(configfilter);
        if (configfile.length > 0) {
            Scanner fi;
            block9: {
                fi = null;
                try {
                    if (this.IsUTFFile(configfile[0].getPath())) {
                        fi = new Scanner(new InputStreamReader((InputStream)new FileInputStream(configfile[0].getPath()), "UTF-16"));
                        break block9;
                    }
                    fi = new Scanner(new FileInputStream(configfile[0].getPath()));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Unable to open config file: " + configfile[0].getPath() + "\n" + e.toString());
                    System.out.println("Unable to open config file: " + configfile[0].getPath());
                    System.out.println(e.toString());
                }
            }
            while (fi.hasNextLine()) {
                String line = fi.nextLine();
                if (line.length() == 0 || line.startsWith("'")) continue;
                String[] columns = this.SplitWithQualifiers(line, ",", "{", "}");
                boolean ponyfound = false;
                for (Pony pony : this.Active_Ponies) {
                    try {
                        String ponyname = this.SplitWithQualifiers(columns[IP_Initiator], ",", "\"")[0];
                        if (!pony.Name.trim().equalsIgnoreCase(ponyname.trim())) continue;
                        ponyfound = true;
                        int repeat_delay = 60;
                        if (columns.length >= IP_Behavior_List) {
                            repeat_delay = Integer.parseInt(columns[IP_Repeat_Delay]);
                        }
                        pony.add_Interaction(columns[IP_Name], ponyname, Double.parseDouble(columns[IP_Probability]), columns[IP_Proximity], columns[IP_Target_List], columns[IP_Target_Selection_Option], columns[IP_Behavior_List], repeat_delay);
                    }
                    catch (Exception ex) {
                        System.out.println("Error loading interaction for Pony: " + pony.Name + "\n" + ex.getMessage());
                    }
                }
                if (ponyfound) continue;
                System.out.println("Warning:  Interaction specifies a non-existant pony: " + line);
            }
        }
    }

    private void moveTimer_Tick() {
        LinkedList<Pony> Ponies_to_Remove = new LinkedList<Pony>();
        for (Pony pony : this.Active_Ponies) {
            if (!pony.Form.isVisible()) {
                try {
                    pony.Form.setName(pony.Name);
                    pony.Form.setVisible(true);
                    pony.Form.Pony_Image.setDoubleBuffered(Options.EnableDoubleBuffering);
                    pony.Form.setup_addpony_menu();
                    pony.Teleport();
                }
                catch (Exception ex) {
                    Ponies_to_Remove.add(pony);
                }
                continue;
            }
            pony.Update();
        }
        for (Pony pony : Ponies_to_Remove) {
            for (Effect_Form effect2 : pony.Active_Effects) {
                effect2.setVisible(false);
            }
            this.Active_Ponies.remove(pony);
        }
        LinkedList<Effect_Form> effects_to_remove = new LinkedList<Effect_Form>();
        for (Effect_Form Effect : this.Active_Effects) {
            if (Effect.End_Time.getTime() - new Date().getTime() > 0L) continue;
            Effect.setVisible(false);
            effects_to_remove.add(Effect);
        }
        for (Effect_Form effect3 : effects_to_remove) {
            this.Active_Effects.remove(effect3);
        }
        if (this.Active_Ponies.isEmpty()) {
            System.exit(0);
        }
    }

    private void options_Click() {
        new Options(this);
    }

    private void zero_ponies_button_click() {
        Component[] componentArray = this.poniesPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component ponypanel = componentArray[n2];
            Component controls = ((JPanel)ponypanel).getComponent(1);
            Component ponycount = ((JPanel)controls).getComponent(3);
            JTextField textbox = (JTextField)ponycount;
            textbox.setText("0");
            ++n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == MoveTimer) {
            this.moveTimer_Tick();
        } else if (e.getActionCommand().equals("Start")) {
            this.go_Click();
        } else if (e.getActionCommand().equals("Options")) {
            this.options_Click();
        } else if (e.getActionCommand().equals("ZeroAll")) {
            this.zero_ponies_button_click();
        }
    }

    public String[] SplitWithQualifiers(String SourceText, String TextDelimiter, String TextQualifier) {
        return this.SplitWithQualifiers(SourceText, TextDelimiter, TextQualifier, "");
    }

    public String[] SplitWithQualifiers(String SourceText, String TextDelimiter, String TextQualifier, String ClosingTextQualifier) {
        String[] strRes;
        boolean blnStart = false;
        String B = "";
        if (TextDelimiter != " ") {
            SourceText = SourceText.trim();
        }
        if (ClosingTextQualifier.length() > 0) {
            SourceText = SourceText.replace(ClosingTextQualifier, TextQualifier);
        }
        String[] strTemp = SourceText.split(TextDelimiter);
        int I = 0;
        while (I < strTemp.length) {
            int J = strTemp[I].indexOf(TextQualifier, 0);
            if (J > -1) {
                String A = strTemp[I].replace(TextQualifier, "").trim();
                String C = strTemp[I].replace(TextQualifier, "");
                if (strTemp[I].trim().equals(String.valueOf(TextQualifier) + A + TextQualifier)) {
                    B = String.valueOf(B) + A + " \n";
                    blnStart = false;
                } else if (strTemp[I].trim().equals(String.valueOf(TextQualifier) + C + TextQualifier)) {
                    B = String.valueOf(B) + C + " \n";
                    blnStart = false;
                } else if (strTemp[I].trim().equals(String.valueOf(TextQualifier) + A)) {
                    B = String.valueOf(B) + A + TextDelimiter;
                    blnStart = true;
                } else if (strTemp[I].trim().equals(A)) {
                    B = String.valueOf(B) + A + TextDelimiter;
                    blnStart = false;
                } else if (strTemp[I].trim().equals(String.valueOf(A) + TextQualifier)) {
                    B = String.valueOf(B) + A + "\n";
                    blnStart = false;
                }
            } else {
                B = blnStart ? String.valueOf(B) + strTemp[I] + TextDelimiter : String.valueOf(B) + strTemp[I] + "\n";
            }
            ++I;
        }
        if (B.length() > 0) {
            B = B.substring(0, B.length());
            strRes = B.split("\n");
        } else {
            strRes = new String[]{SourceText};
        }
        return strRes;
    }

    public void sleep_all() {
        if (MoveTimer.isRunning()) {
            MoveTimer.stop();
            for (Pony pony : this.Active_Ponies) {
                pony.sleep();
            }
        } else {
            for (Pony pony : this.Active_Ponies) {
                pony.wake_up();
            }
            MoveTimer.start();
        }
    }

    public static enum AllowedMoves {
        None,
        Horizontal_Only,
        Vertical_Only,
        Horizontal_Vertical,
        Diagonal_Only,
        Diagonal_Horizontal,
        Diagonal_Vertical,
        All,
        MouseOver,
        Sleep;

    }

    public static enum Directions {
        top,
        bottom,
        left,
        right,
        bottom_right,
        bottom_left,
        top_right,
        top_left,
        center,
        random,
        random_not_center;

    }
}

