/*
 * Decompiled with CFR 0.152.
 */
package JavaPonies;

import JavaPonies.Options;
import JavaPonies.Pony;
import JavaPonies.Speaking_Line;
import JavaPonies.SuperObserver;
import JavaPonies.WinMain;
import com.sun.jna.platform.WindowUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.Timer;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Pony_Form
extends JDialog
implements ActionListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public JLabel Pony_Image = new JLabel();
    public ImageIcon CurrentImage = null;
    private String PonyName = "";
    public boolean ManualControl = false;
    public boolean PonyUp = false;
    public boolean PonyDown = false;
    public boolean PonyLeft = false;
    public boolean PonyRight = false;
    public boolean PonySpeed = false;
    public boolean PonyDirection = false;
    public boolean should_be_sleeping = false;
    private List<Speaking_Line> Lines_Random = new LinkedList<Speaking_Line>();
    private List<Speaking_Line> Lines_Specific = new LinkedList<Speaking_Line>();
    private JWindow tooltip = new JWindow();
    private JLabel tooltiplabel = new JLabel();
    private Timer tooltiptimer;
    private JPopupMenu popupmenu = new JPopupMenu();
    private JMenuItem manualcontrolmenu = null;
    private JMenuItem singlesleep = null;
    private JMenuItem allsleep = null;
    private JMenu addponymenu = null;
    private SuperObserver observer = null;
    private ImageIcon lastobservedimage = null;

    public Pony_Form() {
        this.initializeTooltip();
        this.initializeForm();
    }

    private void initializeForm() {
        this.setUndecorated(true);
        FlowLayout newLayout = new FlowLayout();
        newLayout.setVgap(0);
        newLayout.setHgap(0);
        this.getContentPane().setLayout(newLayout);
        this.getContentPane().add((Component)this.Pony_Image, "Center");
        this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        this.Pony_Image.setOpaque(false);
        this.Pony_Image.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        try {
            Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            Method mSetWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            mSetWindowOpacity.invoke(null, this, false);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        this.Pony_Image.setFocusable(true);
        this.Pony_Image.addKeyListener(this);
        this.Pony_Image.setDoubleBuffered(Options.EnableDoubleBuffering);
        this.Pony_Image.addMouseListener(this);
        this.Pony_Image.addMouseMotionListener(this);
        JMenuItem singlequit = new JMenuItem("Quit");
        singlequit.setActionCommand("ClosePony");
        singlequit.addActionListener(this);
        JMenuItem allquit = new JMenuItem("Quit ALL");
        allquit.setActionCommand("CloseAll");
        allquit.addActionListener(this);
        this.manualcontrolmenu = new JMenuItem("Take Control");
        this.manualcontrolmenu.setActionCommand("ManualControl");
        this.manualcontrolmenu.addActionListener(this);
        JMenuItem showoptions = new JMenuItem("Show Options");
        showoptions.setActionCommand("ShowOptions");
        showoptions.addActionListener(this);
        this.singlesleep = new JMenuItem("Sleep/Pause");
        this.singlesleep.setActionCommand("SleepPony");
        this.singlesleep.addActionListener(this);
        this.allsleep = new JMenuItem("Sleep/Pause All");
        this.allsleep.setActionCommand("SleepAll");
        this.allsleep.addActionListener(this);
        this.addponymenu = new JMenu("Add a pony->");
        this.popupmenu.add(singlequit);
        this.popupmenu.add(allquit);
        this.popupmenu.add(this.manualcontrolmenu);
        this.popupmenu.add(showoptions);
        this.popupmenu.add(this.singlesleep);
        this.popupmenu.add(this.allsleep);
        this.popupmenu.add(this.addponymenu);
        this.setSize(100, 100);
        this.setAlwaysOnTop(true);
        this.setVisible(false);
    }

    private void initializeTooltip() {
        FlowLayout newLayout = new FlowLayout();
        newLayout.setVgap(0);
        newLayout.setHgap(10);
        this.tooltip.getContentPane().setLayout(newLayout);
        this.tooltip.getContentPane().add((Component)this.tooltiplabel, "Center");
        this.tooltip.getContentPane().setBackground(Color.WHITE);
        this.tooltip.setSize(200, 25);
        this.tooltip.setAlwaysOnTop(true);
        this.tooltip.setVisible(false);
        this.tooltiptimer = new Timer(3000, this);
        this.tooltiptimer.stop();
    }

    public void SetPonyName(String name) {
        this.PonyName = name;
    }

    public void SetLines(List<Speaking_Line> speaking_lines) {
        for (Speaking_Line line : speaking_lines) {
            if (line.Skip) {
                this.Lines_Specific.add(line);
                continue;
            }
            this.Lines_Random.add(line);
        }
    }

    public void Pony_Speak(GraphicsDevice screen, Speaking_Line line, boolean override) {
        if (screen == null) {
            return;
        }
        Rectangle screenbounds = screen.getDefaultConfiguration().getBounds();
        if (Options.Pony_Speak_Chance_Counter > 0 || override) {
            int selection = 0;
            String line_to_speak = "";
            if (this.Lines_Random.size() == 0) {
                if (line == null) {
                    return;
                }
            } else {
                selection = WinMain.rand.nextInt(this.Lines_Random.size());
                line_to_speak = this.Lines_Random.get((int)selection).Text;
                if (this.Lines_Random.get((int)selection).SoundFile.length() > 0) {
                    this.Pony_PlaySound(this.Lines_Random.get((int)selection).SoundFile);
                }
            }
            if (this.ManualControl) {
                return;
            }
            if (line != null) {
                line_to_speak = line.Text;
                if (line.SoundFile.length() > 0) {
                    this.Pony_PlaySound(line.SoundFile);
                }
            }
            this.tooltiplabel.setText(String.valueOf(this.PonyName) + ": \"" + line_to_speak + "\"");
            Point newLocation = new Point(this.getX() - 60, this.getY() - 10);
            newLocation.setLocation(Math.max((double)newLocation.x, screenbounds.getMinX()), Math.max((double)newLocation.y, screenbounds.getMinY()));
            this.tooltip.setLocation(newLocation);
            this.tooltip.setVisible(true);
            newLocation.setLocation(Math.min((double)newLocation.x, screenbounds.getMaxX() - (double)this.tooltiplabel.getWidth() - 10.0), Math.min((double)newLocation.y, screenbounds.getMaxY() - (double)this.tooltiplabel.getHeight()));
            this.tooltip.setLocation(newLocation);
            this.tooltip.setSize(this.tooltiplabel.getWidth() + 10, this.tooltiplabel.getHeight());
            this.tooltiptimer.start();
        }
    }

    private void Pony_PlaySound(String filename) {
        if (Options.Sounds_Enabled) {
            try {
                FileInputStream in = new FileInputStream(filename);
                AudioStream as = new AudioStream((InputStream)in);
                AudioPlayer.player.start((InputStream)as);
            }
            catch (Exception ex) {
                System.out.println("Could not play audio file: " + filename + "\n" + ex.getMessage());
            }
        }
    }

    public void setup_addpony_menu() {
        for (Pony pony : WinMain.currentInstance.Selectable_Ponies) {
            JMenuItem addpony = new JMenuItem(pony.Name.trim());
            addpony.setActionCommand("AddPony");
            addpony.addActionListener(this);
            this.addponymenu.add(addpony);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        if (e.getSource() != this.tooltiptimer) break block6;
                                        this.tooltip.setVisible(false);
                                        this.tooltiptimer.stop();
                                        break block5;
                                    }
                                    if (e.getActionCommand() != "ClosePony") break block7;
                                    for (Pony pony : WinMain.currentInstance.Active_Ponies) {
                                        if (pony.Form != this) continue;
                                        WinMain.currentInstance.Active_Ponies.remove(pony);
                                        break;
                                    }
                                    this.setVisible(false);
                                    break block5;
                                }
                                if (e.getActionCommand() != "CloseAll") break block8;
                                while (!WinMain.currentInstance.Active_Ponies.isEmpty()) {
                                    WinMain.currentInstance.Active_Ponies.clear();
                                }
                                break block5;
                            }
                            if (e.getActionCommand() != "ManualControl") break block9;
                            this.ManualControl = !this.ManualControl;
                            this.requestFocus();
                            this.Pony_Image.requestFocus();
                            break block5;
                        }
                        if (e.getActionCommand() != "ShowOptions") break block10;
                        new Options(this);
                        break block5;
                    }
                    if (e.getActionCommand() != "SleepPony") break block11;
                    this.should_be_sleeping = !this.should_be_sleeping;
                    break block5;
                }
                if (e.getActionCommand() != "SleepAll") break block12;
                WinMain.currentInstance.sleep_all();
                break block5;
            }
            if (e.getActionCommand() != "AddPony") break block5;
            String pony_to_add = ((JMenuItem)e.getSource()).getText();
            for (Pony pony : WinMain.currentInstance.Selectable_Ponies) {
                if (!pony.Name.trim().equalsIgnoreCase(pony_to_add)) continue;
                try {
                    Pony new_pony = pony.Duplicate();
                    WinMain.currentInstance.Active_Ponies.add(new_pony);
                }
                catch (Exception exception) {}
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.ManualControl) {
            this.manualcontrolmenu.setText("Release Control");
        } else {
            this.manualcontrolmenu.setText("Take Control");
        }
        if (this.should_be_sleeping) {
            this.singlesleep.setText("Wake up/Resume");
        } else {
            this.singlesleep.setText("Sleep/Pause");
        }
        if (WinMain.MoveTimer.isRunning()) {
            this.allsleep.setText("Sleep/Pause All");
        } else {
            this.allsleep.setText("Wake up/Resume All");
        }
        this.popupmenu.show(this, e.getX() - 20, e.getY() - 20);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (Options.Pony_Dragging_Enabled) {
            this.setLocation(new Point(e.getXOnScreen() - this.getWidth() / 2, e.getYOnScreen() - this.getHeight() / 2));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.ManualControl) {
            switch (e.getKeyCode()) {
                case 40: {
                    this.PonyDown = true;
                    break;
                }
                case 38: {
                    this.PonyUp = true;
                    break;
                }
                case 39: {
                    this.PonyRight = true;
                    break;
                }
                case 37: {
                    this.PonyLeft = true;
                }
            }
            this.PonySpeed = e.isShiftDown();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.ManualControl) {
            switch (e.getKeyCode()) {
                case 40: {
                    this.PonyDown = false;
                    break;
                }
                case 38: {
                    this.PonyUp = false;
                    break;
                }
                case 39: {
                    this.PonyRight = false;
                    break;
                }
                case 37: {
                    this.PonyLeft = false;
                }
            }
            this.PonySpeed = e.isShiftDown();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void paint(Graphics g) {
        if (Options.EnableFullRedraw) {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            g2d.setComposite(AlphaComposite.Clear);
            g2d.fillRect(0, 0, w, h);
            g2d.setComposite(AlphaComposite.Src);
            g2d.setPaint(g2d.getBackground());
            g2d.fillRect(0, 0, w, h);
        }
        super.paint(g);
    }

    @Override
    public void update(Graphics g) {
        if (Options.EnableFullRedraw) {
            this.paint(g);
        } else {
            super.update(g);
        }
    }

    public void observeImage(ImageIcon img) {
        if (Options.EnableShapeWindow) {
            if (this.lastobservedimage != null) {
                this.lastobservedimage.setImageObserver(null);
            }
            if (this.observer != null) {
                this.observer.StopObserving();
            }
            this.observer = new SuperObserver(this);
            img.setImageObserver(this.observer);
            this.lastobservedimage = img;
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (Options.EnableShapeWindow && ((infoflags & 0x10) == 16 || (infoflags & 0x20) == 32)) {
            try {
                WindowUtils.setWindowMask((Window)this, this.lastobservedimage);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return super.imageUpdate(img, infoflags, x, y, width, height);
    }
}

