/*
 * Decompiled with CFR 0.152.
 */
package JavaPonies;

import JavaPonies.Behavior;
import JavaPonies.Effect_Form;
import JavaPonies.Interaction;
import JavaPonies.Options;
import JavaPonies.Pony_Form;
import JavaPonies.Speaking_Line;
import JavaPonies.WinMain;
import JavaPonies.effect;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;

public class Pony {
    public String Name = "";
    public String Alternate_Name = "";
    public ImageIcon picture = null;
    public List<Behavior> Behaviors = new LinkedList<Behavior>();
    public List<Interaction> Interactions = new LinkedList<Interaction>();
    public boolean Interaction_Active = false;
    public Interaction Current_Interaction = null;
    private boolean Is_Interaction_Initiator = false;
    public boolean Is_Interacting = false;
    private Date Interaction_Delay_Until = new Date();
    private int Largest_Size_X = 0;
    private int Largest_Size_Y = 0;
    private Behavior current_behavior;
    private Behavior previous_behavior;
    private GraphicsDevice Current_Screen = null;
    private boolean Cursor_Halt = false;
    private boolean Is_cursor_halted = false;
    private boolean sleeping = false;
    Point Destination = new Point();
    boolean AtDestination = false;
    public List<Effect_Form> Active_Effects = new LinkedList<Effect_Form>();
    public List<Speaking_Line> Speaking_Lines = new LinkedList<Speaking_Line>();
    public Pony_Form Form;

    public Pony(String _name, String _altname, Pony_Form _form, List<Speaking_Line> Lines) {
        this.Name = _name;
        this.Alternate_Name = _altname;
        this.Form = _form;
        this.Form.SetPonyName(this.Name);
        this.Form.SetLines(Lines);
        this.Speaking_Lines = Lines;
    }

    public void Add_Behavior(String name, double chance, double max_duration, double min_duration, double speed, String right_image_path, String left_image_path, WinMain.AllowedMoves Allowed_Moves, String _Linked_Behavior, String _Startline, String _Endline, boolean _skip, int _xcoord, int _ycoord, String _object_to_follow) {
        Behavior new_behavior = new Behavior();
        new_behavior.Name = name.trim();
        new_behavior.Pony_Name = this.Name;
        new_behavior.chance_of_occurance = chance;
        new_behavior.MaxDuration = max_duration;
        new_behavior.MinDuration = min_duration;
        new_behavior.speed = speed;
        new_behavior.Allowed_Movement = Allowed_Moves;
        new_behavior.Start_Line_Name = _Startline;
        new_behavior.End_Line_Name = _Endline;
        new_behavior.Skip = _skip;
        new_behavior.destination_xcoord = _xcoord;
        new_behavior.destination_ycoord = _ycoord;
        new_behavior.follow_object_name = _object_to_follow;
        if (_Linked_Behavior.length() > 0) {
            new_behavior.Linked_Behavior_Name = _Linked_Behavior;
        }
        Image imageright = this.load_animation(right_image_path);
        Image imageleft = this.load_animation(left_image_path);
        if (imageright != null && imageleft != null) {
            new_behavior.right_image = new ImageIcon(imageright);
            new_behavior.right_image_path = right_image_path;
            new_behavior.left_image = new ImageIcon(imageleft);
            new_behavior.left_image_path = left_image_path;
            if (new_behavior.right_image.getIconWidth() > this.Largest_Size_X) {
                this.Largest_Size_X = new_behavior.right_image.getIconWidth();
            }
            if (new_behavior.right_image.getIconHeight() > this.Largest_Size_Y) {
                this.Largest_Size_Y = new_behavior.right_image.getIconHeight();
            }
            if (new_behavior.left_image.getIconWidth() > this.Largest_Size_X) {
                this.Largest_Size_X = new_behavior.left_image.getIconWidth();
            }
            if (new_behavior.left_image.getIconHeight() > this.Largest_Size_Y) {
                this.Largest_Size_Y = new_behavior.left_image.getIconHeight();
            }
            new_behavior.current_image = new_behavior.right_image;
            this.Behaviors.add(new_behavior);
        }
    }

    public void add_Interaction(String interaction_name, String name, double probability, String proximity, String target_list, String target_selection, String behaviorlist, int repeat_delay) throws Exception {
        String[] interaction_behaviors;
        Interaction new_interaction = new Interaction();
        new_interaction.Name = interaction_name;
        new_interaction.Targets_String = target_list;
        new_interaction.PonyName = name;
        new_interaction.Probability = probability;
        new_interaction.Reactivation_Delay = repeat_delay;
        if (target_selection.trim().equalsIgnoreCase("all") || target_selection.trim().equalsIgnoreCase("true")) {
            new_interaction.Select_All_Targets = true;
        } else if (target_selection.trim().equalsIgnoreCase("random") || target_selection.trim().equalsIgnoreCase("false")) {
            new_interaction.Select_All_Targets = false;
        } else {
            throw new Exception("Invalid option for target selection. Use either 'random' or 'all'.\n Interaction file specified: " + target_selection + " for interaction named: " + interaction_name);
        }
        if (!proximity.trim().equalsIgnoreCase("default")) {
            new_interaction.Proximity_Activation_Distance = Double.parseDouble(proximity);
        }
        String[] targets = WinMain.currentInstance.SplitWithQualifiers(target_list, ",", "\"");
        String[] stringArray = interaction_behaviors = WinMain.currentInstance.SplitWithQualifiers(behaviorlist, ",", "\"");
        int n = interaction_behaviors.length;
        int n2 = 0;
        while (n2 < n) {
            String iBehavior = stringArray[n2];
            boolean found = false;
            for (Behavior behavior : this.Behaviors) {
                if (!iBehavior.trim().equalsIgnoreCase(behavior.Name)) continue;
                new_interaction.Behavior_List.add(behavior);
                found = true;
            }
            if (!found) {
                System.out.println("Warning: Pony '" + this.Name + "' does not have required behavior '" + iBehavior + "' for interaction: '" + interaction_name + "'. This interaction is disabled.");
                return;
            }
            ++n2;
        }
        LinkedList<String> ok_targets = new LinkedList<String>();
        String[] stringArray2 = targets;
        int n3 = targets.length;
        n = 0;
        while (n < n3) {
            String target = stringArray2[n];
            boolean ponyfound = false;
            for (Pony pony : WinMain.currentInstance.Active_Ponies) {
                if (!target.trim().equalsIgnoreCase(pony.Name.trim())) continue;
                ponyfound = true;
                ok_targets.add(pony.Name);
                String[] stringArray3 = interaction_behaviors;
                int n4 = interaction_behaviors.length;
                int n5 = 0;
                while (n5 < n4) {
                    String behavior = stringArray3[n5];
                    boolean found = false;
                    for (Behavior ponybehavior : pony.Behaviors) {
                        if (!behavior.trim().equalsIgnoreCase(ponybehavior.Name)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ok_targets.remove(pony.Name);
                        System.out.println("Warning:  Pony " + pony.Name + " (" + pony.Alternate_Name + ") " + " does not have required behavior '" + behavior + "' as specified in interaction " + interaction_name + "\nInteraction is disabled for this pony.");
                    }
                    ++n5;
                }
            }
            if (!ponyfound) {
                System.out.println("Warning: There is no pony with name " + target + " loaded.  Interaction '" + name + "' has this pony listed as a target.");
            }
            ++n;
        }
        if (ok_targets.size() > 0 && new_interaction.Behavior_List.size() > 0) {
            for (String PonyName : ok_targets) {
                new_interaction.Interacts_With_Names.add(PonyName);
            }
            this.Interactions.add(new_interaction);
        }
    }

    public void Cancel_Interaction() {
        this.Is_Interacting = false;
        if (this.Current_Interaction != null) {
            if (this.Is_Interaction_Initiator) {
                for (Pony pony : this.Current_Interaction.Interacts_With) {
                    pony.Cancel_Interaction();
                }
            }
            this.Interaction_Delay_Until = new Date(new Date().getTime() + (long)(this.Current_Interaction.Reactivation_Delay * 1000));
            this.Current_Interaction = null;
            this.Is_Interaction_Initiator = false;
        }
    }

    public Pony Duplicate() throws Exception {
        Pony newpony = new Pony(this.Name, this.Alternate_Name, new Pony_Form(), this.Speaking_Lines);
        for (Behavior behavior : this.Behaviors) {
            newpony.Add_Behavior(behavior.Name, behavior.chance_of_occurance, behavior.MaxDuration, behavior.MinDuration, behavior.speed, behavior.right_image_path, behavior.left_image_path, behavior.Allowed_Movement, behavior.Linked_Behavior_Name, behavior.Start_Line_Name, behavior.End_Line_Name, behavior.Skip, behavior.destination_xcoord, behavior.destination_ycoord, behavior.follow_object_name);
        }
        newpony.Link_Behaviors();
        block1: for (Behavior behavior : this.Behaviors) {
            for (Behavior new_behavior : newpony.Behaviors) {
                if (!behavior.Name.equals(new_behavior.Name)) continue;
                for (effect effect2 : behavior.Effects) {
                    new_behavior.Effects.add(effect2);
                }
                continue block1;
            }
        }
        for (Interaction Interact : this.Interactions) {
            String targets = Interact.Targets_String;
            String behaviors = Interact.getBehaviors();
            if (targets.length() <= 0 || behaviors.length() <= 0) continue;
            newpony.add_Interaction(Interact.Name, newpony.Name, Interact.Probability, Double.toString(Interact.Proximity_Activation_Distance), targets, Boolean.toString(Interact.Select_All_Targets), behaviors, Interact.Reactivation_Delay);
        }
        return newpony;
    }

    public Behavior GetAppropriateBehavior(WinMain.AllowedMoves movement, boolean speed, Behavior specified_behavior) {
        double selected_behavior_speed = 0.0;
        Behavior selected_behavior = this.current_behavior;
        if (movement == WinMain.AllowedMoves.None && (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.None || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver) || movement == WinMain.AllowedMoves.Diagonal_Only && (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical) || movement == WinMain.AllowedMoves.Vertical_Only && (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only) || movement == WinMain.AllowedMoves.Horizontal_Only && (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only) || movement == this.current_behavior.Allowed_Movement || movement == WinMain.AllowedMoves.All) {
            if (this.current_behavior.speed == 0.0 && movement == WinMain.AllowedMoves.None) {
                return this.current_behavior;
            }
            if (this.current_behavior.speed != 0.0 && movement == WinMain.AllowedMoves.All) {
                return this.current_behavior;
            }
        }
        for (Behavior behavior : this.Behaviors) {
            if ((movement != WinMain.AllowedMoves.None || behavior.Allowed_Movement != WinMain.AllowedMoves.None && behavior.Allowed_Movement != WinMain.AllowedMoves.MouseOver) && (movement != WinMain.AllowedMoves.Diagonal_Only || behavior.Allowed_Movement != WinMain.AllowedMoves.Diagonal_Horizontal && behavior.Allowed_Movement != WinMain.AllowedMoves.Diagonal_Only && behavior.Allowed_Movement != WinMain.AllowedMoves.Diagonal_Vertical) && (movement != WinMain.AllowedMoves.Vertical_Only || behavior.Allowed_Movement != WinMain.AllowedMoves.Diagonal_Vertical && behavior.Allowed_Movement != WinMain.AllowedMoves.Horizontal_Vertical && behavior.Allowed_Movement != WinMain.AllowedMoves.Vertical_Only) && (movement != WinMain.AllowedMoves.Horizontal_Only || behavior.Allowed_Movement != WinMain.AllowedMoves.Diagonal_Horizontal && behavior.Allowed_Movement != WinMain.AllowedMoves.Horizontal_Vertical && behavior.Allowed_Movement != WinMain.AllowedMoves.Horizontal_Only) && movement != behavior.Allowed_Movement && movement != WinMain.AllowedMoves.All || behavior.Skip) continue;
            if (behavior.speed == 0.0 && movement != WinMain.AllowedMoves.All) {
                behavior.right = this.Form.PonyDirection;
                return behavior;
            }
            if (specified_behavior != null && (movement == WinMain.AllowedMoves.None && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.None || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver) || movement == WinMain.AllowedMoves.Diagonal_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical) || movement == WinMain.AllowedMoves.Vertical_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only) || movement == WinMain.AllowedMoves.Horizontal_Only && (specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || specified_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only) || movement == specified_behavior.Allowed_Movement || movement == WinMain.AllowedMoves.All)) {
                specified_behavior.right = this.Destination.x == 0 && this.Destination.y == 0 ? this.Form.PonyDirection : this.Get_Destination_Direction(this.Destination).get(0) == WinMain.Directions.right;
                return specified_behavior;
            }
            if (behavior.destination_xcoord != 0 || behavior.destination_ycoord != 0 || behavior.follow_object_name.length() != 0) continue;
            if (speed) {
                if (!(Math.abs(behavior.speed) > selected_behavior_speed)) continue;
                selected_behavior = behavior;
                selected_behavior_speed = Math.abs(behavior.speed);
                continue;
            }
            if (!(Math.abs(behavior.speed) < selected_behavior_speed) && selected_behavior_speed != 0.0) continue;
            selected_behavior = behavior;
            selected_behavior_speed = Math.abs(behavior.speed);
        }
        return selected_behavior;
    }

    private Point GetEffectLocation(int width, int height, WinMain.Directions direction, Pony_Form PonyForm, WinMain.Directions centering) {
        Point point = null;
        switch (direction) {
            case bottom: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth() / 2, PonyForm.getLocation().y + PonyForm.getHeight());
                break;
            }
            case bottom_left: {
                point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y + PonyForm.getHeight());
                break;
            }
            case bottom_right: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y + PonyForm.getHeight());
                break;
            }
            case center: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth() / 2, PonyForm.getLocation().y + PonyForm.getHeight() / 2);
                break;
            }
            case left: {
                point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y + PonyForm.getHeight() / 2);
                break;
            }
            case right: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y + PonyForm.getHeight() / 2);
                break;
            }
            case top: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth() / 2, PonyForm.getLocation().y);
                break;
            }
            case top_left: {
                point = new Point(PonyForm.getLocation().x, PonyForm.getLocation().y);
                break;
            }
            case top_right: {
                point = new Point(PonyForm.getLocation().x + PonyForm.getWidth(), PonyForm.getLocation().y);
            }
        }
        switch (centering) {
            case bottom: {
                point = new Point(point.x - width / 2, point.y - height);
                break;
            }
            case bottom_left: {
                point = new Point(point.x, point.y - height);
                break;
            }
            case bottom_right: {
                point = new Point(point.x - width, point.y - height);
                break;
            }
            case center: {
                point = new Point(point.x - width / 2, point.y - height / 2);
                break;
            }
            case left: {
                point = new Point(point.x, point.y - height / 2);
                break;
            }
            case right: {
                point = new Point(point.x - width, point.y - height / 2);
                break;
            }
            case top: {
                point = new Point(point.x - width / 2, point.y);
                break;
            }
            case top_left: {
                break;
            }
            case top_right: {
                point = new Point(point.x - width, point.y);
            }
        }
        return point;
    }

    private WinMain.Directions GetRandomDirection(boolean IncludeCentered) {
        int dice = IncludeCentered ? WinMain.rand.nextInt(9) : WinMain.rand.nextInt(8);
        switch (dice) {
            case 0: {
                return WinMain.Directions.bottom;
            }
            case 1: {
                return WinMain.Directions.bottom_left;
            }
            case 2: {
                return WinMain.Directions.bottom_right;
            }
            case 3: {
                return WinMain.Directions.left;
            }
            case 4: {
                return WinMain.Directions.right;
            }
            case 5: {
                return WinMain.Directions.top;
            }
            case 6: {
                return WinMain.Directions.top_left;
            }
            case 7: {
                return WinMain.Directions.top_right;
            }
        }
        return WinMain.Directions.center;
    }

    private List<WinMain.Directions> Get_Destination_Direction(Point destination) {
        LinkedList<WinMain.Directions> direction = new LinkedList<WinMain.Directions>();
        if (destination.x - this.Form.getLocation().x <= 0) {
            direction.add(WinMain.Directions.left);
        } else {
            direction.add(WinMain.Directions.right);
        }
        if (destination.y - this.Form.getLocation().y <= 0) {
            direction.add(WinMain.Directions.top);
        } else {
            direction.add(WinMain.Directions.bottom);
        }
        return direction;
    }

    public void Initialize_Interactions() {
        for (Interaction Interact : this.Interactions) {
            for (String Name : Interact.Interacts_With_Names) {
                for (Pony pony : WinMain.currentInstance.Active_Ponies) {
                    if (!Name.equalsIgnoreCase(pony.Name.trim())) continue;
                    boolean already_added = false;
                    for (Pony other_Pony : Interact.Interacts_With) {
                        if (other_Pony != pony) continue;
                        already_added = true;
                        break;
                    }
                    if (already_added) continue;
                    Interact.Interacts_With.add(pony);
                }
            }
        }
    }

    public boolean IsPonyInAvoidanceArea(Point location, GraphicsDevice screen) {
        if (screen == null || this.Current_Screen == null) {
            return false;
        }
        if (this.Current_Screen.getIDstring() != screen.getIDstring()) {
            return false;
        }
        Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
        Rectangle screen_avoidance_area = new Rectangle((int)((double)Options.Avoidance_Loc_X * screenBounds.getWidth() / 100.0 + screenBounds.getMinX()), (int)((double)Options.Avoidance_Loc_Y * screenBounds.getHeight() / 100.0 + screenBounds.getMinY()), (int)((double)Options.Avoidance_Size_X * screenBounds.getWidth() / 100.0), (int)((double)Options.Avoidance_Size_Y * screenBounds.getHeight() / 100.0));
        return screen_avoidance_area.intersects(new Rectangle(location, new Dimension(10, 10)));
    }

    public boolean IsPonyNearMouseCursor(Point location) {
        Point pony_location;
        Rectangle forbidden_zone;
        return Options.Cursor_Avoidance_Enabled && !this.Is_Interacting && !this.Form.ManualControl && (forbidden_zone = new Rectangle(MouseInfo.getPointerInfo().getLocation().x - Options.Cursor_zone_counter, MouseInfo.getPointerInfo().getLocation().y - Options.Cursor_zone_counter, Options.Cursor_zone_counter * 2, Options.Cursor_zone_counter * 2)).contains(pony_location = new Point(location.x + this.Largest_Size_X / 2, location.y + this.Largest_Size_Y / 2));
    }

    public boolean IsPonyOnScreen(Point current_location, Point new_location, GraphicsDevice[] AllScreens) {
        LinkedList<Point> points = new LinkedList<Point>();
        points.add(new_location);
        points.add(new Point(new_location.x + this.Form.getWidth(), new_location.y + this.Form.getHeight()));
        points.add(new Point(new_location.x + this.Form.getWidth(), new_location.y));
        points.add(new Point(new_location.x, new_location.y + this.Form.getHeight()));
        for (Point point : points) {
            boolean ok = false;
            GraphicsDevice[] graphicsDeviceArray = AllScreens;
            int n = AllScreens.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice Screen = graphicsDeviceArray[n2];
                Rectangle screenBounds = Screen.getDefaultConfiguration().getBounds();
                if (screenBounds.contains(point)) {
                    ok = true;
                    this.Current_Screen = Screen;
                    break;
                }
                ++n2;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public Interaction Is_In_Interaction_Range() {
        if (new Date().getTime() <= this.Interaction_Delay_Until.getTime()) {
            return null;
        }
        for (Interaction Interact : this.Interactions) {
            for (Pony target : Interact.Interacts_With) {
                double dice;
                double distance;
                if (this.Form.CurrentImage == null || target.Form.CurrentImage == null || target.Is_Interacting || !((distance = Math.sqrt(Math.pow(this.Form.getLocation().getX() + this.Form.getSize().getWidth() - target.Form.getLocation().getX() + target.Form.getSize().getWidth(), 2.0) + Math.pow(this.Form.getLocation().getY() + this.Form.getSize().getHeight() - target.Form.getLocation().getY() + target.Form.getSize().getHeight(), 2.0))) <= Interact.Proximity_Activation_Distance) || !((dice = WinMain.rand.nextDouble()) <= Interact.Probability)) continue;
                Interact.Trigger = target;
                return Interact;
            }
        }
        return null;
    }

    public void Link_Behaviors() {
        block0: for (Behavior behavior : this.Behaviors) {
            if (behavior.Linked_Behavior_Name.length() == 0) {
                behavior.Linked_Behavior = null;
            } else {
                for (Behavior other_behavior : this.Behaviors) {
                    if (!behavior.Linked_Behavior_Name.equalsIgnoreCase(other_behavior.Name)) continue;
                    behavior.Linked_Behavior = other_behavior;
                    break;
                }
            }
            if (behavior.End_Line_Name.length() > 0) {
                for (Speaking_Line line : this.Speaking_Lines) {
                    if (!line.Name.equalsIgnoreCase(behavior.End_Line_Name)) continue;
                    behavior.End_Line = line;
                    break;
                }
            }
            if (behavior.Start_Line_Name.length() <= 0) continue;
            for (Speaking_Line line : this.Speaking_Lines) {
                if (!line.Name.equalsIgnoreCase(behavior.Start_Line_Name)) continue;
                behavior.Start_Line = line;
                continue block0;
            }
        }
    }

    private Image load_animation(String ponyimage_path) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(ponyimage_path);
        }
        catch (Exception e) {
            System.out.println("Could not load image: " + ponyimage_path);
            System.out.println(e.getMessage());
        }
        return image;
    }

    public void Move() {
        this.current_behavior.blocked = false;
        Point current_location = this.Form.getLocation();
        double speed = this.current_behavior.speed;
        if (this.Form.ManualControl) {
            if (!(this.Form.PonyUp || this.Form.PonyDown || this.Form.PonyRight || this.Form.PonyLeft)) {
                speed = 0.0;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.None, this.Form.PonySpeed, null);
            } else if (this.Form.PonyUp && this.Form.PonyRight) {
                this.Form.PonyDirection = true;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.right = true;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = true;
                this.current_behavior.up = true;
            } else if (this.Form.PonyDown && this.Form.PonyRight) {
                this.Form.PonyDirection = true;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.right = true;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = true;
                this.current_behavior.up = false;
            } else if (this.Form.PonyDown && this.Form.PonyLeft) {
                this.Form.PonyDirection = false;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.right = false;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = true;
                this.current_behavior.up = false;
            } else if (this.Form.PonyUp && this.Form.PonyLeft) {
                this.Form.PonyDirection = false;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Diagonal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.right = false;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = true;
                this.current_behavior.up = true;
            } else if (this.Form.PonyUp) {
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Vertical_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = false;
                this.current_behavior.up = true;
            } else if (this.Form.PonyDown) {
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Vertical_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.vertical = true;
                this.current_behavior.horizontal = false;
                this.current_behavior.up = false;
            } else if (this.Form.PonyRight) {
                this.Form.PonyDirection = true;
                this.current_behavior.right = true;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Horizontal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.vertical = false;
                this.current_behavior.horizontal = true;
            } else if (this.Form.PonyLeft) {
                this.Form.PonyDirection = false;
                this.current_behavior.right = false;
                this.current_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Horizontal_Only, this.Form.PonySpeed, null);
                speed = this.current_behavior.speed;
                this.current_behavior.vertical = false;
                this.current_behavior.horizontal = true;
            }
            if (this.Form.PonySpeed) {
                speed = this.current_behavior.speed * 2.0;
            }
        }
        this.Destination = this.current_behavior.Get_Destination(this.Current_Screen, this);
        double x_movement = 0.0;
        double y_movement = 0.0;
        if (this.Destination.x != 0 || this.Destination.y != 0) {
            double distance = Math.sqrt(Math.pow(this.Form.getLocation().getX() - this.Destination.getX(), 2.0) + Math.pow(this.Form.getLocation().getY() - this.Destination.getY(), 2.0));
            List<WinMain.Directions> direction = this.Get_Destination_Direction(this.Destination);
            try {
                if (direction.get(0) == WinMain.Directions.left) {
                    x_movement = (int)((this.Form.getLocation().getX() - this.Destination.getX()) / distance * -speed);
                    this.current_behavior.right = false;
                } else {
                    x_movement = (int)((this.Destination.getX() - this.Form.getLocation().getX()) / distance * speed);
                    this.current_behavior.right = true;
                }
                y_movement = (int)((this.Form.getLocation().getY() - this.Destination.getY()) / distance * -speed);
            }
            catch (Exception ex) {
                x_movement = 0.0;
                y_movement = 0.0;
            }
            if (distance <= (double)(this.current_behavior.current_image.getIconWidth() / 2)) {
                x_movement = 0.0;
                y_movement = 0.0;
                this.AtDestination = true;
                if (this.current_behavior.Linked_Behavior != null && this.current_behavior.speed != 0.0) {
                    this.current_behavior.end_time = new Date();
                    this.Destination = new Point();
                }
            } else {
                if (this.AtDestination) {
                    this.current_behavior.delay = 10;
                }
                if (this.current_behavior.delay > 0) {
                    this.AtDestination = false;
                    --this.current_behavior.delay;
                    return;
                }
                this.AtDestination = false;
            }
        } else {
            if (!this.current_behavior.right) {
                speed = -speed;
            }
            x_movement = this.current_behavior.horizontal ? speed : 0.0;
            double d = y_movement = this.current_behavior.vertical ? speed : 0.0;
            if (this.current_behavior.up) {
                if (y_movement > 0.0) {
                    y_movement = -y_movement;
                }
            } else if (y_movement < 0.0) {
                y_movement = -y_movement;
            }
        }
        Point new_location = new Point(current_location.x + (int)x_movement, current_location.y + (int)y_movement);
        if (this.IsPonyNearMouseCursor(current_location)) {
            this.Cursor_Halt = true;
            this.Paint();
            return;
        }
        if (this.Is_cursor_halted) {
            this.Cursor_Halt = false;
            return;
        }
        if (this.IsPonyNearMouseCursor(new_location)) {
            this.Cursor_Halt = false;
            if (this.Destination.x == 0 && this.Destination.y == 0) {
                this.current_behavior.Bounce(this, current_location, new_location, x_movement, y_movement, this.Current_Screen);
            } else {
                this.current_behavior = null;
            }
            return;
        }
        if (this.IsPonyOnScreen(current_location, new_location, WinMain.screens_to_use) && !this.IsPonyInAvoidanceArea(new_location, this.Current_Screen)) {
            Interaction Interact;
            this.Form.setLocation(new_location);
            this.Paint();
            if (Options.Interactions_Enabled && !this.Is_Interacting && (Interact = this.Is_In_Interaction_Range()) != null) {
                this.Start_Interaction(Interact);
            }
            return;
        }
        if (this.IsPonyInAvoidanceArea(current_location, WinMain.screens_to_use[0]) || !this.IsPonyOnScreen(new_location, current_location, WinMain.screens_to_use)) {
            this.Teleport();
            return;
        }
        if (this.Destination.x == 0 && this.Destination.y == 0) {
            this.current_behavior.Bounce(this, current_location, new_location, x_movement, y_movement, this.Current_Screen);
        } else if (this.current_behavior.follow_object == null) {
            this.current_behavior = null;
        } else {
            this.current_behavior.blocked = true;
            this.Paint();
        }
    }

    public void MouseOver_Mode() {
        if (this.Cursor_Halt && !this.Is_cursor_halted) {
            this.Is_cursor_halted = true;
            this.previous_behavior = this.current_behavior;
            this.current_behavior = this.Behaviors.get(0);
            for (Behavior behavior : this.Behaviors) {
                if (behavior.Allowed_Movement != WinMain.AllowedMoves.MouseOver) continue;
                this.current_behavior = behavior;
                break;
            }
            this.Paint();
        }
        if (!this.Cursor_Halt && this.Is_cursor_halted) {
            this.current_behavior = this.previous_behavior;
            this.Is_cursor_halted = false;
            this.Paint();
        }
    }

    private void Paint() {
        ImageIcon right_image = this.current_behavior.right_image;
        ImageIcon left_image = this.current_behavior.left_image;
        if (this.Destination.x != 0 || this.Destination.y != 0) {
            double horizonal = Math.abs(this.Destination.getX() - this.Form.getLocation().getX());
            double vertical = Math.abs(this.Destination.getY() - this.Form.getLocation().getY());
            Behavior appropriate_behavior = null;
            WinMain.AllowedMoves allowed_movement = WinMain.AllowedMoves.All;
            double distance = Math.sqrt(Math.pow(this.Form.getLocation().getX() - this.Destination.getX(), 2.0) + Math.pow(this.Form.getLocation().getY() - this.Destination.getY(), 2.0));
            if (distance >= (double)(this.current_behavior.current_image.getIconWidth() * 2) && (!(horizonal * 0.75 > vertical) || allowed_movement != WinMain.AllowedMoves.Horizontal_Only)) {
                switch (allowed_movement) {
                    case Vertical_Only: 
                    case Horizontal_Vertical: 
                    case Diagonal_Vertical: 
                    case All: {
                        allowed_movement = WinMain.AllowedMoves.Vertical_Only;
                        break;
                    }
                    default: {
                        allowed_movement = WinMain.AllowedMoves.None;
                    }
                }
            }
            if (this.AtDestination || this.current_behavior.blocked || this.current_behavior.speed == 0.0) {
                allowed_movement = WinMain.AllowedMoves.None;
            }
            appropriate_behavior = this.Is_Interacting ? this.GetAppropriateBehavior(allowed_movement, true, this.current_behavior) : this.GetAppropriateBehavior(allowed_movement, true, null);
            left_image = appropriate_behavior.left_image;
            right_image = appropriate_behavior.right_image;
        }
        this.current_behavior.current_image = this.current_behavior.right ? right_image : left_image;
        if (this.Form.CurrentImage == null || this.current_behavior.current_image != this.Form.Pony_Image.getIcon()) {
            this.current_behavior.current_image.getImage().flush();
            this.Form.Pony_Image.setIcon(this.current_behavior.current_image);
            this.Form.observeImage(this.current_behavior.current_image);
            this.Form.setSize(this.current_behavior.current_image.getIconWidth(), this.current_behavior.current_image.getIconHeight());
            this.Form.CurrentImage = this.current_behavior.current_image;
        }
        LinkedList<Effect_Form> Effects_to_Remove = new LinkedList<Effect_Form>();
        for (Effect_Form effect_Form : this.Active_Effects) {
            if (!effect_Form.isVisible()) {
                Effects_to_Remove.add(effect_Form);
                continue;
            }
            if (effect_Form.Close_On_New_Behavior && !this.current_behavior.Name.trim().equalsIgnoreCase(effect_Form.Behavior_Name.trim())) {
                effect_Form.setVisible(false);
                Effects_to_Remove.add(effect_Form);
            }
            if (!effect_Form.Follows) continue;
            effect_Form.setLocation(this.GetEffectLocation(effect_Form.Effect_Image.getIcon().getIconWidth(), effect_Form.Effect_Image.getIcon().getIconHeight(), effect_Form.direction, this.Form, effect_Form.centering));
        }
        for (Effect_Form effect_Form : Effects_to_Remove) {
            this.Active_Effects.remove(effect_Form);
        }
        if (Options.Effects_Enabled) {
            for (effect effect2 : this.current_behavior.Effects) {
                Date date = new Date();
                if (!((double)(date.getTime() - effect2.last_used.getTime()) >= effect2.repeat_delay * 1000.0) || effect2.repeat_delay == 0.0 && effect2.already_played_for_currentbehavior) continue;
                effect2.already_played_for_currentbehavior = true;
                Effect_Form effect_form = new Effect_Form();
                if (this.current_behavior.right) {
                    effect_form.setSize(effect2.right_image.getIconWidth(), effect2.right_image.getIconHeight());
                } else {
                    effect_form.setSize(effect2.left_image.getIconWidth(), effect2.right_image.getIconHeight());
                }
                effect_form.setVisible(true);
                if (effect2.duration != 0.0) {
                    effect_form.End_Time = new Date(new Date().getTime() + Math.round(effect2.duration * 1000.0));
                    effect_form.Close_On_New_Behavior = false;
                } else {
                    effect_form.End_Time = this.Is_cursor_halted ? new Date(new Date().getTime() + Math.round(this.current_behavior.MaxDuration * 1000.0)) : this.current_behavior.end_time;
                    effect_form.Close_On_New_Behavior = true;
                }
                effect_form.setName(String.valueOf(this.Name) + "'s " + effect2.name);
                if (this.current_behavior.right) {
                    effect2.right_image.getImage().flush();
                    effect_form.Effect_Image.setIcon(effect2.right_image);
                    effect_form.observeImage(effect2.right_image);
                    effect_form.direction = effect2.placement_direction_right;
                    effect_form.centering = effect2.centering_right;
                } else {
                    effect2.left_image.getImage().flush();
                    effect_form.Effect_Image.setIcon(effect2.left_image);
                    effect_form.observeImage(effect2.left_image);
                    effect_form.direction = effect2.placement_direction_left;
                    effect_form.centering = effect2.centering_left;
                }
                if (effect_form.direction == WinMain.Directions.random) {
                    effect_form.direction = this.GetRandomDirection(true);
                }
                if (effect_form.centering == WinMain.Directions.random) {
                    effect_form.centering = this.GetRandomDirection(true);
                }
                if (effect_form.direction == WinMain.Directions.random_not_center) {
                    effect_form.direction = this.GetRandomDirection(false);
                }
                if (effect_form.centering == WinMain.Directions.random_not_center) {
                    effect_form.centering = this.GetRandomDirection(false);
                }
                effect_form.Follows = effect2.follow;
                effect_form.effect_name = effect2.name;
                effect_form.Behavior_Name = this.current_behavior.Name;
                if (this.current_behavior.right) {
                    effect_form.setLocation(this.GetEffectLocation(effect2.right_image.getIconWidth(), effect2.right_image.getIconHeight(), effect_form.direction, this.Form, effect_form.centering));
                    effect_form.setSize(effect2.right_image.getIconWidth(), effect2.right_image.getIconHeight());
                } else {
                    effect_form.setLocation(this.GetEffectLocation(effect2.left_image.getIconWidth(), effect2.left_image.getIconHeight(), effect_form.direction, this.Form, effect_form.centering));
                    effect_form.setSize(effect2.left_image.getIconWidth(), effect2.left_image.getIconHeight());
                }
                WinMain.currentInstance.Active_Effects.add(effect_form);
                this.Active_Effects.add(effect_form);
                effect2.last_used = new Date();
            }
        }
    }

    public void SelectBehavior(Behavior Specified_Behavior) {
        double dice;
        if (this.Is_Interacting && Specified_Behavior == null) {
            this.Cancel_Interaction();
        }
        int selection = 0;
        if (Specified_Behavior == null) {
            int loop_total = 0;
            while (loop_total <= 200) {
                dice = WinMain.rand.nextDouble();
                selection = WinMain.rand.nextInt(this.Behaviors.size());
                if (dice <= this.Behaviors.get((int)selection).chance_of_occurance && !this.Behaviors.get((int)selection).Skip) {
                    this.Behaviors.get((int)selection).follow_object = null;
                    if (this.Current_Screen == null) {
                        this.Current_Screen = WinMain.screens_to_use[0];
                    }
                    this.Destination = this.Behaviors.get(selection).Get_Destination(this.Current_Screen, this);
                    if (this.Destination.x != 0 || this.Destination.y != 0 || this.Behaviors.get((int)selection).follow_object_name.length() <= 0) {
                        this.current_behavior = this.Behaviors.get(selection);
                        break;
                    }
                }
                ++loop_total;
            }
            if (loop_total > 200) {
                this.current_behavior = this.Behaviors.get(0);
            }
        } else {
            this.Destination = Specified_Behavior.Get_Destination(this.Current_Screen, this);
            if (this.Destination.x == 0 && this.Destination.y == 0 && Specified_Behavior.follow_object_name.length() > 0) {
                this.SelectBehavior(null);
                return;
            }
            this.current_behavior = Specified_Behavior;
            this.current_behavior.follow_object = null;
        }
        for (effect Effect : this.current_behavior.Effects) {
            Effect.already_played_for_currentbehavior = false;
        }
        this.current_behavior.end_time = new Date(new Date().getTime() + Math.round(WinMain.rand.nextDouble() * (this.current_behavior.MaxDuration - this.current_behavior.MinDuration) * 1000.0 + this.current_behavior.MinDuration * 1000.0));
        dice = WinMain.rand.nextDouble();
        this.current_behavior.right = dice >= 0.5;
        dice = WinMain.rand.nextDouble();
        if (this.current_behavior.Start_Line != null) {
            this.Form.Pony_Speak(this.Current_Screen, this.current_behavior.Start_Line, false);
        } else if (this.current_behavior.End_Line == null && this.current_behavior.follow_object_name.length() == 0 && dice <= (double)Options.Pony_Speak_Chance_Counter * 0.01) {
            this.Form.Pony_Speak(this.Current_Screen, null, false);
        }
        if (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.None || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.MouseOver || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Sleep) {
            this.current_behavior.horizontal = false;
            this.current_behavior.vertical = false;
            return;
        }
        LinkedList<WinMain.AllowedMoves> modes = new LinkedList<WinMain.AllowedMoves>();
        if (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.All || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Vertical_Only) {
            modes.add(WinMain.AllowedMoves.Vertical_Only);
        }
        if (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.All || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Vertical || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Only) {
            modes.add(WinMain.AllowedMoves.Diagonal_Only);
        }
        if (this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.All || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Diagonal_Horizontal || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Only || this.current_behavior.Allowed_Movement == WinMain.AllowedMoves.Horizontal_Vertical) {
            modes.add(WinMain.AllowedMoves.Horizontal_Only);
        }
        if (modes.size() == 0) {
            System.out.println("Unhandled movement type in SelectBehavior()");
            return;
        }
        selection = WinMain.rand.nextInt(modes.size());
        WinMain.AllowedMoves selected_mode = (WinMain.AllowedMoves)((Object)modes.get(selection));
        switch (selected_mode) {
            case Vertical_Only: {
                this.current_behavior.horizontal = false;
                this.current_behavior.vertical = true;
                break;
            }
            case Diagonal_Only: {
                this.current_behavior.horizontal = true;
                this.current_behavior.vertical = true;
                break;
            }
            case Horizontal_Only: {
                this.current_behavior.horizontal = true;
                this.current_behavior.vertical = false;
            }
        }
        dice = WinMain.rand.nextDouble();
        this.current_behavior.up = dice >= 0.5;
        dice = WinMain.rand.nextDouble();
        this.current_behavior.right = dice >= 0.5;
    }

    public void sleep() {
        for (Effect_Form effect2 : this.Active_Effects) {
            effect2.setVisible(false);
        }
        Behavior sleep_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.Sleep, false, null);
        if (sleep_behavior.Allowed_Movement != WinMain.AllowedMoves.Sleep) {
            sleep_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.MouseOver, false, null);
            if (sleep_behavior.Allowed_Movement != WinMain.AllowedMoves.MouseOver) {
                sleep_behavior = this.GetAppropriateBehavior(WinMain.AllowedMoves.None, false, null);
            }
        }
        this.SelectBehavior(sleep_behavior);
        this.current_behavior.end_time = new Date();
        this.Paint();
        this.sleeping = true;
    }

    public void Start_Interaction(Interaction interaction) {
        this.Is_Interaction_Initiator = true;
        this.Current_Interaction = interaction;
        this.SelectBehavior(interaction.Behavior_List.get(WinMain.rand.nextInt(interaction.Behavior_List.size())));
        for (effect Effect : this.current_behavior.Effects) {
            Effect.already_played_for_currentbehavior = false;
        }
        if (interaction.Select_All_Targets) {
            for (Pony pony : interaction.Interacts_With) {
                pony.Start_Interaction_As_Target(this.current_behavior.Name, this, interaction);
            }
        } else {
            interaction.Trigger.Start_Interaction_As_Target(this.current_behavior.Name, this, interaction);
        }
        this.Is_Interacting = true;
    }

    public void Start_Interaction_As_Target(String BehaviorName, Pony initiator, Interaction interaction) {
        for (Behavior behavior : this.Behaviors) {
            if (!BehaviorName.trim().equalsIgnoreCase(behavior.Name.trim())) continue;
            this.SelectBehavior(behavior);
            for (effect Effect : this.current_behavior.Effects) {
                Effect.already_played_for_currentbehavior = false;
            }
        }
        interaction.Initiator = initiator;
        this.Is_Interaction_Initiator = false;
        this.Current_Interaction = interaction;
        this.Is_Interacting = true;
    }

    public void Teleport() {
        GraphicsDevice[] UsableScreens = WinMain.screens_to_use;
        int dice = 0;
        GraphicsDevice random_screen = null;
        Point teleport_location = new Point();
        int i = 0;
        while (i < 300) {
            dice = WinMain.rand.nextInt(UsableScreens.length);
            random_screen = UsableScreens[dice];
            Rectangle screenBounds = random_screen.getDefaultConfiguration().getBounds();
            teleport_location = new Point(WinMain.rand.nextInt((int)screenBounds.getWidth()) + (int)screenBounds.getMinX(), WinMain.rand.nextInt((int)screenBounds.getHeight()) + (int)screenBounds.getMinY());
            if (!this.IsPonyInAvoidanceArea(teleport_location, random_screen)) break;
            ++i;
        }
        this.Form.setLocation(teleport_location);
    }

    public void Update() {
        if (this.Behaviors.size() > 0) {
            if (this.Form.should_be_sleeping) {
                if (this.sleeping) {
                    return;
                }
                this.sleep();
            } else if (this.sleeping) {
                this.wake_up();
            }
            if (this.current_behavior == null) {
                for (Effect_Form effect2 : this.Active_Effects) {
                    if (!effect2.Close_On_New_Behavior) continue;
                    effect2.setVisible(false);
                }
                this.Cancel_Interaction();
                this.SelectBehavior(null);
            } else if (this.current_behavior.end_time.getTime() - new Date().getTime() <= 0L && !this.Cursor_Halt && !this.Form.ManualControl) {
                if (this.current_behavior.End_Line != null) {
                    this.Form.Pony_Speak(this.Current_Screen, this.current_behavior.End_Line, false);
                }
                if (this.current_behavior.Linked_Behavior != null) {
                    this.SelectBehavior(this.current_behavior.Linked_Behavior);
                } else {
                    this.SelectBehavior(null);
                }
            } else if (this.current_behavior.end_time.getTime() - new Date().getTime() <= 0L && this.Cursor_Halt && !this.Form.ManualControl) {
                this.SelectBehavior(this.current_behavior);
            }
            if (this.Cursor_Halt || this.Is_cursor_halted) {
                this.MouseOver_Mode();
            }
            this.Move();
        }
    }

    public void wake_up() {
        this.sleeping = false;
    }
}

