/*
 * Decompiled with CFR 0.152.
 */
package JavaPonies;

import JavaPonies.JNumField;
import JavaPonies.JPreviewPanel;
import JavaPonies.WinMain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class Options
extends JDialog
implements ActionListener {
    public static boolean EnableDoubleBuffering = false;
    public static boolean EnableFullRedraw = false;
    public static boolean EnableShapeWindow = false;
    private static String os = System.getProperty("os.name").toLowerCase();
    public static boolean isUnix = os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    public static boolean isWindows = os.indexOf("win") >= 0;
    public static boolean isMac = os.indexOf("mac") >= 0;
    public static int Pony_Speak_Chance_Counter = 5;
    public static boolean Cursor_Avoidance_Enabled = true;
    public static int Cursor_zone_counter = 100;
    public static boolean Pony_Dragging_Enabled = true;
    public static int Max_Pony_Counter = 50;
    public static int Avoidance_Size_X = 0;
    public static int Avoidance_Size_Y = 0;
    public static int Avoidance_Loc_X = 0;
    public static int Avoidance_Loc_Y = 0;
    public static boolean Sounds_Enabled = false;
    public static boolean Effects_Enabled = true;
    public static boolean Interactions_Enabled = true;
    private static final int SC_Options = 1;
    private static final int SC_Monitors = 2;
    private static final int SC_PonyCount = 3;
    private JNumField txtSpeakingChance = null;
    private JCheckBox chkCursorAvoidance = null;
    private JNumField txtAvoidanceArea = null;
    private JCheckBox chkPonyDragging = null;
    private JCheckBox chkEnableSounds = null;
    private JCheckBox chkEnableEffects = null;
    private JCheckBox chkEnableInteractions = null;
    private JCheckBox chkEnableDoubleBuffer = null;
    private JCheckBox chkFullFrameRedraw = null;
    private JCheckBox chkShapeWindow = null;
    private JNumField txtMaxPonies = null;
    private JNumField txtAvoidanceSizeX = null;
    private JNumField txtAvoidanceSizeY = null;
    private JNumField txtAvoidancePointX = null;
    private JNumField txtAvoidancePointY = null;
    private JList lstMonitors = null;
    private JPreviewPanel avoidancePreview = null;
    private Timer updatePreview = new Timer(200, this);

    public Options(JFrame owner) {
        super((Frame)owner, true);
        this.initializeOptionControls();
    }

    public Options(JDialog owner) {
        super((Dialog)owner, true);
        this.initializeOptionControls();
    }

    public Options(Window owner) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initializeOptionControls();
    }

    public void initializeOptionControls() {
        GraphicsDevice screen;
        this.updatePreview.start();
        this.txtSpeakingChance = new JNumField(Integer.toString(Pony_Speak_Chance_Counter));
        this.txtSpeakingChance.setPreferredSize(new Dimension(60, 20));
        JLabel lblSpeakingChance = new JLabel("Pony Speaking random chance (%).");
        JLabel lblSpeakingChance2 = new JLabel("(Does not affect behaviors with speech unless 0)");
        this.chkCursorAvoidance = new JCheckBox("Ponies avoid cursor / stop when hovered over", Cursor_Avoidance_Enabled);
        this.txtAvoidanceArea = new JNumField(Integer.toString(Cursor_zone_counter));
        this.txtAvoidanceArea.setPreferredSize(new Dimension(60, 20));
        JLabel lblAvoidanceArea = new JLabel("Size of area around cursor to avoid.");
        this.chkPonyDragging = new JCheckBox("Ponies can be dragged around with the mouse", Pony_Dragging_Enabled);
        this.chkEnableSounds = new JCheckBox("Enable sounds", Sounds_Enabled);
        this.chkEnableEffects = new JCheckBox("Enable effects", Effects_Enabled);
        this.chkEnableInteractions = new JCheckBox("Enable interactions", Interactions_Enabled);
        this.chkEnableDoubleBuffer = new JCheckBox("*Double buffering", EnableDoubleBuffering);
        this.chkFullFrameRedraw = new JCheckBox("*Full frame redraw", EnableFullRedraw);
        this.chkShapeWindow = new JCheckBox("*Shaped windows", EnableShapeWindow);
        JLabel lblSpecialOptions = new JLabel("*Toggle these options if the animations behave badly");
        JLabel lblMonitors = new JLabel("Monitors to use:", 0);
        Vector<String> allscreens = new Vector<String>();
        GraphicsDevice[] graphicsDeviceArray = WinMain.ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            screen = graphicsDeviceArray[n2];
            allscreens.addElement(screen.getIDstring());
            ++n2;
        }
        this.lstMonitors = new JList(allscreens);
        graphicsDeviceArray = WinMain.screens_to_use;
        n = WinMain.screens_to_use.length;
        n2 = 0;
        while (n2 < n) {
            screen = graphicsDeviceArray[n2];
            this.lstMonitors.setSelectedValue(screen.getIDstring(), false);
            ++n2;
        }
        JLabel lblMonitorWarning = new JLabel("(You need at least one monitor selected)", 0);
        lblMonitorWarning.setForeground(Color.RED);
        JLabel lblMaxPonies = new JLabel("Max # of Ponies:");
        this.txtMaxPonies = new JNumField(Integer.toString(Max_Pony_Counter));
        this.txtMaxPonies.setPreferredSize(new Dimension(60, 20));
        JLabel lblMaxPonyWarning = new JLabel("<html>**** WARNING: Too many ponies might ****<br>**** make your computer slower  ****");
        lblMaxPonyWarning.setForeground(Color.RED);
        JLabel lblAvoidanceZone = new JLabel("Pony avoidance zone: ");
        JLabel lblAvoidanceSize = new JLabel("Size (X,Y)", 4);
        lblAvoidanceSize.setPreferredSize(new Dimension(80, 20));
        this.txtAvoidanceSizeX = new JNumField(Integer.toString(Avoidance_Size_X));
        this.txtAvoidanceSizeX.setPreferredSize(new Dimension(60, 20));
        this.txtAvoidanceSizeY = new JNumField(Integer.toString(Avoidance_Size_Y));
        this.txtAvoidanceSizeY.setPreferredSize(new Dimension(60, 20));
        JLabel lblAvoidancePoint = new JLabel("Location (X,Y)");
        lblAvoidancePoint.setPreferredSize(new Dimension(80, 20));
        this.txtAvoidancePointX = new JNumField(Integer.toString(Avoidance_Loc_X));
        this.txtAvoidancePointX.setPreferredSize(new Dimension(60, 20));
        this.txtAvoidancePointY = new JNumField(Integer.toString(Avoidance_Loc_Y));
        this.txtAvoidancePointY.setPreferredSize(new Dimension(60, 20));
        this.avoidancePreview = new JPreviewPanel();
        this.avoidancePreview.previewArea.setBounds(Avoidance_Loc_X, Avoidance_Loc_Y, Avoidance_Size_X, Avoidance_Size_Y);
        JButton btnSave = new JButton("SAVE");
        JButton btnLoad = new JButton("LOAD");
        JButton btnReset = new JButton("RESET");
        JButton btnClose = new JButton("Close");
        btnSave.setActionCommand("Save");
        btnSave.addActionListener(this);
        btnLoad.setActionCommand("Load");
        btnLoad.addActionListener(this);
        btnReset.setActionCommand("Reset");
        btnReset.addActionListener(this);
        btnClose.setActionCommand("Close");
        btnClose.addActionListener(this);
        JPanel speakingPanel = new JPanel();
        JPanel speakingPanelSub = new JPanel();
        ((FlowLayout)speakingPanelSub.getLayout()).setVgap(0);
        JPanel mouseAvoidancePanel = new JPanel();
        JPanel mouseAvoidancePanelSub = new JPanel();
        ((FlowLayout)mouseAvoidancePanelSub.getLayout()).setVgap(0);
        JPanel monitorsPanel = new JPanel(new BorderLayout());
        JPanel ponycountPanel = new JPanel();
        JPanel monitorponyPanel = new JPanel(new GridLayout(1, 2));
        JPanel screenAvoidancePanel = new JPanel();
        JPanel screenXAvoidancePanel = new JPanel();
        JPanel screenYAvoidancePanel = new JPanel();
        JPanel screenavoidanceSettingsPanel = new JPanel(new GridLayout(4, 1));
        JPanel screenavoidanceContainerPanel = new JPanel(new GridLayout(1, 2));
        JPanel buttonPanel = new JPanel();
        speakingPanel.add(this.txtSpeakingChance);
        speakingPanel.add(lblSpeakingChance);
        speakingPanel.add(lblSpeakingChance2);
        speakingPanel.add(this.chkCursorAvoidance);
        speakingPanelSub.add(this.txtAvoidanceArea);
        speakingPanelSub.add(lblAvoidanceArea);
        speakingPanel.add(speakingPanelSub);
        mouseAvoidancePanel.add(this.chkPonyDragging);
        mouseAvoidancePanel.add(this.chkEnableSounds);
        mouseAvoidancePanel.add(this.chkEnableEffects);
        mouseAvoidancePanel.add(this.chkEnableInteractions);
        mouseAvoidancePanelSub.add(this.chkEnableDoubleBuffer);
        mouseAvoidancePanelSub.add(this.chkFullFrameRedraw);
        mouseAvoidancePanelSub.add(this.chkShapeWindow);
        mouseAvoidancePanel.add(mouseAvoidancePanelSub);
        mouseAvoidancePanel.add(lblSpecialOptions);
        monitorsPanel.add((Component)lblMonitors, "North");
        monitorsPanel.add((Component)this.lstMonitors, "Center");
        monitorsPanel.add((Component)lblMonitorWarning, "South");
        ponycountPanel.add(lblMaxPonies);
        ponycountPanel.add(this.txtMaxPonies);
        ponycountPanel.add(lblMaxPonyWarning);
        monitorponyPanel.add(monitorsPanel);
        monitorponyPanel.add(ponycountPanel);
        screenAvoidancePanel.add(lblAvoidanceSize);
        screenAvoidancePanel.add(lblAvoidancePoint);
        screenXAvoidancePanel.add(this.txtAvoidanceSizeX);
        screenXAvoidancePanel.add(this.txtAvoidancePointX);
        screenYAvoidancePanel.add(this.txtAvoidanceSizeY);
        screenYAvoidancePanel.add(this.txtAvoidancePointY);
        screenavoidanceSettingsPanel.add(lblAvoidanceZone);
        screenavoidanceSettingsPanel.add(screenAvoidancePanel);
        screenavoidanceSettingsPanel.add(screenXAvoidancePanel);
        screenavoidanceSettingsPanel.add(screenYAvoidancePanel);
        screenavoidanceContainerPanel.add(screenavoidanceSettingsPanel);
        screenavoidanceContainerPanel.add(this.avoidancePreview);
        buttonPanel.add(btnSave);
        buttonPanel.add(btnLoad);
        buttonPanel.add(btnReset);
        buttonPanel.add(btnClose);
        this.setLayout(new BorderLayout());
        JPanel centerscreen = new JPanel(new GridLayout(4, 1));
        centerscreen.add(speakingPanel);
        centerscreen.add(mouseAvoidancePanel);
        centerscreen.add(monitorponyPanel);
        centerscreen.add(screenavoidanceContainerPanel);
        this.add((Component)centerscreen, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(507, 517);
        this.setResizable(false);
        this.setTitle("Options");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updatePreview) {
            this.updatePreview();
        } else if (e.getActionCommand() == "Save") {
            this.updateOptions();
            Options.saveOptions();
            JOptionPane.showMessageDialog(this, "Save completed!");
        } else if (e.getActionCommand() == "Load") {
            Options.loadOptions();
            this.refreshOptions();
        } else if (e.getActionCommand() == "Reset") {
            this.resetOptions();
        } else if (e.getActionCommand() == "Close") {
            this.updateOptions();
            this.setVisible(false);
        }
    }

    private void updatePreview() {
        int newAvoidance_Size_X = Integer.parseInt(this.txtAvoidanceSizeX.getText());
        int newAvoidance_Size_Y = Integer.parseInt(this.txtAvoidanceSizeY.getText());
        int newAvoidance_Loc_X = Integer.parseInt(this.txtAvoidancePointX.getText());
        int newAvoidance_Loc_Y = Integer.parseInt(this.txtAvoidancePointY.getText());
        this.avoidancePreview.previewArea.setBounds(newAvoidance_Loc_X, newAvoidance_Loc_Y, newAvoidance_Size_X, newAvoidance_Size_Y);
        this.avoidancePreview.repaint();
    }

    private void resetOptions() {
        this.txtSpeakingChance.setText(Integer.toString(5));
        this.chkCursorAvoidance.setSelected(true);
        this.txtAvoidanceArea.setText(Integer.toString(100));
        this.chkPonyDragging.setSelected(true);
        this.chkEnableSounds.setSelected(false);
        this.chkEnableEffects.setSelected(true);
        this.chkEnableInteractions.setSelected(true);
        this.chkEnableDoubleBuffer.setSelected(false);
        this.chkFullFrameRedraw.setSelected(isMac);
        this.chkShapeWindow.setSelected(isUnix);
        this.txtMaxPonies.setText(Integer.toString(50));
        this.txtAvoidanceSizeX.setText(Integer.toString(0));
        this.txtAvoidanceSizeY.setText(Integer.toString(0));
        this.txtAvoidancePointX.setText(Integer.toString(0));
        this.txtAvoidancePointY.setText(Integer.toString(0));
    }

    private void refreshOptions() {
        this.txtSpeakingChance.setText(Integer.toString(Pony_Speak_Chance_Counter));
        this.chkCursorAvoidance.setSelected(Cursor_Avoidance_Enabled);
        this.txtAvoidanceArea.setText(Integer.toString(Cursor_zone_counter));
        this.chkPonyDragging.setSelected(Pony_Dragging_Enabled);
        this.chkEnableSounds.setSelected(Sounds_Enabled);
        this.chkEnableEffects.setSelected(Effects_Enabled);
        this.chkEnableInteractions.setSelected(Interactions_Enabled);
        this.chkEnableDoubleBuffer.setSelected(EnableDoubleBuffering);
        this.chkFullFrameRedraw.setSelected(EnableFullRedraw);
        this.chkShapeWindow.setSelected(EnableShapeWindow);
        this.txtMaxPonies.setText(Integer.toString(Max_Pony_Counter));
        this.txtAvoidanceSizeX.setText(Integer.toString(Avoidance_Size_X));
        this.txtAvoidanceSizeY.setText(Integer.toString(Avoidance_Size_Y));
        this.txtAvoidancePointX.setText(Integer.toString(Avoidance_Loc_X));
        this.txtAvoidancePointY.setText(Integer.toString(Avoidance_Loc_Y));
    }

    private void updateOptions() {
        Pony_Speak_Chance_Counter = Integer.parseInt(this.txtSpeakingChance.getText());
        Cursor_Avoidance_Enabled = this.chkCursorAvoidance.isSelected();
        Cursor_zone_counter = Integer.parseInt(this.txtAvoidanceArea.getText());
        Pony_Dragging_Enabled = this.chkPonyDragging.isSelected();
        Sounds_Enabled = this.chkEnableSounds.isSelected();
        Effects_Enabled = this.chkEnableEffects.isSelected();
        Interactions_Enabled = this.chkEnableInteractions.isSelected();
        EnableDoubleBuffering = this.chkEnableDoubleBuffer.isSelected();
        EnableFullRedraw = this.chkFullFrameRedraw.isSelected();
        EnableShapeWindow = this.chkShapeWindow.isSelected();
        Max_Pony_Counter = Integer.parseInt(this.txtMaxPonies.getText());
        Avoidance_Size_X = Integer.parseInt(this.txtAvoidanceSizeX.getText());
        Avoidance_Size_Y = Integer.parseInt(this.txtAvoidanceSizeY.getText());
        Avoidance_Loc_X = Integer.parseInt(this.txtAvoidancePointX.getText());
        Avoidance_Loc_Y = Integer.parseInt(this.txtAvoidancePointY.getText());
        int iScreenCount = this.lstMonitors.getSelectedIndices().length;
        WinMain.screens_to_use = new GraphicsDevice[iScreenCount];
        int i = 0;
        GraphicsDevice[] graphicsDeviceArray = WinMain.ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice screen = graphicsDeviceArray[n2];
            Object[] objectArray = this.lstMonitors.getSelectedValues();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object screenID = objectArray[n4];
                if (screen.getIDstring().equals(screenID.toString())) {
                    WinMain.screens_to_use[i] = screen;
                    ++i;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void saveOptions() {
        try {
            PrintWriter fo = new PrintWriter(new FileOutputStream("./Settings.ini"));
            fo.println("1," + Cursor_zone_counter + "," + Avoidance_Loc_X + "," + Avoidance_Loc_Y + "," + Avoidance_Size_X + "," + Avoidance_Size_Y + "," + Max_Pony_Counter + "," + Pony_Dragging_Enabled + "," + Cursor_Avoidance_Enabled + "," + Pony_Speak_Chance_Counter + "," + Effects_Enabled + "," + Sounds_Enabled + "," + Interactions_Enabled + "," + EnableDoubleBuffering + "," + EnableFullRedraw + "," + EnableShapeWindow);
            GraphicsDevice[] graphicsDeviceArray = WinMain.screens_to_use;
            int n = WinMain.screens_to_use.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice screen = graphicsDeviceArray[n2];
                fo.println("2,\"" + screen.getIDstring() + "\"");
                ++n2;
            }
            int PonyNumber = 0;
            Component[] componentArray = WinMain.currentInstance.poniesPanel.getComponents();
            int n3 = componentArray.length;
            n = 0;
            while (n < n3) {
                Component ponypanel = componentArray[n];
                Component controls = ((JPanel)ponypanel).getComponent(1);
                Component ponycount = ((JPanel)controls).getComponent(3);
                JTextField textbox = (JTextField)ponycount;
                try {
                    int numbertoadd = Integer.parseInt(textbox.getText());
                    fo.println("3,\"" + WinMain.currentInstance.Selectable_Ponies.get((int)PonyNumber).Name + "\"," + numbertoadd);
                }
                catch (NumberFormatException ex) {
                    System.out.println("Error saving pony : " + PonyNumber);
                }
                ++PonyNumber;
                ++n;
            }
            fo.close();
        }
        catch (Exception ex) {
            System.out.println("Could not open file for save : Settings.ini");
            System.out.println(ex.getMessage());
        }
    }

    public static void loadOptions() {
        EnableFullRedraw = isMac;
        EnableShapeWindow = isUnix;
        try {
            int n;
            Scanner fi = new Scanner(new FileInputStream("./Settings.ini"));
            LinkedList<String> monitors = new LinkedList<String>();
            block19: while (fi.hasNextLine()) {
                String line = fi.nextLine();
                String[] columns = line.split(",");
                if (columns.length <= 0) continue;
                if (columns[0].equals(Integer.toString(1))) {
                    int i = 1;
                    while (i < columns.length) {
                        switch (i) {
                            case 1: {
                                Cursor_zone_counter = Integer.parseInt(columns[1]);
                                break;
                            }
                            case 2: {
                                Avoidance_Loc_X = Integer.parseInt(columns[2]);
                                break;
                            }
                            case 3: {
                                Avoidance_Loc_Y = Integer.parseInt(columns[3]);
                                break;
                            }
                            case 4: {
                                Avoidance_Size_X = Integer.parseInt(columns[4]);
                                break;
                            }
                            case 5: {
                                Avoidance_Size_Y = Integer.parseInt(columns[5]);
                                break;
                            }
                            case 6: {
                                Max_Pony_Counter = Integer.parseInt(columns[6]);
                                break;
                            }
                            case 7: {
                                Pony_Dragging_Enabled = Boolean.parseBoolean(columns[7]);
                                break;
                            }
                            case 8: {
                                Cursor_Avoidance_Enabled = Boolean.parseBoolean(columns[8]);
                                break;
                            }
                            case 9: {
                                Pony_Speak_Chance_Counter = Integer.parseInt(columns[9]);
                                break;
                            }
                            case 10: {
                                Effects_Enabled = Boolean.parseBoolean(columns[10]);
                                break;
                            }
                            case 11: {
                                Sounds_Enabled = Boolean.parseBoolean(columns[11]);
                                break;
                            }
                            case 12: {
                                Interactions_Enabled = Boolean.parseBoolean(columns[12]);
                                break;
                            }
                            case 13: {
                                EnableDoubleBuffering = Boolean.parseBoolean(columns[13]);
                                break;
                            }
                            case 14: {
                                EnableFullRedraw = Boolean.parseBoolean(columns[14]);
                                break;
                            }
                            case 15: {
                                EnableShapeWindow = Boolean.parseBoolean(columns[15]);
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                if (columns[0].equals(Integer.toString(2))) {
                    monitors.add(columns[1].replace('\"', ' ').trim());
                    continue;
                }
                if (!columns[0].equals(Integer.toString(3))) continue;
                int PonyNumber = 0;
                Component[] componentArray = WinMain.currentInstance.poniesPanel.getComponents();
                int n2 = componentArray.length;
                n = 0;
                while (n < n2) {
                    Component ponypanel = componentArray[n];
                    Component controls = ((JPanel)ponypanel).getComponent(1);
                    Component ponycount = ((JPanel)controls).getComponent(3);
                    JTextField textbox = (JTextField)ponycount;
                    if (WinMain.currentInstance.Selectable_Ponies.get((int)PonyNumber).Name.equals(columns[1].replace('\"', ' ').trim())) {
                        textbox.setText(columns[2]);
                        continue block19;
                    }
                    ++PonyNumber;
                    ++n;
                }
            }
            int iScreenCount = monitors.size();
            WinMain.screens_to_use = new GraphicsDevice[iScreenCount];
            int i = 0;
            GraphicsDevice[] graphicsDeviceArray = WinMain.ge.getScreenDevices();
            n = graphicsDeviceArray.length;
            int n3 = 0;
            while (n3 < n) {
                GraphicsDevice screen = graphicsDeviceArray[n3];
                for (String screenID : monitors) {
                    if (!screen.getIDstring().equals(screenID)) continue;
                    WinMain.screens_to_use[i] = screen;
                    ++i;
                    break;
                }
                ++n3;
            }
            fi.close();
        }
        catch (Exception ex) {
            System.out.println("Could not open file for load : Settings.ini");
            System.out.println(ex.getMessage());
        }
    }
}

