/*
 * Decompiled with CFR 0.152.
 */
package JavaPonies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class JNumField
extends JFormattedTextField
implements ActionListener {
    public JNumField() {
        super(NumberFormat.getInstance());
        this.initializeNumField();
    }

    @Override
    public String getText() {
        String text = super.getText();
        try {
            Integer.parseInt(text);
            return text;
        }
        catch (Exception ex) {
            return "0";
        }
    }

    public JNumField(String text) {
        super(NumberFormat.getInstance());
        this.setText(text);
        this.initializeNumField();
    }

    private void initializeNumField() {
        this.setLayout(new BorderLayout());
        JButton pressup = new JButton();
        pressup.setActionCommand("up");
        pressup.addActionListener(this);
        JButton pressdown = new JButton();
        pressdown.setActionCommand("down");
        pressdown.addActionListener(this);
        GridLayout buttongrid = new GridLayout(2, 1);
        buttongrid.setHgap(0);
        buttongrid.setVgap(0);
        JPanel buttons = new JPanel(buttongrid);
        buttons.setPreferredSize(new Dimension(20, 20));
        buttons.add(pressup);
        buttons.add(pressdown);
        this.add((Component)buttons, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "up") {
            int i = Integer.parseInt(this.getText());
            this.setText(Integer.toString(++i));
        } else if (e.getActionCommand() == "down") {
            int i = Integer.parseInt(this.getText());
            i = Math.max(0, i - 1);
            this.setText(Integer.toString(i));
        }
    }
}

