﻿Module enhsplit

    ' A variant of the Split function, that offers the following improvements
    '   You can pass text qualifier as the third argument and optionally specify
    '   to treat consecutive occurrences of delimiters as one
    '   For example, the following source text contains comma inside one of the 
    ' fields, so the
    '   regular Split function will parse it incorrectly:
    '   "zzzzzzzzzz","xxxxxx","yyyyyyyyy, wwww, gggggggg, ppppppp",,,,10,,2,
    ' ,,
    '   Also, it has some empty fields, which do not have any values or text 
    ' qualifiers.
    '   In this case, we need to specify comma as delimiter and double quote 
    ' character As Text
    '   qualifier, and do not treat consecutive occurrences of delimiters as one
    '
    '   Usage:
    '   Dim res() As String
    '   res() = SplitWithQualifiers("""zzzzzzzzzz"",""xxxxxx"",""yyyyyyyyy, 
    ' wwww, gggggggg, ppppppp"",,,,10,,2,,,", ",", """", False)

    Public Function SplitWithQualifiers(ByVal SourceText As String, ByVal TextDelimiter As String, ByVal TextQualifier As String, Optional ByVal ClosingTextQualifier As String = "", _
                                        Optional TextQualifier2 As String = "", Optional ClosingTextQualifier2 As String = "") As String()
        Dim strTemp
        Dim strRes() As String, I As Long, J As Long, A As String, B As String, blnStart As Boolean
        B = ""


        If TextDelimiter <> " " Then SourceText = Trim$(SourceText)
        If ClosingTextQualifier <> "" Then SourceText = Replace(SourceText, ClosingTextQualifier, TextQualifier)

        Dim in_second_qualifiers As Boolean = False

        If InStr(SourceText, "asleep") <> 0 Then
            Dim oops = 1
        End If

        strTemp = Split(SourceText, TextDelimiter)
        For I = 0 To UBound(strTemp)
            J = InStr(1, strTemp(I), TextQualifier, vbTextCompare)
            If J Then
                A = Trim(Replace(strTemp(I), TextQualifier, ""))
                Dim C = Replace(strTemp(I), TextQualifier, "")
                Select Case Trim(strTemp(I))
                    Case TextQualifier & A & TextQualifier '  "xxx"
                        B = B & A & vbCrLf
                        blnStart = False '
                    Case TextQualifier & C & TextQualifier ' " xxx "
                        B = B & C & vbCrLf
                        blnStart = False '
                    Case TextQualifier & A     '   "xxx
                        If in_second_qualifiers Then
                            B = B & TextQualifier & A & TextDelimiter
                            blnStart = True
                        Else
                            B = B & A & TextDelimiter
                            blnStart = True
                        End If
                     
                    Case A       '  xxx
                        B = B & A & TextDelimiter
                        blnStart = False
                    Case A & TextQualifier   '   xxx"
                        If in_second_qualifiers Then
                            B = B & C & TextQualifier & TextDelimiter
                            blnStart = False
                        Else
                            B = B & C & vbCrLf
                            blnStart = False
                        End If
                    Case Else
                        If InStr(A, ClosingTextQualifier2) <> 0 Then
                            If in_second_qualifiers Then
                                B = B & Replace(A, ClosingTextQualifier2, TextQualifier & ClosingTextQualifier2) & vbCrLf
                            Else
                                B = B & TextQualifier & Replace(A, ClosingTextQualifier2, TextQualifier & ClosingTextQualifier2) & vbCrLf
                            End If

                            blnStart = False
                            in_second_qualifiers = False
                        Else

                            If InStr(A, TextQualifier2) <> 0 Then

                                If I < UBound(strTemp) Then
                                    If InStr(strTemp(I + 1), ClosingTextQualifier2) = 0 Then
                                        Dim oops = 1
                                        B = B & Replace(A, TextQualifier2, TextQualifier2 & TextQualifier) & TextDelimiter
                                        blnStart = True
                                        in_second_qualifiers = True
                                        Exit Select
                                    End If
                                End If

                                B = B & Replace(A, TextQualifier2, TextQualifier2 & TextQualifier) & TextQualifier & TextDelimiter
                                blnStart = False

                            End If
                        End If

                End Select
            Else
                If blnStart Then
                    B = B & strTemp(I) & TextDelimiter
                Else
                    B = B & strTemp(I) & vbCrLf
                End If
            End If
        Next I
        If B <> "" Then
            B = Left$(B, Len(B) - 2)
            strRes = Split(B, vbCrLf)
        Else
            ReDim strRes(0)
            strRes(0) = SourceText
        End If
        SplitWithQualifiers = strRes
    End Function



End Module
