﻿Imports System.Windows.Forms

Public Class New_Speech


    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Trim(Name_Textbox.Text) = "" Then
            MsgBox("You must enter a name for the new speech.")
            Exit Sub
        End If

        If Trim(Text_TextBox.Text) = "" Then
            MsgBox("You need to enter some sort of text for the pony to say.")
            Exit Sub

        End If

        Dim filename = My.Forms.Pony_Editor.get_filename(Sound_Textbox.Text)


        Dim new_speech As New Pony.Behavior.Speaking_Line(My.Forms.Pony_Editor.Preview_Pony.Name, _
                                                          Name_Textbox.Text, _
                                                          Text_TextBox.Text, _
                                                          Replace(Sound_Textbox.Text, filename, ""), _
                                                          filename, _
                                                          Not Random_Checkbox.Checked, Group_NumberBox.Value)

        My.Forms.Pony_Editor.Preview_Pony.Speaking_Lines.Add(new_speech)

        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click

        Me.Close()
    End Sub

    Private Sub New_Behavior_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Text_TextBox.Text = ""
        Name_Textbox.Text = ""


    End Sub


    Private Sub SetSound_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetSound_Button.Click

        OpenSoundDialog.Filter = "MP3 Files (*.mp3)|*.mp3"
        OpenSoundDialog.InitialDirectory = My.Forms.Main.Install_Location

        Dim sound_path = Nothing

        If OpenSoundDialog.ShowDialog() = DialogResult.OK Then
            sound_path = OpenSoundDialog.FileName
        End If

        If IsNothing(sound_path) Then
            Exit Sub
        End If

        Dim new_path = My.Forms.Pony_Editor.Preview_Pony.Path_to_Files & System.IO.Path.DirectorySeparatorChar & _
            My.Forms.Pony_Editor.get_filename(sound_path)

        If new_path <> sound_path Then
            My.Computer.FileSystem.CopyFile(sound_path, new_path, True)
        End If

        Sound_Textbox.Text = sound_path

    End Sub


End Class
