﻿Imports System.Windows.Forms

Public Class New_Pony

    Dim new_pony_path = ""

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Trim(Name_Textbox.Text) = "" Then
            MsgBox("You must enter a name for the new pony.")
            Exit Sub
        End If

        If InStr(Name_Textbox.Text, ",") <> 0 Then
            MsgBox("The pony's name can't have a comma in it.")
            Exit Sub
        End If

        For Each Pony In My.Forms.Main.Selectable_Ponies
            If LCase(Pony.Name) = LCase(Trim(Name_Textbox.Text)) Then
                MsgBox("A pony with this name already exists!  Please select another name or rename the other pony.")
                Exit Sub
            End If
        Next

        If InStr(Name_Textbox.Text, "{") <> 0 Then
            MsgBox("The pony's name can't have a { in it.")
            Exit Sub
        End If

        If InStr(Name_Textbox.Text, "}") <> 0 Then
            MsgBox("The pony's name can't have a } in it.")
            Exit Sub
        End If

        If My.Forms.Pony_Editor.Preview_Pony.Behaviors.Count = 0 Then
            MsgBox("You need to create at least one new behavior before the pony can be saved.")
            Exit Sub
        End If

        Try

            My.Forms.Pony_Editor.SavePony(new_pony_path)

        Catch ex As Exception
            MsgBox("Unable to save pony! Details: " & ex.Message)
        End Try
        Me.DialogResult = DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub New_Pony_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Name_Textbox.Text = ""
        Name_Textbox.Enabled = True
        Right_ImageBox.Image = Nothing
    End Sub

    Private Sub First_Behavior_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles First_Behavior_Button.Click

        If Trim(Name_Textbox.Text) = "" Then
            MsgBox("You must enter a name for the new pony first.")
            Exit Sub
        End If

        Name_Textbox.Enabled = False

        Try
            new_pony_path = My.Forms.Main.Install_Location & System.IO.Path.DirectorySeparatorChar & Name_Textbox.Text & System.IO.Path.DirectorySeparatorChar
            If My.Computer.FileSystem.DirectoryExists(new_pony_path) Then
                Throw New Exception("Path already exists! Won't overwrite whatever is there: " & new_pony_path)
            End If
            My.Computer.FileSystem.CreateDirectory(new_pony_path)
            My.Forms.Pony_Editor.Preview_Pony.Path_to_Files = new_pony_path
        Catch ex As Exception
            MsgBox("Unable to create directory for new pony:  " & ex.Message)
            Name_Textbox.Enabled = True
            Exit Sub
        End Try

        My.Forms.Pony_Editor.Preview_Pony.Name = Name_Textbox.Text

        My.Forms.New_Behavior.ShowDialog()

        For Each behavior In My.Forms.Pony_Editor.Preview_Pony.Behaviors
            If System.IO.File.Exists(behavior.right_image_path) Then
                Right_ImageBox.Image = Image.FromFile(behavior.right_image_path)
                Exit For
            End If
        Next

    End Sub

End Class
