﻿Imports System.Windows.Forms

Public Class New_Behavior

    Dim follow_name = ""
    Dim follow_x = 0
    Dim follow_y = 0
    Dim left_image_path = ""
    Dim right_image_path = ""

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click

        If Trim(Name_Textbox.Text) = "" Then
            MsgBox("You must enter a name for the new behavior.")
            Exit Sub
        End If

        For Each behavior In My.Forms.Pony_Editor.Preview_Pony.Behaviors
            If LCase(behavior.Name) = LCase(Name_Textbox.Text) Then
                MsgBox("Behavior '" & behavior.Name & "' already exists for this pony.  Please select another name.")
                Exit Sub
            End If
        Next

        If InStr(Name_Textbox.Text, ",") <> 0 Then
            MsgBox("The behavior name can't have a comma in it.")
            Exit Sub
        End If

        If InStr(Name_Textbox.Text, "{") <> 0 Then
            MsgBox("The behavior name can't have a { in it.")
            Exit Sub
        End If

        If InStr(Name_Textbox.Text, "}") <> 0 Then
            MsgBox("The behavior name can't have a } in it.")
            Exit Sub
        End If

        If left_image_path = "" OrElse right_image_path = "" Then
            MsgBox("You need to select two pictures - one left, one right.")
            Exit Sub
        End If

        If Movement_Combobox.SelectedIndex = -1 Then
            MsgBox("You need to select a movement type.")
            Exit Sub
        End If

        Dim chance = Trim(Replace(Chance_Box.Text, "%", ""))

        If Not IsNumeric(chance) Then
            MsgBox("You need to enter a % chance that the behavior has to occur (or you may have entered an invalid one).")
            Exit Sub
        End If

        If Not IsNumeric(Min_Box.Text) OrElse Not IsNumeric(Max_Box.Text) Then
            MsgBox("You need to enter minimum and maximum durations of the behavior in seconds.")
            Exit Sub
        End If

        If CDbl(Min_Box.Text) > CDbl(Max_Box.Text) Then
            MsgBox("The maximum duration needs to be larger than the minimum duration.")
            Exit Sub
        End If

        If CDbl(chance) < 0 OrElse CDbl(Min_Box.Text) < 0 OrElse CDbl(Max_Box.Text) < 0 Then
            MsgBox("You entered a negative value for % chance, Min duration, or Max duration.  Please correct this.")
            Exit Sub
        End If

        If Not IsNumeric(Speed_Box.Text) Then
            MsgBox("You need to enter a movement speed (or entered an invalid one)")
            Exit Sub

        End If

        Dim linked_behavior = ""

        linked_behavior = Link_Box.Text

        Dim skip = DontRunRandomly_CheckBox.Checked

        Dim start_line = ""
        If StartSpeech_Box.SelectedIndex <> -1 Then
            start_line = StartSpeech_Box.SelectedItem
        End If
        If start_line = "None" Then start_line = ""

        Dim end_line = ""
        If EndSpeech_Box.SelectedIndex <> -1 Then
            end_line = EndSpeech_Box.SelectedItem
        End If

        If end_line = "None" Then end_line = ""

        My.Forms.Pony_Editor.Preview_Pony.Add_Behavior(True, Name_Textbox.Text, _
                                                       chance / 100, _
                                                       Max_Box.Text, _
                                                       Min_Box.Text, _
                                                       Speed_Box.Text, _
                                                       right_image_path, _
                                                       left_image_path, _
                                                        My.Forms.Pony_Editor.String_ToMovement(Movement_Combobox.SelectedItem), _
                                                       linked_behavior, _
                                                       start_line, _
                                                       end_line, _
                                                       skip, _
                                                       follow_x, _
                                                       follow_x, _
                                                       follow_name,
                                                    False, "", "", Nothing, Nothing, DontRepeat_CheckBox.Checked, Group_Numberbox.Value)


        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click

        Me.Close()
    End Sub

    Private Sub New_Behavior_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Link_Box.Items.Clear()
        EndSpeech_Box.Items.Clear()
        StartSpeech_Box.Items.Clear()
        Movement_Combobox.Items.Clear()

        Chance_Box.Text = ""
        Min_Box.Text = ""
        Max_Box.Text = ""
        Speed_Box.Text = ""
        follow_name = ""
        follow_x = 0
        follow_y = 0
        Name_Textbox.Text = ""

        right_image_path = ""
        left_image_path = ""

        Right_ImageBox.Image = Nothing
        Left_ImageBox.Image = Nothing

        With My.Forms.Pony_Editor
 
            Dim linked_behavior_list As DataGridViewComboBoxColumn = .Pony_Behaviors_Grid.Columns(My.Forms.Pony_Editor.B_Grid.Link)
            For Each item In linked_behavior_list.Items
                Link_Box.Items.Add(item)
            Next

            Dim speech_list As DataGridViewComboBoxColumn = .Pony_Behaviors_Grid.Columns(My.Forms.Pony_Editor.B_Grid.Start_Speech)
            For Each item In speech_list.Items
                StartSpeech_Box.Items.Add(item)
                EndSpeech_Box.Items.Add(item)
            Next

            Dim movement_list As DataGridViewComboBoxColumn = .Pony_Behaviors_Grid.Columns(My.Forms.Pony_Editor.B_Grid.Movement)
            For Each item In movement_list.Items
                Movement_Combobox.Items.Add(item)
            Next

        End With

        Follow_Box.Text = "None"

    End Sub

    Private Sub Left_Image_Set_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Left_Image_Set_Button.Click

        If Not IsNothing(Left_ImageBox.Image) Then
            Left_ImageBox.Image.Dispose()
            Left_ImageBox.Image = Nothing
        End If
       
        Dim path = My.Forms.Pony_Editor.Add_Picture()
        If IsNothing(path) Then Exit Sub
        Left_ImageBox.Image = Image.FromFile(path)

        left_image_path = path

        My.Forms.Pony_Editor.Image_Size_Check(Left_ImageBox.Image.Size)

        Dim runtime = GetGifTotalRuntime(Left_ImageBox.Image)

        If runtime <> 0 AndAlso My.Forms.GifRuntime_Dialog.ShowDialog = DialogResult.OK Then
            Min_Box.Text = runtime
            Max_Box.Text = runtime
        End If

    End Sub

    Private Sub Right_Image_Set_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Right_Image_Set_Button.Click

        If Not IsNothing(Right_ImageBox.Image) Then
            Right_ImageBox.Image.Dispose()
            Right_ImageBox.Image = Nothing
        End If

        Dim path = My.Forms.Pony_Editor.Add_Picture()
        If IsNothing(path) Then Exit Sub
        Right_ImageBox.Image = Image.FromFile(path)

        right_image_path = path

        My.Forms.Pony_Editor.Image_Size_Check(Right_ImageBox.Image.Size)

        Dim runtime = GetGifTotalRuntime(Right_ImageBox.Image)

        If runtime <> 0 AndAlso My.Forms.GifRuntime_Dialog.ShowDialog = DialogResult.OK Then
            Min_Box.Text = runtime
            Max_Box.Text = runtime
        End If

    End Sub

    Private Sub SetFollow_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetFollow_Button.Click

        Dim new_behavior As New Pony.Behavior

        My.Forms.Follow_Object.Change_Behavior(new_behavior)
        My.Forms.Follow_Object.ShowDialog()

        If new_behavior.follow_object_name <> "" Then
            follow_name = new_behavior.follow_object_name
            'MsgBox("Note:  If you wish to have this behavior follow another pony, you should change the movement type to 'All'."
        Else
            If new_behavior.destination_xcoord <> 0 AndAlso new_behavior.destination_ycoord <> 0 Then
                follow_name = new_behavior.destination_xcoord & " , " & new_behavior.destination_ycoord
            End If
        End If

        Follow_Box.Text = follow_name
        follow_name = new_behavior.follow_object_name
        follow_x = new_behavior.destination_xcoord
        follow_y = new_behavior.destination_ycoord

    End Sub

    Friend Function GetGifTotalRuntime(ByVal image As Image) As Double

        Try
            Dim gif_dimensions = New System.Drawing.Imaging.FrameDimension(image.FrameDimensionsList(0))
            Dim gif_framecount = image.GetFrameCount(gif_dimensions)

            Dim PropertyTagFrameDelay As Integer = &H5100 '"from gdiplugimaging.h"

            Dim propertyitem = image.GetPropertyItem(PropertyTagFrameDelay)

            Dim bytes() = propertyitem.Value

            Dim delays(gif_framecount) As Integer

            For frame = 0 To gif_framecount - 1
                delays(frame) = BitConverter.ToInt32(bytes, frame * 4)
            Next

            Dim total_delay As Integer = 0
            For Each delay In delays
                total_delay += delay
            Next

            Return total_delay / 100

        Catch ex As Exception

            'could not get timing info.
            Return 0

        End Try
    End Function

End Class
