BrainPuff
=========

BrainPuff is a programming language based on Brainfuck and the speech of everypony's favorite fluffy pony, Fluffle Puff.

Conversion table
----------------
```
BF  Fluffle Puff
+   pf
-   bl
>   b
<   t
.   !
,   ?
[   *gasp*
]   *pomf*
```
Examples
--------
Sample hello world in Brainfuck:
```
++++++++++[>+++++++>++++++++++>+++>+<<<<-]>++.>+.+++++++..+++.>++.<<+++++++++++++++.>.+++.------.--------.>+.>.
```

Sample hello world translated in BrainPuff:
```
pfpfpfpfpfpfpfpfpfpf*gasp*bpfpfpfpfpfpfpfbpfpfpfpfpfpfpfpfpfpfbpfpfpfbpfttttbl*pomf*bpfpf!bpf!pfpfpfpfpfpfpf!!pfpfpf!bpfpf!ttpfpfpfpfpfpfpfpfpfpfpfpfpfpfpf!b!pfpfpf!blblblblblbl!blblblblblblblbl!bpf!b!
```

Output:
```
Hello World!
```
Compile and Run
---------------
This project comes with a reference implementation written in C++.

Just install ```flex```, then type ```make``` in a Linux, Mac OS X or Windows (with Cygwin) command prompt. Then you can run it like this:
```
% cat hello.fp | ./flufflepuff
```
```
% ./flufflepuff < hello.fp
```
```
% ./flufflepuff hello.fp
```
That's really simple. For now.

Implementations
---------------
This is the reference implementation released under GPL, so feel free to make your own implementation in other languages. You'll want to link back to the [original project's page](https://github.com/juju2143/flufflepuff) on your project page and tell me about it so I can link you here, it will be greatly appreciated.

* [Implementation in Javascript by Lunar Fire](http://newlunarfire.github.io/brainpuff/)
* [Brainfuck/Brainpuff converter by Jared M.F.](https://gist.github.com/JaredMFProgramming/a914a5a22cb893c913ec7c0a84d602d2)

Links
-----
* [Esolangs](http://esolangs.org/wiki/Fluffle_Puff)
* [Fluffle Puff's blog](http://askflufflepuff.tumblr.com)
* [Juju the Developer's website](http://juju2143.ca)
* [Twitter](http://twitter.com/juju2143)
* [Tumblr](http://toasters.rocks)

![Fluffle Puff](http://th02.deviantart.net/fs70/PRE/i/2013/110/f/6/fluffle_puff_by_mixermike622-d4l5y4r.png "Fluffle Puff")
