var flambeCanvas = document.getElementById("gameCanvas");

/**
 * Get Audio Manager functions (call from Gamecore)
 * 
 */
function get_audioManager()
{
	return audioEngine;
}

/**
 * All Audio Manager functions
 * 
 */
var audioEngine =
{
	playSound:function(name,interrupt,delay,offset,loop,volume,pan)
	{
		return createjs.Sound.play(name,interrupt,delay,offset,loop,volume,pan);
	},
	
	setMasterVolume:function(value)
	{
		createjs.Sound.setVolume(value);
	},
	
	checkReady:function()
	{
		return createjs.Sound.isReady();
	},
	
	checkIfSndLoaded:function(snd)
	{
		return createjs.Sound.loadComplete(snd);
	}
}

var funcToCallOnLoad = null;

/**
 * Audio Manager
 * 
 */
function audioManager() 
{
	var context = this;
	var eventType = "";
	var nbSoundsToLoad = 0;
	var nbSoundsLoaded = 0;
	
	/**
	 * Init
	 * 
	 */
	function init()
	{		
		var mobile = navigator.userAgent.match(/iPhone|iPad|iPod/i) || navigator.userAgent.match(/Android/i) || (navigator.userAgent.indexOf("Silk") !== -1);
		
		if (!mobile)
		{
			// Web
			handleClick();			
		}
		else
		{
			// Mobile
			eventType = "touchstart";
			// Register event for initialization
			flambeCanvas.addEventListener(eventType, handleClick, false);
		}		
	}

	/**
	 * Click event
	 * 
	 */
	function handleClick()
	{
		// Remove event
		if (eventType != "") flambeCanvas.removeEventListener(eventType, handleClick, false);
		
		/*console.log(createjs.HTMLAudioPlugin.isSupported());
		console.log(createjs.WebAudioPlugin.isSupported());*/
		
		// Init audio
		if (!createjs.Sound.isReady())
		{			
			// Init engine
			if (!createjs.Sound.initializeDefaultPlugins()) {				
				funcToCallOnLoad();
				return;
			}
			
			// Init all sound
			var audioPath = "assets-html/audio/";
			var manifest = [
				{id:"LifeEquestria", src:audioPath+"LifeEquestria.mp3|"+audioPath+"LifeEquestria.ogg"},
				{id:"BarnSong", src:audioPath+"BarnSong.mp3|"+audioPath+"BarnSong.ogg"},
				{id:"CutieMark", src:audioPath+"CutieMark.mp3|"+audioPath+"CutieMark.ogg"},
				{id:"MorningPonyville", src:audioPath+"MorningPonyville.mp3|"+audioPath+"MorningPonyville.ogg"},
				{id:"TrueFriend", src:audioPath+"TrueFriend.mp3|"+audioPath+"TrueFriend.ogg"},
				{id:"Final", src:audioPath+"Final.mp3|"+audioPath+"Final.ogg"},
				{id:"music_menu", src:audioPath+"music_menu.mp3|"+audioPath+"music_menu.ogg"},
				{id:"Major_Treasure_Found", src:audioPath+"Major_Treasure_Found.mp3|"+audioPath+"Major_Treasure_Found.ogg"},
				{id:"Collectible_Found_01", src:audioPath+"Collectible_Found_01.mp3|"+audioPath+"Collectible_Found_01.ogg"},
				{id:"Collectible_Found_02", src:audioPath+"Collectible_Found_02.mp3|"+audioPath+"Collectible_Found_02.ogg"},
				{id:"Collectible_Found_03", src:audioPath+"Collectible_Found_03.mp3|"+audioPath+"Collectible_Found_03.ogg"},
				{id:"Button_Click_01", src:audioPath+"Button_Click_01.mp3|"+audioPath+"Button_Click_01.ogg"},
				{id:"Button_Click_02", src:audioPath+"Button_Click_02.mp3|"+audioPath+"Button_Click_02.ogg"},
				{id:"Button_Click_03", src:audioPath+"Button_Click_03.mp3|"+audioPath+"Button_Click_03.ogg"},
				{id:"Rarity_Cameo_Action", src:audioPath+"Rarity_Cameo_Action.mp3|"+audioPath+"Rarity_Cameo_Action.ogg"},
				{id:"Rarity_Cameo_Intro_and_Conclu", src:audioPath+"Rarity_Cameo_Intro_and_Conclu.mp3|"+audioPath+"Rarity_Cameo_Intro_and_Conclu.ogg"},
				{id:"Palace_Guards", src:audioPath+"Palace_Guards.mp3|"+audioPath+"Palace_Guards.ogg"},
				{id:"Game_Launch", src:audioPath+"Game_Launch.mp3|"+audioPath+"Game_Launch.ogg"},
				{id:"applejack_walk", src:audioPath+"applejack_walk.mp3|"+audioPath+"applejack_walk.ogg"},
				{id:"applejack_hitTree", src:audioPath+"applejack_hitTree.mp3|"+audioPath+"applejack_hitTree.ogg"},
				{id:"squirrel", src:audioPath+"squirrel.mp3|"+audioPath+"squirrel.ogg"},
				{id:"squirrel_grass", src:audioPath+"squirrel_grass.mp3|"+audioPath+"squirrel_grass.ogg"},
				{id:"flutterShy_wingFlap", src:audioPath+"flutterShy_wingFlap.mp3|"+audioPath+"flutterShy_wingFlap.ogg"},
				{id:"rainbow_hitCloud", src:audioPath+"rainbow_hitCloud.mp3|"+audioPath+"rainbow_hitCloud.ogg"},
				{id:"rainbow_in", src:audioPath+"rainbow_in.mp3|"+audioPath+"rainbow_in.ogg"},
				{id:"rainbow_out", src:audioPath+"rainbow_out.mp3|"+audioPath+"rainbow_out.ogg"},
				{id:"pinkie_in", src:audioPath+"pinkie_in.mp3|"+audioPath+"pinkie_in.ogg"},
				{id:"pinkie_out", src:audioPath+"pinkie_out.mp3|"+audioPath+"pinkie_out.ogg"},
				{id:"apple_hit", src:audioPath+"apple_hit.mp3|"+audioPath+"apple_hit.ogg"},
				{id:"apple_fall", src:audioPath+"apple_fall.mp3|"+audioPath+"apple_fall.ogg"},
				{id:"selectInteracItem", src:audioPath+"selectInteracItem.mp3|"+audioPath+"selectInteracItem.ogg"},
				{id:"hitObstacle", src:audioPath+"hitObstacle.mp3|"+audioPath+"hitObstacle.ogg"},
				{id:"timeLeft", src:audioPath+"timeLeft.mp3|"+audioPath+"timeLeft.ogg"},
				{id:"endTime", src:audioPath+"endTime.mp3|"+audioPath+"endTime.ogg"},
				{id:"lightning", src:audioPath+"lightning.mp3|"+audioPath+"lightning.ogg"}
			];                  
					
			nbSoundsToLoad = manifest.length;
			createjs.Sound.addEventListener("fileload", handleLoad);
			createjs.Sound.registerManifest(manifest);
		}else{
			funcToCallOnLoad();
		}
	}

	/**
	 * Load end event
	 * 
	 * @param	event
	 */
	function handleLoad(event)
	{		
		nbSoundsLoaded++;
		if (nbSoundsLoaded >= nbSoundsToLoad)
		{		
			funcToCallOnLoad();			
		}
	}
	
	function onSoundsLoaded(funcToCall)
	{
		funcToCallOnLoad = funcToCall;
	}

	//Public methods
	this.init = init;
	this.onSoundsLoaded = onSoundsLoaded;
	
	return this;
}

function onSoundsLoaded(funcToCall)
{
	audioManager().onSoundsLoaded(funcToCall);
}