/**
* Game Javascript API and platform specific handlers
*/
function get_gameApi()
{
	return gameApi;
}

var gameApi =
{	
	//onOrientationChange:null,
	
	ipadVersion:0,

	gameSize: {
		width:853,
		height:480
	},
	
	// ::: GET COOKIE :::
	getCookie:function(name) 
	{
		var value = document.cookie;
		var start = value.indexOf(" " + name + "=");
		if (start == -1) {
			start = value.indexOf(name + "=");
		}
		
		if (start == -1) {
			value = null;
		} else {
			start = value.indexOf("=", start) + 1;
			var end = value.indexOf(";", start);
			if (end == -1) {
				end = value.length;
			}
			value = unescape(value.substring(start,end));
		}
		return value;
	},
	
	// ::: SET COOKIE :::
	setCookie:function(name, value, exdays) 
	{
		var exdate 		= new Date();
		exdate.setDate(exdate.getDate() + exdays);
		var value 		= escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
		document.cookie = name + "=" + value;
	},
	
	// http://javascript.crockford.com/memory/leak.html
	// cleans dom element to prevent memory leaks
	domPurge:function(d) 
	{
	    var a = d.attributes, i, l, n;
	    if (a) {
	        for (i = a.length - 1; i >= 0; i -= 1) {
	            n = a[i].name;
	            if (typeof d[n] === 'function') {
	                d[n] = null;
	            }
	        }
	    }
	    a = d.childNodes;
	    if (a) {
	        l = a.length;
	        for (i = 0; i < l; i += 1) {
	            domPurge(d.childNodes[i]);
	       }
	    }
	},

	domRemove:function(id) 
	{
	    var elem = document.getElementById(id);
	    domPurge(elem);
	    return elem.parentNode.removeChild(elem);
	},
	
	isIos5:function()
	{
		if(/OS [5]_\d(_\d)? like Mac OS X/i.test(navigator.userAgent)) 
		{			
			return true;
		}
		else
		{
			return false;
		}
	},	
	
	// Open a page in a new window
	openPage:function(url)
	{		
		var win=window.open(url,"_blank");
		if (win)
		{
			win.focus();
		}
	},
	
	// Get by the game if this one can start normally
	canStartGame:function()
	{
		return window.gameReady;
	},
	
	reloadPage:function()
	{
		window.location.reload();
	},
	
	// ::: GET CURRENTLOCALE :::
	getCurrentLocale:function()
	{
		var parameters = location.search.substring(1).split("&");
		var lang = unescape(parameters[0].split("=")[1]);
		return (lang == "undefined")?"en_US":lang;
	}
	
};