#!/usr/bin/env node

function toPythonString(str) {
    // FIXME: this is clearly incomplete
    return "\"" + (""+str).replace("\"", "\\\"") + "\"";
}

var Parser = require("./metavn/extensibleparser");
var Lang = require("./metavn/mvnlang");
var Markup = require("./metavn/mvnmarkup");
var Assets = require("./metavn/mvnassets");
var RenPy = null;
var VNDS = null;
var WebStory = null;

var parser = new Parser();
var lang = new Lang(parser);
Markup(lang);
Assets(lang);

var fs = require("fs");
var child_process = require("child_process");
var cpcmds = [];

function mkdirP(dir) {
    var dirParts = dir.split("/");
    dir = dirParts[0];
    var i = 0;
    do {
        if (dir !== "" && !fs.existsSync(dir))
            fs.mkdirSync(dir);
        dir += "/" + dirParts[++i];
    } while (i < dirParts.length);
}

function dirname(file) {
    var parts = file.split("/");
    if (parts.length === 0) {
        return ".";
    } else {
        var ret = parts.slice(0, parts.length - 1).join("/");
        if (ret === "") ret = "/";
        return ret;
    }
}

function basename(file) {
    return file.split("/").pop();
}

function fileOr404(file, f404) {
    if (fs.existsSync(file)) return file;
    var dir = file;
    do {
        dir = dirname(dir);
        file = dir + "/" + f404;
        if (fs.existsSync(file)) return file;
    } while (dir !== "." && dir !== "/");
}

var cp, cpR;
if (process.platform === "win32") {
    cp = function(from, to) {
        from = from.replace(/\//g, "\\");
        to = to.replace(/\//g, "\\");
        cpcmds.push(["cmd", "/C", "copy", "/Y", from, to]);
    }

    cpR = function(args) {
        var last = args.pop().replace(/\//g, "\\");
        for (var i = 0; i < args.length; i++) {
            var arg = args[i];
            var base = basename(arg);
            cpcmds.push(["robocopy", "/E", arg.replace(/\//g, "\\"), last + base]);
        }
    }

} else if(process.platform === "darwin") {
    cp = function(from, to) {
        cpcmds.push(["cp", from, to]);
    }

    cpR = function(args) {
        cpcmds.push(["cp", "-R"].concat(args));
    }
} else {
    cp = function(from, to) {
        cpcmds.push(["cp", from, to]);
    }

    cpR = function(args) {
        cpcmds.push(["cp", "-dR"].concat(args));
    }

}

// get our state
var startScript = null;
var assetsDir = "Assets";
var compile = true;
var distribute = true;
var outDir = "starswirlacademy";
var jpeg = true;
var jpegQuality = "97";

function help() {
    console.log("Use: build <options>\n" +
        "Options:\n" +
        "\t-s|--start-script <name>: Specify starting script. (required)\n" +
        "\t-a|--assets <dir>: Specify asset directory.\n" +
        "\t-S|--script-only: Only write script.rpy, do not compile or create a distribution.\n" +
        "\t-c|--compile-only: Compile only, do not create a distribution.\n" +
        "\t-o|--output-dir <dir>: Output to the specified (new) directory.\n" +
        "\t--png: Do not convert backgrounds to jpeg.\n" +
        "\t--jpeg-quality <q>: JPEG quality (if used).\n" +
        "\t--vnds: Generate VNDS instead of Ren'Py.\n" +
        "\t--wse: Generate WebStory instead of Ren'Py.\n");
}

for (var ai = 2; ai < process.argv.length; ai++) {
    var arg = process.argv[ai];
    switch (arg) {
        case "-a":
        case "--assets":
            assetsDir = process.argv[++ai];
            break;

        case "-s":
        case "--start-script":
            startScript = process.argv[++ai];
            break;

        case "-S":
        case "--script-only":
            compile = false;
            distribute = false;
            break;

        case "-c":
        case "--compile-only":
            compile = true;
            distribute = false;
            break;

        case "-o":
        case "--output-dir":
            outDir = process.argv[++ai];
            break;

        case "--png":
            jpeg = false;
            break;

        case "--jpeg-quality":
            jpegQuality = process.argv[++ai];
            break;

        case "--vnds":
            if (VNDS === null) {
                VNDS = require("./metavn/mvnvnds");
                VNDS(lang);
            }
            break;

        case "--wse":
        case "--webstory":
            if (WebStory === null) {
                WebStory = require("./metavn/mvnwebstory");
                WebStory(lang);
            }
            break;

        default:
            help();
            process.exit(1);
    }
}

if (!assetsDir || !startScript) {
    help();
    process.exit(1);
}

if (!VNDS && !WebStory) {
    RenPy = require("./metavn/mvnrenpy");
    RenPy(lang);
}

var jpegQualityArg = [];
if (jpeg)
    jpegQualityArg = ["-quality", jpegQuality];

// copy in the base
if (distribute) {
    if (RenPy) {
        mkdirP(outDir + "/game/music");
        mkdirP(outDir + "/game/video");
        mkdirP(outDir + "/game/bgs");
        cpR(["game", outDir + "/"]);
        cp("project.json", outDir + "/project.json");
        cpR([assetsDir + "/ui", assetsDir + "/fonts", outDir + "/game/"]);
        cp(assetsDir + "/ui/android-icon.png", outDir + "/android-icon.png");
        cp(assetsDir + "/ui/android-presplash.jpg", outDir + "/android-presplash.jpg");
        cp(assetsDir + "/ui/gameIcon.ico", outDir + "/icon.ico");
        cp(assetsDir + "/ui/gameIcon.icns", outDir + "/icon.icns");
        cp(assetsDir + "/music/TWNGTCTS.ogg", outDir + "/game/music/TWNGTCTS.ogg");
        cp(assetsDir + "/bgs/blank.png", outDir + "/game/bgs/blank.png");
        cp(assetsDir + "/video/logo.mp4", outDir + "/game/video/logo.mp4");
        cp(assetsDir + "/video/logo.mkv", outDir + "/game/video/logo.mkv");
    } else if (VNDS) {
        mkdirP(outDir + "/script");
        fs.writeFileSync(outDir + "/info.txt", "title=Starswirl Academy");
    } else if (WebStory) {
        mkdirP(outDir);
    }
}

// compile everything
var assets = void 0;
var definitions = {};

var todo = ["Definitions", startScript];
var scripts = {"+Definitions": true};
scripts["+" + startScript] = true;
var out = ""

if (RenPy)
    out += "label start:\n jump " + parser.mkIdentifier(startScript) + "_start\n\n";

if (VNDS)
    fs.writeFileSync(outDir + "/script/main.scr", "jump " + parser.mkIdentifier(startScript) + ".scr");

for (var ti = 0; ti < todo.length; ti++) {
    var script = todo[ti];

    console.log("\n" + script);

    var inp = fs.readFileSync(assetsDir + "/scripts/" + script + ".txt", "utf8");
    inp = lang.removeGDocsComments(inp);
    var parsed = lang.parse(inp, definitions);
    assets = parsed.collectAssets(assets);

    if (RenPy) {
        out += parsed.compileRenPyTop(script);
    } else if (VNDS) {
        fs.writeFileSync(outDir + "/script/" + parser.mkIdentifier(script) + ".scr", parsed.compileVNDS());
    } else if (WebStory) {
        out += parsed.compileWSE(script);
    }

    // add any new scripts
    for (var script in assets.scenes) {
        if (script[0] !== "+") continue;
        if (script in scripts) continue;
        scripts[script] = true;
        script = script.substring(1);
        todo.push(script);
    }
}

if (RenPy) {
    var ctcs = {};

    // copy in the assets and make their Ren'Py statements
    var arp = "init -5 python:\n" +
              " narrator = Character(ctc=\"ctc_animation\")\n";
    for (var character in assets.characters) {
        if (character[0] !== "+") continue;

        character = assets.characters[character];
        var charid = parser.mkIdentifier(character.id);

        // if they have a CTC icon, note that
        var ctc = "ctc_animation";
        if (fs.existsSync(assetsDir + "/ui/ctc/" + charid + ".png")) {
            ctc = "ctc_animation_" + charid;
            ctcs[charid] = true;

            arp = "image " + ctc + ":\n" +
                  " \"ui/ctc/" + charid + ".png\"\n" +
                  " pause 0.56\n" +
                  " Null(width=29, height=27) with Dissolve(0.56, alpha=True)\n" +
                  " pause 0.7\n" +
                  " \"ui/ctc/" + charid + ".png\" with Dissolve(0.56, alpha=True)\n" +
                  " pause 0.56\n" +
                  " repeat\n" +
                  arp;
        }

        // the variables
        var svar = parser.mkIdentifier(character.nick);
        var svarl = svar.toLowerCase();
        arp += " " + svar + " = " + toPythonString(character.nick) + "\n" +
               " " + svarl + " = " + svar + "\n" +
               " " + svar + "_f = " + toPythonString(character.name) + "\n" +
               " " + svarl + "_f = " + svar + "_f\n" +
               " " + svar + "_s = " + toPythonString(character.surname) + "\n" +
               " " + svarl + "_s = " + svar + "_s\n" +
               " " + svar + "_full = " + toPythonString(character.fullname) + "\n" +
               " " + svarl + "_full = " + svar + "_full\n";

        var charVar = parser.mkIdentifier("chr_" + character.id);
        var image = "";
        if (("+" + character.id) in assets.sprites)
            image = ", image=\"" + charid + "\"";
        arp += " " + charVar + " = Character(" + svar + image + ", what_prefix=\"“\", what_suffix=\"”\"," +
               "ctc=\"" + ctc + "\")\n";
    }

    for (var bg in assets.bgs) {
        if (bg[0] !== "+") continue;

        bg = bg.substring(1);
        var bgi = parser.mkIdentifier(bg);
        var bgif = fileOr404(assetsDir + "/bgs/" + bg + ".png", "404.png");
        var bgof = "bgs/" + bg + (jpeg ? ".jpg" : ".png");
        var bgofBlur = "bgs/" + bg + "_blur" + (jpeg ? ".jpg" : ".png");
        arp += " load_background(\"" + bgi + "\", \"" + bgof + "\", \"" + bgofBlur + "\", True)\n"
            bgof = outDir + "/game/" + bgof;
        bgofBlur = outDir + "/game/" + bgofBlur;

        if (distribute) {
            mkdirP(dirname(bgof));
            if (jpeg) {
                if (!fs.existsSync(bgof)) {
                    cpcmds.push(["convert", bgif].concat(
                                jpegQualityArg).concat([
                                    bgof]));
                }
            } else {
                cp(bgif, bgof);
            }
            if (!fs.existsSync(bgofBlur)) {
                cpcmds.push(["convert", bgif,
                        "-gaussian-blur", "16x16"].concat(
                            jpegQualityArg).concat([
                                bgofBlur]));
            }
        }
    }
    for (var character in assets.posedSprites) {
        if (character[0] !== "+") continue;
        var poses = assets.posedSprites[character];
        character = character.substring(1);
        for (var pose in poses) {
            if (pose[0] !== "+") continue;
            var expressions = poses[pose];
            pose = pose.substring(1);
            for (var expression in expressions) {
                if (expression[0] !== "+") continue;
                expression = expression.substring(1);
    
                var sprite = "/sprites/" + character + "/" + pose + expression;
                arp += " load_sprite(\"" + character + "\", \"" + pose + expression + "\", \"None\")\n";
    
                if (distribute) {
                    mkdirP(outDir + "/game/sprites/" + character);
                    cp(fileOr404(assetsDir + sprite + ".png", "404.png"), outDir + "/game" + sprite + ".png");

                    if (!fs.existsSync(outDir + "/game" + sprite + "_side.png")) {
                        /*cpcmds.push(["convert", assetsDir + sprite + ".png",
                                     "-filter", "Lanczos",
                                     "-resize", "x432",
                                     outDir + "/game" + sprite + "_side.png"]);
                        */
                        cpcmds.push(["convert", assetsDir + sprite + ".png",
                                    "-trim", "+repage", 
                                    "-crop", "0x550+0+0", 
                                    "-trim", "+repage",
                                    "-filter", "Lanczos",
                                    "-resize", "x170",
                                     outDir + "/game" + sprite + "_side.png"]);
                    }
                }
            }
        }
    }
    if (distribute) {
        for (var music in assets.music) {
            if (music[0] !== "+") continue;
            music = music.substring(1);

            mkdirP(outDir + "/game/music");
            cp(fileOr404(assetsDir + "/music/" + music + ".ogg", "TWNGTCTS.ogg"), outDir + "/game/music/" + music + ".ogg");
        }

        for (var video in assets.videos) {
            if (video[0] !== "+") continue;
            video = video.substring(1);

            mkdirP(outDir + "/game/video");
            cp(fileOr404(assetsDir + "/video/" + video, "404.mkv"), outDir + "/game/video/" + video);
        }
    }
    out = arp + "\n" + out;

    // write out the script
    mkdirP(outDir + "/game");
    fs.writeFileSync(outDir + "/game/script.rpy", out);

    // compile it
    if (compile) {
        if (process.platform === "win32") {
            cpcmds.push(["renpy\\renpy", outDir.replace(/\//g, "\\"), "compile"]);
        } else {
            cpcmds.push(["renpy/renpy.sh", outDir, "compile"]);
        }
    }

} else if (VNDS) {
    for (var bg in assets.bgs) {
        if (bg[0] !== "+") continue;

        bg = bg.substring(1);
        var bgi = parser.mkIdentifier(bg);
        var bgif = fileOr404(assetsDir + "/bgs/" + bg + ".png", "404.png");
        var bgof = outDir + "/background/" + bgi + (jpeg ? ".jpg" : ".png");

        if (distribute) {
            mkdirP(dirname(bgof));
            if (!fs.existsSync(bgof)) {
                cpcmds.push(["convert", bgif,
                             "-resize", "341x192",
                             "-ordered-dither", "o8x8,32,32,32",
                             "-depth", "5",
                             "-crop", "256x192+42+0"].concat(
                            jpegQualityArg).concat([
                                bgof]));
            }
        }
    }
    for (var character in assets.sprites) {
        if (character[0] !== "+") continue;
        var expressions = assets.sprites[character];
        character = character.substring(1);
        for (var expression in expressions) {
            if (expression[0] !== "+") continue;
            expression = expression.substring(1);

            var sprite = fileOr404(assetsDir + "/sprites/" + character + "/" + expression + ".png", "404.png");
            var si = parser.mkIdentifier(character + "_" + expression);
            var spriteo = outDir + "/foreground/" + si + ".png";

            if (distribute) {
                mkdirP(dirname(spriteo));
                if (!fs.existsSync(spriteo)) {
                    cpcmds.push(["convert", sprite,
                                 "-resize", "256x256",
                                 "-ordered-dither", "o8x8,32,32,32",
                                 "-depth", "5",
                                 "-crop", "256x192+0+32",
                                 spriteo]);
                }
            }
        }
    }

} else if (WebStory) {
    fs.writeFileSync(outDir + "/script.xml", out);

}


// and run the commands
function cpcmd() {
    if (cpcmds.length > 0) {
        var run = cpcmds.shift();
        console.log(run.join(" "));
        var cp = child_process.spawn(run[0], run.slice(1));
        cp.on("exit", cpcmd);
    } else {
        console.log("Complete.");
    }
}
cpcmd();
