#!/usr/local/bin/fish

# General copying and shit
set outdir starswirlacademy
set jpegQuality 97

mkdir -p "$outdir"/game/assets/{music,video,bgs,fonts,sprites,ui}

cp -R project.json "$outdir/"

cp game/assets/ui/{android-icon.png,android-presplash.png} "$outdir"
cp game/assets/ui/gameIcon.ico "$outdir/icon.ico"
cp game/assets/ui/gameIcon.icns "$outdir/icon.icns"

# Scripts
cp -R game/{scripts,*.rpy} "$outdir/game"

# Assets without processing
cp -L -R game/assets/{music,video,fonts,ui} "$outdir/game/assets/"

# Backgrounds, with blur
for bg in game/assets/bgs/**.jpg
        echo "$bg"
        set outfile "$outdir/$bg"
        set outfile_dir (dirname "$outfile")

        mkdir -p "$outfile_dir"

        cp "$bg" "$outfile"

        set baseName (basename "$bg" .jpg)
        
        set blurFile "$outfile_dir/$baseName"_blur.jpg

        if not test -f "$blurFile"
                convert "$bg" -gaussian-blur 16x16 -quality $jpegQuality "$blurFile"
        end
end

for bg in game/assets/bgs/**.png
        echo "$bg"

        set outfile "$outdir/$bg"
        set outfile_dir (dirname "$outfile")

        mkdir -p "$outfile_dir"

        set baseName (basename "$bg" .png)
        set blurFile "$outfile_dir/$baseName"_blur.jpg
        set jpegFile "$outfile_dir/$baseName.jpg"

        if not test -f "$jpegFile"
                convert "$bg" -quality $jpegQuality "$jpegFile"
        end

        if not test -f "$blurFile"
                convert "$bg" -gaussian-blur 16x16 -quality $jpegQuality "$blurFile"
        end
end

# Sprites
for sprite in game/assets/sprites/**.png
        echo "$sprite"

        set basename (basename "$sprite" .png)
        set spritename "$outdir/$sprite"
        set spritedir (dirname "$spritename")
        
        mkdir -p "$spritedir"

        cp "$sprite" "$spritename"

        set sidename "$spritedir/$basename"_side.png

        if not test -f "$sidename"
                convert "$sprite" -trim +repage -crop 0x550+0+0 -trim +repage -filter Lanczos -resize x170 $sidename
        end
end

bash renpy/renpy.sh "$outdir" compile