package main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import gui.IntegerField;

import javax.swing.*;
import javax.swing.border.BevelBorder;

public class SettingsConfig extends JPanel implements ActionListener, PropertyChangeListener
	{
	private static final long serialVersionUID = 1357436113072816888L;
	
	IntegerField width,height,audioBuffer;
	JCheckBox fullscreen;
	JCheckBox forcePOTs;
	JCheckBox useVBO;
	JButton start,close;
	JComboBox sampleRate;
	JFrame frame;
	
	static final boolean SKIP_CONFIG = false;
	
	public SettingsConfig()
		{
		Settings.readSettings();
		frame = new JFrame();
		frame.add(this);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		String tip;
		
		setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
		setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 2;
		
		add(new JLabel("Configuration"),c);
		
		c.gridy++;
		c.fill = GridBagConstraints.HORIZONTAL;
		
		JSeparator sep = new JSeparator(JSeparator.HORIZONTAL);
		sep.setPreferredSize(new Dimension(8,24));
		sep.setVisible(true);
		add(sep,c);
		
		c.fill = GridBagConstraints.NONE;
		c.gridy++;
		
		tip = "Whether to start in fullscreen mode. Toggle with F4.";
		fullscreen = new JCheckBox();
		fullscreen.setToolTipText(tip);
		fullscreen.setSelected(Main.isFullscreen);
		fullscreen.setText("Fullscreen");
		fullscreen.addActionListener(this);
		add(fullscreen,c);
		
		c.gridwidth = 1;
		c.gridx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		
		tip = "Windowed mode width:";
		width = new IntegerField(320, Toolkit.getDefaultToolkit().getScreenSize().width, Main.preferredWidth, 5);
		width.setToolTipText(tip);
		width.setValue(Main.preferredWidth, true);
		width.addValuePropertyChangeListener(this);
		add(width,c);
		
		c.gridx++;
		c.anchor = GridBagConstraints.WEST;
		
		JLabel l = new JLabel(" Width(windowed)");
		l.setToolTipText(tip);
		add(l,c);

		c.gridx = 0;
		c.gridwidth = 1;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		
		tip = "Windowed mode height:";
		height = new IntegerField(240, Toolkit.getDefaultToolkit().getScreenSize().height, Main.preferredHeight, 5);
		height.setToolTipText(tip);
		height.setValue(Main.preferredHeight, true);
		height.addValuePropertyChangeListener(this);
		add(height,c);
		
		c.gridx++;
		c.anchor = GridBagConstraints.WEST;
		
		l = new JLabel(" Height(windowed)");
		add(l,c);
		l.setToolTipText(tip);

		c.gridx = 0;
		c.gridwidth = 2;
		c.gridy++;
		c.fill = GridBagConstraints.HORIZONTAL;
		
		sep = new JSeparator(JSeparator.HORIZONTAL);
		sep.setPreferredSize(new Dimension(8,12));
		sep.setVisible(true);
		add(sep,c);
		
		c.fill = GridBagConstraints.NONE;
		
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.CENTER;
		c.gridy++;
		
		tip = "Whether to use Power-Of-Two Texture dimensions only. Enable if some textures are missing:";
		forcePOTs = new JCheckBox();
		forcePOTs.setToolTipText(tip);
		forcePOTs.setSelected(Main.forcePOTs);
		forcePOTs.setText("Force POTs");
		forcePOTs.addActionListener(this);
		add(forcePOTs,c);
		
		c.gridy++;
		
		tip = "Whether to use VBOs when available. Try disabling if game crashes:";
		useVBO = new JCheckBox();
		useVBO.setToolTipText(tip);
		useVBO.setSelected(Main.useVBO);
		useVBO.setText("Use VBOs");
		useVBO.addActionListener(this);
		add(useVBO,c);
		
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		c.gridwidth = 2;
		c.fill = GridBagConstraints.HORIZONTAL;
		
		sep = new JSeparator(JSeparator.HORIZONTAL);
		sep.setPreferredSize(new Dimension(8,16));
		sep.setVisible(true);
		add(sep,c);
		
		c.gridx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		c.gridwidth = 1;
		c.fill = GridBagConstraints.NONE;
		
		tip = "JavaSound buffer size. A small value yields less lag but higher risk of audio glitches:";
		audioBuffer = new IntegerField(2, 16, Main.audioBuffer, 5);
		audioBuffer.setToolTipText(tip);
		audioBuffer.setValue(Main.audioBuffer, true);
		audioBuffer.addValuePropertyChangeListener(this);
		add(audioBuffer,c);
		
		c.gridx++;
		c.anchor = GridBagConstraints.WEST;
		
		l = new JLabel(" Audio Buffer");
		add(l,c);
		l.setToolTipText(tip);
		
		c.gridx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		c.gridwidth = 1;
		c.fill = GridBagConstraints.NONE;
		
		String[] s = new String[]{"8000","11025","16000","22050","44100","48000"};
		int index = -1;
		for(int i=0; i<s.length; i++)
			{
			if(String.valueOf(Main.sampleRate).equals(s[i]))
				index = i;
			}
		if(index==-1)
			{
			index = s.length;
			s = new String[]{"8000","11025","16000","22050","44100","48000",String.valueOf(Main.sampleRate)};
			}
		tip = "JavaSound sample rate in Hz. A small value yields lower quality but better performance:";
		sampleRate = new JComboBox(s);
		sampleRate.setToolTipText(tip);
		sampleRate.setSelectedIndex(index);
		sampleRate.addActionListener(this);
		add(sampleRate,c);
		
		c.gridx++;
		c.anchor = GridBagConstraints.WEST;
		
		l = new JLabel(" Sample Rate(Hz)");
		add(l,c);
		l.setToolTipText(tip);

		c.gridx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		c.gridwidth = 2;
		c.fill = GridBagConstraints.HORIZONTAL;
		
		sep = new JSeparator(JSeparator.HORIZONTAL);
		sep.setPreferredSize(new Dimension(8,16));
		sep.setVisible(true);
		add(sep,c);
		
		c.gridx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridy++;
		c.gridwidth = 1;
		c.fill = GridBagConstraints.BOTH;
		
		start = new JButton("Start Game");
		start.addActionListener(this);
		start.setBackground(new Color(32,255,32));
		add(start,c);
		
		c.gridx++;
		c.anchor = GridBagConstraints.WEST;
		
		close = new JButton("Exit Game");
		close.addActionListener(this);
		close.setBackground(new Color(255,64,64));
		add(close,c);
		
		frame.getRootPane().setDefaultButton(start);
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
		
		if(SKIP_CONFIG)
			start.doClick();
		}

	@Override
	public void actionPerformed(ActionEvent e)
		{
		Object o = e.getSource();
		if (o==start)
			{
			Settings.writeSettings();
			frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
			frame.dispose();
			Thread t = new Thread(){public void run(){
			Main.start();}};
			t.start();
			}
		else if (o==close)
			{
			Settings.writeSettings();
			frame.dispose();
			}
		else if (o==fullscreen)
			{
			Main.isFullscreen = fullscreen.isSelected();
			}
		else if (o==forcePOTs)
			{
			Main.forcePOTs = forcePOTs.isSelected();
			}
		else if (o==useVBO)
			{
			Main.useVBO = useVBO.isSelected();
			}
		else if(o==sampleRate)
			{
			Main.sampleRate = Integer.parseInt((String) sampleRate.getSelectedItem());
			}
		
		}

	@Override
	public void propertyChange(PropertyChangeEvent e)
		{
		Object o = e.getSource();
		if(o==width)
			{
			Main.preferredWidth = (Integer)e.getNewValue();
			}
		else if(o==height)
			{
			Main.preferredHeight = (Integer)e.getNewValue();
			}
		else if(o==audioBuffer)
			{
			Main.audioBuffer = (Integer)e.getNewValue();
			}
		}
	
	}
