package main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Settings
	{
	public static void writeSettings()
		{
		File f = new File("settings.dat");
		System.out.println("Writing settings");
		try
			{
			String nl = System.getProperty("line.separator");
			FileWriter fr = new FileWriter(f);
			BufferedWriter br = new BufferedWriter(fr);
			
			br.write("This is the graphics and audio configuration file. Not case sensitive, not sensitive to parameter ordering.");
			br.write(nl);
			br.write("Missing or corrupt settings are replaced with the default settings.");
			br.write(nl);
			br.write(nl);
			
			br.write("The initial size, if windowed:");
			br.write(nl);
			br.write("width = "+Main.preferredWidth);
			br.write(nl);
			br.write("height = "+Main.preferredHeight);
			br.write(nl);
			br.write("Whether to start the game in full screen mode. Toggle with F4:");
			br.write(nl);
			br.write("fullscreen = "+Main.isFullscreen);
			br.write(nl);
			br.write(nl);
			
			br.write("JavaSound buffer size. A small value yields less lag but higher risk of audio glitches:");
			br.write(nl);
			br.write("audioBuffer = "+Main.audioBuffer);
			br.write(nl);
			br.write("JavaSound sample rate in Hz. A small value yields lower quality but better performance:");
			br.write(nl);
			br.write("sampleRate = "+Main.sampleRate);
			br.write(nl);
			br.write(nl);
			
			br.write("Use BLOOM_GLSL, BLOOM_FFP or BLOOM_OFF. The GLSL implementation is faster, but less compatible:");
			br.write(nl);
			br.write("bloom = ");
			if(Main.bloom==Main.BLOOM_OFF) br.write("BLOOM_OFF");
			if(Main.bloom==Main.BLOOM_FFP) br.write("BLOOM_FFP");
			if(Main.bloom==Main.BLOOM_GLSL) br.write("BLOOM_GLSL");
			br.write(nl);
			br.write("Whether to use Power-Of-Two Texture dimensions only. Enable if some textures are missing:");
			br.write(nl);
			br.write("forcePOTs = "+Main.forcePOTs);
			br.write(nl);
			br.write("Whether to use VBOs when available. Try disabling if game crashes:");
			br.write(nl);
			br.write("useVBO = "+Main.useVBO);
			br.write(nl);
						
			br.close();
			fr.close();
			}
		catch (IOException e)
			{
			System.err.println("Settings file could not be written.");
			e.printStackTrace();
			}
		}

	static void readSettings()
		{
		File f = new File("settings.dat");
		if(f.exists())
			{
			System.out.println("Reading settings");
			try
				{
				FileReader fr = new FileReader(f);
				BufferedReader br = new BufferedReader(fr);
				String str;
				while ((str = br.readLine())!=null)
					{
					if(str.contains("=") && !str.startsWith("//"))
						{
						String[] split = str.split("=");
						if(split.length==2)
							{
							split[0] = split[0].trim().toLowerCase();
							split[1] = split[1].trim().toLowerCase();
							if(split[0].equals("width"))
								Main.preferredWidth = Integer.parseInt(split[1]);
							else if(split[0].equals("height"))
								Main.preferredHeight = Integer.parseInt(split[1]);
							else if(split[0].equals("fullscreen"))
								Main.isFullscreen = Boolean.parseBoolean(split[1]);
							else if(split[0].equals("audiobuffer"))
								Main.audioBuffer = Integer.parseInt(split[1]);
							else if(split[0].equals("samplerate"))
								Main.sampleRate = Integer.parseInt(split[1]);
							else if(split[0].equals("bloom"))
								{if(split[1].equals("bloom_ffp"))Main.bloom=Main.BLOOM_FFP;
								else if(split[1].equals("bloom_glsl"))Main.bloom=Main.BLOOM_GLSL;
								else Main.bloom = Main.BLOOM_OFF;}
							else if(split[0].equals("forcepots"))
								Main.forcePOTs = Boolean.parseBoolean(split[1]);
							else if(split[0].equals("usevbo"))
								Main.useVBO = Boolean.parseBoolean(split[1]);
							else if(split[0].equals("bilinearmag"))
								Main.bilinearMag = Boolean.parseBoolean(split[1]);
							else if(split[0].equals("bilinearmin"))
								Main.bilinearMin = Boolean.parseBoolean(split[1]);
							else
								System.out.println("Unrecognized setting parameter");
							}
						}
					}
				}
			catch (Exception e)
				{
				System.err.println("Settings file is corrupt.");
				e.printStackTrace();
				}
			}
		else
			System.out.println("Settings file doesn't exist. Continuing peacefully.");
		
		}
	}
