package main;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import mechanics.Scene;

import graphics.GFX;
import graphics.MTL;
import io.IOH;

import audio.*;

/**
 * This class sets up what we need in general.
 */

@SuppressWarnings("serial")
public class Main
	{
	public static final int BLOOM_OFF = 0,BLOOM_FFP = 1, BLOOM_GLSL = 2;
	
	static int preferredWidth =	640;
	static int preferredHeight=	480;
	private static int originalWidth;
	private static int originalHeight;
	public  static boolean ignoreResize = false;
	/**Target frame rate.*/
	public  static int FPS = 30;
	public  static boolean isFullscreen=true;
	private static final String TITLE="Pika pika";
	
	private static Integer x = null;
	private static Integer y = null;
	public static double airResistance;
	public static final double GROUND_FRICTION_STANDARD = 0.6;
	
	public static Cursor noCursor;
	public static Frame frame;
	public static JFrame loadFrame;
	public static BufferedImage loadImage,screenImage;
	protected static double loadProgress,targetLoadProgress;
	
	public static IOH io; 
	public static Scene scene;
	public static AnimatorBase animator;
	public static AbstractGraphicsDevice device;
	public static GLProfile profile;
	public static GLCapabilities caps;
	public static GLCanvas canvas;
	public static Audio audio;
	public static GFX gfx;
	public static MTL mtl;
	public static int audioBuffer = 8;
	public static int sampleRate = 22050;
	
	public static boolean alwaysUseDisplayLists = false;
	public static boolean forcePOTs = true;
	public static boolean useVBO = true;
	public static int bloom = BLOOM_FFP;
	public static boolean bilinearMag = false;
	public static boolean bilinearMin = false;
	/**Set to true if the keepProcess argument is passed to the program.*/
	public static boolean keepProcess = false;	

	public static void main(String[] args)
		{
		if (args.length>0 && args[0].equals("keepProcess"))
			{
			keepProcess = true;
			start();
			}
		else
			new SettingsConfig();
		}
	
	public static void start()
		{
		RuntimeFixer.DEMANDED_MEMORY = 256;
		if(RuntimeFixer.validateProcess())
			{
		    new Main();
			}
		}
	
	private Main()
	    {
	    loadProgress = 0;
	    setTargetLoadProgress(0.5);
	    
	    if(RuntimeFixer.runningFromJar)
	    	System.setErr(new ErrorHandler().getStream());
	    
	    Thread thrd = new Thread(){@Override public void run(){
	    	showLoaderFrame();
	    	try {sleep(200);}catch (InterruptedException e){}
	    	while(loadFrame!=null)
	    		{loadProgress = (loadProgress*5+targetLoadProgress)/6;
	    		loadFrame.getContentPane().repaint();
	    		loadFrame.repaint();
	    		try {sleep(200);}catch (InterruptedException e){}}}};
	    thrd.start();
	    
	    //GLProfile.initSingleton();
	    setTargetLoadProgress(0.75);
		Settings.readSettings();
		Settings.writeSettings();
		   
	    airResistance=0.0007;
	    
	    // create a blank cursor
	    Toolkit t = Toolkit.getDefaultToolkit();
	    Image i = new BufferedImage(1, 1, BufferedImage.TYPE_INT_ARGB);
	    noCursor = t.createCustomCursor(i, new Point(0, 0), "none"); 
	    
	    audio = new Audio();
	    setTargetLoadProgress(1);
	    System.out.println("Initializing OpenGL");
	    device = GLProfile.getDefaultDevice();
	    profile = GLProfile.get(device,GLProfile.GL2);
	    caps = new GLCapabilities(profile);
	    caps.setAlphaBits(0);
	    caps.setRedBits(8);
	    caps.setGreenBits(8);
	    caps.setBlueBits(8);
	    caps.setBackgroundOpaque(true);
	    //caps.setDepthBits(depthBits)
	    caps.setDoubleBuffered(true);
	    caps.setHardwareAccelerated(true);
	    caps.setSampleBuffers(false);
	    caps.setStencilBits(0);
	    caps.setStereo(false);
	    
	    scene = new Scene(preferredWidth,preferredHeight);//Note: scene instantiates the GFX
	    System.out.println("Creating GLCanvas.");
	    canvas = new GLCanvas(caps);
	    canvas.addGLEventListener(scene);
	    canvas.setPreferredSize(new Dimension(preferredWidth,preferredHeight));
	    io = new IOH(this);
	    
	    //This is the most random workaround ever
	    //But it increases the timing resolution on windows.
	    Thread sleeper = new Thread(){public void run(){
	    	try {sleep(Long.MAX_VALUE);}
			catch (InterruptedException e){}
	    	}};
	    sleeper.setDaemon(true);
	    sleeper.start();
	    
	    //animator = new FPSAnimator(canvas, FPS, scheduleAtFixedRate);
	    animator = new Animator();
	    animator.add(canvas);
	    ((Animator)animator).setRunAsFastAsPossible(true);
	    
		frame = new Frame(TITLE){
			@Override
			public void dispose()
				{
				System.out.println("System exit");
				animator.stop();
				scene.dispose(null);//obs
				super.dispose();
				System.exit(0);
				}};
	    frame.setCursor(noCursor);
	    frame.setUndecorated(true);
	    frame.add(canvas);
	    frame.setResizable(false);
	    frame.pack();
	    originalWidth=frame.getWidth();
	    originalHeight=frame.getHeight();
	    
	    frame.addWindowListener(new WindowAdapter()
	    {public void windowClosing(WindowEvent e)
	        {frame.dispose();}
	    	});
	    
	    
	    
	    frame.addComponentListener(new ComponentAdapter()
	    {public void componentResized(ComponentEvent e)
	    	{if (!ignoreResize)
	    		{originalWidth=e.getComponent().getWidth();
	    		originalHeight=e.getComponent().getHeight();}
	    	ignoreResize=false;}
	    	});
	    canvas.requestFocusInWindow();
	    
	    //sleep(300);
	    System.out.println("Attempting to display GLCanvas.");
	    frame.setVisible(true);
	    //canvas.display();
		}
	private synchronized static void setTargetLoadProgress(double d)
		{
		targetLoadProgress = d;
		}

	private void showLoaderFrame()
		{
		try
			{
		    loadFrame = new JFrame();
		    loadFrame.setUndecorated(true);
		    File img = new File("res/in.png");
		    if(!img.exists())
		    	{
		    	error("The loader image \"in.png\" was missing.\n" +
		    			"Please make sure you have extracted the\n" +
		    			"archive to your disk before running the game.\n" +
		    			"\n" +
		    			"Exiting game.", "Loader image missing");
		    	throw new IOException("Missing image file");
		    	}
		    
		    loadImage = ImageIO.read(img);
		    JPanel p = new JPanel(){
		    	@Override
		    	public void paintComponent(Graphics g)
		    		{g.drawImage(screenImage,0,0,null);
		    		g.drawImage(loadImage,(int)(260*(1-loadProgress)),0,260,410,0,0,(int)(260*(loadProgress)), 410, null);
		    		g.drawImage(loadImage,0,0,260,410,260,0,520, 410, null);
		    		}
		    	};
		    p.setPreferredSize(new Dimension(260,410));
		    loadFrame.setContentPane(p);
		    loadFrame.pack();
		    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		    loadFrame.setLocation(screenSize.width-260, screenSize.height/2-205);
		    screenImage = IOH.robot.createScreenCapture(loadFrame.getBounds());
		    loadFrame.setVisible(true);
			}
		catch (IOException e)
			{System.err.println("Loader Image Missing");
			System.exit(1);}
		}

	/**This will show a JOptionPane error message.*/
	public static void error(String message, String caption)
		{
		JOptionPane.showMessageDialog(null,message,caption,JOptionPane.ERROR_MESSAGE);
		}
	
	public static void setFullScreen(boolean full)
		{
		System.out.println(full+", "+originalWidth+", "+originalHeight);
		isFullscreen = full;
		if(isFullscreen)
	    	{
	    	ignoreResize=true;
		    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		    frame.setBounds(0,0,screenSize.width, screenSize.height);
	    	}
	    else
	    	frame.setBounds(getXPos(),getYPos(),originalWidth, originalHeight);
		}
	private static int getXPos()
		{
		if(x==null)
			return Toolkit.getDefaultToolkit().getScreenSize().width/2-originalWidth/2;
		else
			return x;
		}
	private static int getYPos()
		{
		if(y==null)
			return Toolkit.getDefaultToolkit().getScreenSize().height/2-originalHeight/2;
		else
			return y;
		}
	/**Sleep without exceptions.*/
	public static void sleep(int i)
		{
		try {Thread.sleep(i);}
		catch (InterruptedException e){}
		}
	}