package io;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;

import calc.Calc;

import main.Main;

public class IOH implements KeyListener, MouseListener, MouseWheelListener, MouseMotionListener
	{
	public Main parent;
	private static boolean[] keyPresses;
	private static boolean[] stepKeyPresses;
	private static boolean[] stepKeyReleases;
	private static final int maxKey = 128;
	private static Hashtable<Integer,Boolean> mousePresses;
	public static int mouseX,mouseY;
	private static boolean useRelativeMouse;
	public static double mouseH,mouseV;
	public static double mouseSensitivity;
	/**Use to invert mouse*/
	public static int mouseYMultiplier;
	public static Robot robot;
	
	static 
		{
		try
			{robot = new Robot();}
		catch (AWTException e)
			{System.err.println("WtfError");
			e.printStackTrace();}
		}
	
	public IOH(Main parent)
		{
		this.parent=parent;
		mouseX=0;
		mouseY=0;
		useRelativeMouse=false;
		mouseSensitivity=1d/160;
		mouseH=0;
		mouseV=0;
		mouseYMultiplier= -1;
		
		stepKeyPresses = new boolean[maxKey];
		stepKeyReleases = new boolean[maxKey];
		keyPresses = new boolean[maxKey];
		mousePresses = new Hashtable<Integer,Boolean>();
		//Main.frame.addKeyListener(this);
		//Main.frame.addMouseMotionListener(this);
		//Main.frame.addMouseListener(this);
		//Main.frame.addMouseWheelListener(this);
		Main.canvas.addKeyListener(this);
		Main.canvas.addMouseMotionListener(this);
		Main.canvas.addMouseListener(this);
		Main.canvas.addMouseWheelListener(this);
		}
	
	public static void addKeyListener(KeyListener l)
		{
		//Main.frame.addKeyListener(l);
		Main.canvas.addKeyListener(l);
		}
	public static void addMouseMotionListener(MouseMotionListener l)
		{
		//Main.frame.addMouseMotionListener(l);
		Main.canvas.addMouseMotionListener(l);
		}
	public static void addMouseListener(MouseListener l)
		{
		//Main.frame.addMouseListener(l);
		Main.canvas.addMouseListener(l);
		}
	public static void addMouseWheelListener(MouseWheelListener l)
		{
		//Main.frame.addMouseWheelListener(l);
		Main.canvas.addMouseWheelListener(l);
		}
	
	public static boolean checkKey(int key)
		{
		if(key>=maxKey)
			throw new IllegalArgumentException("Unsupported key: "+key);
		return keyPresses[key];
		}
	public static boolean checkKeyPressed(int key)
		{
		if(key>=maxKey)
			throw new IllegalArgumentException("Unsupported key: "+key);
		return stepKeyPresses[key];
		}
	public static boolean checkKeyReleased(int key)
		{
		if(key>=maxKey)
			throw new IllegalArgumentException("Unsupported key: "+key);
		return stepKeyReleases[key];
		}
	public static boolean checkMouse(int button)
		{
		Boolean result = mousePresses.get(button);
		return (result==null)?false:result;
		}
	@Override
	public void mouseClicked(MouseEvent e)
		{}
	@Override
	public void mouseEntered(MouseEvent e)
		{}
	@Override
	public void mouseExited(MouseEvent e)
		{}
	@Override
	public void mousePressed(MouseEvent e)
		{
		mousePresses.put(e.getButton(),true);
		}
	@Override
	public void mouseReleased(MouseEvent e)
		{
		mousePresses.put(e.getButton(),false);
		}
	@Override
	public void mouseWheelMoved(MouseWheelEvent e)
		{}
	@Override
	public void mouseDragged(MouseEvent e)
		{
		mouseMotion(e);
		}
	@Override
	public void mouseMoved(MouseEvent e)
		{
		mouseMotion(e);
		}
	private void mouseMotion(MouseEvent e)
		{
		mouseX=e.getX();
		mouseY=e.getY();
		}

	@Override
	public void keyPressed(KeyEvent e)
		{
		if(e.getKeyCode()<maxKey)
			{
			if(!keyPresses[e.getKeyCode()])
				stepKeyPresses[e.getKeyCode()]=true;
			keyPresses[e.getKeyCode()]=true;
			}
		}
	@Override
	public void keyReleased(KeyEvent e)
		{
		if(e.getKeyCode()<maxKey)
			{
			stepKeyReleases[e.getKeyCode()]=true;
			keyPresses[e.getKeyCode()]=false;
			}
		}
	@Override
	public void keyTyped(KeyEvent e)
		{}

	public static void step()
		{
		if(useRelativeMouse && Main.canvas.isFocusOwner() && Main.frame.isFocused())
			{
			Point p = Main.canvas.getLocationOnScreen();
			int h = p.x+Main.canvas.getWidth()/2;
			int v = p.y+Main.canvas.getHeight()/2;
			mouseH = (mouseX-Main.canvas.getWidth()/2) *mouseSensitivity;
			mouseV = (mouseY-Main.canvas.getHeight()/2)*mouseSensitivity;
			robot.mouseMove(h, v);//Detect failure?
			}
		else
			{mouseH=0;
			mouseV=0;}
		if(checkKey(KeyEvent.VK_LEFT))
			mouseH-=0.2;
		if(checkKey(KeyEvent.VK_RIGHT))
			mouseH+=0.2;
		if(checkKey(KeyEvent.VK_UP))
			mouseV-=0.2;
		if(checkKey(KeyEvent.VK_DOWN))
			mouseV+=0.2;
		
		mouseH = Calc.limit(mouseH, -1, 1);
		mouseV = mouseYMultiplier*Calc.limit(mouseV, -1, 1);
		}
	
	public static void endStep()
		{
		for(int i=0; i<maxKey; i++)
			{
			stepKeyPresses[i]=false;
			stepKeyReleases[i]=false;
			}
		}
	
	/**Use to force the mouse position to stay in the center of the screen. 
	 * This enables the use of the mouseH, mouseV variables to detect mouse motions. 
	 * These values are limited to an absolute value of 1. 
	 * Use mouseSensitivity to control how much these are influenced per pixel movement of the mouse.*/
	public static void setRelativeMouse(boolean b)
		{
		mouseH=0;
		mouseV=0;
		useRelativeMouse=b;
		}

	}
