package gui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

@SuppressWarnings("serial")
public class IntegerField extends JTextField implements FocusListener, DocumentListener
	{
	private PropertyChangeSupport pcs;
	private Integer minimum,maximum;
	private int value;
	
	public IntegerField(Integer min,Integer max,int currentValue,int cols)
		{
		super(cols);
		
		minimum=min;
		maximum=max;
		pcs = new PropertyChangeSupport(this);
		value = currentValue;
		setTextWithNoEvents(String.valueOf(value));
		this.addFocusListener(this);
		getDocument().addDocumentListener(this);
		}
	public void setValue(int newValue,boolean setText)
		{
		if(setText)
			{
			String newText = String.valueOf(newValue);
			setTextWithNoEvents(newText);
			}
		setBackground(Color.WHITE);
		pcs.firePropertyChange("VALUE",value,newValue);
		value=newValue;
		}
	public int getValue()
		{
		return value;
		}

	@Override
	public void focusGained(FocusEvent e)
		{
		//setCaretPosition(getText().length());
		//moveCaretPosition(0);
		}

	@Override
	public void focusLost(FocusEvent e)
		{
		Integer newValue = valueOf(getText());
		if (newValue==null)
			{
			setTextWithNoEvents(String.valueOf(value));
			setBackground(Color.WHITE);
			}
		//value will already be consistent with text
		}
	private void setTextWithNoEvents(String s)
		{
		setDocument(new PlainDocument());
		setText(s);
		getDocument().addDocumentListener(this);
		}
	
	private Integer valueOf(String s)
		{
		try
			{
			return Integer.parseInt(s);
			}
		catch(NumberFormatException e)
			{
			return null;
			}
		}

	public void addValuePropertyChangeListener(PropertyChangeListener obj)
		{
		pcs.addPropertyChangeListener(obj);
		}
	@Override
	public void changedUpdate(DocumentEvent e)
		{
		System.err.println("Wtf is this");
		/*try {documentChanged(e.getDocument().getText(0, e.getDocument().getLength()));}
		catch (BadLocationException e1){}*/
		}
	@Override
	public void insertUpdate(DocumentEvent e)
		{
		try {documentChanged(e.getDocument().getText(0, e.getDocument().getLength()));}
		catch (BadLocationException e1){}
		}
	@Override
	public void removeUpdate(DocumentEvent e)
		{
		try {documentChanged(e.getDocument().getText(0, e.getDocument().getLength()));}
		catch (BadLocationException e1){}
		}
	public void documentChanged(String newString)
		{
		Integer newValue = valueOf(newString);
		if(maximum != null && newValue!=null && newValue>maximum)
				newValue=null;
			if(minimum != null && newValue!=null && newValue<minimum)
				newValue=null;
		if (newValue!=null)
			{
			setValue(newValue,false);
			}
		else
			{
			setBackground(Color.RED);
			}
		}

	}
