package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;

import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

import main.Main;


public class GuiUtil
	{

	public static Component createLink(String name, final String url)
	{
	JLabel link = new UnderlinedLabel(name);
	link.setForeground(Color.WHITE);
	link.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	link.addMouseListener(new MouseAdapter() {
	   public void mouseClicked(MouseEvent e) {
	      if (e.getClickCount() > 0) {
	    	  GuiUtil.openURL(url);
	      }
	   }
	});
	JPanel p = new JPanel();
	p.setOpaque(false);
	Dimension d = new Dimension(16,16);
	p.add(new Box.Filler(d, d, d));
	p.add(link);
	p.add(new Box.Filler(d, d, d));
	return p;
	}

	public static void openURL(String url)
	{
	if (Desktop.isDesktopSupported()) 
		{
	    Desktop desktop = Desktop.getDesktop();
	    try 
	    	{
			URI uri = new URI(url);
	        desktop.browse(uri);
	        return;
	    	} 
	    catch (Exception ex) 
	    	{
	    	Main.error("Failed to open URL:\n"+url,"Browser unavailable");
	    	}
		} 
	else 
		{
		Main.error("Failed to open URL:\n"+url,"Browser unavailable");
		}
	}

	/**Returns whether successful*/
	public static boolean setClipboard(String str) 
		{
		try
			{
			StringSelection ss = new StringSelection(str);
			Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
			return true;
			}
		catch(Exception e)
			{
			return false;
			}
		}

	}
