package graphics;

import java.awt.Point;

import javax.media.opengl.GL2;

/**Container object class for texture arrays with an assigned origin adjustment*/
public class Tex
	{
	public static final int NO_REPEAT = 0;
	public static final int REPEAT_H = 1;
	public static final int REPEAT_V = 2;
	public static final int REPEAT_BOTH = 3;
	
	public int[] tex;
	public Point origin;
	public int length;
	public String name;
	
	public int width;
	public int height;
	
	public float xMult = 1, yMult = 1;
	byte[][] data;
	byte[][] recoverData;
	
	boolean isCorruptable = true;
	
	public Tex(String name, byte[][] data, int[] tex, int width, int height)
		{
		this(name, data, tex, new Point(0,0), width, height);
		}
	public Tex(String name, byte[][] data, int[] tex, Point origin, int width, int height)
		{
		this.tex=tex;
		this.origin=origin;
		this.name=name;
		this.width = width;
		this.height = height;
		if(width+height>640 || tex.length>8)//Don't waste too much CPU on corrupting these things
			isCorruptable = false;
		else
			this.data = data;
		length=tex.length;
		}
	public int getWidth()
		{
		return width;
		}
	public int getHeight()
		{
		return height;
		}
	public Point getOrigin(int orientation)
		{
		int x=0,y=0;
		if (orientation==GFX.CENTER)
			{
			x=getWidth()/2;
			y=getHeight()/2;
			}
		else
			{
			if (orientation>0 && orientation<4)
				y=0;
			else if (orientation>4)
				y=getHeight();
			else
				y=getHeight()/2;
			
			if (orientation<2 || orientation>6)
				x=getWidth();
			else if (orientation>2 && orientation<6)
				x=0;
			else
				x=getWidth()/2;
			}
		return new Point(x+origin.x,y+origin.y);
		}
	@Override
	public String toString()
		{
		return name;
		}
	public void enable(int i)
		{
		GFX.gl.glEnable(GL2.GL_TEXTURE_2D);
		GFX.gl.glBindTexture(GL2.GL_TEXTURE_2D, tex[i]);
		}
	public void disable()
		{
		GFX.gl.glDisable(GL2.GL_TEXTURE_2D);
		GFX.gl.glBindTexture(GL2.GL_TEXTURE_2D, 0);
		}
	public void setRepeating(int repeatType)
		{
		if(xMult!=1 && (repeatType==REPEAT_BOTH || repeatType==REPEAT_H))
			System.err.println("WARNING: Unsafe to h-repeat a NPOT Texture: "+name);
		if(yMult!=1 && (repeatType==REPEAT_BOTH || repeatType==REPEAT_V))
			System.err.println("WARNING: Unsafe to v-repeat a NPOT Texture: "+name);
		
		for(int i=0; i<tex.length; i++)
			{
			GFX.gl.glBindTexture(GL2.GL_TEXTURE_2D, tex[i]);
			GFX.gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_WRAP_S, 
					(repeatType==REPEAT_H||repeatType==REPEAT_BOTH)?GL2.GL_REPEAT:GL2.GL_CLAMP_TO_EDGE);
			GFX.gl.glTexParameteri(GL2.GL_TEXTURE_2D, GL2.GL_TEXTURE_WRAP_T,
					(repeatType==REPEAT_V||repeatType==REPEAT_BOTH)?GL2.GL_REPEAT:GL2.GL_CLAMP_TO_EDGE);
			}
		}
	}
